#
# uspac2.rb
#   $Id: uspac2.rb,v 1.2 2000/11/18 19:03:48 keiko Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nmax = 201
imax = 5
x = NArray.sfloat(nmax)
y0 = NArray.sfloat(nmax)
y1 = NArray.sfloat(nmax)
y2 = NArray.sfloat(nmax)
a = NArray.sfloat(imax)

#-- data ---
for i in 0..imax-1
  ii = 2*i + 1
  a[i] = ((-1.0)**(i+1))*2/(ii*PI)
end

x = x.indgen * 1.0/(nmax-1)
for n in 0..nmax-1
  t     = 2.0*PI*x[n]
  if (t < PI/2.0 || t >= PI*3.0/2.0)
    y0[n] = 0.0
  else
    y0[n] = 1.0
  end
  y1[n] = 0.5 + a[0]*cos(t) 
  y2[n] = 0.5
  for i in 0..imax-1
    ii = 2*i + 1
    y2[n] = y2[n] + a[i]*cos(ii*t)
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::usspnt(x, y0)
DCL::usspnt(x, y1)
DCL::usspnt(x, y2)
DCL::uspfit
DCL::grstrf

DCL::ussttl('FREQUENCY', '/DAY', 'RESPONSE', ' ')
DCL::usdaxs

DCL::uulin(x, y0)
DCL::uuslnt(2)
DCL::uuslni(3)
DCL::uulin(x, y1)
DCL::uuslnt(3)
DCL::uulin(x, y2)

DCL::grcls

