/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_rmax(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rmax_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rmax0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rmax0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rmax1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rmax1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rmin(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rmin_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rmin0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rmin0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rmin1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rmin1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rsum(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rsum_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rsum0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rsum0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rsum1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rsum1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rave(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rave_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rave0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rave0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rave1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rave1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rvar(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rvar_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rvar0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rvar0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rvar1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rvar1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rstd(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rstd_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rstd0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rstd0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rstd1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rstd1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rrms(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rrms_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rrms0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rrms0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rrms1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = rrms1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_ramp(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = ramp_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_ramp0(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = ramp0_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_ramp1(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *i_rx;
    integer i_n;
    integer i_jx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = ramp1_(i_rx, &i_n, &i_jx);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_rvmax(obj, rx, ns, np, nq, nd)
    VALUE obj, rx, ns, np, nq, nd;
{
    real *i_rx;
    integer *i_ns;
    integer *i_np;
    integer *i_nq;
    integer i_nd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nq) == T_BIGNUM) || (TYPE(nq) == T_FIXNUM)) {
      nq = rb_Array(nq);
    }
    /* if ((TYPE(nq) != T_ARRAY) && 
           (rb_obj_is_kind_of(nq, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_rx = dcl_obj2crealary(rx);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);
    i_nq = dcl_obj2cintegerary(nq);


    o_rtn_val = rvmax_(i_rx, i_ns, i_np, i_nq, &i_nd);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);
    dcl_freecintegerary(i_nq);

    return rtn_val;

}

static VALUE
dcl_rvmax0(obj, rx, ns, np, nq, nd)
    VALUE obj, rx, ns, np, nq, nd;
{
    real *i_rx;
    integer *i_ns;
    integer *i_np;
    integer *i_nq;
    integer i_nd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nq) == T_BIGNUM) || (TYPE(nq) == T_FIXNUM)) {
      nq = rb_Array(nq);
    }
    /* if ((TYPE(nq) != T_ARRAY) && 
           (rb_obj_is_kind_of(nq, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_rx = dcl_obj2crealary(rx);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);
    i_nq = dcl_obj2cintegerary(nq);


    o_rtn_val = rvmax0_(i_rx, i_ns, i_np, i_nq, &i_nd);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);
    dcl_freecintegerary(i_nq);

    return rtn_val;

}

static VALUE
dcl_rvmin(obj, rx, ns, np, nq, nd)
    VALUE obj, rx, ns, np, nq, nd;
{
    real *i_rx;
    integer *i_ns;
    integer *i_np;
    integer *i_nq;
    integer i_nd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nq) == T_BIGNUM) || (TYPE(nq) == T_FIXNUM)) {
      nq = rb_Array(nq);
    }
    /* if ((TYPE(nq) != T_ARRAY) && 
           (rb_obj_is_kind_of(nq, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_rx = dcl_obj2crealary(rx);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);
    i_nq = dcl_obj2cintegerary(nq);


    o_rtn_val = rvmin_(i_rx, i_ns, i_np, i_nq, &i_nd);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);
    dcl_freecintegerary(i_nq);

    return rtn_val;

}

static VALUE
dcl_rvmax1(obj, rx, ns, np, nq, nd)
    VALUE obj, rx, ns, np, nq, nd;
{
    real *i_rx;
    integer *i_ns;
    integer *i_np;
    integer *i_nq;
    integer i_nd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nq) == T_BIGNUM) || (TYPE(nq) == T_FIXNUM)) {
      nq = rb_Array(nq);
    }
    /* if ((TYPE(nq) != T_ARRAY) && 
           (rb_obj_is_kind_of(nq, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_rx = dcl_obj2crealary(rx);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);
    i_nq = dcl_obj2cintegerary(nq);


    o_rtn_val = rvmax1_(i_rx, i_ns, i_np, i_nq, &i_nd);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);
    dcl_freecintegerary(i_nq);

    return rtn_val;

}

static VALUE
dcl_rvmin1(obj, rx, ns, np, nq, nd)
    VALUE obj, rx, ns, np, nq, nd;
{
    real *i_rx;
    integer *i_ns;
    integer *i_np;
    integer *i_nq;
    integer i_nd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nq) == T_BIGNUM) || (TYPE(nq) == T_FIXNUM)) {
      nq = rb_Array(nq);
    }
    /* if ((TYPE(nq) != T_ARRAY) && 
           (rb_obj_is_kind_of(nq, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_rx = dcl_obj2crealary(rx);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);
    i_nq = dcl_obj2cintegerary(nq);


    o_rtn_val = rvmin1_(i_rx, i_ns, i_np, i_nq, &i_nd);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);
    dcl_freecintegerary(i_nq);

    return rtn_val;

}

static VALUE
dcl_rvmin0(obj, rx, ns, np, nq, nd)
    VALUE obj, rx, ns, np, nq, nd;
{
    real *i_rx;
    integer *i_ns;
    integer *i_np;
    integer *i_nq;
    integer i_nd;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nq) == T_BIGNUM) || (TYPE(nq) == T_FIXNUM)) {
      nq = rb_Array(nq);
    }
    /* if ((TYPE(nq) != T_ARRAY) && 
           (rb_obj_is_kind_of(nq, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_rx = dcl_obj2crealary(rx);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);
    i_nq = dcl_obj2cintegerary(nq);


    o_rtn_val = rvmin0_(i_rx, i_ns, i_np, i_nq, &i_nd);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);
    dcl_freecintegerary(i_nq);

    return rtn_val;

}
void
init_math1_rfalib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "rmax", dcl_rmax, 3);
    rb_define_module_function(mDCL, "rmax0", dcl_rmax0, 3);
    rb_define_module_function(mDCL, "rmax1", dcl_rmax1, 3);
    rb_define_module_function(mDCL, "rmin", dcl_rmin, 3);
    rb_define_module_function(mDCL, "rmin0", dcl_rmin0, 3);
    rb_define_module_function(mDCL, "rmin1", dcl_rmin1, 3);
    rb_define_module_function(mDCL, "rsum", dcl_rsum, 3);
    rb_define_module_function(mDCL, "rsum0", dcl_rsum0, 3);
    rb_define_module_function(mDCL, "rsum1", dcl_rsum1, 3);
    rb_define_module_function(mDCL, "rave", dcl_rave, 3);
    rb_define_module_function(mDCL, "rave0", dcl_rave0, 3);
    rb_define_module_function(mDCL, "rave1", dcl_rave1, 3);
    rb_define_module_function(mDCL, "rvar", dcl_rvar, 3);
    rb_define_module_function(mDCL, "rvar0", dcl_rvar0, 3);
    rb_define_module_function(mDCL, "rvar1", dcl_rvar1, 3);
    rb_define_module_function(mDCL, "rstd", dcl_rstd, 3);
    rb_define_module_function(mDCL, "rstd0", dcl_rstd0, 3);
    rb_define_module_function(mDCL, "rstd1", dcl_rstd1, 3);
    rb_define_module_function(mDCL, "rrms", dcl_rrms, 3);
    rb_define_module_function(mDCL, "rrms0", dcl_rrms0, 3);
    rb_define_module_function(mDCL, "rrms1", dcl_rrms1, 3);
    rb_define_module_function(mDCL, "ramp", dcl_ramp, 3);
    rb_define_module_function(mDCL, "ramp0", dcl_ramp0, 3);
    rb_define_module_function(mDCL, "ramp1", dcl_ramp1, 3);
    rb_define_module_function(mDCL, "rvmax", dcl_rvmax, 5);
    rb_define_module_function(mDCL, "rvmax0", dcl_rvmax0, 5);
    rb_define_module_function(mDCL, "rvmin", dcl_rvmin, 5);
    rb_define_module_function(mDCL, "rvmax1", dcl_rvmax1, 5);
    rb_define_module_function(mDCL, "rvmin1", dcl_rvmin1, 5);
    rb_define_module_function(mDCL, "rvmin0", dcl_rvmin0, 5);
}
