#
# color2.rb
#   $Id: color2.rb,v 1.1 2000/11/18 19:03:31 keiko Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nmax = 50
x = NArray.sfloat(nmax+1)
y = NArray.sfloat(nmax+1)

#-- data ---
x.indgen(1950.0, 1.0)
r    = 3.7
y[0] = 0.5
for n in 0..nmax-1
  y[n+1] = r*y[n]*(1.0-y[n])
end
yave = DCL::rave(y, nmax+1, 1)
y = -4 * (y - yave)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(x[0], x[nmax], -1.5, 2.0)
DCL::grsvpt(0.2, 0.9, 0.2, 0.9)
DCL::grstrn(1)
DCL::grstrf

DCL::sgiset('IFONT', 2)
DCL::uziset('INDEXT1', 402)
DCL::uziset('INDEXT2', 404)
DCL::uziset('INDEXL1', 303)
DCL::uziset('INDEXL2', 123)
DCL::uxaxdv('B', 2.0, 10.0)
DCL::uxaxdv('T', 2.0, 10.0)
DCL::uxsttl('B', 'YEAR', 0.0)

DCL::uyaxdv('L', 0.1, 0.5)
DCL::uyaxdv('R', 0.1, 0.5)
cttl = DCL::csgi(131) + 'T [K]'
DCL::uysttl('L', cttl, 0.0)

DCL::uxmttl('T', 'INTERANNUAL VARIATION', 0.0)

DCL::sgspli(24)
DCL::sgplu(x, y)
DCL::grcls

