/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


VALUE mDCL;

static VALUE
dcl_vignn(obj, n, jx)
    VALUE obj, n, jx;
{
    integer *o_ix;
    integer i_n;
    integer i_jx;
    VALUE ix;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);

    o_ix= ALLOCA_N(integer, i_jx*(i_n-1)+1);

    vignn_(o_ix, &i_n, &i_jx);

    {int array_shape[1] = {i_jx*(i_n-1)+1};
     ix = dcl_cintegerary2obj(o_ix, i_jx*(i_n-1)+1, 1, array_shape);
    }


    return ix;

}

static VALUE
dcl_vrgnn(obj, n, jx)
    VALUE obj, n, jx;
{
    real *o_rx;
    integer i_n;
    integer i_jx;
    VALUE rx;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);

    o_rx= ALLOCA_N(real, i_jx*(i_n-1)+1);

    vrgnn_(o_rx, &i_n, &i_jx);

    {int array_shape[1] = {i_jx*(i_n-1)+1};
     rx = dcl_crealary2obj(o_rx, i_jx*(i_n-1)+1, 1, array_shape);
    }


    return rx;

}

static VALUE
dcl_dxfloc(obj, nd, ns, np)
    VALUE obj, nd, ns, np;
{
    integer i_nd;
    integer *i_ns;
    integer *i_np;
    integer o_ncp;
    VALUE ncp;

    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(np) == T_BIGNUM) || (TYPE(np) == T_FIXNUM)) {
      np = rb_Array(np);
    }
    /* if ((TYPE(np) != T_ARRAY) && 
           (rb_obj_is_kind_of(np, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_nd = NUM2INT(nd);
    i_ns = dcl_obj2cintegerary(ns);
    i_np = dcl_obj2cintegerary(np);


    dxfloc_(&i_nd, i_ns, i_np, &o_ncp);

    ncp = INT2NUM(o_ncp);

    dcl_freecintegerary(i_ns);
    dcl_freecintegerary(i_np);

    return ncp;

}

static VALUE
dcl_dxiloc(obj, nd, ns, ncp)
    VALUE obj, nd, ns, ncp;
{
    integer i_nd;
    integer *i_ns;
    integer *o_np;
    integer i_ncp;
    VALUE np;

    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ns) == T_BIGNUM) || (TYPE(ns) == T_FIXNUM)) {
      ns = rb_Array(ns);
    }
    /* if ((TYPE(ns) != T_ARRAY) && 
           (rb_obj_is_kind_of(ns, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ncp) != T_BIGNUM) || (TYPE(ncp) != T_FIXNUM)) {
      ncp = rb_funcall(ncp, rb_intern("to_i"), 0);
    }

    i_nd = NUM2INT(nd);
    i_ncp = NUM2INT(ncp);
    i_ns = dcl_obj2cintegerary(ns);

    o_np= ALLOCA_N(integer, (i_nd));

    dxiloc_(&i_nd, i_ns, o_np, &i_ncp);

    {int array_shape[1] = {i_nd};
     np = dcl_cintegerary2obj(o_np, (i_nd), 1, array_shape);
    }

    dcl_freecintegerary(i_ns);

    return np;

}
void
init_math1_sublib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "vignn", dcl_vignn, 2);
    rb_define_module_function(mDCL, "vrgnn", dcl_vrgnn, 2);
    rb_define_module_function(mDCL, "dxfloc", dcl_dxfloc, 3);
    rb_define_module_function(mDCL, "dxiloc", dcl_dxiloc, 3);
}
