module NumRu
  module NuSDaSMod

    @@models = {
      '_GSM' => 'global spectral model',
      '_RSM' => 'regional spectral model',
      '_MSM' => 'Mesoscale model',
      '_TYM' => 'typhoon model',
      '_DCD' => 'decoded observation bulletins',
      '_SRF' => 'very short-range precipitation forecast',
      '_WFM' => 'week-range ensemble model',
      '_SF1' => 'month-range ensemble model',
      '_SF4' => 'four-month-range ensemble model',
    }

    @@vertical_grids = {
      'PP' => 'isobaric plane/layer',
      'ET' => 'eta vertical coordinate plane/layer',
      'SG' => 'sigma vertical coordinate plane/layer',
      'HB' => 'hybrid vertical coordinate plane/layer',
      'LA' => 'latitude (for vertical cross section data)',
      'LO' => 'longitude (for vertical cross section data)',
      'ZZ' => 'plane/layer specified by height',
      'TH' => 'isentropic plane/layer',
      'ZS' => 'Z* vertical coordinate plane/layer',
      'LY' => 'altitude coordinate plane, echo top, all layer, etc',
      'SF' => 'surface'
    }

    @@data_attributes = {
      'FC' => 'Forecast',
      'EA' => 'Early analysis',
      'AA' => 'Cycle analysis',
      'RA' => 'Reanalysis',
      'CC' => 'Constants',
      'OB' => 'Observations',
      'GS' => 'Guess',
      'AF' => 'Forcast in analysis',
      'EF' => 'Ensemble forcast',
      'IN' => 'Initial condition',
      'PT' => 'Pertabasions for ensemble',
      'RA' => 'Reanalysis',
      'VR' => 'Validated values'
    }

    @@time_attributes = {
      'SV' => 'snapshot: the valid time has only one significant value',
      'MV' => 'time-average value for time span specified by valid1 and valid2',
      'AV' => 'summation value for time span specified by valid1 and valid2',
      'DV' => 'standard deviation value for region specified by valid1 and valid2',
      'AN' => 'summation value for climatorogy',
      'DN' => 'standard deviation value for climatorogy',
      'MA' => 'deviation of time-average value',
      'MN' => 'time-average value',
      'PV' => 'statistical value',
      'SN' => 'climatorogy of snapshot'
    }

    @@projection_abbrs = {
      'FG' => 'FG  ',
      'GS' => 'GS  ',
      'LL' => 'LL  ',
      'LM' => 'LMN ',
#      'LM' => 'LMS ',
      'MR' => 'MER ',
      'ME' => 'MER ',
      'OL' => 'OL  ',
      'PS' => 'NPS ',
#      'PS' => 'SPS ',
      'RD' => 'RD  ',
      'RG' => 'RG  ',
      'RT' => 'RT  ',
      'SB' => 'SB  ',
      'ST' => 'ST  ',
      'XP' => 'XP  ',
      'YP' => 'YP  ',
      'XX' => 'XX  '
    }

    @@projections = {
      'FG'  => 'Free Grid',
      'GS'  => 'Gaussian grid',
      'LL'  => 'Cylindrical Equidistance',
      'LMN' => 'Lambert Conformal (Northern hemisphere)',
      'LMS' => 'Lambert Conformal (Southern hemisphere',
      'MER' => 'Mercator',
      'OL'  => 'Oblique Lambert Conformal',
      'NPS' => 'Polar Stereo (Northern hemisphere)',
      'SPS' => 'Polar Stereo (Southern hemisphere)',
      'RD'  => 'RADAR site',
      'RG'  => 'Reduced Gaussian grid',
      'RT'  => 'Radar of Spherical Coordinate',
      'SB'  => 'details',
      'ST'  => 'Station data',
      'XP'  => 'Section of latitude',
      'YP'  => 'Section of longitude',
      'XX'  => 'unknown'
    }

    @@elements = {
      'P'      => ['hPa', 'Pressure'],
      'Pres'   => ['Pa', 'Pressure'],
      'PAI'    => [nil, 'Log pressure'],
      'PSEA'   => ['hPa', 'Pressure reduced to MSL'],
      'Pmsl'   => ['Pa', 'Pressure reduced to MSL'],
      'Ptend'  => ['Pa.s-1', 'Pressure tendency'],
      'pVOR'   => ['K.m2.kg-1.s-1','Potential vorticity'],
      'sarH'   => ['m', 'ICAO Standard Atmosphere reference height'],
      'PHI'    => ['m2.s-2', 'Geopotential'],
      'gpH'    => ['m2.s-2', 'Geopotential'],
      'Z'      => ['m', 'Geopotential height'],
      'gpH'    => ['gpm', 'Geopotential height'],
      'gmH'    => ['m', 'Geometrical height'],
      'sdH'    => ['m', 'Standard deviation of height'],
      'tOZON'  => ['Dobson', 'Total ozone'],
      'T'      => ['K', 'Temperature'],
      'vT'     => ['K', 'Virtual temperature'],
      'pT'     => ['K', 'Potential temperature'],
      'papT'   => ['K', 'Pseudo-adiabatic potential temperature'],
      'maxT'   => ['K', 'Maximum temperature'],
      'minT'   => ['K', 'Minimum temperature'],
      'dT'     => ['K', 'Dew-point temperature'],
      'TTD'    => ['K', 'Dew-point depression (or deficit)'],
      'TRate'  => ['K.m-1', 'Lapse rate'],
      'VIS'    => ['m', 'Visibility'],
      'Radr1'  => [nil, 'Radar spectra (1)'],
      'Radr2'  => [nil, 'Radar spectra (2)'],
      'Radr3'  => [nil, 'Radar spectra (3)'],
      'PLI50'  => ['K', 'Parcel lifted index (to 500 hPa)'],
      'Tano'   => ['K', 'Temperature anomaly'],
      'Pano'   => ['Pa', 'Pressure anomaly'],
      'gpHan'  => ['gpm', 'Geopotential height anomaly'],
      'Wave1'  => [nil, 'Wave spectra (1)'],
      'Wave2'  => [nil, 'Wave spectra (2)'],
      'Wave3'  => [nil, 'Wave spectra (3)'],
      'WindD'  => ['Degree_true', 'Wind direction'],
      'WindS'  => ['m.s-1', 'Wind speed'],
      'U'      => ['m.s-1', 'u-component of wind [X direction]'],
      'WindX'  => ['m.s-1', 'u-component of wind [X direction]'],
      'UU'     => ['m.s-1', 'u-component of wind [eastward]'],
      'V'      => ['m.s-1', 'v-component of wind [Y direction]'],
      'WindY'  => ['m.s-1', 'v-component of wind [Y direction]'],
      'VV'     => ['m.s-1', 'v-component of wind [northward]'],
      'PSI'    => ['m2.s-1', 'Stream function'],
      'CHI'    => ['m2.s-1', 'Velocity potential'],
      'mPSI'   => ['m2.s-2', 'Montgomery stream function'],
      'sVV'    => ['s-1', 'Sigma coordinate vertical velocity'],
      'OMG'    => ['hPa.h-1', 'Vertical velocity'],
      'VVPa'   => ['Pa.s-1', 'Vertical velocity'],
      'VVm'    => ['m.s-1', 'Vertical velocity'],
      'aVOR'   => ['s-1', 'Absolute vorticity'],
      'aDIV'   => ['s-1', 'Absolute divergence'],
      'VOR'    => ['10-6.s-1', 'Relative vorticity'],
      'rVOR'   => ['s-1', 'Relative vorticity'],
      'DIV'    => ['10-6.s-1', 'Relative divergence'],
      'rDIV'   => ['s-1', 'Relative divergence'],
      'vUS'    => ['s-1', 'Vertical u-component shear'],
      'vVS'    => ['s-1', 'Vertical v-component shear'],
      'CrntD'  => ['Degree_true', 'Direction of current'],
      'CrntS'  => ['m.s-1', 'Speed of current'],
      'CrntU'  => ['m.s-1', 'u-component of current'],
      'CrntV'  => ['m.s-1', 'v-component of current'],
      'Q'      => ['kg.kg-1', 'Specific humidity'],
      'RH'     => ['%', 'Relative humidity'],
      'HMR'    => ['kg.kg-1', 'Humidity mixing ratio'],
      'TPW'    => ['kg.m-2', 'Precipitable water'],
      'VP'     => ['Pa', 'Vapour pressure'],
      'VPVPD'  => ['Pa', 'Saturation deficit'],
      'Evap'   => ['kg.m-2', 'Evaporation'],
      'CIC'    => ['kg.m-2', 'Cloud ice'],
      'RRate'  => ['kg.m-2.s-1', 'Precipitation rate'],
      'ThndP'  => ['%', 'Thunderstorm probability'],
      'RAIN'   => ['kg.m-2', 'Total precipitation'],
      'RR10'   => ['0.1 mm.min-1', 'Total precipitation'],
      'RR60'   => ['mm.h-1', 'Total precipitation'],
      'RR3H'   => ['8 mm.day-1', 'Total precipitation'],
      'RR6H'   => ['4 mm.day-1', 'Total precipitation'],
      'RR1D'   => ['mm.day-1', 'Total precipitation'],
      'RR1M'   => ['mm.mon-1', 'Total precipitation'],
      'RRfr0'  => ['mm', 'Precipitation from last hour 00min'],
      'RRL'    => ['kg.m-2', 'Large scale precipitation'],
      'RRLpD'  => ['mm.day-1', 'Large scale precipitation'],
      'RRC'    => ['kg.m-2', 'Convective precipitation'],
      'RRCpD'  => ['mm.day-1', 'Convective precipitation'],
      'SnRWe'  => ['kg.m-2.s-1', 'Snawfall rate water equivalent'],
      'SnWe'   => ['kg.m-2', 'Water equivalent of accumulated snow depth'],
      'SnowD'  => ['m', 'Snow depth'],
      'MLD'    => ['m', 'Mixed layer depth'],
      'tTcD'   => ['m', 'Transient thermocline depth'],
      'mTcD'   => ['m', 'Main thermocline depth'],
      'mTcan'  => ['m', 'Main thermocline anomaly'],
      'CLA'    => ['%', 'Total cloud cover'],
      'CLC'    => ['%', 'Convective cloud cover'],
      'CLL'    => ['%', 'Low cloud cover'],
      'CLM'    => ['%', 'Medium cloud cover'],
      'CLH'    => ['%', 'High cloud cover'],
      'CWC'    => ['kg.m-2', 'Cloud water'],
      'TCWC'   => ['kg.m-2', 'Cloud water'],
      'BLI50'  => ['K', 'Best lifted index (to 500 hPa)'],
      'SnC'    => ['kg.m-2', 'Convective snow'],
      'SnL'    => ['kg.m-2', 'Large scale snow'],
      'WatrT'  => ['K', 'Water temperature'],
      'SST'    => ['K', 'Water temperature [sea surface]'],
      'Land'   => ['Proportion', 'Land cover (1 = land, 0 = sea)'],
      'Sldev'  => ['m', 'Deviation of sea level from mean'],
      'Z0'     => ['m', 'Surface roughness'],
      'Albed'  => ['%', 'Albedo'],
      'SoilT'  => ['K', 'Soil temperature'],
      'SoilW'  => ['kg.m-2', 'Soil moisture content'],
      'Veget'  => ['%', 'Vegetation'],
      'Sali'   => ['kg.kg-1', 'Salinity'],
      'Dens'   => ['kg.m-3', 'Density'],
      'Runof'  => ['kg.m-2', 'Water run-off'],
      'ROF'    => ['mm.day-1', 'Water run-off'],
      'ROFS'   => ['mm.day-1', 'Water run-off [surface]'],
      'ROFD'   => ['mm.day-1', 'Water run-off [gravity drag]'],
      'IceC'   => ['Proportion', 'Ice cover (1 = ice, 0 = no ice)'],
      'ICE'    => ['Proportion', 'Ice cover (1 = ice, 0 = no ice)'],
      'IceD'   => ['m', 'Ice thickness'],
      'IceMD'  => ['Degree true', 'Direction of ice drift'],
      'IceMS'  => ['m.s-1', 'Speed of ice drift'],
      'IceMU'  => ['m.s-1', 'u-component of ice drift'],
      'IceMV'  => ['m.s-1', 'v-component of ice drift'],
      'IceGR'  => ['m.s-1', 'Ice growth rate'],
      'IceDV'  => ['s-1', 'Ice divergence'],
      'SNMlt'  => ['kg.m-2', 'Snow melt'],
      'CWSSH'  => ['m', 'Significant height of combined wind waves and swell'],
      'WWvD'   => ['Degree true', 'Direction of wind waves'],
      'WWvSH'  => ['m', 'Significant height of wind waves'],
      'WWvMP'  => ['s', 'Mean period of wind waves'],
      'SwvD'   => ['Degree true', 'Direction of swell waves'],
      'SwvSH'  => ['m', 'Significant height of swell waves'],
      'SwvMP'  => ['s', 'Mean period of swell waves'],
      'PWvD'   => ['Degree ture,', 'Primary wave direction'],
      'PWvMP'  => ['s', 'Primary wave mean period'],
      '2WvD'   => ['Degree ture', 'Secondary wave direction'],
      '2WvMP'  => ['s', 'Secondary wave mean period'],
      'RSNB'   => ['W.m-2', 'Net short-wave radiation flux (surface)'],
      'RLNB'   => ['W.m-2', 'Net long-wave radiation flux (surface)'],
      'RSNT'   => ['W.m-2', 'Net short-wave radiation flux (top of atmosphere)'],
      'RLNT'   => ['W.m-2', 'Net long-wave radiation flux (top of atmosphere)'],
      'RL'     => ['W.m-2', 'Long-wave radiation flux'],
      'RLUB'   => ['W.m-2', 'ibid. [upward, surface]'],
      'RLDB'   => ['W.m-2', 'ibid. [downward, surface]'],
      'RLUT'   => ['W.m-2', 'ibid. [upward, top of atm]'],
      'RLDT'   => ['W.m-2', 'ibid. [downward, top of atm]'],
      'RLUTc'  => ['W.m-2', 'ibid. [upward, top of atm, clear sky]'],
      'RLDBc'  => ['W.m-2', 'ibid. [downward, surface, clear sky]'],
      'RS'     => ['W.m-2', 'Short-wave radiation flux'],
      'RSUB'   => ['W.m-2', 'ibid. [upward, surface]'],
      'RSDB'   => ['W.m-2', 'ibid. [downward, surface]'],
      'RSUT'   => ['W.m-2', 'ibid. [upward, top of atm]'],
      'RSDT'   => ['W.m-2', 'ibid. [downward, top of atm]'],
      'RSUBc'  => ['W.m-2', 'ibid. [upward, surface, clear sky]'],
      'RSDBc'  => ['W.m-2', 'ibid. [downward, surface, clear sky]'],
      'RSUTc'  => ['W.m-2', 'ibid. [upward, top of atm, clear sky]'],
      'RSDSn'  => ['W.m-2', 'ibid. [downward, in accumulated snow]'],
      'GlRad'  => ['W.m-2', 'Global radiation flux'],
      'BrT'    => ['K', 'Brightness temperature'],
      'WNRad'  => ['W.m-1.sr-1', 'Radiance (with respect to wave number)'],
      'WLRad'  => ['W.m-3.sr-1', 'Radiance (with respect to wave length)'],
      'FLLH'   => ['W.m-2', 'Latent heat flux'],
      'FLSH'   => ['W.m-2', 'Sensible heat flux'],
      'BLDsp'  => ['W.m-2', 'Boundary layer dissipation'],
      'FLMU'   => ['N.m-2', 'Momentum flux, u-component'],
      'FLMV'   => ['N.m-2', 'Momentum flux, v-component'],
      'WMixE'  => ['J', 'Wind mixing energy'],
      'Image'  => ['Brightness Level', 'Image data'],
      'WatrT'  => ['K', 'Water Temperature'],
      'CLC2'   => ['%', 'Cloud cover'],
      'AvTBB'  => ['K', 'Averaged blackbody temperature'],
      'MnTBB'  => ['K', 'Minimum blackbody temperature'],
      'SDTBB'  => ['K', 'Standard deviation of blackbody temperature'],
      'SNCov'  => ['%', 'Snow cover'],
      'Tsun'   => ['J.m-2', 'Global solar irradiation'],
      'HZanP'  => [nil, 'Probability of high geopotential height anomaly'],
      'PSprd'  => [nil, 'Ensemble spread of pressure'],
      'ZSprd'  => [nil, 'Ensemble spread of geopotential height'],
      'TSprd'  => [nil, 'Ensemble spread of temperature'],
      'EAvSLP' => ['Pa', 'Ensemble mean sea-level pressue'],
      'EAvZ'   => ['gpm', 'Ensemble mean geopotential height'],
      'EAvT'   => ['K', 'Ensemble mean temperature'],
      'EAvU'   => ['m.s-1', 'Ensemble mean u-component of wind'],
      'EAvV'   => ['m.s-1', 'Ensemble mean v-component of wind'],
      'ESDSLP' => ['Pa', 'Ensemble standard deviation of pressure'],
      'ESDZ'   => ['gpm', 'Ensemble standard deviation of geopotential height'],
      'ESDT'   => ['K', 'Ensemble standard deviation of temperature'],
      'ESDU'   => ['m.s-1', 'Ensemble standard deviation of u-component of wind'],
      'ESDV'   => ['m.s-1', 'Ensemble standard deviation of v-component of wind'],
      'FGSU'   => ['N.m-2', 'x-component of momentum flux due to short gravity wave'],
      'FGSV'   => ['N.m-2', 'y-component of momentum flux due to short gravity wave'],
      'FGLU'   => ['N.m-2', 'x-component of momentum flux due to long gravity wave'],
      'FGLV'   => ['N.m-2', 'y-component of momentum flux due to long gravity wave'],
      'LTRS'   => ['W.m-2.s-1', 'Evaporation'],
      'LINT'   => ['W.m-2.s-1', 'Interception'],
      'MSC'    => ['m', 'Moisture in canopy'],
      'MSG'    => ['m', 'Moisture in ground or grass'],
      'TSC'    => ['K', 'Temperature in canopy'],
      'TSG'    => ['K', 'Temperature in ground or grass'],
      'ISC'    => ['m', 'Ice or frost on canopy'],
      'ISG'    => ['m', 'Frost on grass'],
      'SoilI'  => [nil, 'Soil ice content'],
      'SoilQ'  => [nil, 'Converged heat in soil'],
      'TSN'    => ['K', 'Temperature of accumulated snow surface'],
      'SnTmp'  => ['K', 'Temperature in accumulated snow'],
      'SnQ'    => [nil, 'Converged heat in accumulated snow'],
      'SnW'    => [nil, 'Moisture in accumulated snow'],
      'SnDen'  => [nil, 'Density of accumulated snow'],
      'SnFr'   => ['Proportion', 'Snow cover'],
      'KIND'   => [nil, 'Land surface status code'],
      'U1'     => ['m.s-1', 'x-component of wind at the lowest model level'],
      'V1'     => ['m.s-1', 'y-component of wind at the lowest model level'],
      'T1'     => ['K', 'Temperature at the lowest model level'],
      'Q1'     => ['kg.kg-1', 'Specific humidity the lowest model level'],
      'WET'    => [nil, 'Wetness'],
      'UWV'    => ['kg.m-1.s-1', 'Water vapor flux, x-component'],
      'VWV'    => ['kg.m-1.s-1', 'Water vapor flux, y-component'],
      'RCST'   => [nil, 'Radiation forcing (short wave, top of atm)'],
      'RCSB'   => [nil, 'Radiation forcing (short wave, surfce)'],
      'RCLT'   => [nil, 'Radiation forcing (long wave, top of atm)'],
      'RCLB'   => [nil, 'Radiation forcing (long wave, surfce)'],
      'PBLH'   => ['m', 'Height of planetary boundary layer'],
      'CVR'    => ['Proportion', 'Cloud cover'],
      'HRRS'   => ['K.day-1', 'Heating rate due to short-wave radiation'],
      'HRRL'   => ['K.day-1', 'Heating rate due to long-wave radiation'],
      'HRCV'   => ['K.day-1', 'Heating rate due to convection'],
      'HRLC'   => ['K.day-1', 'Heating rate due to large-scale condensation'],
      'HRVD'   => ['K.day-1', 'Heating rate due to vertical diffusion'],
      'HRAD'   => ['K.day-1', 'Heating rate due to adiabatic motion'],
      'QRCV'   => ['kg.kg-1.day-1', 'Moistening rate due to convection'],
      'QRLC'   => ['kg.kg-1.day-1', 'Moistening rate due to large-scale condensation'],
      'QRVD'   => ['kg.kg-1.day-1', 'Moistening rate due to vertical diffusion'],
      'QRAD'   => ['kg.kg-1.day-1', 'Moistening rate due to adiabatic motion'],
      'URCV'   => ['m.s-1.day-1', 'u-component acceleration due to convection'],
      'URLC'   => ['m.s-1.day-1', 'u-component acceleration due to large-scale condensation'],
      'URVD'   => ['m.s-1.day-1', 'u-component acceleration due to vertical diffusion'],
      'URAD'   => ['m.s-1.day-1', 'u-component acceleration due to adiabatic motion'],
      'VRCV'   => ['m.s-1.day-1', 'v-component acceleration due to convection'],
      'VRLC'   => ['m.s-1.day-1', 'v-component acceleration due to large-scale condensation'],
      'VRVD'   => ['m.s-1.day-1', 'v-component acceleration due to vertical diffusion'],
      'VRAD'   => ['m.s-1.day-1', 'v-component acceleration due to adiabatic motion'],
      'UMF'    => ['kg.m-2.s-1', 'Upward mass flux'],
      'UMB'    => ['kg.m-2.s-1', 'Upward mass flux at bottom of cloud'],
      'CWF'    => ['J.kg-1', 'Cloud work function'],
      'MXWIN'  => ['m', 'Height of maximum wind speed'],
      'TROP1'  => ['m', 'Height of first tropopause'],
      'TROP2'  => ['m', 'Height of second tropopause'],
      'CBTOP'  => ['m', 'Height of top of cumulonimbus'],
      'NUM'    => [nil, 'Station ID number'],
      'LAT'    => ['degree', 'Latitude'],
      'MLAT'   => ['degree', 'Latitude'],
      'LON'    => ['degree', 'Longitude'],
      'MLON'   => ['degree', 'Longitude'],
      'HIGH'   => ['m', 'Height'],
      'AQC'    => [nil, 'AQC code in AMeDAS'],
      'Sunsh'  => ['s', 'Duration of sunshine'],
      'SSfr0'  => ['min', 'Duration of sunshine'],
      'SEC'    => ['s', 'Time'],
      'CSEC'   => ['s', 'Time'],
      'TDDKK'  => [nil, 'Thunder multiplicity and discharge code'],
      'TEC'    => ['kA', 'Thunder current'],
      'SM'     => [nil, 'Map factor'],
      'PI10LV' => [nil, 'Radar 10 minutes precipitation index'],
      'RR60LV' => [nil, 'Radar 60 minutes precipitation index'],
      'HIGHLV' => [nil, 'Radar echo top height index']
    }

  end

end

