%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkIO_typemaps.i


%{
#include "vtkDEMReader.h"
%}

%import vtkImageSource.h


%{
extern void vtkDEMReader_freefunc(void *ptr)
{
    vtkDEMReader *obj;
    obj = (vtkDEMReader*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[15] {
  int i;
  $result = rb_ary_new2(15);
  for (i=0; i<15; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[15]{
   float *GetProjectionParameters()
}
%ignore GetProjectionParameters(float data[15]);
%ignore GetProjectionParameters(float _arg[15]);
%ignore GetProjectionParameters(float &_arg1,float &_arg2,float &_arg3,float &_arg4,float &_arg5,float &_arg6,float &_arg7,float &_arg8,float &_arg9,float &_arg10,float &_arg11,float &_arg12,float &_arg13,float &_arg14,float &_arg15);

%typemap(ruby,out) float value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[2]{
   float *GetElevationBounds()
}
%ignore GetElevationBounds(float data[2]);
%ignore GetElevationBounds(float _arg[2]);
%ignore GetElevationBounds(float &_arg1,float &_arg2);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetSpatialResolution()
}
%ignore GetSpatialResolution(float data[3]);
%ignore GetSpatialResolution(float _arg[3]);
%ignore GetSpatialResolution(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) int value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[2]{
   int *GetProfileDimension()
}
%ignore GetProfileDimension(int data[2]);
%ignore GetProfileDimension(int _arg[2]);
%ignore GetProfileDimension(int &_arg1,int &_arg2);

%include vtkDEMReader.h
