%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageMandelbrotSource.h"
%}

%import vtkImageSource.h


%{
extern void vtkImageMandelbrotSource_freefunc(void *ptr)
{
    vtkImageMandelbrotSource *obj;
    obj = (vtkImageMandelbrotSource*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetWholeExtent()
}
%ignore GetWholeExtent(int data[6]);
%ignore GetWholeExtent(int _arg[6]);
%ignore GetWholeExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetProjectionAxes()
}
%ignore GetProjectionAxes(int data[3]);
%ignore GetProjectionAxes(int _arg[3]);
%ignore GetProjectionAxes(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) double value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[4]{
   double *GetOriginCX()
}
%ignore GetOriginCX(double data[4]);
%ignore GetOriginCX(double _arg[4]);
%ignore GetOriginCX(double &_arg1,double &_arg2,double &_arg3,double &_arg4);

%typemap(ruby,out) double value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[4]{
   double *GetSampleCX()
}
%ignore GetSampleCX(double data[4]);
%ignore GetSampleCX(double _arg[4]);
%ignore GetSampleCX(double &_arg1,double &_arg2,double &_arg3,double &_arg4);

%include vtkImageMandelbrotSource.h
