%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkRendering_typemaps.i


%{
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkVolume.h"
#include "vtkCuller.h"
#include "vtkActor.h"
#include "vtkCamera.h"
#include "vtkLightCollection.h"
#include "vtkCullerCollection.h"
#include "vtkLight.h"
%}

%import vtkViewport.h
%import vtkVolumeCollection.h
%import vtkActorCollection.h


%{
extern void vtkRenderer_freefunc(void *ptr)
{
    vtkRenderer *obj;
    obj = (vtkRenderer*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetAmbient()
}
%ignore GetAmbient(float data[3]);
%ignore GetAmbient(float _arg[3]);
%ignore GetAmbient(float &_arg1,float &_arg2,float &_arg3);

%include vtkRenderer.h
