%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkGraphics_typemaps.i


%{
#include "vtkButtonSource.h"
%}

%import vtkPolyDataSource.h


%{
extern void vtkButtonSource_freefunc(void *ptr)
{
    vtkButtonSource *obj;
    obj = (vtkButtonSource*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOrigin()
}
%ignore GetOrigin(double data[3]);
%ignore GetOrigin(double _arg[3]);
%ignore GetOrigin(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) int value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[2]{
   int *GetTextureDimensions()
}
%ignore GetTextureDimensions(int data[2]);
%ignore GetTextureDimensions(int _arg[2]);
%ignore GetTextureDimensions(int &_arg1,int &_arg2);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetShoulderTextureCoordinate()
}
%ignore GetShoulderTextureCoordinate(double data[2]);
%ignore GetShoulderTextureCoordinate(double _arg[2]);
%ignore GetShoulderTextureCoordinate(double &_arg1,double &_arg2);

%include vtkButtonSource.h
