%typemap(constant) int, short, long, signed char
        "if (!rb_const_defined($module, rb_intern(\"$name\")))\n        rb_define_const($module,\"$symname\", INT2NUM($name));";

%typemap(constant) unsigned int, unsigned short, unsigned long, unsigned char
        "rb_define_const($module,\"$symname\", UINT2NUM($name));";

%typemap(constant) long long
        "rb_define_const($module,\"$symname\", LL2NUM($name));";

%typemap(constant) unsigned long long
        "rb_define_const($module,\"$symname\", ULL2NUM($name));";

%typemap(constant) double, float
        "if (!rb_const_defined($module, rb_intern(\"$name\")))\n        rb_define_const($module,\"$symname\", rb_float_new($name));";

%typemap(constant) bool
        "rb_define_const($module,\"$symname\", ($name ? Qtrue : Qfalse));";

%typemap(constant) char
        "rb_define_const($module,\"$symname\", rb_str_new($name,1));";

%typemap(constant) char *
        "rb_define_const($module,\"$symname\", rb_str_new2($name));";

%typemap(constant) SWIGTYPE*, SWIGTYPE &, SWIGTYPE []
        "rb_define_const($module,\"$symname\", SWIG_NewPointerObj((void *) $name, $name_descriptor,0));";

%typemap(constant) SWIGTYPE "rb_define_const($module,\"$symname\", SWIG_NewPointerObj((void *) &$name, &$name_descriptor, 0));";

%typemap(constant) SWIGTYPE (CLASS::*) "rb_define_const($module, \"$symname\", SWIG_NewPackedObj((void *) &$name, sizeof($type), $name_descriptor));";


%typemap(ruby,in) const double value[ANY] {
  int i, len;
  len = RARRAY($input)->len;
  if (len!=$1_dim0)
    rb_raise(rb_eArgError, "Size mismatch Expected $1_dim0 elements");
  $1 = (double*) malloc(len*sizeof(double));
  for (i=0; i<len; i++)
    $1[i] = NUM2DBL(RARRAY($input)->ptr[i]);
}
%typemap(ruby,freearg) const double value[ANY] {
  if ($1) free($1);
}
%apply (const double value[ANY]){
       (const double x[3])
};
%typemap(ruby,in) int value[ANY] {
  int i, len;
  len = RARRAY($input)->len;
  if (len!=$1_dim0)
    rb_raise(rb_eArgError, "Size mismatch Expected $1_dim0 elements");
  $1 = (int*) malloc(len*sizeof(int));
  for (i=1; i<len; i++)
    $1[i] = NUM2INT(RARRAY($input)->ptr[i]);
}
%typemap(ruby,freearg) int value[ANY] {
  if ($1) free($1);
}
%apply int value[ANY]{
       int dim[3],
       int extent[6]
};

%typemap(ruby,out) float value[6] {
  int i;
  int len = 6;
  $result = rb_ary_new2(len);
  for (i=0; i<len; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[6]{
   double *GetBounds()
}
%ignore GetBounds(float bounds[6]);


%rename(new) New();
%ignore Delete();
