require "narray"
require "numru/gphys"
require "numru/dcl"
include NumRu
include NMath

ns=21
nr=6
nx = ny = 49

#x = NArray.float(ns,nr)
#y = NArray.float(ns,nr)

theta = 2.0*PI/(ns-1) * NArray.float(ns,1).indgen
r = NArray.float(1,nr).indgen! #+ 1e-9

x = r * cos(theta)
y = r * sin(theta)
z = sqrt(r) * sin(2*theta)

x0=-6.0; dx=0.25 
y0=-6.0; dy=0.25

DCL.swpset("iwidth",1000)
DCL.swpset("iheight",500)
DCL.gropn(1)
DCL.glpset("lmiss",true)
DCL.sldiv("y",2,1)

def tone(gp)
  DCL.grfrm
  DCL.grsvpt(0.2,0.8,0.2,0.8)
  DCL.grswnd(0,1,0,1)
  DCL.grstrf
  DCL.uepset("ltone",true)
  DCL.usdaxs
  DCL.uetone(gp)
end

tone(x)
tone(y)

si, ri, p, q = GPhys.quad_mesh_sample_init(x, y, nx, x0, dx, ny, y0, dy, nil)
misval = DCL.glpget("rmiss")
zg = GPhys.quad_mesh_sample(z, si, ri, p, q, misval)

tone(si)
tone(ri)
tone(p+si)
tone(q+ri)
tone(z)
tone(zg)

x[5..8,1..2] = misval
y[15,3] = misval
si, ri, p, q = GPhys.quad_mesh_sample_init(x, y, nx, x0, dx, ny, y0, dy, misval)
zg = GPhys.quad_mesh_sample(z, si, ri, p, q, misval)
tone(zg)


DCL.grcls


