require "narray"

############################################################

=begin
=module NumRu::Derivative in derivative.rb

==todo
* b_expand_linear_ext ΰ򥷥ܥˤ뤫ˤ뤫
  * Ͽ
  * dRuby ǥܥ뤬ɤ뤫ˤ
* ¾ζˤб
* 1 Ԥ 80 ʸǼ 
* Recast document in English  


==Index
* ((<module NumRu::Derivative>))
  * ((<cderiv>))
    * First derivative (center difference)
  * ((<b_expand_linear_ext>))
    * 뼡ζξüĥ֤. 
  * ((<cdiff>))
    * ʬ֤. (center difference)

=module NumRu::Derivative

Module functions of Derivative Operater for NArray.
ʬ黻⥸塼. Ĥμ˱äʬ֤ͤ.

---cderiv(data, axis, dim, bc=LINEAR_EXT)

    Derivate (({data})) respect to (({dim})) th dimention. (({data})) κʬ 
    (({axis})) κʬǳä ( ʤ (na_{i+1} - na_{i-1}) / (x_{i+1} - x_{i-1}): 
     na  (({data})), x  (({axis})), _{i}  ((<dim>)) ܤ i ܤź
    ɽ ) ֤.

    ARGUMENTS
    * data (NArray): a NArray which you want to derivative.
    * axis (NArray): a NArray representing the dimension which derivative respect to.
      󥯤 1 ǤʤƤϤʤʤ.
    * dim (Numeric): ʬȤ뼡. Numeric Ϳ. (dim<0)
      ȤǤ뤬, data.rank dim < 0 ȤʤäƤϤʤ.
    * bc (Numeric or ܥ) : . LINEAR_EXT ü2˳ĥ,
      ((<b_expand_linear_ext>)) Ƥ. ߤĥݡȤƤʤ.

    RETURN VALUE
    * cderiv_data (NArray): (na_{i+1} - na_{i-1}) / (x_{i+1} - x_{i-1})

---b_expand_linear_ext(data, dim)

    Expand boundary with linear value.
    礭, ꤷ˴ؤξü 1 ĤŤĿФ, ǡ
    ü2κ򤽤ΤޤޱĹ (ʤ 2*x_{0}-x_{1} ڤ
    2*x_{n-1}-x_{n-2}:  x  (({data})), _{i}  (({dim}))  i 
    ź, n ϤμĹɽ) 롣

    ARGUMENTS
    * data (NArray): a NArray which you want to expand boundary.
    * dim (Numeric): ĥ뼡. Numeric Ϳ. 
      (dim<0)ȤǤ뤬, data.rank dim < 0 ȤʤäƤϤʤ.

    RETURN VALUE
    * expand_data (NArray): 

---cdiff(data, dim)

    Diffrence operater. data ʬȤä( ʤ (x_{i+1} - x_{i-1}): 
     x  data, _{i}  ((<dim>)) ܤ i ܤźɽ ) ֤.

    ARGUMENTS
    * data (NArray): a NArray which you want to get difference.
    * dim (Numeric): ʬȤ뼡. Numeric Ϳ. (dim<0)
      ȤǤ뤬, (data.rank + dim < 0) ȤʤäƤϤʤ.

    RETURN VALUE
    * cdiff_data (NArray): (x_{i+1} - x_{i-1})

=end
############################################################

module NumRu

  module Derivative

    module_function 

    #<<module constant>>
    LINEAR_EXT = 1

    def cderiv(z, x, dim, bc=LINEAR_EXT)
      dim += z.rank if dim<0
      raise ArgumentError,"dim value (#{dim}) must be smaller than z.rank and >= 0" if dim >= z.rank || dim<0
      raise ArgumentError,"rank of x (#{x.rank}) must be 1" if x.rank != 1
      # <<expand boundary>>
      case bc
      when LINEAR_EXT
	ze = b_expand_linear_ext(z,dim)             # expand boundary of data.
      else
	raise ArgumentError,"unsupported boundary condition #{bc}."
      end
      xe = b_expand_linear_ext(x,0)                 # expand boundary of axis.
      # <<difference operation>>
      dz = cdiff(ze,dim)
      dx = cdiff(xe,0)
      if dx.rank != dz.rank                         # make dx.rank == dz.rank
	dx = dx.reshape(*([1]*dim + [true] + [1]*(dz.rank-1-dim))) 
      end
      dzdx = dz/dx
      return dzdx
    end
    
    def b_expand_linear_ext(na,dim)

      val0  = na[*([true]*dim +  [0] + [false])]    # first
      val1  = na[*([true]*dim +  [1] + [false])]    # second
      valm1 = na[*([true]*dim + [-1] + [false])]    # last 
      valm2 = na[*([true]*dim + [-2] + [false])]    # one before last

      # expand boundary
      nae = na[*([true]*dim   + [[0,0..(na.shape[dim]-1),0]]  + [false])]  
      nae[*([true]*dim + [0]  + [false])] = 2*val0-val1      
      nae[*([true]*dim + [-1] + [false])] = 2*valm1-valm2    
      return nae
    end
    
    def cdiff(na,dim)
      na1 = na[*([true]*dim   + [2..-1] + [false])]   
      na2 = na[*([true]*dim   + [0..-3] + [false])]   
      cna = na1-na2                                 # cna[i] = cna[n+1] - cna[n-1]
      return cna
    end
    
  end
  
end

######################################################
## < test >
if $0 == __FILE__
  include NumRu::Derivative
  include NMath
  
  nx = 10
  x1 = (2*PI*NArray.sfloat(nx).indgen!/(nx-1))
  f1 = sin(x1)
  dfdx1 = cderiv(f1, x1, 0)
  dfdx2 = cos(x1)
  print "#####\n"
  print "*******\n" 
  print "1-dimentional data\n"
  p f1
  p dfdx1
  print "dfdx - kaiseki_kai\n" 
  p ((dfdx1 - dfdx2).abs.max)

  nx=100; ny = 50; nz = 5 
  x2 = 2*PI*(NArray.sfloat(nx).indgen!/(nx-1))      # [0, .., 2PI]
  y2 =   PI*(NArray.sfloat(ny).indgen!/(ny-1)-0.5)  # [-PI/2,..,PI/2]
  z2 =      (NArray.sfloat(nz).indgen!)             # [0, 1, .., 10]
  f2 = (sin(x2).newdim(-1).newdim(-1))*(cos(y2).newdim(0).newdim(-1)*z2.newdim(0).newdim(0))
  print "*******\n" 
  dfdx1 = cderiv(f2, x2, 0)
  dfdy1 = cderiv(f2, y2, 1)
  dfdz1 = cderiv(f2, z2, 2)
  #<<kaiseki_kai>>
  dfdx2 =  (cos(x2).newdim(-1).newdim(-1))*(cos(y2).newdim(0).newdim(-1)*z2.newdim(0).newdim(0))
  dfdy2 = -(sin(x2).newdim(-1).newdim(-1))*(sin(y2).newdim(0).newdim(-1)*z2.newdim(0).newdim(0))
  dfdz2 =  (sin(x2).newdim(-1).newdim(-1))*(cos(y2).newdim(0).newdim(-1))
  print "*******\n" 
  print "3-dimentional data\n"
  print "dfdx - kaiseki_kai\n" 
  p ((dfdx1 - dfdx2).abs.max)
  print "dfdy - kaiseki_kai\n" 
  p ((dfdy1 - dfdy2).abs.max)
  print "dfdz - kaiseki_kai\n" 
  p ((dfdz1 - dfdz2).abs.max)
  print "#####\n"

end
