require "mkmf"

def have_librarys(*lib)
  printf "checking librarys lib%s... ", lib.join(", lib")
  STDOUT.flush

  libs = "-l" + lib.join(" -l") + " " + $libs
  r = try_link(<<"SRC", libs)
int main() { return 0; }
SRC
  unless r
    print "no\n"
    return false
  end

  $libs = libs
  print "yes\n"
  return true
end

case RUBY_PLATFORM
when "i386-linux"

  dir_config("--with-ifort9","/opt/intel/fc/9.0/include","/opt/intel/fc/9.0/lib")
  if ! have_librarys("imf","svml") then
    STDERR.print "cannot find library file for imf,svml\n"
    STDERR.print "ruby extconf.rb --with-ifort9-lib=(path of libimf.so and libsvml.so)\n"
    exit 1
  end

else

    STDERR.print "unsuported platform: "+RUBY_PLATFORM+"\n"
    exit 1

end

dir_config("--with-ispack","/usr/local/lib","/usr/local/lib")
if ! have_library("isp") then
  STDERR.print "cannot find library file for isp\n"
  STDERR.print "ruby extconf.rb --with-ispack-lib=(path of libisp.a)\n"
  exit 1
end

create_makefile("ispack_raw")
