!----------------------------------------------------------------------
!     COPYRIGHT (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  aq_module ƥȥץ
!
!  2008/04/01  ݹ
!      2008/07/07  ʿ ϰϤ
!      2008/08/13  ݹ q_r2_q ƥɲ
!
program aq_test_base1d

  use dc_message, only : MessageNotify
  use aq_module
  implicit none

  integer, parameter :: im=16, km=31         ! ʻ, ȿ
  real(8), parameter :: ra=2                 ! ΰ礭

  real(8), parameter :: alpha=1.0D0        ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta= 1.0D0        ! Ÿ¿༰ѥ᥿  0 < 

  real(8), parameter :: eps=5.0D-8

  real(8), dimension(im)   :: g_z
  real(8), dimension(0:km) :: q_z

  write(6,*)'++++++ Testing basic functions q_g, g_q, q_rDr_q, q_r2_q, q_r2Inv_q +++++'

  call aq_Initial(im,km,ra,alpha,beta,(/1/))

  g_z = g_R**5
  q_z = q_g(g_z)
  write(6,*) 'z = g_R**5'
  write(6,*) 'g_q(q_g(z)) - z = 0'
  write(6,*) 'Max.val of error values is ', maxval(abs(g_q(q_z)- g_z))
  if ( maxval(abs(g_q(q_z)- g_z)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'Transform error too large.')
  endif

  write(6,*) 'q_rDr_q(q_g(z))) - 5*g_R**5 = 0'
  write(6,*) 'Max.val of calculated error are ',&
       maxval(abs(g_q(q_rDr_q(q_z)) - 5*g_R**5))
  if ( maxval(abs(g_q(q_rDr_q(q_z)) - 5*g_R**5)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'Differentiation error too large.')
  endif

  write(6,*) 'q_r2_q(q_g(z))) - g_R**7 = 0'
  write(6,*) 'Max.val of calculated error are ',&
       maxval(abs(g_q(q_r2_q(q_z)) - g_R**7))
  if ( maxval(abs(g_q(q_r2_q(q_z)) - g_R**7)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'r^2 multipilication error too large.')
  endif

  write(6,*) 'q_r2Inv_q(q_g(z))) - g_R**3 = 0'
  write(6,*) 'Max.val of calculated error are ',&
       maxval(abs(g_q(q_r2Inv_q(q_z)) - g_R**3))
  if ( maxval(abs(g_q(q_r2Inv_q(q_z)) - g_R**3)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'r^-2 multipilication error too large.')
  endif

  call aq_Initial(im,km,ra,alpha,beta,(/2/))

  g_z = g_R**6
  q_z = q_g(g_z)
  write(6,*) 'z = g_R**6'
  write(6,*) 'g_q(q_g(z)) - z = 0'
  write(6,*) 'Max.val of error values is ', maxval(abs(g_q(q_z)- g_z))
  if ( maxval(abs(g_q(q_z)- g_z)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'Transform error too large.')
  endif

  write(6,*) 'q_rDr_q(q_g(z))) - 6*g_R**6 = 0'
  write(6,*) 'Max.val of calculated error are ',&
       maxval(abs(g_q(q_rDr_q(q_z)) - 6*g_R**6))
  if ( maxval(abs(g_q(q_rDr_q(q_z)) - 6*g_R**6)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'Differentiation error too large.')
  endif

  write(6,*) 'q_r2_q(q_g(z))) - g_R**8 = 0'
  write(6,*) 'Max.val of calculated error are ',&
       maxval(abs(g_q(q_r2_q(q_z)) - g_R**8))
  if ( maxval(abs(g_q(q_r2_q(q_z)) - g_R**8)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'r^2 multipilication error too large.')
  endif

  write(6,*) 'q_r2Inv_q(q_g(z))) - g_R**4 = 0'
  write(6,*) 'Max.val of calculated error are ',&
       maxval(abs(g_q(q_r2Inv_q(q_z)) - g_R**4))
  if ( maxval(abs(g_q(q_r2Inv_q(q_z)) - g_R**4)) > eps )then
     call MessageNotify('E','aq_test_base1d', &
          'r^-2 multipilication error too large.')
  endif

  call MessageNotify('M','aq_test_base1d', &
       'Tests of basic functions g_q, q_g, q_rDr_q suceeded!')

end program aq_test_base1d
