!----------------------------------------------------------------------
!     COPYRIGHT (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/04/10  $BC]9-??0l(B
!      2007/10/25  $BC]9-??0l(B  $B%(%i!<%a%C%;!<%8DI2C(B
!
program at_test_base

  use dc_message, only : MessageNotify
  use at_module
  implicit none
  integer, parameter :: im=32, km=32, nm=2
  real(8), parameter :: xmin=-2.0D0, xmax=6.0D0
  real(8), parameter :: eps=1.0D-6

  real(8), dimension(0:im) :: g_z
  real(8), dimension(0:im) :: g_z_sol

  real(8), allocatable, dimension(:) :: t_z

  real(8), dimension(nm,0:im) :: ag_z
  real(8), dimension(nm,0:im) :: ag_z_sol

  real(8), allocatable, dimension(:,:) :: at_z

  integer :: i

  write(6,*)'++++++ Testing basic functions +++++'

do i=1,2
  allocate(t_z(0:km/i),at_z(nm,0:km/i))
  call at_initial(im,km/i,xmin,xmax)

  write(6,*)'Testing g_t,t_g...'
  g_z = sin(g_X)
  t_z = t_g(g_z)
  write(6,*) 'z = sin(x)'
  g_z_sol = g_z
  write(6,*) 'g_t(t_g(z)) - z = 0'
  write(6,*) 'Max.val of calculated values is ', maxval(abs(g_t(t_z)- g_z_sol))
  if ( maxval(abs(g_t(t_z)- g_z)) > eps )then
     call MessageNotify('E','Test of g_t', &
          'Transform error too large.')
  endif

  write(6,*)'Testing t_Dx_t...'
  g_z_sol = cos(g_X)
  write(6,*) "g_t(t_dx_t(t_g(z))) - z' = 0"
  write(6,*) 'Max.val of calculated values are ',&
       maxval(abs(g_t(t_dx_t(t_z)) - g_z_sol))
  if ( maxval(abs(g_t(t_dx_t(t_z)) - g_z_sol)) > eps )then
     call MessageNotify('E','Test of t_dx_t', &
          'Differentiation error too large.')
  endif

  ag_z(1,:) = cos(g_X)
  ag_z(2,:) = exp(-g_X/2)
  at_z = at_ag(ag_z)

  write(6,*)'Testing ag_at,at_ag...'
  write(6,*) 'ag_at(at_ag(z)) - z = 0'
  write(6,*) 'Max.val of calculated values is ', maxval(abs(ag_at(at_z)- ag_z))
  if ( maxval(abs(ag_at(at_z)- ag_z)) > eps )then
     call MessageNotify('E','Test of ag_at', &
          'Transform error too large.')
  endif

  write(6,*)'Testing at_Dx_at...'
  ag_z_sol(1,:) = -sin(g_X)
  ag_z_sol(2,:) = -exp(-g_X/2)/2
  write(6,*) "ag_at(at_Dx_at(at_ag(z))) - z' = 0"
  write(6,*) 'Max.val of calculated values are ',&
       maxval(abs(ag_at(at_Dx_at(at_z)) - ag_z_sol))
  if ( maxval(abs(ag_at(at_Dx_at(at_z)) - ag_z_sol)) > eps )then
     call MessageNotify('E','Test of t_dx_t', &
          'Differentiation error too large.')
  endif

  deallocate(t_z,at_z)
enddo

  call MessageNotify('M','Test of basic functions', &
       'Tests of basic functions g_t, t_g, t_Dx_t, ag_at, at_ag, at_Dx_at suceeded!')


end program at_test_base
