!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  yt_module
!      ݥ뼧Ȼ
!
!  2002/02/07  ݹ
!      2002/04/11  ݹ  ⥸塼̾ѹ
!
program ytdiff3

  use lumatrix
  use yt_module
  use gtool_history
  implicit none

 !---- ֲ ----
  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)

 !---- ɸѿʤ ----
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

 !---- ѿ ----
  real(8), dimension(im,jm,0:km)     :: ggg_pmag   ! ݥ뼧
  real(8), dimension((nm+1)**2,0:lm) :: yt_pmag    ! ݥ뼧

  real(8)             :: gg_pmagbndry(im,jm,2)     ! 
  real(8)             :: y_pmagbndry((nm+1)**2,2)  ! 

 !---- ʬѥ᥿ ----
  real(8), parameter :: dt=1e-5                 ! ֥ƥå״ֳ
  integer, parameter :: nt=10000, ndisp=1000    ! ʬ, ɽƥå

 !---- ʪѥ᥿ ----
  character(len=2), parameter :: tempbc='DN'    ! ٶ(DD/DN/ND/NN)
  real(8), parameter :: nu=1.0                  ! Ǵ

  real(8), parameter :: pi=3.1415926535897932385D0
  real(8), parameter :: lon1=pi                 ! ʬ۰ٺɸ
  real(8), parameter :: lat1=0.0                ! ʬ۷ٺɸ
  real(8), parameter :: rad1=(ri+ro)/2.0        ! ʬưºɸ
  real(8), parameter :: sigma=0.2               ! ʬۤ礭

 !---- ¾ ----
  integer :: it


 !---------------- ɸͤ ---------------------
  call yt_initial(im,jm,km,nm,lm,ri,ro)

 !-------------------  ----------------------
  ggg_pmag =  exp(-((ggg_lon-lon1)**2+(ggg_lat-lat1)**2+(ggg_rad-rad1)**2)&
                 /(2*sigma**2))
  yt_pmag = yt_ggg(ggg_pmag)


 !-------------------  ----------------------
  gg_pmagbndry(:,:,1) = 0
  gg_pmagbndry(:,:,2) = 0

  y_pmagbndry(:,1) = y_gg(gg_pmagbndry(:,:,1))
  y_pmagbndry(:,2) = y_gg(gg_pmagbndry(:,:,2))

  call output_gtool4_init
  call output_gtool4

 !------------------- ʬ ----------------------
  do it=1,nt                                         ! Euler ˡˤʬ
     yt_pmag = yt_pmag + dt *( nu * yt_lapla_yt(yt_pmag) )
     call ytpmagboundaries(yt_pmag)

     if(mod(it,ndisp) .eq. 0)then                    ! 
        ggg_pmag = ggg_yt(yt_pmag)
        call output_gtool4
     endif
  enddo
  call output_gtool4_close

contains
  subroutine ytpmagboundaries(yt) ! ڥȥ֤ǤΥݥ뼧춭
    ! ϤŵƳΤξ
    !     dBP_l^m/dr + (l+1)BP_l^m/r = 0 at r=r_o
    !     dBP_l^m/dr - l BP_l^m/r = 0    at r=r_i

    real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)  :: yt ! ǡ

    real(8), dimension(:,:,:), allocatable  :: alu
    integer, dimension(:,:), allocatable    :: kp
    real(8), dimension(0:lm,0:lm)           :: tt_data
    real(8), dimension(0:lm,0:km)           :: tg_f
    real(8), dimension(0:lm,0:km)           :: tg_dfdr

    logical :: first = .true.
    integer :: l, nwave(2), m, nn
    save    :: alu, kp, first

    if ( first ) then
       first = .false.

       allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))

       tt_data = 0
       do l=0,lm
          tt_data(l,l)=1
       enddo
       alu = spread(tt_data,1,(nm+1)*(nm+1))

       tg_f    = ag_at(tt_data)
       tg_dfdr = ag_at(at_dr_at(tt_data))

       do nn=1,(nm+1)*(nm+1)
          nwave = nm_l(nn)
          l = nwave(1)
          alu(nn,lm-1,:) = tg_dfdr(:,0)  + (l+1) * tg_f(:,0)/g_rad(0)
          alu(nn,lm,:)   = tg_dfdr(:,km) - l * tg_f(:,km)/g_rad(km)
       end do

       call ludecomp(alu,kp)
    end if

    yt(:,km-1) = 0
    yt(:,km)   = 0
    yt = lusolve(alu,kp,yt)

  end subroutine ytpmagboundaries

  subroutine output_gtool4_init
    call HistoryCreate( &                                  ! ҥȥ꡼
           file='yt_diff3.nc', title='Diffusion model in a spherical shell', &
           source='Sample program of spmodel library', &
           institution='GFD_Dennou Club SPMODEL project',     &
           dims=(/'lon','lat','rad','t  '/), dimsizes=(/im,jm,km+1,0/),&
           longnames=(/'Longitude','Latitude ','Radius   ','time     '/),&
           units=(/'1','1','1','1'/),   &
           origin=0.0, interval=real(ndisp*dt) )

    call HistoryPut('lon',g_lon/pi*180)                       ! ѿ
    call HistoryPut('lat',g_lat/pi*180)                       ! ѿ
    call HistoryPut('rad',g_rad)                              ! ѿ

    call HistoryAddVariable( &                                ! ѿ
           varname='pmag', dims=(/'lon','lat','rad','t  '/), & 
           longname='poloidal magnetic potential', units='1', xtype='double')
  end subroutine output_gtool4_init

  subroutine output_gtool4
    write(6,*) 'it = ',it
    call HistoryPut('t',real(it*dt))
    call HistoryPut('pmag',ggg_pmag)
  end subroutine output_gtool4

  subroutine output_gtool4_close
    call HistoryClose
  end subroutine output_gtool4_close

end program ytdiff3

