!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wghi_module
!
!  2002/05/26  ݹ  
!
!ľؤΤȤ
!
!   -------------     nz         g(nz)
!		     nz-1/2      h(nz)
!   -------------     nz-1       g(nz-1), i(nz-1)
!   ...
!
!   ...
!   -------------     2          g(2), i(2)
!		     3/2         h(2)
!   -------------     1          g(1), i(1)
!		     1/2         h(1)
!   -------------  iz=0          g(0)
!
!
!      ǡ index
!
!   x   : ٳʻ
!   y   : ٳʻ
!   g   : ľʻ()      Grid points
!   h   : ľʻ(Ⱦ)    grid points with Half integer
!   i   : ľʻ(,ΰ) Internal grid points
!
!   w   : ʿĴȡ
!   a   : Ǥդμ
!
!   xyg, xyh : 3 ʻǡ
!   wg, wh   : ʿڥȥľʻǡ(ľʻ)
!
!   xy      : ʿʻǡ
!   w       : ʿڥȥǡ
!
!   xg, xh  : ٱ̳ʻǡ
!   yg, yh  : Ҹ̳ʻǡ
!
module wghi_module

  use wa_module
  implicit none
  private

  public wghi_initial

 !---- ɸѿ ----
  public x_lon, x_lon_weight
  public y_lat, y_lat_weight
  public g_ver, g_ver_weight
  public h_ver, h_ver_weight
  public i_ver, i_ver_weight
  public l_nm, nm_l
  public xyg_lon, xyg_lat, xyg_ver
  public xyh_lon, xyh_lat, xyh_ver
  public xyi_lon, xyi_lat, xyi_ver

 !---- ǡѴ ----
  public w_xy, xy_w                                     ! ڥȥѴ
  public xyg_wg, xyh_wh, xyi_wi                         ! ڥȥѴ
  public wg_xyg, wh_xyh, wi_xyi                         ! ڥȥѴ
  public xyi_xyg, xi_xg, yi_yg, i_g, wi_wg              ! ľʻ
  public xyi_xyh, xi_xh, yi_yh, i_h, wi_wh              ! ľʻ
  public xyh_xyg, xh_xg, yh_yg, h_g, wh_wg              ! ľʻ
  public xyg_yg, xyh_yh, xyi_yi                         ! Ҹ̥ǡĥ

 !---- ʬ ----

  public wi_dver_wh, wh_dver_wg                            ! ľʬ
  public xyg_gradlon_wg, xyg_gradlat_wg                    ! ʿ
  public xyh_gradlon_wh, xyh_gradlat_wh                    ! ʿ
  public xyi_gradlon_wi, xyi_gradlat_wi                    ! ʿ
  public wg_divlon_xyg, wg_divlat_xyg                      ! ȯ
  public wh_divlon_xyh, wh_divlat_xyh, wh_div_xyh_xyh_xyg  ! ȯ
  public wi_divlon_xyi, wi_divlat_xyi, wi_div_xyi_xyi_xyh  ! ȯ
  public wg_laplah_wg, wh_laplah_wh, wi_laplah_wi          ! ʿץ饷

 !---- ʬ ----
  public yg_intlon_xyg, yh_intlon_xyh 
  public xg_intlat_xyg, xh_intlat_xyh
  public xy_intver_xyg, xy_intver_xyh
  public y_intlonver_xyg, y_intlonver_xyh
  public x_intlatver_xyg, x_intlatver_xyh
  public g_intlonlat_xyg, h_intlonlat_xyh
  public intlonlatver_xyg, intlonlatver_xyh

 !---- ʿ ----
  public yg_avrlon_xyg, yh_avrlon_xyh 
  public xg_avrlat_xyg, xh_avrlat_xyh
  public xy_avrver_xyg, xy_avrver_xyh
  public x_avrlatver_xyg, x_avrlatver_xyh
  public y_avrlonver_xyg, y_avrlonver_xyh
  public g_avrlonlat_xyg, h_avrlonlat_xyh
  public avrlonlatver_xyg, avrlonlatver_xyh


 !---- ѿ ----
  integer            :: im=64, jm=32, km=16  ! ʻ(, , ľ)
  integer            :: nm=21                ! ʿȿ
  real(8)            :: ra=1.0               ! Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:), allocatable :: g_ver, g_ver_weight    ! ľɸ
  real(8), dimension(:), allocatable :: h_ver, h_ver_weight    ! ľɸ
  real(8), dimension(:), allocatable :: i_ver, i_ver_weight    ! ľɸ

  real(8), dimension(:,:,:), allocatable :: xyg_lon, xyg_lat, xyg_ver ! ɸ
  real(8), dimension(:,:,:), allocatable :: xyh_lon, xyh_lat, xyh_ver ! ɸ
  real(8), dimension(:,:,:), allocatable :: xyi_lon, xyi_lat, xyi_ver ! ɸ

  save im, jm, km, nm, ra

  contains
  !---------------  -----------------
    subroutine wghi_initial(i,j,k,n,r,g_in,h_in)

     integer,intent(in) :: i, j, k        ! ʻ(, , ľ)
     integer,intent(in) :: n              ! ȿ(ʿ)
     real(8),intent(in) :: r              ! Ⱦ
     real(8),intent(in),dimension(0:k) :: g_in       ! ľɸ
     real(8),intent(in),dimension(k)   :: h_in       ! ľɸ

     im = i  ; jm = j ; km = k
     nm = n  ; ra = r

     call wa_initial(nm,im,jm,km+1)

     allocate(g_ver(0:km))
     allocate(g_ver_weight(0:km))
     allocate(h_ver(km))
     allocate(h_ver_weight(km))
     allocate(i_ver(km-1))
     allocate(i_ver_weight(km-1))

     g_ver = g_in ; h_ver = h_in

     h_ver_weight = g_ver(1:km) - g_ver(0:km-1)
     g_ver_weight(1:km-1) = h_ver(2:km) - h_ver(1:km-1)
     g_ver_weight(0) = h_ver(1) - g_ver(0)
     g_ver_weight(km) = g_ver(km) - h_ver(km)

     i_ver = i_g(g_ver) ; i_ver_weight = i_g(g_ver_weight)

     allocate(xyg_lon(im,jm,0:km))
     allocate(xyg_lat(im,jm,0:km))
     allocate(xyg_ver(im,jm,0:km))
     allocate(xyh_lon(im,jm,km))
     allocate(xyh_lat(im,jm,km))
     allocate(xyh_ver(im,jm,km))
     allocate(xyi_lon(im,jm,km-1))
     allocate(xyi_lat(im,jm,km-1))
     allocate(xyi_ver(im,jm,km-1))

     xyg_lon = spread(xy_lon,3,km+1)
     xyg_lat = spread(xy_lat,3,km+1)
     xyg_ver = spread(spread(g_ver,1,jm),1,im)
     xyh_lon = spread(xy_lon,3,km)
     xyh_lat = spread(xy_lat,3,km)
     xyh_ver = spread(spread(h_ver,1,jm),1,im)
     xyi_lon = spread(xy_lon,3,km-1)
     xyi_lat = spread(xy_lat,3,km-1)
     xyi_ver = spread(spread(i_ver,1,jm),1,im)

   end subroutine wghi_initial

  !--------------- Ѵ -----------------

    function xyg_wg(wg_data)  ! ڥȥ -> ʻ
      real(8), dimension(im,jm,0:km)                     :: xyg_wg
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data

      xyg_wg = xya_wa(wg_data)

    end function xyg_wg

    function xyh_wh(wh_data)  ! ڥȥ -> ʻ
      real(8), dimension(im,jm,km)                     :: xyh_wh
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wh_data

      xyh_wh = xya_wa(wh_data)

    end function xyh_wh

    function xyi_wi(wi_data)  ! ڥȥ -> ʻ
      real(8), dimension(im,jm,km-1)                     :: xyi_wi
      real(8), dimension((nm+1)*(nm+1),km-1), intent(in) :: wi_data

      xyi_wi = xya_wa(wi_data)

    end function xyi_wi

    function wg_xyg(xyg_data)  ! ʻ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wg_xyg
      real(8), dimension(im,jm,0:km), intent(in)         :: xyg_data

      wg_xyg = wa_xya(xyg_data)

    end function wg_xyg

    function wh_xyh(xyh_data)  ! ʻ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),km)             :: wh_xyh
      real(8), dimension(im,jm,km), intent(in)         :: xyh_data

      wh_xyh = wa_xya(xyh_data)

    end function wh_xyh

    function wi_xyi(xyi_data)  ! ʻ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),km-1)             :: wi_xyi
      real(8), dimension(im,jm,km-1), intent(in)         :: xyi_data

      wi_xyi = wa_xya(xyi_data)

    end function wi_xyi

    function xyi_xyg(xyg_data) ! ľѴ
      real(8), dimension(im,jm,km-1)                     :: xyi_xyg
      real(8), dimension(im,jm,0:km), intent(in)         :: xyg_data

      xyi_xyg = xyg_data(:,:,1:km-1)
    end function xyi_xyg

    function xi_xg(xg_data)    ! ľѴ
      real(8), dimension(im,km-1)                     :: xi_xg
      real(8), dimension(im,0:km), intent(in)         :: xg_data

      xi_xg = xg_data(:,1:km-1)
    end function xi_xg

    function yi_yg(yg_data)    ! ľѴ
      real(8), dimension(jm,km-1)                     :: yi_yg
      real(8), dimension(jm,0:km), intent(in)         :: yg_data

      yi_yg = yg_data(:,1:km-1)
    end function yi_yg

    function i_g(g_data)       ! ľѴ
      real(8), dimension(km-1)                     :: i_g
      real(8), dimension(0:km), intent(in)         :: g_data

      i_g = g_data(1:km-1)
    end function i_g

    function wi_wg(wg_data)    ! ľѴ
      real(8), dimension((nm+1)*(nm+1),km-1)             :: wi_wg
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data

      wi_wg = wg_data(:,1:km-1)
    end function wi_wg

    function xyi_xyh(xyh_data)    ! ľ(ľ)
      real(8), dimension(im,jm,km-1)                   :: xyi_xyh
      real(8), dimension(im,jm,km), intent(in)         :: xyh_data
      integer :: k

      do k=1,km-1
         xyi_xyh(:,:,k) = (   (h_ver(k+1)-i_ver(k))*xyh_data(:,:,k)  &
                            + (i_ver(k)-h_ver(k))*xyh_data(:,:,k+1) )&
                          /(h_ver(k+1)-h_ver(k))
      enddo
    end function xyi_xyh

    function xi_xh(xh_data)    ! ľ(ľ)
      real(8), dimension(im,km-1)                   :: xi_xh
      real(8), dimension(im,km), intent(in)         :: xh_data
      integer :: k

      do k=1,km-1
         xi_xh(:,k) = (   (h_ver(k+1)-i_ver(k))*xh_data(:,k)  &
                        + (i_ver(k)-h_ver(k))*xh_data(:,k+1) )&
                          /(h_ver(k+1)-h_ver(k))
      enddo
    end function xi_xh

    function yi_yh(yh_data)    ! ľ(ľ)
      real(8), dimension(jm,km-1)                   :: yi_yh
      real(8), dimension(jm,km), intent(in)         :: yh_data
      integer :: k

      do k=1,km-1
         yi_yh(:,k) = (   (h_ver(k+1)-i_ver(k))*yh_data(:,k)  &
                        + (i_ver(k)-h_ver(k))*yh_data(:,k+1) )&
                          /(h_ver(k+1)-h_ver(k))
      enddo
    end function yi_yh

    function i_h(h_data)       ! ľ(ľ)
      real(8), dimension(km-1)                   :: i_h
      real(8), dimension(km), intent(in)         :: h_data
      integer :: k

      do k=1,km-1
         i_h(k) = (   (h_ver(k+1)-i_ver(k))*h_data(k)  &
                    + (i_ver(k)-h_ver(k))*h_data(k+1) )&
                  /(h_ver(k+1)-h_ver(k))
      enddo
    end function i_h

    function wi_wh(wh_data)    ! ľ(ľ)
      real(8), dimension((nm+1)*(nm+1),km-1)           :: wi_wh
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wh_data
      integer :: k

      do k=1,km-1
         wi_wh(:,k) = (   (h_ver(k+1)-i_ver(k))*wh_data(:,k)  &
                        + (i_ver(k)-h_ver(k))*wh_data(:,k+1) )&
                          /(h_ver(k+1)-h_ver(k))
      enddo
    end function wi_wh

    function xyh_xyg(xyg_data)    ! ľ(ľ)
      real(8), dimension(im,jm,km)                   :: xyh_xyg
      real(8), dimension(im,jm,0:km), intent(in)     :: xyg_data
      integer :: k

      do k=1,km
         xyh_xyg(:,:,k) = (   (g_ver(k)-h_ver(k))*xyg_data(:,:,k-1)  &
                            + (h_ver(k)-g_ver(k-1))*xyg_data(:,:,k) )&
                          /(g_ver(k)-g_ver(k-1))
      enddo
    end function xyh_xyg

    function xh_xg(xg_data)    ! ľ(ľ)
      real(8), dimension(im,km)                       :: xh_xg
      real(8), dimension(im,0:km), intent(in)         :: xg_data
      integer :: k

      do k=1,km
         xh_xg(:,k) = (   (g_ver(k)-h_ver(k))*xg_data(:,k-1)  &
                        + (h_ver(k)-g_ver(k-1))*xg_data(:,k) )&
                        /(g_ver(k)-g_ver(k-1))
      enddo
    end function xh_xg

    function yh_yg(yg_data)    ! ľ(ľ)
      real(8), dimension(jm,km)                       :: yh_yg
      real(8), dimension(jm,0:km), intent(in)         :: yg_data
      integer :: k

      do k=1,km
         yh_yg(:,k) = (   (g_ver(k)-h_ver(k))*yg_data(:,k-1)  &
                        + (h_ver(k)-g_ver(k-1))*yg_data(:,k) )&
                        /(g_ver(k)-g_ver(k-1))
      enddo
    end function yh_yg

    function h_g(g_data)       ! ľ(ľ)
      real(8), dimension(km)                       :: h_g
      real(8), dimension(0:km), intent(in)         :: g_data
      integer :: k

      do k=1,km
         h_g(k) = (   (g_ver(k)-h_ver(k))*g_data(k-1)  &
                    + (h_ver(k)-g_ver(k-1))*g_data(k) ) &
                   /(g_ver(k)-g_ver(k-1))
      enddo
    end function h_g

    function wh_wg(wg_data)    ! ľ(ľ)
      real(8), dimension((nm+1)*(nm+1),km)               :: wh_wg
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data
      integer :: k

      do k=1,km
         wh_wg(:,k) = (   (g_ver(k)-h_ver(k))*wg_data(:,k-1)  &
                        + (h_ver(k)-g_ver(k-1))*wg_data(:,k) )&
                        /(g_ver(k)-g_ver(k-1))
      enddo
    end function wh_wg

    function xyg_yg(yg_data)    ! Ҹ̥ǡĥ
      real(8), dimension(im,jm,0:km)              :: xyg_yg
      real(8), dimension(jm,0:km), intent(in)     :: yg_data

      xyg_yg = spread(yg_data,1,im)
    end function xyg_yg

    function xyh_yh(yh_data)    ! Ҹ̥ǡĥ
      real(8), dimension(im,jm,km)                :: xyh_yh
      real(8), dimension(jm,km), intent(in)       :: yh_data

      xyh_yh = spread(yh_data,1,im)
    end function xyh_yh

    function xyi_yi(yi_data)    ! Ҹ̥ǡĥ
      real(8), dimension(im,jm,km-1)              :: xyi_yi
      real(8), dimension(jm,km-1), intent(in)     :: yi_data

      xyi_yi = spread(yi_data,1,im)
    end function xyi_yi

  !--------------- ʬ׻ -----------------
    function wi_dver_wh(wh_data)            ! ľʬ
      real(8), dimension((nm+1)*(nm+1),km-1), intent(in) :: wh_data
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wi_dver_wh

      wi_dver_wh = (wh_data(:,2:km) - wh_data(:,1:km-1)) & 
                              /spread(i_ver_weight,1,(nm+1)*(nm+1))

    end function wi_dver_wh

    function wh_dver_wg(wg_data)            ! ľʬ
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data
      real(8), dimension((nm+1)*(nm+1),km)               :: wh_dver_wg

      wh_dver_wg = (wg_data(:,1:km) - wg_data(:,0:km-1)) &
                    /spread(h_ver_weight,1,(nm+1)*(nm+1))

    end function wh_dver_wg

    function xyg_gradlon_wg(wg_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! 1/rcosա/ߦ
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data
      real(8), dimension(im,jm,0:km)                     :: xyg_gradlon_wg

      xyg_gradlon_wg = xya_gradlon_wa(wg_data)/ra

    end function xyg_gradlon_wg

    function xyh_gradlon_wh(wh_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! 1/rcosա/ߦ
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wh_data
      real(8), dimension(im,jm,km)                     :: xyh_gradlon_wh

      xyh_gradlon_wh = xya_gradlon_wa(wh_data)/ra

    end function xyh_gradlon_wh

    function xyi_gradlon_wi(wi_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! 1/rcosա/ߦ
      real(8), dimension((nm+1)*(nm+1),km-1), intent(in) :: wi_data
      real(8), dimension(im,jm,km-1)                     :: xyi_gradlon_wi

      xyi_gradlon_wi = xya_gradlon_wa(wi_data)/ra

    end function xyi_gradlon_wi

    function xyg_gradlat_wg(wg_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! 1/r /ߦ
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data
      real(8), dimension(im,jm,0:km)                     :: xyg_gradlat_wg

      xyg_gradlat_wg = xya_gradlat_wa(wg_data)/ra
    end function xyg_gradlat_wg

    function xyh_gradlat_wh(wh_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! 1/r /ߦ
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wh_data
      real(8), dimension(im,jm,km)                     :: xyh_gradlat_wh

      xyh_gradlat_wh = xya_gradlat_wa(wh_data)/ra
    end function xyh_gradlat_wh

    function xyi_gradlat_wi(wi_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! 1/r /ߦ
      real(8), dimension((nm+1)*(nm+1),km-1), intent(in) :: wi_data
      real(8), dimension(im,jm,km-1)                     :: xyi_gradlat_wi

      xyi_gradlat_wi = xya_gradlat_wa(wi_data)/ra
    end function xyi_gradlat_wi

    function wg_divlon_xyg(xyg_data)   ! ʻҤ˺Ѥȯʬ 
                                       ! 1/rcosա/ߦ

      real(8), dimension(im,jm,0:km), intent(in)   :: xyg_data
      real(8), dimension((nm+1)*(nm+1),0:km)       :: wg_divlon_xyg

      wg_divlon_xyg = wa_divlon_xya(xyg_data)/ra
    end function wg_divlon_xyg

    function wh_divlon_xyh(xyh_data)   ! ʻҤ˺Ѥȯʬ 
                                       ! 1/rcosա/ߦ

      real(8), dimension(im,jm,km), intent(in)   :: xyh_data
      real(8), dimension((nm+1)*(nm+1),km)       :: wh_divlon_xyh

      wh_divlon_xyh = wa_divlon_xya(xyh_data)/ra
    end function wh_divlon_xyh

    function wi_divlon_xyi(xyi_data)   ! ʻҤ˺Ѥȯʬ 
                                       ! 1/rcosա/ߦ

      real(8), dimension(im,jm,km-1), intent(in)   :: xyi_data
      real(8), dimension((nm+1)*(nm+1),km-1)       :: wi_divlon_xyi

      wi_divlon_xyi = wa_divlon_xya(xyi_data)/ra
    end function wi_divlon_xyi

    function wg_divlat_xyg(xyg_data)   ! ʻҤ˺Ѥȯʬ
                                       ! 1/rcosա(f cos)/ߦ

      real(8), dimension(im,jm,0:km), intent(in)   :: xyg_data
      real(8), dimension((nm+1)*(nm+1),0:km)       :: wg_divlat_xyg

      wg_divlat_xyg = wa_divlat_xya(xyg_data)/ra
    end function wg_divlat_xyg

    function wh_divlat_xyh(xyh_data)   ! ʻҤ˺Ѥȯʬ
                                       ! 1/rcosա(f cos)/ߦ

      real(8), dimension(im,jm,km), intent(in)   :: xyh_data
      real(8), dimension((nm+1)*(nm+1),km)       :: wh_divlat_xyh

      wh_divlat_xyh = wa_divlat_xya(xyh_data)/ra
    end function wh_divlat_xyh

    function wi_divlat_xyi(xyi_data)   ! ʻҤ˺Ѥȯʬ
                                       ! 1/rcosա(f cos)/ߦ

      real(8), dimension(im,jm,km-1), intent(in)   :: xyi_data
      real(8), dimension((nm+1)*(nm+1),km-1)       :: wi_divlat_xyi

      wi_divlat_xyi = wa_divlat_xya(xyi_data)/ra
    end function wi_divlat_xyi

    function wi_div_xyi_xyi_xyh(xyi_vlon,xyi_vlat,xyh_vver)    ! ȯ

      real(8), dimension(im,jm,km-1), intent(in) :: xyi_vlon   ! ʬ
      real(8), dimension(im,jm,km-1), intent(in) :: xyi_vlat   ! ʬ
      real(8), dimension(im,jm,km), intent(in)   :: xyh_vver   ! ưʬ
      real(8), dimension((nm+1)*(nm+1),km-1)     :: wi_div_xyi_xyi_xyh

      wi_div_xyi_xyi_xyh =   wi_divlon_xyi(xyi_vlon) &
                           + wi_divlat_xyi(xyi_vlat) &
                           + wi_dver_wh(wh_xyh(xyh_vver))

    end function wi_div_xyi_xyi_xyh

    function wh_div_xyh_xyh_xyg(xyh_vlon,xyh_vlat,xyg_vver)    ! ȯ

      real(8), dimension(im,jm,km), intent(in)   :: xyh_vlon   ! ʬ
      real(8), dimension(im,jm,km), intent(in)   :: xyh_vlat   ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_vver   ! ưʬ
      real(8), dimension((nm+1)*(nm+1),km)       :: wh_div_xyh_xyh_xyg

      wh_div_xyh_xyh_xyg =   wh_divlon_xyh(xyh_vlon) &
                           + wh_divlat_xyh(xyh_vlat) &
                           + wh_dver_wg(wg_xyg(xyg_vver))

    end function wh_div_xyh_xyh_xyg

    function wg_laplah_wg(wg_data) ! ڥȥ˺Ѥʿץ饷
                                   ! ^2_H
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wg_data
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wg_laplah_wg

      wg_laplah_wg = wa_lapla_wa(wg_data)

    end function wg_laplah_wg

    function wh_laplah_wh(wh_data) ! ڥȥ˺Ѥʿץ饷
                                   ! ^2_H
      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wh_data
      real(8), dimension((nm+1)*(nm+1),km)             :: wh_laplah_wh

      wh_laplah_wh = wa_lapla_wa(wh_data)

    end function wh_laplah_wh

    function wi_laplah_wi(wi_data) ! ڥȥ˺Ѥʿץ饷
                                   ! ^2_H
      real(8), dimension((nm+1)*(nm+1),km-1), intent(in) :: wi_data
      real(8), dimension((nm+1)*(nm+1),km-1)             :: wi_laplah_wi

      wi_laplah_wi = wa_lapla_wa(wi_data)

    end function wi_laplah_wi

  !--------------- ʬ׻ -----------------

    function yg_intlon_xyg(xyg_data)  ! (Ӿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data ! 3 ʻ
      real(8), dimension(jm,0:km)  :: yg_intlon_xyg          ! Ҹ̳ʻ

      yg_intlon_xyg = ya_intlon_xya(xyg_data)
    end function yg_intlon_xyg

    function yh_intlon_xyh(xyh_data)  ! (Ӿ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data ! 3 ʻ
      real(8), dimension(jm,km)  :: yh_intlon_xyh          ! Ҹ̳ʻ

      yh_intlon_xyh = ya_intlon_xya(xyh_data)
    end function yh_intlon_xyh

    function xg_intlat_xyg(xyg_data)  ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data ! 3 ʻ
      real(8), dimension(im,0:km)  :: xg_intlat_xyg          ! ٱ߳ʻ

      xg_intlat_xyg = xa_intlat_xya(xyg_data)
    end function xg_intlat_xyg

    function xh_intlat_xyh(xyh_data)  ! ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data ! 3 ʻ
      real(8), dimension(im,km)  :: xh_intlat_xyh          ! ٱ߳ʻ

      xh_intlat_xyh = xa_intlat_xya(xyh_data)
    end function xh_intlat_xyh

    function xy_intver_xyg(xyg_data)  ! ưʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data ! 3 ʻ
      real(8), dimension(im,jm)  :: xy_intver_xyg            ! ʿʻ
      integer :: k

      xy_intver_xyg = 0
      do k=0,km
         xy_intver_xyg(:,:) = xy_intver_xyg(:,:) &
                       + xyg_data(:,:,k) * g_ver_weight(k)
      enddo
    end function xy_intver_xyg

    function xy_intver_xyh(xyh_data)  ! ưʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data ! 3 ʻ
      real(8), dimension(im,jm)  :: xy_intver_xyh            ! ʿʻ
      integer :: k

      xy_intver_xyh = 0
      do k=1,km
         xy_intver_xyh(:,:) = xy_intver_xyh(:,:) &
                       + xyh_data(:,:,k) * h_ver_weight(k)
      enddo
    end function xy_intver_xyh

    function x_intlatver_xyg(xyg_data)  ! ư(Ҹ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8), dimension(im)     :: x_intlatver_xyg      ! ٳʻ

      x_intlatver_xyg = x_intlat_xy(xy_intver_xyg(xyg_data))
    end function x_intlatver_xyg

    function x_intlatver_xyh(xyh_data)  ! ư(Ҹ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8), dimension(im)     :: x_intlatver_xyh         ! ٳʻ

      x_intlatver_xyh = x_intlat_xy(xy_intver_xyh(xyh_data))
    end function x_intlatver_xyh

    function y_intlonver_xyg(xyg_data)  ! ư(ٱ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8), dimension(jm)       :: y_intlonver_xyg         ! ٳʻ

      y_intlonver_xyg = y_intlon_xy(xy_intver_xyg(xyg_data))
    end function y_intlonver_xyg

    function y_intlonver_xyh(xyh_data)  ! ư(ٱ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8), dimension(jm)       :: y_intlonver_xyh       ! ٳʻ

      y_intlonver_xyh = y_intlon_xy(xy_intver_xyh(xyh_data))
    end function y_intlonver_xyh

    function g_intlonlat_xyg(xyg_data)  ! ٷ(ʿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8), dimension(0:km)     :: g_intlonlat_xyg         ! ư³ʻ

      g_intlonlat_xyg = a_intlonlat_xya(xyg_data)
    end function g_intlonlat_xyg

    function h_intlonlat_xyh(xyh_data)  ! ٷ(ʿ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8), dimension(km)     :: h_intlonlat_xyh         ! ư³ʻ

      h_intlonlat_xyh = a_intlonlat_xya(xyh_data)
    end function h_intlonlat_xyh

    function intlonlatver_xyg(xyg_data) ! ٷư()ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8)                        :: intlonlatver_xyg      ! ʬ

      intlonlatver_xyg = intlonlat_xy(xy_intver_xyg(xyg_data))
    end function intlonlatver_xyg

    function intlonlatver_xyh(xyh_data) ! ٷư()ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8)                        :: intlonlatver_xyh      ! ʬ

      intlonlatver_xyh = intlonlat_xy(xy_intver_xyh(xyh_data))
    end function intlonlatver_xyh

  !--------------- ʿѷ׻ -----------------

    function yg_avrlon_xyg(xyg_data)  ! (Ӿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data ! 3 ʻ
      real(8), dimension(jm,0:km)  :: yg_avrlon_xyg          ! Ҹ̳ʻ

      yg_avrlon_xyg = ya_avrlon_xya(xyg_data)
    end function yg_avrlon_xyg

    function yh_avrlon_xyh(xyh_data)  ! (Ӿ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data ! 3 ʻ
      real(8), dimension(jm,km)  :: yh_avrlon_xyh          ! Ҹ̳ʻ

      yh_avrlon_xyh = ya_avrlon_xya(xyh_data)
    end function yh_avrlon_xyh

    function xg_avrlat_xyg(xyg_data)  ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data ! 3 ʻ
      real(8), dimension(im,0:km)  :: xg_avrlat_xyg          ! ٱ߳ʻ

      xg_avrlat_xyg = xa_avrlat_xya(xyg_data)
    end function xg_avrlat_xyg

    function xh_avrlat_xyh(xyh_data)  ! ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data ! 3 ʻ
      real(8), dimension(im,km)  :: xh_avrlat_xyh          ! ٱ߳ʻ

      xh_avrlat_xyh = xa_avrlat_xya(xyh_data)
    end function xh_avrlat_xyh

    function xy_avrver_xyg(xyg_data)  ! ưʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data ! 3 ʻ
      real(8), dimension(im,jm)  :: xy_avrver_xyg            ! ʿʻ

      xy_avrver_xyg = xy_intver_xyg(xyg_data)/sum(g_ver_weight)
    end function xy_avrver_xyg

    function xy_avrver_xyh(xyh_data)  ! ưʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data ! 3 ʻ
      real(8), dimension(im,jm)  :: xy_avrver_xyh            ! ʿʻ

      xy_avrver_xyh = xy_intver_xyh(xyh_data)/sum(h_ver_weight)
    end function xy_avrver_xyh

    function x_avrlatver_xyg(xyg_data)  ! ư(Ҹ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8), dimension(im)     :: x_avrlatver_xyg      ! ٳʻ

      x_avrlatver_xyg = x_avrlat_xy(xy_avrver_xyg(xyg_data))
    end function x_avrlatver_xyg

    function x_avrlatver_xyh(xyh_data)  ! ư(Ҹ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8), dimension(im)     :: x_avrlatver_xyh         ! ٳʻ

      x_avrlatver_xyh = x_avrlat_xy(xy_avrver_xyh(xyh_data))
    end function x_avrlatver_xyh

    function y_avrlonver_xyg(xyg_data)  ! ư(ٱ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8), dimension(jm)       :: y_avrlonver_xyg         ! ٳʻ

      y_avrlonver_xyg = y_avrlon_xy(xy_avrver_xyg(xyg_data))
    end function y_avrlonver_xyg

    function y_avrlonver_xyh(xyh_data)  ! ư(ٱ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8), dimension(jm)       :: y_avrlonver_xyh       ! ٳʻ

      y_avrlonver_xyh = y_avrlon_xy(xy_avrver_xyh(xyh_data))
    end function y_avrlonver_xyh

    function g_avrlonlat_xyg(xyg_data)  ! ٷ(ʿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8), dimension(0:km)     :: g_avrlonlat_xyg         ! ư³ʻ

      g_avrlonlat_xyg = a_avrlonlat_xya(xyg_data)
    end function g_avrlonlat_xyg

    function h_avrlonlat_xyh(xyh_data)  ! ٷ(ʿ)ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8), dimension(km)     :: h_avrlonlat_xyh         ! ư³ʻ

      h_avrlonlat_xyh = a_avrlonlat_xya(xyh_data)
    end function h_avrlonlat_xyh

    function avrlonlatver_xyg(xyg_data) ! ٷư()ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyg_data  ! 3 ʻ
      real(8)                        :: avrlonlatver_xyg      ! ʬ

      avrlonlatver_xyg = avrlonlat_xy(xy_avrver_xyg(xyg_data))
    end function avrlonlatver_xyg

    function avrlonlatver_xyh(xyh_data) ! ٷư()ʬ
      real(8), dimension(im,jm,km), intent(in) :: xyh_data  ! 3 ʻ
      real(8)                        :: avrlonlatver_xyh      ! ʬ

      avrlonlatver_xyh = avrlonlat_xy(xy_avrver_xyh(xyh_data))
    end function avrlonlatver_xyh

  end module wghi_module
