!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  SPPACK/ISPACK-F90
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!         Ȥꤢ 1 
!
module y_deriv_module
  use y_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a, &
                            y_base_initial, gg_y, y_gg
  implicit none

  real(8), allocatable  :: rn(:,:)            ! ץ饷黻
  integer, allocatable  :: irm(:,:)           ! ʬ黻
  integer, allocatable  :: ip2(:), ip3(:)     ! 䥳ӥ׻
  real(8), allocatable  :: p2(:), p3(:)       ! 䥳ӥ׻
  real(8), allocatable  :: r2(:), r3(:)       ! 䥳ӥ׻

  real(8), allocatable  :: q(:)               ! 
  real(8), allocatable  :: ww(:),ws(:)        ! 

  private

  public y_deriv_initial                      ! 
  public y_lapla_y, y_laplainv_y              ! ץ饷ȵձ黻
  public y_dlon_y                             ! ʬ
  public gg_gradlon_y, gg_gradlat_y           ! ۷ʬ
  public y_divlon_gg, y_divlat_gg             ! ȯʬ
  public y_div_gg_gg                          ! ȯʬ
  public y_jacobian_y_y                       ! 䥳ӥ

  public rn, irm                              ! ץ饷/ʬ黻

  save rn, irm, ip2, ip3, p2, p3, r2, r3

  contains

  !---------------  -----------------
    subroutine y_deriv_initial(n_in,i_in,j_in)

      integer,intent(in) :: i_in, j_in        ! ʻ(, )
      integer,intent(in) :: n_in              ! ȿ

      integer iw

      call y_base_initial(n_in,i_in,j_in)

      allocate(rn((nm+1)*(nm+1),2))           ! ץ饷黻
      allocate(irm((nm+1)*(nm+1),2))          ! ʬ黻
      call spnini(nm,rn)
      call spmini(nm,irm)

      allocate(ip2(2*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p2(2*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r2(2*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      allocate(ip3(3*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p3(3*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r3(3*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      call snkini(nm,jm,2,ip,p,r,ip2,p2,r2)
      call snkini(nm,jm,3,ip,p,r,ip3,p3,r3)

      allocate(q(3*((nm+1)/2+nm+1)*jm))       ! 
      iw=3*max( ((nm+1)/2*2+3)*(nm/2+2)*2, &
                jm*((nm+1)/2+nm+1)*2, jm*jm )
      allocate(ws(iw),ww(iw))                 ! 
    end subroutine y_deriv_initial

  !--------------- ʬ׻ -----------------
    function y_lapla_y(y_data)      ! ڥȥ˺Ѥ Laplacian
      real(8)              :: y_lapla_y((nm+1)*(nm+1))
      real(8), intent(in)  :: y_data((nm+1)*(nm+1))

      call spclap(nm,y_data,y_lapla_y,rn(1,1))
    end function y_lapla_y

    function y_laplainv_y(y_data)   ! ڥȥ˺Ѥ Laplacian 黻
      real(8)              :: y_laplainv_y((nm+1)*(nm+1))
      real(8), intent(in)  :: y_data((nm+1)*(nm+1))

      call spclap(nm,y_data,y_laplainv_y,rn(1,2))
    end function y_laplainv_y

    function y_dlon_y(y_data)       ! ڥȥ˺Ѥʬ /ߦ
      real(8)              :: y_dlon_y((nm+1)*(nm+1))
      real(8), intent(in)  :: y_data((nm+1)*(nm+1))

      call spclam(nm,y_data,y_dlon_y,irm)
    end function y_dlon_y

    function gg_gradlon_y(y_data) ! ڥȥ˺Ѥ۷ʬ
                                  ! 1/cosա/ߦ
      real(8)              :: gg_gradlon_y(im,jm)
      real(8), intent(in)  :: y_data((nm+1)*(nm+1))

      gg_gradlon_y = gg_y(y_data,ipow=1,iflag=-1)
    end function gg_gradlon_y

    function gg_gradlat_y(y_data) ! ڥȥ˺Ѥ۷ʬ, /ߦ
      real(8)              :: gg_gradlat_y(im,jm)
      real(8), intent(in)  :: y_data((nm+1)*(nm+1))

      gg_gradlat_y = gg_y(y_data,ipow=1,iflag=1)
    end function gg_gradlat_y

    function y_divlon_gg(gg) ! ʻҤ˺Ѥȯʬ 1/cosա/ߦ
      real(8)              :: y_divlon_gg((nm+1)*(nm+1))
      real(8), intent(in)  :: gg(im,jm)

      y_divlon_gg = y_gg(gg,ipow=1,iflag=-1)
    end function y_divlon_gg

    function y_divlat_gg(gg)   ! ʻҤ˺Ѥȯʬ
                                   ! 1/cosա(f cos)/ߦ

      real(8)              :: y_divlat_gg((nm+1)*(nm+1))
      real(8), intent(in)  :: gg(im,jm)

      y_divlat_gg = y_gg(gg,ipow=1,iflag=1)
    end function y_divlat_gg

    function y_div_gg_gg(gg_u,gg_v)   ! ʻҤ˺Ѥȯ
      real(8)              :: y_div_gg_gg((nm+1)*(nm+1))
      real(8), intent(in)  :: gg_u(im,jm)   ! ٥ȥʬ
      real(8), intent(in)  :: gg_v(im,jm)   ! ٥ȥʬ

      y_div_gg_gg = y_divlon_gg(gg_u) + y_divlat_gg(gg_v)
    end function y_div_gg_gg

    function y_jacobian_y_y(y_a,y_b) ! ڥȥ˺Ѥ䥳ӥ
                             ! J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
                             !        = f/ߦˡ1/cosաg/ߦ
                             !           - g/ߦˡ1/cosաf/ߦ

      real(8)             :: y_jacobian_y_y((nm+1)*(nm+1))
      real(8), intent(in) :: y_a((nm+1)*(nm+1))
      real(8), intent(in) :: y_b((nm+1)*(nm+1))

      call spnjcb(nm,im,im,jm,jm,y_a,y_b,y_jacobian_y_y,&
           it,t,y,ip2,p2,r2,ip3,p3,r3,ia,a,q,ws,ww)
    end function y_jacobian_y_y

  end module y_deriv_module

