!----------------------------------------------------------------------
!     Copyright (c) 2001-2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  esc_module
!
!      spml/esc_module ⥸塼 2 ͥΰǤήαư
!      ڥȥˡˤͷ׻뤿 Fortran90 ؿ󶡤. 
!
!       ISPACK/C2PACK  Fortran77 ֥롼ƤǤ. 
!      ڥȥǡӳʻǡγǼˡˤĤƤ 
!      ISPACK/C2PACK Υޥ˥奢򻲾Ȥ줿.
!
!  2001/10/07  ݹ
!      2001/12/26  ݹ  ؿ, ѿ̿̾ˡѹ
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/19  ݹ  ʻҥǡź gg -> xy ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!      2005/03/15  ݹ  xy -> yx ƬҤѹ
!      2006/03/06  ݹ  Ȥ RDoc Ѥ˽
!
module esc_module
  !
  !  esc_module
  !
  !      spml/esc_module ⥸塼 2 ͥΰǤήαư
  !      ڥȥˡˤͷ׻뤿 Fortran90 ؿ󶡤. 
  !
  !       ISPACK/C2PACK  Fortran77 ֥롼ƤǤ. 
  !      ڥȥǡӳʻǡγǼˡˤĤƤ 
  !      ISPACK/C2PACK Υޥ˥奢򻲾Ȥ줿.
  !
  !  ؿѿ̾ȷˤĤ
  !
  !  ̿̾ˡ
  !
  !    * ؿ̾Ƭ (es_, ec_, yx_, x_, y_) , ֤ͤη򼨤Ƥ.
  !       es_,ec_ : ڥȥǡ(Y  SIN Ÿ, COS Ÿ)
  !       yx_     : 2 ʻǡ
  !       x_      : X  1 ʻǡ
  !       y_      : Y  1 ʻǡ
  !
  !    * ؿ̾δ֤ʸ(Dx, Dy, Lapla, LaplaInv, Jacobian), 
  !      δؿκѤɽƤ.
  !
  !    * ؿ̾κǸ (_es_es,_es_ec,_es,_ec, _yx, _x, _y) , 
  !      ѿηڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !       _es    : ڥȥǡ(Y  SIN )
  !       _ec    : ڥȥǡ(Y  COS ) 
  !       _es_es : 2 ĤΥڥȥǡ
  !       _es_ec : 2 ĤΥڥȥǡ
  !       _yx    : 2 ʻǡ, 
  !       _x     : X  1 ʻǡ
  !       _y     : Y  1 ʻǡ
  !
  !  ƥǡμ
  !
  !    * yx : 2 ʻǡ.
  !      ѿμȼ real(8), dimension(0:jm,0:im-1). im, jm 
  !      줾 X, Y ɸγʻǤ, ֥롼 esc_Initial ˤ
  !      餫ꤷƤ. 
  !
  !       1  Y ɸγʻֹ,  2  X ɸγʻֹ
  !      Ǥ (X, Y νǤϤʤ)Ȥ.
  !
  !    * es : X աꥨ, Y  SIN ڥȥǡ.
  !      ѿμȼ real(8), dimension(-km:km,lm). km, lm 
  !      줾 X, Y κȿǤ, ֥롼 esc_Initial ˤ
  !      餫ꤷƤ. ڥȥǡγǼΤˤĤƤ...
  !
  !    * ec : X աꥨ, Y  COS ڥȥǡ.
  !      ѿμȼ real(8), dimension(-km:km,0:lm). km, lm Ϥ줾
  !      X, Y κȿǤ, ֥롼 esc_Initial ˤƤ餫
  !      ꤷƤ. ڥȥǡγǼΤˤĤƤ...
  !
  !    * x, y : X, Y  1 ʻǡ.
  !      ѿμȼϤ줾 real(8), dimension(0:im-1) 
  !       real(8), dimension(0:jm).
  !
  !    * es_, ec_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  !    * yx_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  !    * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  !    * ڥȥǡФʬκѤȤ, бʻǡ
  !      ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  implicit none

  private
  public esc_Initial                                      ! 롼
  public yx_es, yx_ec, es_yx, ec_yx                       ! Ѵ
  public es_Lapla_es, es_LaplaInv_es, es_Dx_es, ec_Dy_es  ! ʬ
  public ec_Lapla_ec, ec_Dx_ec, es_Dy_ec                  ! ʬ
  public es_Jacobian_es_es, ec_Jacobian_es_ec             ! ׻
  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ

  integer   :: im=32, jm=8                                ! ʻ(X,Y)
  integer   :: km=10, lm=5                                ! ȿ(X,Y)
  real(8)   :: xl=2.0, yl=1.0                             ! ΰ礭

  integer,dimension(5)                  :: itj
  real(8),dimension(:),allocatable      :: tj
  integer,dimension(5)                  :: iti
  real(8),dimension(:),allocatable      :: ti

  real(8), dimension(:), allocatable    :: x_X
  ! ʻɸ(X)Ǽ 1 

  real(8), dimension(:), allocatable    :: y_Y
  ! ʻɸ(X)Ǽ 1 

  real(8), dimension(:), allocatable    :: x_X_Weight
  ! Ťߺɸ(X)Ǽ 1 . X γʻδֳ֤ǼƤ.

  real(8), dimension(:), allocatable    :: y_Y_Weight
  ! Ťߺɸ(Y)Ǽ 1 . Y γʻδֳ֤ǼƤ.

  real(8), dimension(:,:), allocatable  :: yx_X
  ! Ƴʻ(i,j)ΰ֤ X ɸǼʻҥǡ.

  real(8), dimension(:,:), allocatable  :: yx_Y
  ! Ƴʻ(i,j)ΰ֤ Y ɸǼʻҥǡ.

  real(8), dimension(:),   allocatable  :: wg, ws, wgj
  real(8), dimension(:,:), allocatable  :: yx_work,es_work,ec_work
  real(8), parameter  ::  pi=3.1415926535897932385D0

  save im, jm, km, lm, itj, tj, iti, ti, xl, yl
  save x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y

  contains
  !---------------  -----------------
    subroutine esc_Initial(i,j,k,l,xmin,xmax,ymin,ymax)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      integer,intent(in) :: i           !(in) ʻ(X)
      integer,intent(in) :: j           !(in) ʻ(Y)
      integer,intent(in) :: k           !(in) ȿ(X)
      integer,intent(in) :: l           !(in) ȿ(Y)

      real(8),intent(in) :: xmin, xmax     !(in) X ɸϰ
      real(8),intent(in) :: ymin, ymax     !(in) Y ɸϰ

      integer :: ii, jj

      im = i         ; jm = j
      km = k         ; lm = l
      xl = xmax-xmin ; yl = ymax-ymin

      allocate(tj(jm*6),ti(im*2))
      allocate(wg((jm+1)*im))
      allocate(ws((2*km+1)*(lm+1)),wgj((jm+1)*im*3))
      allocate(yx_work(0:jm,0:im-1))
      allocate(es_work(-km:km,lm),ec_work(-km:km,0:lm))

      call c2init(jm,im,itj,tj,iti,ti)

      allocate(x_X(0:im-1), x_X_Weight(0:im-1))
      allocate(y_Y(0:jm), y_Y_Weight(0:jm))
      allocate(yx_X(0:jm,0:im-1), yx_Y(0:jm,0:im-1))

      do ii=0,im-1
         x_X(ii) = xmin + xl/im*ii
      enddo
      x_X_Weight = xl/im

      do jj=0,jm
         y_Y(jj) = ymin + yl/jm*jj
      enddo
      y_Y_Weight(0) = yl/(2*jm)
      y_Y_Weight(1:jm-1) = yl/jm 
      y_Y_Weight(jm) = yl/(2*jm)

      yx_X = spread(x_X,1,jm+1)
      yx_Y = spread(y_Y,2,im)

    end subroutine esc_Initial

  !--------------- Ѵ -----------------
    function yx_es(es)
      !
      ! SIN(Y)ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_es
      !(out) ʻǡ

      real(8), dimension(-km:km,lm), intent(in)    :: es
      !(in) SIN(Y)ڥȥǡ

      call c2s2ga(lm,km,jm,im,es,yx_es,wg,itj,tj,iti,ti,1)
    end function yx_es

    function yx_ec(ec)
      !
      ! COS(Y)ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_ec
      !(out) ʻǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: ec
      !(in) COS(Y)ڥȥǡ

      call c2s2ga(lm,km,jm,im,ec,yx_ec,wg,itj,tj,iti,ti,2)
    end function yx_ec

    function es_yx(yx)
      !
      ! ʻҥǡ SIN(Y)ڥȥǡѴ.
      !
      real(8), dimension(-km:km,lm)                :: es_yx
      !(out) SIN(Y)ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      yx_work = yx
      call c2g2sa(lm,km,jm,im,yx_work,es_yx,wg,itj,tj,iti,ti,1)
    end function es_yx

    function ec_yx(yx)
      !
      ! ʻҥǡ COS(Y)ڥȥǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: ec_yx
      !(in) COS(Y)ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(out) ʻǡ

      yx_work = yx
      call c2g2sa(lm,km,jm,im,yx_work,ec_yx,wg,itj,tj,iti,ti,2)
    end function ec_yx

  !--------------- ʬ׻ -----------------
    function es_Lapla_es(es)
      !
      ! SIN(Y)ϥڥȥǡ˥ץ饷(xx+yy)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) 򤫤
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-km:km,lm)                :: es_Lapla_es
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-km:km,lm), intent(in)    :: es
      !(in) SIN(Y)ϥڥȥǡ

      integer k,l

      do l=1,lm
         do k=-km,km
            es_Lapla_es(k,l) = -((2*pi*k/xl)**2+(pi*l/yl)**2)*es(k,l)
         enddo
      enddo
    end function es_Lapla_es

    function ec_Lapla_ec(ec)
      !
      ! COS(Y)ϥڥȥǡ˥ץ饷(xx+yy)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) 򤫤
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-km:km,0:lm)                :: ec_Lapla_ec
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-km:km,0:lm), intent(in)    :: ec
      !(in) COS(Y)ϥڥȥǡ

      integer k,l

      do l=0,lm
         do k=-km,km
            ec_Lapla_ec(k,l) = -((2*pi*k/xl)**2+(pi*l/yl)**2)*ec(k,l)
         enddo
      enddo
    end function ec_Lapla_ec

    function es_LaplaInv_es(es)   ! ڥȥ SINY ˺Ѥ \lapla 黻
      !
      ! ϥڥȥǡ˵եץ饷(xx+yy)**(-1)Ѥ.
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) ǳ
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-km:km,lm)                :: es_LaplaInv_es
      !(out) ڥȥǡεեץ饷

      real(8), dimension(-km:km,lm), intent(in)    :: es
      !(in) SIN(Y)ڥȥǡ

      integer k,l

      do l=1,lm
         do k=-km,km
            es_LaplaInv_es(k,l) = -es(k,l)/((2*pi*k/xl)**2+(pi*l/yl)**2)
         enddo
      enddo
    end function es_LaplaInv_es

    function es_Dx_es(es)
      !
      ! SIN(Y)ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,lm)                :: es_Dx_es
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-km:km,lm), intent(in)    :: es
      !(in) SIN(Y)ϥڥȥǡ

      integer k,l

      do l=1,lm
         do k=-km,km
            es_Dx_es(k,l)  =  (-2*pi*k/xl)*es(-k,l)
         enddo
      enddo
    end function es_Dx_es

    function ec_Dx_ec(ec)
      !
      ! COS(Y)ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,0:lm)                :: ec_Dx_ec
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-km:km,0:lm), intent(in)    :: ec
      !(in) COS(Y)ϥڥȥǡ

      integer k,l

      do l=0,lm
         do k=-km,km
            ec_Dx_ec(k,l)  =  (-2*pi*k/xl)*ec(-k,l)
         enddo
      enddo
    end function ec_Dx_ec

    function ec_Dy_es(es)   ! ڥȥ SINY ˺Ѥ y ʬ黻
      !
      ! SIN(Y)ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ l 򤫤Ƥ. 
      !
      real(8), dimension(-km:km,0:lm)              :: ec_Dy_es
      !(out) ڥȥǡ Y ʬ, COS(Y).

      real(8), dimension(-km:km,lm), intent(in)    :: es
      !(in) SIN(Y)ϥڥȥǡ

      integer k,l

      do k=-km,km
         ec_Dy_es(k,0)  =  0.0
      enddo
      do l=1,lm
         do k=-km,km
            ec_Dy_es(k,l)  =  (pi*l/yl)*es(k,l)
         enddo
      enddo
    end function ec_Dy_es

    function es_Dy_ec(ec)   ! ڥȥ COSY ˺Ѥ y ʬ黻
      !
      ! COS(Y)ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ l 򤫤Ƥ. 
      !
      real(8), dimension(-km:km,lm)                 :: es_Dy_ec
      !(out) ڥȥǡ Y ʬ, SIN(Y).

      real(8), dimension(-km:km,0:lm), intent(in)   :: ec
      !(in) COS(Y)ϥڥȥǡ

      integer k,l

      do l=1,lm
         do k=-km,km
            es_Dy_ec(k,l)  =  -(pi*l/yl)*ec(k,l)
         enddo
      enddo
    end function es_Dy_ec

 !------------------- ׻ ----------------------
    function es_Jacobian_es_es(es_a,es_b) !ڥȥ SINY ˺Ѥ䥳ӥ
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=(xA)(yB)-(yA)(xB)
      !
      !  ׻.
      !
      !  2 ĤΥڥȥǡΥ䥳ӥȤ, б 2 Ĥ
      !  ʻǡΥ䥳ӥΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,lm)                :: es_Jacobian_es_es
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), dimension(-km:km,lm), intent(in)    :: es_A,es_B
      !(in) 2Ĥ SIN(Y)ϥڥȥǡ

      integer k,l

      call c2ajcb(lm,km,jm,im,es_A,es_B,es_work,ws,wgj,itj,tj,iti,ti)

      do l=1,lm
         do k=-km,km
            es_Jacobian_es_es(k,l) = (2*pi/xl)*(pi/yl)*es_work(k,l)
         enddo
      enddo
    end function es_Jacobian_es_es

    function ec_Jacobian_es_ec(es,ec)  ! ڥȥ COS(Y) ˺Ѥ䥳ӥ
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=(xA)(yB)-(yA)(xB)
      !
      !  ׻.
      !
      !  2 ĤΥڥȥǡΥ䥳ӥȤ, б 2 Ĥ
      !  ʻǡΥ䥳ӥΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm)              :: ec_Jacobian_es_ec
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), dimension(-km:km,lm), intent(in)    :: es
      !(in) 1ܤ SIN(Y)ϥڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: ec
      !(in) 2ܤ COS(Y)ϥڥȥǡ

      integer k,l

      call c2ajcc(lm,km,jm,im,es,ec,ec_work,ws,wgj,itj,tj,iti,ti)

      do l=0,lm
         do k=-km,km
            ec_Jacobian_es_ec(k,l) = (2*pi/xl)*(pi/yl)*ec_work(k,l)
         enddo
      enddo
    end function ec_Jacobian_es_ec

  !--------------- ʬ׻ -----------------
    function IntYX_yx(yx)
      !
      ! 2 ʻǡΰʬʿ.
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8)                           :: IntYX_yx
      !(out) ʬ

      integer :: i, j

      IntYX_yx = 0.0d0
      do i=0,im-1
         do j=0,jm
            IntYX_yx = IntYX_yx + yx(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntYX_yx

    function y_IntX_yx(yx)  ! X ʬ
      !
      ! 1 (X)ʻǡ X ʬ
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm)          :: y_IntX_yx
      !(out) X ʬ줿 1 (Y)ʻǡ

      integer :: i

      y_IntX_yx = 0.0d0
      do i=0,im-1
         y_IntX_yx(:) = y_IntX_yx(:) + yx(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_yx

    function x_IntY_yx(yx)
      !
      ! 2 ʻǡ Y ʬ
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)        :: x_IntY_yx
      !(out) Y ʬ줿 1 (X)ʻǡ

      integer :: j

      x_IntY_yx = 0.0d0
      do j=0,jm
         x_IntY_yx(:) = x_IntY_yx(:) + yx(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_yx

    function IntX_x(x)      ! X ʬ
      !
      ! 1 (X)ʻǡ X ʬ
      !
      real(8), dimension(0:im-1)   :: x
      !(in) 1 (X)ʻǡ

      real(8)                      :: IntX_x
      !(out) ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)      ! Y ʬ
      !
      ! 1 (Y)ʻǡ Y ʬ
      !
      real(8), dimension(0:jm)   :: y
      !(in) 1 (Y)ʻǡ

      real(8)                    :: IntY_y
      !(out) ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

  !--------------- ʿѷ׻ -----------------
    function AvrYX_yx(yx)    ! ΰʿ
      !
      ! 2 ʻǡΰʿ
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8)                           :: AvrYX_yx
      !(out) ʿ

      AvrYX_yx = IntYX_yx(yx)/(sum(x_X_weight)*sum(y_Y_weight))
    end function AvrYX_yx

    function y_AvrX_yx(yx)   ! X ʿ
      !
      ! 1 (X)ʻǡ X ʿ
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm)          :: y_AvrX_yx
      !(out) X ʿѤ줿 1 (Y)ʻǡ

      y_AvrX_yx = y_IntX_yx(yx)/sum(x_X_weight)
    end function y_AvrX_yx

    function x_AvrY_yx(yx)   ! Y ʿ
      !
      ! 2 ʻǡ Y ʿ
      !
      real(8), dimension(0:jm,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)        :: x_AvrY_yx
      !(out) Y ʿѤ줿 1 (X)ʻǡ

      x_AvrY_yx = x_IntY_yx(yx)/sum(y_Y_weight)
    end function x_AvrY_yx

    function AvrX_x(x)       ! X ʿ
      !
      ! 1 (X)ʻǡ X ʿ
      !
      real(8), dimension(0:im-1)   :: x
      !(in) 1 (X)ʻǡ

      real(8)                      :: AvrX_x
      !(out) ʿ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)       ! Y ʿ
      !
      ! 1 (Y)ʻǡ Y ʿ
      !
      real(8), dimension(0:jm)   :: y
      !(in) 1 (Y)ʻǡ

      real(8)                    :: AvrY_y
      ! ʿ

      AvrY_y = IntY_y(y)/sum(y_Y_weight)
    end function AvrY_y

  end module esc_module
