!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_module
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module w_deriv_module
  use w_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a, &
                            w_base_initial, xy_w, w_xy
  implicit none

  real(8), allocatable  :: rn(:,:)            ! ץ饷黻
  integer, allocatable  :: irm(:,:)           ! ʬ黻
  integer, allocatable  :: ip2(:), ip3(:)     ! 䥳ӥ׻
  real(8), allocatable  :: p2(:), p3(:)       ! 䥳ӥ׻
  real(8), allocatable  :: r2(:), r3(:)       ! 䥳ӥ׻

  real(8), allocatable  :: q(:)               ! 
  real(8), allocatable  :: ww(:),ws(:)        ! 

  private

  public w_deriv_initial                      ! 
  public w_lapla_w, w_laplainv_w              ! ץ饷ȵձ黻
  public w_dlon_w                             ! ʬ
  public xy_gradlon_w, xy_gradlat_w           ! ۷ʬ
  public w_divlon_xy, w_divlat_xy             ! ȯʬ
  public w_div_xy_xy                          ! ȯʬ
  public w_jacobian_w_w                       ! 䥳ӥ

  public rn, irm                              ! ץ饷/ʬ黻

  save rn, irm, ip2, ip3, p2, p3, r2, r3

  contains

  !---------------  -----------------
    subroutine w_deriv_initial(n_in,i_in,j_in)

      integer,intent(in) :: i_in, j_in        ! ʻ(, )
      integer,intent(in) :: n_in              ! ȿ

      integer iw

      call w_base_initial(n_in,i_in,j_in)

      allocate(rn((nm+1)*(nm+1),2))           ! ץ饷黻
      allocate(irm((nm+1)*(nm+1),2))          ! ʬ黻
      call spnini(nm,rn)
      call spmini(nm,irm)

      allocate(ip2(2*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p2(2*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r2(2*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      allocate(ip3(3*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p3(3*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r3(3*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      call snkini(nm,jm,2,ip,p,r,ip2,p2,r2)
      call snkini(nm,jm,3,ip,p,r,ip3,p3,r3)

      allocate(q(3*((nm+1)/2+nm+1)*jm))       ! 
      iw=3*max( ((nm+1)/2*2+3)*(nm/2+2)*2, &
                jm*((nm+1)/2+nm+1)*2, jm*jm )
      allocate(ws(iw),ww(iw))                 ! 
    end subroutine w_deriv_initial

  !--------------- ʬ׻ -----------------
    function w_lapla_w(w_data)      ! ڥȥ˺Ѥ Laplacian
      real(8)              :: w_lapla_w((nm+1)*(nm+1))
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      call spclap(nm,w_data,w_lapla_w,rn(1,1))
    end function w_lapla_w

    function w_laplainv_w(w_data)   ! ڥȥ˺Ѥ Laplacian 黻
      real(8)              :: w_laplainv_w((nm+1)*(nm+1))
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      call spclap(nm,w_data,w_laplainv_w,rn(1,2))
    end function w_laplainv_w

    function w_dlon_w(w_data)       ! ڥȥ˺Ѥʬ /ߦ
      real(8)              :: w_dlon_w((nm+1)*(nm+1))
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      call spclam(nm,w_data,w_dlon_w,irm)
    end function w_dlon_w

    function xy_gradlon_w(w_data) ! ڥȥ˺Ѥ۷ʬ
                                  ! 1/cosա/ߦ
      real(8)              :: xy_gradlon_w(im,jm)
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      xy_gradlon_w = xy_w(w_data,ipow=1,iflag=-1)
    end function xy_gradlon_w

    function xy_gradlat_w(w_data) ! ڥȥ˺Ѥ۷ʬ, /ߦ
      real(8)              :: xy_gradlat_w(im,jm)
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      xy_gradlat_w = xy_w(w_data,ipow=1,iflag=1)
    end function xy_gradlat_w

    function w_divlon_xy(xy_data) ! ʻҤ˺Ѥȯʬ 1/cosա/ߦ
      real(8)              :: w_divlon_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_data(im,jm)

      w_divlon_xy = w_xy(xy_data,ipow=1,iflag=-1)
    end function w_divlon_xy

    function w_divlat_xy(xy_data)   ! ʻҤ˺Ѥȯʬ
                                   ! 1/cosա(f cos)/ߦ

      real(8)              :: w_divlat_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_data(im,jm)

      w_divlat_xy = w_xy(xy_data,ipow=1,iflag=1)
    end function w_divlat_xy

    function w_div_xy_xy(xy_u,xy_v)   ! ʻҤ˺Ѥȯ
      real(8)              :: w_div_xy_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_u(im,jm)   ! ٥ȥʬ
      real(8), intent(in)  :: xy_v(im,jm)   ! ٥ȥʬ

      w_div_xy_xy = w_divlon_xy(xy_u) + w_divlat_xy(xy_v)
    end function w_div_xy_xy

    function w_jacobian_w_w(w_a,w_b) ! ڥȥ˺Ѥ䥳ӥ
                             ! J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
                             !        = f/ߦˡ1/cosաg/ߦ
                             !           - g/ߦˡ1/cosաf/ߦ

      real(8)             :: w_jacobian_w_w((nm+1)*(nm+1))
      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      real(8), intent(in) :: w_b((nm+1)*(nm+1))

      call spnjcb(nm,im,im,jm,jm,w_a,w_b,w_jacobian_w_w,&
           it,t,y,ip2,p2,r2,ip3,p3,r3,ia,a,q,ws,ww)
    end function w_jacobian_w_w

  end module w_deriv_module

