!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  SPPACK/ISPACK-F90
!
!  2002/02/02  ݹ 
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ⥸塼̾ѹ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module ya_deriv_module
  use y_base_module, only : im, jm, nm
  use ya_base_module, only : km, ya_base_initial, gga_ya, ya_gga
  use y_deriv_module, only : rn, irm, y_jacobian_y_y

  implicit none

  private
 
  public ya_deriv_initial                     ! 
  public ya_lapla_ya, ya_laplainv_ya          ! ץ饷ȵձ黻
  public ya_dlon_ya                           ! ʬ
  public gga_gradlon_ya, gga_gradlat_ya       ! ۷ʬ
  public ya_divlon_gga, ya_divlat_gga         ! ȯʬ
  public ya_div_gga_gga                       ! ȯʬ
  public ya_jacobian_ya_ya                    ! 䥳ӥ

  contains

  !---------------  -----------------
    subroutine ya_deriv_initial(k_in)

      integer,intent(in) :: k_in              ! ǡ(ؿ)򵭲

      call ya_base_initial(k_in)

    end subroutine ya_deriv_initial

  !--------------- ʬ׻ -----------------
    function ya_lapla_ya(ya)       ! ڥȥ˺Ѥ Laplacian
      real(8), intent(in)  :: ya(:,:)
      real(8)              :: ya_lapla_ya((nm+1)*(nm+1),size(ya,2))

      integer :: l,k

      do k=1,size(ya,2)
         do l=1,(nm+1)*(nm+1)
            ya_lapla_ya(l,k) = rn(l,1)*ya(l,k)
         enddo
      enddo
    end function ya_lapla_ya

    function ya_laplainv_ya(ya)    ! ڥȥ˺Ѥ Laplacian 黻
      real(8), intent(in)  :: ya(:,:)
      real(8)              :: ya_laplainv_ya((nm+1)*(nm+1),size(ya,2))

      integer :: l,k

      do k=1,size(ya,2)
         do l=1,(nm+1)*(nm+1)
            ya_laplainv_ya(l,k) = rn(l,2)*ya(l,k)
         enddo
      enddo
    end function ya_laplainv_ya

    function ya_dlon_ya(ya)        ! ڥȥ˺Ѥʬ /ߦ
      real(8), intent(in)  :: ya(:,:)
      real(8)              :: ya_dlon_ya((nm+1)*(nm+1),size(ya,2))

      integer :: l,k

      do k=1,size(ya,2)
         do l=1,(nm+1)*(nm+1)
            ya_dlon_ya(irm(l,1),k) = irm(l,2)*ya(l,k)
         enddo
      enddo
    end function ya_dlon_ya

    function gga_gradlon_ya(ya) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/cosա/ߦ
      real(8), intent(in)  :: ya(:,:)
      real(8)              :: gga_gradlon_ya(im,jm,size(ya,2))

      gga_gradlon_ya = gga_ya(ya,ipow=1,iflag=-1)
    end function gga_gradlon_ya

    function gga_gradlat_ya(ya) ! ڥȥ˺Ѥ۷ʬ, /ߦ
      real(8), intent(in)  :: ya(:,:)
      real(8)              :: gga_gradlat_ya(im,jm,size(ya,2))

      gga_gradlat_ya = gga_ya(ya,ipow=1,iflag=1)
    end function gga_gradlat_ya

    function ya_divlon_gga(gga)   ! ʻҤ˺Ѥȯʬ 
                                  ! 1/cosա/ߦ

      real(8), intent(in)  :: gga(:,:,:)
      real(8)              :: ya_divlon_gga((nm+1)*(nm+1),size(gga,3))

      ya_divlon_gga = ya_gga(gga,ipow=1,iflag=-1)
    end function ya_divlon_gga

    function ya_divlat_gga(gga)   ! ʻҤ˺Ѥȯʬ
                                  ! 1/cosա(f cos)/ߦ

      real(8), intent(in)  :: gga(:,:,:)
      real(8)              :: ya_divlat_gga((nm+1)*(nm+1),size(gga,3))

      ya_divlat_gga = ya_gga(gga,ipow=1,iflag=1)
    end function ya_divlat_gga

    function ya_div_gga_gga(gga_u,gga_v)     ! ʻҤ˺Ѥȯ
      real(8), intent(in)  :: gga_u(:,:,:)   ! ٥ȥʬ
      real(8), intent(in)  :: gga_v(:,:,:)   ! ٥ȥʬ
      real(8)              :: ya_div_gga_gga((nm+1)*(nm+1),size(gga_u,3))

      ya_div_gga_gga = ya_divlon_gga(gga_u) + ya_divlat_gga(gga_v)
    end function ya_div_gga_gga

    function ya_jacobian_ya_ya(ya_a,ya_b)  ! ڥȥ˺Ѥ䥳ӥ
                             ! J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
                             !        = f/ߦˡ1/cosաg/ߦ
                             !           - g/ߦˡ1/cosաf/ߦ

      real(8), intent(in) :: ya_a(:,:)
      real(8), intent(in) :: ya_b(:,:)
      real(8)             :: ya_jacobian_ya_ya((nm+1)*(nm+1),size(ya_a,2))

      integer :: k

      do k=1,size(ya_a,2)
         ya_jacobian_ya_ya(:,k) = y_jacobian_y_y(ya_a(:,k),ya_b(:,k))
      end do
    end function ya_jacobian_ya_ya

  end module ya_deriv_module

