!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  et_module
!      2 ϩΰ, Fourier Ÿ + Chebyshev Ÿˡ
!
!  2002/01/27  ݹ
!      2002/03/30  ݹ  ⥸塼̾ѹ
!      2002/08/19  ݹ  ʻҥǡź gg -> xy, eg -> ey ѹ
!                            ʬʿѴؿɲ
!
module et_module

  use lumatrix
  use ae_module, x_X => g_X, x_X_weight => g_X_Weight, &
                 e_x => e_g, ae_ax => ae_ag, &
                 x_e => g_e, ax_ae => ag_ae
  use at_module, y_Y => g_X, y_Y_Weight => g_X_Weight, &
                 at_ay => at_ag, t_y => t_g, &
                 ay_at => ag_at, y_t => g_t, &
                 t_Dy_t => t_Dx_t, at_Dy_at => at_Dx_at

  implicit none
  private

  public et_Initial                                       ! 

  public x_X, y_Y, x_X_Weight, y_Y_Weight, xy_X, xy_Y     ! ɸѿ

  public xy_et, et_xy                                     ! Ѵ
  public e_x, x_e, ae_ax, ax_ae                           ! Ѵ
  public t_y, y_t, at_ay, ay_at                           ! Ѵ

  public et_Dx_et, e_Dx_e, ae_Dx_ae                       ! ʬ
  public et_Dy_et, t_Dy_t, at_Dy_at                       ! ʬ
  public et_Lapla_et                                      ! ʬ

  public et_Jacobian_et_et                                ! ׻

  public et_Boundaries                                    ! 
  public at_Boundaries_DD, at_Boundaries_DN               ! 
  public at_Boundaries_ND, at_Boundaries_NN               ! 
  public et_LaplaInv_et, ey_Vor2Strm_ey                   ! 
  public et_Vor2Strm_et, et_Vor2Strm1_et                  ! 

  public IntXY_xy, y_IntX_xy, x_IntY_xy, IntX_x, IntY_y   ! ʬ
  public AvrXY_xy, y_AvrX_xy, x_AvrY_xy, AvrX_x, AvrY_y   ! ʿ

  integer            :: im=32, jm=8      ! ʻ(X,Y)
  integer            :: km=10, lm=5      ! ȿ(X,Y)
  real(8)            :: xl=2.0, yl=1.0   ! ΰ礭
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:), allocatable :: xy_X, xy_Y

  save im, jm, km, lm, xl, yl

  contains
  !---------------  -----------------
    subroutine et_initial(i,j,k,l,xmin,xmax,ymin,ymax)

      integer,intent(in) :: i, j           ! ʻ(X,Y)
      integer,intent(in) :: k, l           ! ȿ(X,Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      im = i       ; jm = j
      km = k       ; lm = l
      xl = xmax-xmin ; yl = ymax-ymin

      call ae_initial(im,km,xmin,xmax)
      call at_initial(jm,lm,ymin,ymax)

      allocate(xy_X(0:jm,0:im-1),xy_Y(0:jm,0:im-1))
      xy_X = spread(x_X,1,jm+1)
      xy_Y = spread(y_Y,2,im)

    end subroutine et_initial

  !--------------- Ѵ -----------------

    function xy_et(et)  ! ڥȥ -> ʻ
      real(8), dimension(0:jm,0:im-1)              :: xy_et
      real(8), dimension(-km:km,0:lm), intent(in)  :: et

      xy_et = ax_ae(transpose(ay_at(et)))

    end function xy_et

    function et_xy(xy)  ! ʻ -> ڥȥ
      real(8), dimension(-km:km,0:lm)              :: et_xy
      real(8), dimension(0:jm,0:im-1), intent(in)  :: xy

      et_xy = at_ay(transpose(ae_ax(xy)))

    end function et_xy

  !--------------- ʬ׻ -----------------

    function et_Dx_et(et)   ! ڥȥ˺Ѥ x ʬ黻
      real(8), dimension(-km:km,0:lm)                :: et_Dx_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et
      integer k

      do k=-km,km
         et_Dx_et(k,:)  =  (-2*pi*k/xl)*et(-k,:)
      enddo
    end function et_Dx_et

    function et_Dy_et(et)   ! ڥȥ˺Ѥ y ʬ黻
      real(8), dimension(-km:km,0:lm)               :: et_Dy_et
      real(8), dimension(-km:km,0:lm), intent(in)   :: et

      et_Dy_et = at_Dy_at(et)

    end function et_Dy_et

    function et_Lapla_et(et)   ! ڥȥ˺Ѥ Laplacian 黻
      real(8), dimension(-km:km,0:lm)                :: et_Lapla_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et
      integer k

      do k=-km,km
         et_Lapla_et(k,:) = -(2*pi*k/xl)**2*et(k,:)
      enddo

      et_Lapla_et = et_Lapla_et + et_Dy_et(et_Dy_et(et))

    end function et_Lapla_et

    function et_Jacobian_et_et(et_a,et_b) ! ڥȥ˺Ѥ Jacobian
      real(8), dimension(-km:km,0:lm)                :: et_Jacobian_et_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et_a
      real(8), dimension(-km:km,0:lm), intent(in)    :: et_b
      integer k

      et_Jacobian_et_et = et_xy(&
           xy_et(et_Dx_et(et_a)) * xy_et(et_Dy_et(et_b)) &
           -xy_et(et_Dy_et(et_a)) * xy_et(et_Dx_et(et_b)) )

    end function et_Jacobian_et_et


  !---------------  -----------------

    subroutine et_Boundaries(et,values,cond)   ! ǥꥯ, Υޥ
      ! Chebyshev ֤ǤζŬ

      real(8), dimension(-km:km,0:lm),intent(inout)      :: et
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(-km:km,2), intent(in), optional :: values
              ! Ǥ / ʬۤʿڥȥѴΤͿ. 
              ! ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              ! . ά 'DD'
              !   DD : ξüǥꥯ
              !   DN,ND : ǥꥯ/Υޥ
              !   NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_Boundaries_DD(et,values)
         else
            call at_Boundaries_DD(et)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_Boundaries_NN(et,values)
         else
            call at_Boundaries_NN(et)
         endif
      case ('DN')
         if (present(values)) then
            call at_Boundaries_DN(et,values)
         else
            call at_Boundaries_DN(et)
         endif
      case ('ND')
         if (present(values)) then
            call at_Boundaries_ND(et,values)
         else
            call at_Boundaries_ND(et)
         endif
      case ('DD')
         if (present(values)) then
            call at_Boundaries_DD(et,values)
         else
            call at_Boundaries_DD(et)
         endif
      case default
         call msgdmp('E','et_Boundaries','B.C. not supported')
      end select

    end subroutine et_Boundaries

    function et_LaplaInv_et(et,values) !  Laplacian, Dirichlet 
      ! Chebyshev-tau ˡˤ׻

      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      real(8), dimension(-km:km,0:lm)             :: et_LaplaInv_et
      real(8), dimension(-km:km,2), intent(in), optional :: values   ! 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(0:lm,0:lm)           :: tt_work
      real(8), dimension(0:lm,0:jm)           :: ty_work
      real(8), dimension(-km:km)              :: value1, value2   ! 

      logical :: first = .true.
      integer :: k,l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(:,1) ; value2 = values(:,2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         tt_work=0
         do l=0,lm
            tt_work(l,l)=1
         enddo
         ty_work=ay_at(tt_work)

         do k=-km,km
            alu(k,:,:) = transpose(at_Dy_at(at_Dy_at(tt_work)) &
                                   - (2*pi*k/xl)**2*tt_work)
            alu(k,lm-1,:) = ty_work(:,0)
            alu(k,lm,:)   = ty_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et
      et_work(:,lm-1) = value1
      et_work(:,lm)   = value2
      et_LaplaInv_et = lusolve(alu,kp,et_work)

    end function et_LaplaInv_et

    function ey_Vor2Strm_ey(ey,values,cond)    ! ٤ή. 
                                               ! ǥեȤǴ
      ! Chebyshev-Collocation ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries

      !  : ǽ˸ƤФȤζǰʸ׻(׻ѹ)

      real(8), dimension(-km:km,0:jm),intent(in)  :: ey
              ! ϱʬ

      real(8), dimension(-km:km,0:jm)             :: ey_Vor2Strm_ey
              ! ήʬ

      real(8), dimension(2), intent(in), optional :: values
              ! ή. ǰʤΤȿ 0 ʬΤ
	      ! ά 0.

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF : ξüϤʤ

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:jm)         :: ey_work
      real(8), dimension(0:jm,0:jm)           :: yy
      real(8), dimension(0:jm,0:jm)           :: yy_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,j
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call msgdmp('E','ey_Vor2Strm_ey','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:jm,0:jm),kp(-km:km,0:jm))

         yy=0
         do j=0,jm
            yy(j,j)=1
         enddo
         do k=-km,km
            alu(k,:,:) = transpose( &
                 ay_at(at_Dy_at(at_Dy_at(at_ay(yy)))) &
                 - (2*pi*k/xl)** 2* yy )
         enddo

         ! ưŪ. ή϶ǰ
         yy_work=yy
         do k=-km,km
            alu(k,0,:)   = yy_work(:,0)
            alu(k,jm,:)  = yy_work(:,jm)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            yy_work=ay_at(at_Dy_at(at_ay(yy)))
         else
            yy_work=ay_at(at_Dy_at(at_Dy_at(at_ay(yy))))
         endif
         do k=-km,km
            alu(k,1,:) = yy_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            yy_work=ay_at(at_Dy_at(at_ay(yy)))
         else
            yy_work=ay_at(at_Dy_at(at_Dy_at(at_ay(yy))))
         endif
         do k=-km,km
            alu(k,jm-1,:) = yy_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      ey_work = ey
      ey_work(:,1)    = 0               ! ϳŪ
      ey_work(:,jm-1) = 0               ! ϳŪ

      ey_work(:,0) = 0            ! ưŪ. ȿ 0 ʳ 0 
      ey_work(0,0) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      ey_work(:,jm)   = 0            ! ưŪ. ȿ 0 ʳ 0 
      ey_work(0,jm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      ey_Vor2Strm_ey = lusolve(alu,kp,ey_work)

    end function ey_Vor2Strm_ey

   !-----   : ׻ޤ. pending ---- 
    function et_Vor2Strm_et(et,values,rigid) ! ٤ή. 
                                             ! ǥեȤǴ
      ! Chebyshev-tau ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries
      !
      ! l=0,1,lm-1,lm ʬμ˶Ϳ. 
      ! ٤㼡ʬ̵뤹뤳Ȥ
      ! \nabla^4 \psi = \zeta^2 򤤤Ƥ뤳Ȥ. 
      ! 4 ʬˤ뤳ȤǶοȤĤĤޤ. 

      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      real(8), dimension(-km:km,0:lm)             :: et_Vor2Strm_et

      ! ή. ǰʤΤȿ 0 ʬΤ
      real(8), dimension(2), intent(in), optional :: values
      ! 凉å
      logical, dimension(2), intent(in), optional :: rigid

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(0:lm,0:lm)           :: tt_work
      real(8), dimension(0:lm,0:jm)           :: ty_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if (.not. present(rigid)) then
         rigid1=.true. ; rigid2=.true.
      else
         rigid1 = rigid(1) ; rigid2 = rigid(2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         tt_work=0
         do l=0,lm
            tt_work(l,l)=1
         enddo
         do k=-km,km
            alu(k,:,:) = transpose(at_Dy_at(at_Dy_at(tt_work)) &
                                   - (2*pi*k/xl)**2*tt_work)
         enddo

         ! ưŪ. ή϶ǰ
         ty_work=ay_at(tt_work)
         do k=-km,km
            alu(k,lm-1,:) = ty_work(:,0)
            alu(k,lm,:)   = ty_work(:,jm)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            ty_work=ay_at(at_Dy_at(tt_work))
         else
            ty_work=ay_at(at_Dy_at(at_Dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,0,:) = ty_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            ty_work=ay_at(at_Dy_at(tt_work))
         else
            ty_work=ay_at(at_Dy_at(at_Dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,1,:) = ty_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et
      et_work(:,0) = 0               ! ϳŪ
      et_work(:,1) = 0               ! ϳŪ

      et_work(:,lm-1) = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm-1) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_work(:,lm)   = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_Vor2Strm_et = lusolve(alu,kp,et_work)

    end function et_Vor2Strm_et

   !-----   : ׻ޤ. pending ---- 
    function et_Vor2Strm1_et(et,values,rigid) ! ٤ή. 
                                              ! ǥեȤǴ
      ! Chebyshev-tau ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries
      !
      ! \nabla^4 \psi = \nabla^2\zeta 
      ! 4 ʬˤ뤳ȤǶοȤĤĤޤ. 

      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      real(8), dimension(-km:km,0:lm)             :: et_Vor2Strm1_et

      ! ή. ǰʤΤȿ 0 ʬΤ
      real(8), dimension(2), intent(in), optional :: values
      ! 凉å
      logical, dimension(2), intent(in), optional :: rigid

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(0:lm,0:lm)           :: tt_work
      real(8), dimension(0:lm,0:jm)           :: ty_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if (.not. present(rigid)) then
         rigid1=.true. ; rigid2=.true.
      else
         rigid1 = rigid(1) ; rigid2 = rigid(2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         tt_work=0
         do l=0,lm
            tt_work(l,l)=1
         enddo
         do k=-km,km
            alu(k,:,:) = transpose( &
                 at_Dy_at(at_Dy_at(at_Dy_at(at_Dy_at(tt_work)))) &
                 - 2 * (2*pi*k/xl)**2 * at_Dy_at(at_Dy_at(tt_work)) &
                 + (2*pi*k/xl)**4*tt_work &
                 )
         enddo

         ! ưŪ. ή϶ǰ
         ty_work=ay_at(tt_work)
         do k=-km,km
            alu(k,lm-1,:) = ty_work(:,0)
            alu(k,lm,:)   = ty_work(:,jm)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            ty_work=ay_at(at_Dy_at(tt_work))
         else
            ty_work=ay_at(at_Dy_at(at_Dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,lm-3,:) = ty_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            ty_work=ay_at(at_Dy_at(tt_work))
         else
            ty_work=ay_at(at_Dy_at(at_Dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,lm-2,:) = ty_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et_Lapla_et(et)
      et_work(:,lm-3) = 0               ! ϳŪ
      et_work(:,lm-2) = 0               ! ϳŪ

      et_work(:,lm-1) = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm-1) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_work(:,lm)   = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_Vor2Strm1_et = lusolve(alu,kp,et_work)

    end function et_Vor2Strm1_et

  !--------------- ʬ׻ -----------------
    function IntXY_xy(xy)   ! ΰʬ
      real(8), dimension(0:jm,0:im-1)   :: xy          ! 2 ʻ
      real(8)                           :: IntXY_xy    ! ʬ
      integer :: i, j

      IntXY_xy = 0.0d0
      do i=0,im-1
         do j=0,jm
            IntXY_xy = IntXY_xy + xy(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntXY_xy

    function y_IntX_xy(xy)  ! X ʬ
      real(8), dimension(0:jm,0:im-1)   :: xy          ! 2 ʻ
      real(8), dimension(0:jm)          :: y_IntX_xy   ! 1 (Y)ʻ
      integer :: i

      y_IntX_xy = 0.0d0
      do i=0,im-1
         y_IntX_xy(:) = y_IntX_xy(:) + xy(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_xy

    function x_IntY_xy(xy)  ! Y ʬ
      real(8), dimension(0:jm,0:im-1)   :: xy          ! 2 ʻ
      real(8), dimension(0:im-1)        :: x_IntY_xy   ! 1 (X)ʻ
      integer :: j

      x_IntY_xy = 0.0d0
      do j=0,jm
         x_IntY_xy(:) = x_IntY_xy(:) + xy(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_xy

    function IntX_x(x)      ! X ʬ
      real(8), dimension(0:im-1)   :: x          ! 2 ʻ
      real(8)                      :: IntX_x     ! ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)      ! Y ʬ
      real(8), dimension(0:jm)   :: y          ! 2 ʻ
      real(8)                    :: IntY_y     ! ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

  !--------------- ʿѷ׻ -----------------
    function AvrXY_xy(xy)    ! ΰʿ
      real(8), dimension(0:jm,0:im-1)   :: xy          ! 2 ʻ
      real(8)                           :: AvrXY_xy    ! ʿ

      AvrXY_xy = IntXY_xy(xy)/(sum(x_X_weight)*sum(y_Y_weight))
    end function AvrXY_xy

    function y_AvrX_xy(xy)   ! X ʿ
      real(8), dimension(0:jm,0:im-1)   :: xy          ! 2 ʻ
      real(8), dimension(0:jm)          :: y_AvrX_xy   ! 1 (Y)ʻ

      y_AvrX_xy = y_IntX_xy(xy)/sum(x_X_weight)
    end function y_AvrX_xy

    function x_AvrY_xy(xy)   ! Y ʿ
      real(8), dimension(0:jm,0:im-1)   :: xy          ! 2 ʻ
      real(8), dimension(0:im-1)        :: x_AvrY_xy   ! 1 (X)ʻ

      x_AvrY_xy = x_IntY_xy(xy)/sum(y_Y_weight)
    end function x_AvrY_xy

    function AvrX_x(x)       ! X ʿ
      real(8), dimension(0:im-1)   :: x          ! 2 ʻ
      real(8)                      :: AvrX_x     ! ʬ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)       ! Y ʿ
      real(8), dimension(0:jm)   :: y          ! 2 ʻ
      real(8)                    :: AvrY_y     ! ʬ

      AvrY_y = IntY_y(y)/sum(y_Y_weight)
    end function AvrY_y

  end module et_module
