!----------------------------------------------------------------------
!     Copyright (c) 2002--2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ͭꥵ֥롼 (LAPACK)
!
!  2002/07/06  ݹ
!      2005/01/25  ݹ  MessageNotify/gt4f90io Ѥ dcl ڤΥ.
!
!      Debian/GNU Linux + Fujitsu frt ʤ
!      lapack, lapack-deb ѥå򥤥󥹥ȡ뤷, 
!         -llapack -lblas -L/usr/lib/gcc-lib/i386-linux/2.95.4 -lg2c
!      ȤäץĤ٤. 

module lapack_eigen

  use dc_message, only : MessageNotify

  implicit none
  private
  public deigen_lapack

contains
  subroutine deigen_lapack(amat,eigen_r,eigen_i,eigvec_r,eigvec_i,&
                           info,sort,reverse )
    !
    ! DGEEV/LAPACK 롼ˤ¹θͭ/ͭ٥ȥ׻
    !
    !   *  AMAT  i ܸͭͤ eigen_r(i), eigen_i(i) ˳Ǽ
    !   * бͭ٥ȥ eigvec_r(:,i), eigvec_i(:,i) ˳Ǽ
    !   * Ǽͭͤοϰ eigen_r 礭Ƿޤ
    !
    !   * ͭͤν֤ sort  order . 
    !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
    !     (R), (RA), (I), (IA)
    !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
    !   * ǥեȤ sort='R', reverse=.false.

    interface 
       function indexx(arrin)
         implicit none
         real(8), dimension(:), intent(in)  :: arrin
         integer, dimension(size(arrin))    :: indexx
       end function indexx
    end interface

   !------------  ------------
    real(8), dimension(:,:)                   :: amat      ! 
    real(8), intent(out), dimension(:)        :: eigen_r   ! ͭͼ¿
    real(8), intent(out), dimension(:)        :: eigen_i   ! ͭ͵
    real(8), intent(out), &
      dimension(size(amat,1),size(eigen_r))   :: eigvec_r  ! ͭ٥ȥ
    real(8), intent(out), &
      dimension(size(amat,1),size(eigen_i))   :: eigvec_i  ! ͭ٥ȥ
    integer, intent(out)                      :: info      ! ơ
    character(len=2), intent(in), optional    :: sort      ! ¤Ѥ
    logical, intent(in), optional             :: reverse   ! ¤Ѥå

   !------------ ѿ ------------
    real(8), dimension(size(amat,1))              :: wr    ! ͭͼ¿
    real(8), dimension(size(amat,1))              :: wi    ! ͭ͵
    real(8), dimension(size(amat,1),size(amat,1)) :: vl    ! ͭ٥ȥ
    real(8), dimension(size(amat,1),size(amat,1)) :: vr    ! ͭ٥ȥ
    real(8), dimension(size(amat,1)*4)            :: work  ! ѿ
    integer, dimension(size(amat,1))              :: index ! ¤Ѥ
    character(len=1), parameter :: jobvl='N', jobvr='V'    ! DEGGV Ϥå

    integer :: nm, i, j

    !------- å ------
    if (size(amat,1) /= size(amat,2))then
       call MessageNotify('E','DEIGEN_LAPACK','Input matrix not square')
    else
       nm = size(amat,1)
    endif

    !------- DGEEV/LAPACK ˤ׻ ------
    call DGEEV( jobvl, jobvr, nm, amat, nm, wr, wi, &
                vl, nm, vr, nm, work, nm*4, info )

    !------- ֥롼󥨥顼 -------
    if ( info /= 0 ) then
       call MessageNotify('W','DEIGEN_LAPACK',&
            'Error in calculating eigenvalues/vectors...',i=(/info/) )
       return
    endif

    !------- ͭ٥ȥ촹 -------
    if ( present(sort) ) then
       if ( sort == 'RA' ) then          ! ͭͼ
          index=indexx(abs(wr))
       elseif ( trim(sort) == 'I' ) then ! ͭ͵
          index=indexx(wi)
       elseif ( sort == 'IA' ) then      ! ͭ͵
          index=indexx(abs(wi))
       else
          index=indexx(wr)               ! defaultϸͭͼ
       endif
    else
       index=indexx(wr)                  ! defaultϸͭͼ
    endif

    if ( present(reverse) )then
       if ( reverse ) then               ! 礭
          index=index(size(index):1:-1)
       endif
    endif

    do i=1,size(eigen_r)
       j = index(i)
       eigen_r(i) = wr(j)
       eigen_i(i) = wi(j)

       if ( wi(j) == 0 ) then
          eigvec_r(:,i) = vr(:,j)
          eigvec_i(:,i) = 0.0
       elseif ( wi(j) > 0 ) then
          eigvec_r(:,i) = vr(:,j)
          eigvec_i(:,i) = vr(:,j+1)
       else
          eigvec_r(:,i) = vr(:,j-1)
          eigvec_i(:,i) = -vr(:,j)
       endif
    enddo

  end subroutine deigen_lapack

end module lapack_eigen
