#!/usr/bin/ruby
require "numru/ggraph"
include NumRu


filelistname_flux = 'filelist_flux.txt'
filelistname_tend = 'filelist_tend.txt'
outfile_flux      = 'out/Flux-SUM-10.nc'
outfile_tend      = 'out/Tendency-SUM-10.nc'

#####################################################
## create test file list
#File.open(filelistname_flux, "w") do |f|
#  for i in 1..120
#    f.puts 'out/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
#  end
#end
#File.open(filelistname_tend, "w") do |f|
#  for i in 1..120
#    f.puts 'out/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
#  end
#end
#####################################################


a_file = []
linenum = 1
File.open(filelistname_flux, "r") do |f|
  f.each_line { |line|
    file = line.chomp
#    puts(linenum.to_s + ": " + file)
    a_file << file
    linenum += 1
  }
end
a_file_Flux = a_file
a_file = []
linenum = 1
File.open(filelistname_tend, "r") do |f|
  f.each_line { |line|
    file = line.chomp
#    puts(linenum.to_s + ": " + file)
    a_file << file
    linenum += 1
  }
end
a_file_Tendency = a_file

ifile = 0
ncfn = a_file_Flux[ifile]
gp_uflw_sum = GPhys::IO.open_gturl( ncfn + "@" + "RadUwFluxLW" )
gp_dflw_sum = GPhys::IO.open_gturl( ncfn + "@" + "RadDwFluxLW" )
gp_ufsw_sum = GPhys::IO.open_gturl( ncfn + "@" + "RadUwFluxSW" )
gp_dfsw_sum = GPhys::IO.open_gturl( ncfn + "@" + "RadDwFluxSW" )
for ifile in (0+1)..(a_file_Flux.size-1)
  ncfn = a_file_Flux[ifile]
  gp_uflw_sum += GPhys::IO.open_gturl( ncfn + "@" + "RadUwFluxLW" )
  gp_dflw_sum += GPhys::IO.open_gturl( ncfn + "@" + "RadDwFluxLW" )
  gp_ufsw_sum += GPhys::IO.open_gturl( ncfn + "@" + "RadUwFluxSW" )
  gp_dfsw_sum += GPhys::IO.open_gturl( ncfn + "@" + "RadDwFluxSW" )
end

ifile = 0
ncfn = a_file_Tendency[ifile]
gp_dTdtlw_sum = GPhys::IO.open_gturl( ncfn + "@" + "DTempDtLW" )
gp_dTdtsw_sum = GPhys::IO.open_gturl( ncfn + "@" + "DTempDtSW" )
for ifile in (0+1)..(a_file_Flux.size-1)
  ncfn = a_file_Tendency[ifile]
  gp_dTdtlw_sum += GPhys::IO.open_gturl( ncfn + "@" + "DTempDtLW" )
  gp_dTdtsw_sum += GPhys::IO.open_gturl( ncfn + "@" + "DTempDtSW" )
end

outfile = NetCDF.create(outfile_flux)
GPhys::NetCDF_IO.write( outfile, gp_uflw_sum )
GPhys::NetCDF_IO.write( outfile, gp_dflw_sum )
GPhys::NetCDF_IO.write( outfile, gp_ufsw_sum )
GPhys::NetCDF_IO.write( outfile, gp_dfsw_sum )
outfile.close
outfile = NetCDF.create(outfile_tend)
GPhys::NetCDF_IO.write( outfile, gp_dTdtlw_sum )
GPhys::NetCDF_IO.write( outfile, gp_dTdtsw_sum )
outfile.close
