set term qt
#set term pdf
#set output 'fig_optip-loss.pdf'

nprof   = 1
nvar    = 8
ntotvar = nprof * nvar


set key left Left reverse

set ytics autofreq
set autoscale
unset logscale

set xlabel  "number of integration point"
set ylabel  "loss function divided by 10"
set ylabel  "loss function"
#set y2label "loss function, but with respect to LBL model (x 0.1)"
#set ytics nomirror
#set y2tics nomirror

plot \
     "out/loss.txt"u 2:($3/ntotvar) t "" w lp


pause -1

set multiplot

unset logscale
set autoscale

set xlabel  "number of integration point"
set ylabel  "loss function, but with respect to the LBL model (x 0.1)"
set ylabel  "loss function, but with respect to the LBL model"
set y2label ""
set ytics mirror

plot \
     "out/loss_lbl.txt"u 2:($3/ntotvar) t "" w lp


set origin 0.25, 0.25
set size 0.7, 0.7
set xrange [100:170]
set yrange [0:0.5]
set ytics 0, 0.05, 1
set xlabel  ""
set ylabel  ""

set grid

plot \
     "out/loss_lbl.txt"u 2:($3/ntotvar) t "" w lp

unset grid
set origin 0.0, 0.0
set size 1.0, 1.0
unset multiplot

set term qt
