#!/usr/bin/ruby
require 'parallel'

#nproc = 10  # number of processes

nband       = 23   # number of bands
nbandreg    =  1   # number of regions in a band
nregip_init = 16   # number of initial IPs in a region

ntotalreg = nband * nbandreg   # number of total regions


print '  Number of band              : ', nband, "\n"
print '  Number of regions in a band : ', nbandreg, "\n"
print '  Number of total regions     : ', ntotalreg, "\n"
print '  Number of IP                : ', ntotalreg*nregip_init, "\n"



# define factors
scl_f    =    1.0          # assumption
scl_R    =   10.0/30.0e-3  # gas constant
scl_g    =   10.0
scl_cp   = 1000.0
scl_t    =  250.0
#
scl_dz   = scl_R * scl_t / scl_g        # ~1e3*1e2/10.0=1e4
#
scl_p    =  1.0e1                       # roughly corresponds to upper boundary
scl_rho  =  scl_p / ( scl_R * scl_t )   # ~1.0/(1e3*1e2)=1e-5
#
factor_flx    = 1.0/( scl_f )
factor_flxcnv = 1.0/( scl_f/scl_dz )                   # 1e4
factor_tend   = 1.0/( scl_f/(scl_dz*scl_cp*scl_rho) )  # 1e4*1e3*1e-5=1e2

print '----------', "\n"
print ' Scales:', "\n"
print '   R               :', scl_R  , "\n"
print '   g               :', scl_g  , "\n"
print '   Cp              :', scl_cp , "\n"
print '   F               :', scl_f  , "\n"
print '   T               :', scl_t  , "\n"
print '   P   (for tend.) :', scl_p  , "\n"
print '   Rho (for tend.) :', scl_rho, "\n"
print ' Scale factors:', "\n"
print '   Flux            :', factor_flx   , "\n"
print '   Flux conv.      :', factor_flxcnv, "\n"
print '   Tendency        :', factor_tend  , "\n"
print '----------', "\n"
print "\n"



r_syms = [
  'Earth_ICRCCM_LW_Case25_TRP_CO2-300ppmv',
  'Earth_ICRCCM_LW_Case26_TRP_CO2-600ppmv',
  'Earth_ICRCCM_LW_Case27_MLS_CO2-300ppmv',
  'Earth_ICRCCM_LW_Case28_MLS_CO2-600ppmv',
  'Earth_ICRCCM_LW_Case29_MLW_CO2-300ppmv',
  'Earth_ICRCCM_LW_Case30_MLW_CO2-600ppmv',
  'Earth_ICRCCM_LW_Case31_SAS_CO2-300ppmv',
  'Earth_ICRCCM_LW_Case32_SAS_CO2-600ppmv',
  'Earth_ICRCCM_LW_Case33_SAW_CO2-300ppmv',
  'Earth_ICRCCM_LW_Case34_SAW_CO2-600ppmv',
]
r_syms = [
  'Earth_ICRCCM_LW_Case27_MLS_CO2-300ppmv',
]


r_INPROFNCFNs       = []
r_INORGOPTPROPNCFNs = []
r_syms.each { |sym|
  r_INPROFNCFNs       << '../../../prog01.0_mkprofile_ascii/out/'+sym+'.nc'
  r_INORGOPTPROPNCFNs << '../../../prog02.1_calc_ac/out/'+sym+'_ac.nc'
}

nRefProfs = r_INPROFNCFNs.size


pro_path             = 'sort_ac'
$conf_path                       = 'sort_ac.conf'
$conf_template_path              = 'template_'+$conf_path
$conf_sort_ac_file_path          = 'sort_ac_file.conf'
$conf_sort_ac_file_template_path = 'template_'+$conf_sort_ac_file_path
script_rmse_path     = 'disp_comp_1Dresults_v1.rb'
out_rmse_path        = 'error_script_rmse_each.log'
script_rmse_lbl_path = 'disp_comp_1Dresults_v1_LBL.rb'
out_rmse_lbl_path    = 'error_script_rmse_lbl_each.log'
ipstruct_path        = 'out/ip_structure.txt'
loss_path            = 'out/loss.txt'
loss_lbl_path        = 'out/loss_lbl.txt'
$files_dir           = 'files'
filelistname_flux    = 'filelist_flux.txt'
filelistname_tend    = 'filelist_tend.txt'


b_nip = []   # number of integration point in bands
# initialization of number of integration point
for i in 0..(ntotalreg-1)
  b_nip << nregip_init
end


def prep_dir( dir_work, flag_quiet = true )

  # create working directory
  unless ( flag_quiet ) then
    print 'creating working directory '+dir_work+"\n"
  end
  com = 'mkdir '+dir_work
  system( com )

  # copy files required to perform calculation
  unless ( flag_quiet ) then
    print 'copying files to '+dir_work+"\n"
  end
  com = 'cp '+$files_dir+'/* '+dir_work
  system( com )

  # enter into the working directory
  unless ( flag_quiet ) then
    print 'cd '+dir_work+"\n"
  end
  Dir.chdir(dir_work)

  # check and make output directory
  dir = 'out'
  unless ( File.directory?( dir ) ) then
    unless ( flag_quiet ) then
      print 'making '+dir+' directory'+"\n"
    end
    com = 'mkdir '+dir
    system( com )
  end

end


def makeconf( nband, bands, bande, nbandreg, b_nip, cINPROFNCFN, cINORGOPTPROPNCFN )

  # make configuration file, sort_ac.conf
#  com = 'cp ' + $conf_template_path + ' ' + $conf_path
#  system( com )
  com = 'cat ' + $conf_template_path +
        '| sed -e s#BANDNUMS#' + bands.to_s + '#g' +
        '| sed -e s#BANDNUME#' + bande.to_s + '#g' +
        '> ' + $conf_path
  system( com )
  #  band setting
  file = File.open($conf_path, 'a')
  for i in 1..nband
    line = '&band_exception_nml KeyMolNum=1,2,3, '+
           'BandNum='+i.to_s+','+
           'GaussRegNBins(1:'+nbandreg.to_s+')='
    for j in 0..(nbandreg-1)
      line += b_nip[nbandreg*(i-1)+j].to_s+','
    end
    line += ' /'
    file.puts line
  end
  file.close

  # make configuration file, sort_ac_file.conf
  com = 'cat ' + $conf_sort_ac_file_template_path +
        '| sed -e s#INPROFNCFN#'       + cINPROFNCFN       + '#g' +
        '| sed -e s#INORGOPTPROPNCFN#' + cINORGOPTPROPNCFN + '#g' +
        '> ' + $conf_sort_ac_file_path
  system( com )

end

def read_RMSEs( out_path )

  # read RMSEs
  iline = 1
  i = 0
  a_rmses = Array.new(8,0.0)
  File.foreach( out_path ){|line|
    #Example
    #RMSE summary
    # 1st file  : out/Flux-000-10.nc
    #           : out/Tendency-000-10.nc
    # 2nd file  : out/Flux-000-LBL.nc
    #           : out/Tendency-000-LBL.nc
    #variable : Planetary Rad.      Solar Rad.
    #   upflx   : 2.59421e-01    |    1.27926e-01 W m-2
    #   dnflx   : 1.22763e-01    |    1.20202e-01 W m-2
    #   flxcnv  : 5.11733e-05    |    2.29760e-05 W m-3
    #   tend    : 1.81266e-05    |    1.24212e-05 K s-1
    #
    # a_rmses[0] = upflx  of Planetary Rad.
    # a_rmses[1] = upflx of Solar Rad.
    # a_rmses[2] = dnflx  of Planetary Rad.
    # a_rmses[3] = dnflx  of Solar Rad.
    # a_rmses[4] = flxcnv of Planetary Rad.
    # a_rmses[5] = flxcnv of Solar Rad.
    # a_rmses[6] = tend   of Planetary Rad.
    # a_rmses[7] = tend   of Solar Rad.
    if ( iline >= 7 ) then
      line = line.split
      a_rmses[i] = line[2].to_f # planetary radiation
      i += 1
      a_rmses[i] = line[4].to_f # solar radiation
      i += 1
    end
    iline += 1
  }

  return a_rmses
end


dir = 'workdir-ref'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end
dir = 'out'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end


# check and make output directory
dir = 'out'
unless ( File.directory?( dir ) ) then
#  print '  making '+dir+' directory'+"\n"
  com = 'mkdir '+dir
  system( com )
end

# create output files
file = File.open(ipstruct_path, 'w')
file.close
#
file = File.open(loss_path, 'w')
#line = '# iloop  nip  loss  band#'
line = '# [iloop]  [nip]  [loss]  [band#]  [prof1 RMSE sum]  [prof2 RMSE sum] ... [PR.upflx mean RMSE]  [SR.upflx mean RMSE]  [PR.dnflx mean RMSE]  [SR.dnflx mean RMSE]  [PR.flxcnv mean RMSE]  [SR.flxcnv mean RMSE]  [PR.tend mean RMSE]  [SR.tend mean RMSE]'
file.puts line
file.close
#
file = File.open(loss_lbl_path, 'w')
#line = '# iloop  nip  loss  band#'
line = '# [iloop]  [nip]  [loss]  [band#]  [prof1 RMSE sum]  [prof2 RMSE sum] ... [PR.upflx mean RMSE]  [SR.upflx mean RMSE]  [PR.dnflx mean RMSE]  [SR.dnflx mean RMSE]  [PR.flxcnv mean RMSE]  [SR.flxcnv mean RMSE]  [PR.tend mean RMSE]  [SR.tend mean RMSE]'
file.puts line
file.close


print '====================', "\n"

# calculate reference
print 'calculate reference values with the k-dist. model'+"\n"

ra_rmses = []
#for iRefProf in 0..(nRefProfs-1)
Parallel.each(0..(nRefProfs-1)) do |iRefProf|
  com = 'sleep ' + iRefProf.to_s
  system( com )
  print '  reference profile #', iRefProf, "\n"

  #   prepare working directory
  dir_work = 'workdir-ref-'+iRefProf.to_s
  prep_dir( dir_work )

  #   make configuration file, sort_ac.conf and sort_ac_file.conf
  cINPROFNCFN       = r_INPROFNCFNs[iRefProf]
  cINORGOPTPROPNCFN = r_INORGOPTPROPNCFNs[iRefProf]
  print '    profile   : ', cINPROFNCFN, "\n"
  print '    opt. prop.: ', cINORGOPTPROPNCFN, "\n"
  makeconf( nband, 0, 0, nbandreg, b_nip, cINPROFNCFN, cINORGOPTPROPNCFN )

  #   execute sort_ac
  com = './'+pro_path + ' >> error_pro_all.log'
  system( com )

  # calculate RMSEs with respect to LBL
  com = 'ruby '+script_rmse_lbl_path+' 2'+' 1> '+out_rmse_lbl_path+' 2> /dev/null'
  system( com )

  #   go back to the parent directory
#  print '  exiting '+dir_work+"\n"
  Dir.chdir('..')

end


print '  Checking RMSEs', "\n"
ra_rmses_lbl = Array.new(nRefProfs) { Array.new(8,0.0) }
for iRefProf in 0..(nRefProfs-1)
  dir_work = 'workdir-ref-'+iRefProf.to_s
  Dir.chdir(dir_work)

  # calculate RMSEs with respect to LBL
  a_rmses = read_RMSEs( out_rmse_lbl_path )
  for i in 0..(a_rmses.size-1)
    ra_rmses_lbl[iRefProf][i] = a_rmses[i]
  end

  #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
  Dir.chdir('..')
end

#   output RMSEs with respect to the LBL model
file = File.open(loss_lbl_path, 'a')
loss = 0.0
for iRefProf in 0..(nRefProfs-1)
  a_rmses = ra_rmses_lbl[iRefProf]
  # old
  #loss += a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]
  # new
  loss += factor_flx    * (a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]) +
          factor_flxcnv * (a_rmses[4]+a_rmses[5]) +
          factor_tend   * (a_rmses[6]+a_rmses[7])
end
line = 0.to_s+' '+b_nip.sum.to_s+' '+loss.to_s+' '+0.to_s
for iRefProf in 0..(nRefProfs-1)
  a_rmses = ra_rmses_lbl[iRefProf]
  # old
#  loss = a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]
  # new
  loss = factor_flx    * (a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]) +
         factor_flxcnv * (a_rmses[4]+a_rmses[5]) +
         factor_tend   * (a_rmses[6]+a_rmses[7])
  line += ' '+loss.to_s
end
for j in 0..(8-1)
  loss = a_rmses[j]
  line += ' '+loss.to_s
end
file.puts line
file.close

# save results for reference profiles
for iRefProf in 0..(nRefProfs-1)
  dir_work = 'workdir-ref-'+iRefProf.to_s
#  com = 'mv ' + dir_work + ' ' + dir_work+'-'+iRefProf.to_s
  com = 'mv ' + dir_work+'/out' + ' ' + 'out.ref-'+iRefProf.to_s
  system( com )

  com = 'rm -rf ' + dir_work
  system( com )
end


# calculate k-dist. and flux and tendency in all each band separately
print 'calculate k-dist. and flux and tendency in all each band, separately', "\n"
a_dir_work_alleach = []
for iRefProf in 0..(nRefProfs-1)
  a_dir_work_alleach << 'workdir-alleachbands'+'-'+iRefProf.to_s
end
#  for iRefProf in 0..(nRefProfs-1)
Parallel.each(0..(nRefProfs-1)) do |iRefProf|
  com = 'sleep ' + iRefProf.to_s
  system( com )
#    print '    reference profile #', iRefProf, "\n"
  if ( iRefProf == 0 ) then
    print '  reference profile #', iRefProf
  else
    print ',', iRefProf
  end
  if ( iRefProf == (nRefProfs-1) ) then
    print "\n"
  end

  # prepare working directory
  dir_work = a_dir_work_alleach[iRefProf]
  prep_dir( dir_work )

  # make configuration file, sort_ac.conf and sort_ac_file.conf
  cINPROFNCFN       = r_INPROFNCFNs[iRefProf]
  cINORGOPTPROPNCFN = r_INORGOPTPROPNCFNs[iRefProf]
  makeconf( nband, 0, nband, nbandreg, b_nip, cINPROFNCFN, cINORGOPTPROPNCFN )
  # execute sort_ac
  com = './'+pro_path + ' >> error_pro_all.log'
  system( com )

  #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
  Dir.chdir('..')

end


for iloop in 1..b_nip.sum
  print '====================', "\n"
  print 'Outermost loop: ', iloop, "\n"
  print '  NIP: ', b_nip.sum, "\n"
  print '  IPs: ', b_nip, "\n"


  a_dir_work = []
  for ireg in 0..(ntotalreg-1)
    for iRefProf in 0..(nRefProfs-1)
      a_dir_work << 'workdir-'+ireg.to_s.rjust(4,"0")+'-'+iRefProf.to_s
    end
  end

  # loop for trials with decreased integration points in each band
#  for isubloop in 0..(ntotalreg*nRefProfs-1)
  Parallel.each(0..(ntotalreg*nRefProfs-1)) do |isubloop|
    iband    = isubloop / nRefProfs
    iRefProf = isubloop.modulo(nRefProfs)

    if ( iRefProf == 0 ) then
      if ( iband == 0 ) then
        print '  Trial for band: '
      else
        print ','
      end
      print iband
    end

    # prepare number of IPs
    b_nip_current = []
    for i in 0..(ntotalreg-1)
      b_nip_current << b_nip[i]
    end
    if ( b_nip_current[iband] > 1 ) then
      b_nip_current[iband] -= 1
      flag_calc = true
    else
      flag_calc = false
    end


    # prepare working directory
    dir_work = a_dir_work[isubloop]
    prep_dir( dir_work )

    if ( flag_calc ) then
      # make configuration file, sort_ac.conf and sort_ac_file.conf
      cINPROFNCFN       = r_INPROFNCFNs[iRefProf]
      cINORGOPTPROPNCFN = r_INORGOPTPROPNCFNs[iRefProf]
      makeconf( nband, iband+1, iband+1, nbandreg, b_nip_current, cINPROFNCFN, cINORGOPTPROPNCFN )

      # execute sort_ac
      com = './'+pro_path + ' >> error_pro_all.log'
      system( com )

      # calculate flux and tendency by summing values in each band
      #   make a list of file for flux
      dir_work = '../'+a_dir_work_alleach[iRefProf]
      File.open(filelistname_flux, "w") do |f|
        for i in 1..((iband+1)-1)
          f.puts dir_work+'/out/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
        i = iband+1
        f.puts 'out'+'/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
        for i in ((iband+1)+1)..nband
          f.puts dir_work+'/out/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
      end
      #   make a list of file for tendency
      dir_work = '../'+a_dir_work_alleach[iRefProf]
      File.open(filelistname_tend, "w") do |f|
        for i in 1..((iband+1)-1)
          f.puts dir_work+'/out/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
        i = iband+1
        f.puts 'out'+'/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
        for i in ((iband+1)+1)..nband
          f.puts dir_work+'/out/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
      end
      #   flux and tendency summed over all each band are output to
      #   out/Flux-SUM-10.nc and out/Tendency-SUM-10.nc
      com = 'ruby sum_flux_tendency.rb'
      system( com )
      com = 'ln -s Flux-SUM-10.nc out/Flux-000-10.nc'
      system( com )
      com = 'ln -s Tendency-SUM-10.nc out/Tendency-000-10.nc'
      system( com )

      # calculate RMSEs
      com = 'cp -Rp ' + '../out.ref-'+iRefProf.to_s + ' out.ref'
      system( com )
      com = 'ruby '+script_rmse_path+' 2'+' 1> '+out_rmse_path+' 2> /dev/null'
      system( com )
      com = 'rm -rf out.ref'
      system( com )

      # calculate RMSEs with respect to LBL
      com = 'ln -s ../../out.ref-'+iRefProf.to_s+'/Flux-000-LBL.nc out'
      system( com )
      com = 'ln -s ../../out.ref-'+iRefProf.to_s+'/Tendency-000-LBL.nc out'
      system( com )
      com = 'ruby '+script_rmse_lbl_path+' 2'+' 1> '+out_rmse_lbl_path+' 2> /dev/null'
      system( com )

    end

    # output flag for calculation
    file = File.open('flag.txt', "w")
    file.puts( flag_calc.to_s )
    file.close

    #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
    Dir.chdir('..')

  end
  print "\n"
#  p ba_rmses


  print '  Checking RMSEs', "\n"
  bra_rmses     = Array.new(ntotalreg) { Array.new(nRefProfs) { Array.new(8,0.0) } }
  bra_rmses_lbl = Array.new(ntotalreg) { Array.new(nRefProfs) { Array.new(8,0.0) } }
  for isubloop in 0..(ntotalreg*nRefProfs-1)
    ireg     = isubloop / nRefProfs
    iRefProf = isubloop.modulo(nRefProfs)
    dir_work = a_dir_work[isubloop]
    Dir.chdir(dir_work)

    flag_calc = true
    file = File.open('flag.txt', "r")
    flag_calc = file.read
    file.close
    flag_calc.chomp!
    if ( flag_calc == 'true' ) then
      flag_calc = true
    else
      flag_calc = false
    end

    if ( flag_calc ) then

      # calculate RMSEs
      a_rmses = read_RMSEs( out_rmse_path )
      for i in 0..(a_rmses.size-1)
        bra_rmses[ireg][iRefProf][i] = a_rmses[i]
      end

      # calculate RMSEs with respect to LBL
      a_rmses = read_RMSEs( out_rmse_lbl_path )
      for i in 0..(a_rmses.size-1)
        bra_rmses_lbl[ireg][iRefProf][i] = a_rmses[i]
      end

    else

      for i in 0..(bra_rmses[0].size-1)
        bra_rmses    [ireg][iRefProf][i] = 1.0e10
        bra_rmses_lbl[ireg][iRefProf][i] = 1.0e10
      end

    end

    #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
    Dir.chdir('..')

  end

  # check minimum RMSEs
  b_rmses = []
  for ireg in 0..(ntotalreg-1)
    loss = 0.0
    for iRefProf in 0..(nRefProfs-1)
      #       PR.upflx
      loss += bra_rmses[ireg][iRefProf][0]*factor_flx+
      #      +SR.upflx
              bra_rmses[ireg][iRefProf][1]*factor_flx+
      #      +PR.dnflx
              bra_rmses[ireg][iRefProf][2]*factor_flx+
      #      +SR.dnflx
              bra_rmses[ireg][iRefProf][3]*factor_flx+
      #      +PR.flxcnv
              bra_rmses[ireg][iRefProf][4]*factor_flxcnv+
      #      +SR.flxcnv
              bra_rmses[ireg][iRefProf][5]*factor_flxcnv+
      #      +PR.tend
              bra_rmses[ireg][iRefProf][6]*factor_tend+
      #      +SR.tend
              bra_rmses[ireg][iRefProf][7]*factor_tend
    end
    b_rmses << loss
  end
  i_min = b_rmses.index(b_rmses.min)
  print '  Decrease IP in the band #'+(i_min+1).to_s+' (RMSE sum=', b_rmses.min, ')'+"\n"
  # decrease integration point in the (i_min+1)th band
  b_nip[i_min] -= 1
  # check condition
  if ( b_nip[i_min] <= 0 ) then
    print 'Number of integration point in the band #'+(i_min+1).to_s+' will be zero.'+"\n"
    break
  end


  # copy flux and tendency of (i_min+1)th band to the workdir-alleachbands-N
  # directory???
  print '  Copy the files for flux and tendency in a band with decreased IP.', "\n"
  for iRefProf in 0..(nRefProfs-1)
    dir_work         = a_dir_work        [i_min*nRefProfs+iRefProf]
    dir_work_alleach = a_dir_work_alleach[                iRefProf]
    com = 'cp -Rp '+dir_work+'/out/'+'Flux-'    +(i_min+1).to_s.rjust(3,'0')+'-10.nc '+
          dir_work_alleach+'/out'
    system( com )
    com = 'cp -Rp '+dir_work+'/out/'+'Tendency-'+(i_min+1).to_s.rjust(3,'0')+'-10.nc '+
          dir_work_alleach+'/out'
    system( com )
  end


  a_dir_work.each{ |dir_work|
#    print 'deleting working directory, '+dir_work+"\n"
    com = 'rm -rf '+dir_work
    system( com )
  }

# output to file
  line = ''
  file = File.open(ipstruct_path, 'a')
  line = 'Total number of IPs : '+ b_nip.sum.to_s
  file.puts line
  line = '  Number of IPs : '+ b_nip.to_s
  file.puts line
#  for ireg in 0..(ntotalreg-1)
#    line = iloop.to_s+' '+ireg.to_s+' '+b_nip[ireg].to_s
#    file.puts line
#  end
  line = ''
  file.puts line
  file.close
  #
  file = File.open(loss_path, 'a')
  line = iloop.to_s+' '+b_nip.sum.to_s+' '+b_rmses.min.to_s+' '+(i_min+1).to_s
  for iRefProf in 0..(nRefProfs-1)
    loss = bra_rmses[i_min][iRefProf][0]*factor_flx+
           bra_rmses[i_min][iRefProf][1]*factor_flx+
           bra_rmses[i_min][iRefProf][2]*factor_flx+
           bra_rmses[i_min][iRefProf][3]*factor_flx+
           bra_rmses[i_min][iRefProf][4]*factor_flxcnv+
           bra_rmses[i_min][iRefProf][5]*factor_flxcnv+
           bra_rmses[i_min][iRefProf][6]*factor_tend+
           bra_rmses[i_min][iRefProf][7]*factor_tend
    line += ' '+loss.to_s
  end
  for j in 0..(8-1)
    loss = 0.0
    for iRefProf in 0..(nRefProfs-1)
      loss += bra_rmses[i_min][iRefProf][j]
    end
    loss /= nRefProfs
    line += ' '+loss.to_s
  end
  file.puts line
  file.close


  file = File.open(loss_lbl_path, 'a')
  loss = 0.0
  for iRefProf in 0..(nRefProfs-1)
    loss += bra_rmses_lbl[i_min][iRefProf][0]*factor_flx+
            bra_rmses_lbl[i_min][iRefProf][1]*factor_flx+
            bra_rmses_lbl[i_min][iRefProf][2]*factor_flx+
            bra_rmses_lbl[i_min][iRefProf][3]*factor_flx+
            bra_rmses_lbl[i_min][iRefProf][4]*factor_flxcnv+
            bra_rmses_lbl[i_min][iRefProf][5]*factor_flxcnv+
            bra_rmses_lbl[i_min][iRefProf][6]*factor_tend+
            bra_rmses_lbl[i_min][iRefProf][7]*factor_tend
  end
  line = iloop.to_s+' '+b_nip.sum.to_s+' '+loss.to_s+' '+(i_min+1).to_s
  for iRefProf in 0..(nRefProfs-1)
    loss = bra_rmses_lbl[i_min][iRefProf][0]*factor_flx+
           bra_rmses_lbl[i_min][iRefProf][1]*factor_flx+
           bra_rmses_lbl[i_min][iRefProf][2]*factor_flx+
           bra_rmses_lbl[i_min][iRefProf][3]*factor_flx+
           bra_rmses_lbl[i_min][iRefProf][4]*factor_flxcnv+
           bra_rmses_lbl[i_min][iRefProf][5]*factor_flxcnv+
           bra_rmses_lbl[i_min][iRefProf][6]*factor_tend+
           bra_rmses_lbl[i_min][iRefProf][7]*factor_tend
    line += ' '+loss.to_s
  end
  for j in 0..(8-1)
    loss = 0.0
    for iRefProf in 0..(nRefProfs-1)
      loss += bra_rmses_lbl[i_min][iRefProf][j]
    end
    loss /= nRefProfs
    line += ' '+loss.to_s
  end
  file.puts line
  file.close

end


a_dir_work.each{ |dir_work|
#  print 'deleting working directory, '+dir_work+"\n"
  com = 'rm -rf '+dir_work
  system( com )
}
a_dir_work_alleach.each{ |dir_work|
#      print 'deleting working directory, '+dir_work_alleach+"\n"
  com = 'rm -rf '+dir_work
  system( com )
}

print 'Finish', "\n"
