#!/usr/bin/ruby
require 'parallel'

#nproc = 10  # number of processes

wn = 10.0
w_bandbnd           = [wn]   # wavenumber boundary of band
w_bandbnd_nonremove = [wn]   # wavenumber boundary which cannot be removed
# initialization of wavenumber boundary of band
wn = 100.0
while ( wn < 3500.0 ) do
  w_bandbnd << wn
  wn += 100.0
end
wn = 3500.0
w_bandbnd_nonremove << wn
while ( wn < 50000.0 ) do
  w_bandbnd << wn
  wn += 1000.0
end
wn = 50000.0
w_bandbnd << wn
w_bandbnd_nonremove << wn
print 'number of band                        : ', (w_bandbnd.size-1), "\n"
print 'band boundary (cm-1)                  : ', w_bandbnd, "\n"
print 'band boundary not to be removed (cm-1): ', w_bandbnd_nonremove, "\n"



# TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
wn = 10.0
w_bandbnd = [wn]   # wavenumber boundary of band
w_bandbnd_nonremove = [wn]   # wavenumber boundary which cannot be removed
# initialization of wavenumber boundary of band
wn = 100.0
while ( wn < 3500.0 ) do
  w_bandbnd << wn
  wn += 100.0
end
wn = 3500.0
w_bandbnd_nonremove << wn
while ( wn < 50000.0 ) do
  w_bandbnd << wn
  wn += 1000.0
end
wn = 50000.0
w_bandbnd << wn
w_bandbnd_nonremove << wn
print 'number of band                        : ', (w_bandbnd.size-1), "\n"
print 'band boundary (cm-1)                  : ', w_bandbnd, "\n"
print 'band boundary not to be removed (cm-1): ', w_bandbnd_nonremove, "\n"
# TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST



nip = 8*2


pro_path             = 'sort_ac'
$conf_path           = 'sort_ac.conf'
$conf_template_path  = 'template_'+$conf_path
script_rmse_path     = 'disp_comp_1Dresults_v1.rb'
out_rmse_path        = 'error_script_rmse_each.log'
script_rmse_lbl_path = 'disp_comp_1Dresults_v1_LBL.rb'
out_rmse_lbl_path    = 'error_script_rmse_lbl_each.log'
bandstruct_path      = 'out/band_structure.txt'
loss_path            = 'out/loss.txt'
loss_lbl_path        = 'out/loss_lbl.txt'
$files_dir           = 'files'


def prep_dir( dir_work, flag_quiet = true )

  # create working directory
  unless ( flag_quiet ) then
    print 'creating working directory '+dir_work+"\n"
  end
  com = 'mkdir '+dir_work
  system( com )

  # copy files required to perform calculation
  unless ( flag_quiet ) then
    print 'copying files to '+dir_work+"\n"
  end
  com = 'cp '+$files_dir+'/* '+dir_work
  system( com )

  # enter into the working directory
  unless ( flag_quiet ) then
    print 'cd '+dir_work+"\n"
  end
  Dir.chdir(dir_work)

  # check and make output directory
  dir = 'out'
  unless ( File.directory?( dir ) ) then
    unless ( flag_quiet ) then
      print 'making '+dir+' directory'+"\n"
    end
    com = 'mkdir '+dir
    system( com )
  end

end


def makeconf( w_bandbnd, nip )

  # make configuration file, sort_ac.conf
  com = 'cp ' + $conf_template_path + ' ' + $conf_path
  system( com )
  #  band setting
  file = File.open($conf_path, 'a')
  line = '&band_nml'
  file.puts line
  line = '  KeyMolNum = 1, 2, 3,'
  file.puts line
  line = '  BandNBin  = '+nip.to_s+','
  file.puts line
  line = '  NBand     = '+(w_bandbnd.size-1).to_s+','
  file.puts line
  line = '  WNBnds    = '
  for i in 0..(w_bandbnd.size-1)
    line += w_bandbnd[i].to_s + 'd2,'
  end
  file.puts line
  line = '/'
  file.puts line
  file.close

end


def read_RMSEs( out_path )

  # read RMSEs
  iline = 1
  i = 0
  a_rmses = Array.new(8,0.0)
  File.foreach( out_path ){|line|
    if ( iline >= 7 ) then
      line = line.split
      a_rmses[i] = line[2].to_f # planetary radiation
      i += 1
      a_rmses[i] = line[4].to_f # solar radiation
      i += 1
    end
    iline += 1
  }

  return a_rmses
end


dir = 'workdir-ref'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end
dir = 'out'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end
dir = 'out.ref'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end


print '====================', "\n"

# calculate reference
print 'calculate reference values with the k-dist. model'+"\n"

#   prepare working directory
dir_work = 'workdir-ref'
prep_dir( dir_work )

#   make configuration file, sort_ac.conf
makeconf( w_bandbnd, nip )

#   execute sort_ac
com = './'+pro_path + ' >> error_pro_all.log'
system( com )

#   calculate RMSEs
com = 'ruby '+script_rmse_lbl_path+' 2'+' 1> '+out_rmse_lbl_path+' 2> /dev/null'
system( com )
#   read RMSEs with respect to LBL
a_rmses = read_RMSEs( out_rmse_lbl_path )

#   go back to the parent directory
#print '  exiting '+dir_work+"\n"
Dir.chdir('..')


# check and make output directory
dir = 'out'
unless ( File.directory?( dir ) ) then
#  print '  making '+dir+' directory'+"\n"
  com = 'mkdir '+dir
  system( com )
end

# create output files
file = File.open(bandstruct_path, 'w')
line = '# iloop  bandbnd'
file.puts line
file.close
#
file = File.open(loss_path, 'w')
line = '# iloop  nband  loss  bandbnd'
file.puts line
file.close
#
file = File.open(loss_lbl_path, 'w')
line = '# iloop  nband  loss  bandbnd'
file.puts line
file.close


#   output RMSEs with respect to the LBL model
file = File.open(loss_lbl_path, 'a')
loss = a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]
line = 0.to_s+' '+(w_bandbnd.size-1).to_s+' '+loss.to_s+' '+0.to_s
for i in 0..(a_rmses.size-1)
  line += ' '+a_rmses[i].to_s
end
file.puts line
file.close

#   move output files to save directory
com = 'mv '+dir_work+'/out'+' out.ref/'
system( com )


nbandbnd_init = w_bandbnd.size
for iloop in 1..(nbandbnd_init-2)
  print '====================', "\n"
  print 'Outermost loop: ', iloop, "\n"
  print '  number of band        : ', w_bandbnd.size-1, "\n"
  print '  band boundaries (cm-1): ', w_bandbnd, "\n"

  nbandbnd = w_bandbnd.size

  dirs_work = []
  for ibandbnd in 0..(nbandbnd-1)
    dirs_work << 'workdir-'+ibandbnd.to_s.rjust(4,"0")
  end

  # loop for trials with increased integration points in each band
#  for ibandbnd in 0..(nbandbnd-1)
#  Parallel.each(0..(nbandbnd-1), in_proceses: nproc) do |ibandbnd|
  Parallel.each(0..(nbandbnd-1)) do |ibandbnd|
    if ( ibandbnd == 0 ) then
      print '  Trial for band boundary: '
    else
      print ','
    end
    print ibandbnd

    # prepare working directory
    dir_work = dirs_work[ibandbnd]
    prep_dir( dir_work )


    flag_calc = true
    for i in 0..(w_bandbnd_nonremove.size-1)
      if ( w_bandbnd[ibandbnd] == w_bandbnd_nonremove[i] ) then
        # If the boundary #ibandbnd is one that cannot be removed, calculation
        # will not be performed.
        flag_calc = false
      end
    end

    if ( flag_calc ) then

      # prepare number of band boundaries
      w_bandbnd_current = []
      for i in 0..(ibandbnd-1)
        w_bandbnd_current << w_bandbnd[i]
      end
      for i in (ibandbnd+1)..(nbandbnd-1)
        w_bandbnd_current << w_bandbnd[i]
      end

      # make configuration file, sort_ac.conf
      makeconf( w_bandbnd_current, nip )

      # execute sort_ac
      com = './'+pro_path + ' >> error_pro_all.log'
      system( com )

      # calculate RMSEs
      com = 'ruby '+script_rmse_path+' 2'+' 1> '+out_rmse_path+' 2> /dev/null'
      system( com )

      # calculate RMSEs with respect to LBL
      com = 'ruby '+script_rmse_lbl_path+' 2'+' 1> '+out_rmse_lbl_path+' 2> /dev/null'
      system( com )

    end

    # output flag for calculation
    file = File.open('flag.txt', "w")
    file.puts( flag_calc.to_s )
    file.close

    #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
    Dir.chdir('..')

  end
  print "\n"
#  p ba_rmses


  print '  Checking RMSEs', "\n"
  wa_rmses     = Array.new(nbandbnd) { Array.new(8,0.0) }
  wa_rmses_lbl = Array.new(nbandbnd) { Array.new(8,0.0) }
  for ibandbnd in 0..(nbandbnd-1)
    dir_work = dirs_work[ibandbnd]
    Dir.chdir(dir_work)

    flag_calc = true
    file = File.open('flag.txt', "r")
    flag_calc = file.read
    file.close
    flag_calc.chomp!
    if ( flag_calc == 'true' ) then
      flag_calc = true
    else
      flag_calc = false
    end

    if ( flag_calc ) then

      # read RMSEs
      a_rmses = read_RMSEs( out_rmse_path )
      for i in 0..(a_rmses.size-1)
        wa_rmses[ibandbnd][i] = a_rmses[i]
      end

      # read RMSEs with respect to LBL
      a_rmses = read_RMSEs( out_rmse_lbl_path )
      for i in 0..(a_rmses.size-1)
        wa_rmses_lbl[ibandbnd][i] = a_rmses[i]
      end

    else

      for i in 0..(wa_rmses[0].size-1)
        wa_rmses    [ibandbnd][i] = 1.0e10
        wa_rmses_lbl[ibandbnd][i] = 1.0e10
      end

    end

    #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
    Dir.chdir('..')

  end

  dirs_work.each{ |dir_work|
#    print 'deleting working directory, '+dir_work+"\n"
    com = 'rm -rf '+dir_work
    system( com )
  }


  # check minimum RMSEs
  w_rmses = []
  for ibandbnd in 0..(nbandbnd-1)
    #      PR.upflx             +SR.upflx             +PR.dnflx             +SR.dnflx
    loss = wa_rmses[ibandbnd][0]+wa_rmses[ibandbnd][1]+wa_rmses[ibandbnd][2]+wa_rmses[ibandbnd][3]
    w_rmses << loss
  end
  i_min = w_rmses.index(w_rmses.min)
  print '  Delete band boundary at '+w_bandbnd[i_min].to_s+' cm-1 (RMSE sum=', w_rmses.min, ')'+"\n"
  # delete band boundary #i_min
  w_bandbnd_bk = []
  for i in 0..(nbandbnd-1)
    w_bandbnd_bk << w_bandbnd[i]
  end
  w_bandbnd = []
  for i in 0..(i_min-1)
    w_bandbnd << w_bandbnd_bk[i]
  end
  for i in (i_min+1)..(nbandbnd-1)
    w_bandbnd << w_bandbnd_bk[i]
  end
  nbandbnd = w_bandbnd.size
  # check condition
  if ( w_bandbnd.size <= w_bandbnd_nonremove.size ) then
    print 'All remained band boundary are required, ', w_bandbnd, '.'+"\n"
    exit
  end


  # output to file
  line = ''
  file = File.open(bandstruct_path, 'a')
  for ibandbnd in 0..(nbandbnd-1)
    line = iloop.to_s+' '+w_bandbnd[ibandbnd].to_s
    file.puts line
  end
  line = ''
  file.puts line
  file.close
  #
  file = File.open(loss_path, 'a')
  line = iloop.to_s+' '+(w_bandbnd.size-1).to_s+' '+w_rmses.min.to_s+' '+w_bandbnd_bk[i_min].to_s
  for i in 0..(wa_rmses[0].size-1)
    line += ' '+wa_rmses[i_min][i].to_s
  end
  file.puts line
  file.close


  file = File.open(loss_lbl_path, 'a')
  loss = wa_rmses_lbl[i_min][0]+wa_rmses_lbl[i_min][1]+wa_rmses_lbl[i_min][2]+wa_rmses_lbl[i_min][3]
  line = iloop.to_s+' '+(w_bandbnd.size-1).to_s+' '+loss.to_s+' '+w_bandbnd_bk[i_min].to_s
  for i in 0..(wa_rmses_lbl[0].size-1)
    line += ' '+wa_rmses_lbl[i_min][i].to_s
  end
  file.puts line
  file.close

end
