#!/usr/bin/ruby
require 'parallel'

flag_TEST = true
flag_TEST = false

#nproc = 10  # number of processes

# define factors
scl_f    =    1.0          # assumption
scl_R    =   10.0/50.0e-3  # gas constant
scl_g    =   10.0
scl_cp   = 1000.0
scl_t    =  200.0
#
scl_dz   = scl_R * scl_t / scl_g        # ~1e3*1e2/10.0=1e4
#
scl_p    =  1.0e2                       # roughly corresponds to upper boundary
scl_rho  =  scl_p / ( scl_R * scl_t )   # ~1.0/(1e3*1e2)=1e-5
#
factor_flx    = 1.0/( scl_f )
factor_flxcnv = 1.0/( scl_f/scl_dz )                   # 1e4
factor_tend   = 1.0/( scl_f/(scl_dz*scl_cp*scl_rho) )  # 1e4*1e3*1e-5=1e2

print '----------', "\n"
print ' Scales:', "\n"
print '   R               :', scl_R  , "\n"
print '   g               :', scl_g  , "\n"
print '   Cp              :', scl_cp , "\n"
print '   F               :', scl_f  , "\n"
print '   T               :', scl_t  , "\n"
print '   P   (for tend.) :', scl_p  , "\n"
print '   Rho (for tend.) :', scl_rho, "\n"
print ' Scale factors:', "\n"
print '   Flux            :', factor_flx   , "\n"
print '   Flux conv.      :', factor_flxcnv, "\n"
print '   Tendency        :', factor_tend  , "\n"
print '----------', "\n"
print "\n"


wn = 10.0
w_bandbnd           = [wn]   # wavenumber boundary of band
w_bandbnd_nonremove = [wn]   # wavenumber boundary which cannot be removed
# initialization of wavenumber boundary of band
wn = 100.0
while ( wn < 7700.0 ) do
  w_bandbnd << wn
  wn += 100.0
end
wn = 7700.0
w_bandbnd_nonremove << wn
while ( wn < 50000.0 ) do
  w_bandbnd << wn
  wn += 1000.0
end
wn = 50000.0
w_bandbnd << wn
w_bandbnd_nonremove << wn


# TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
if ( flag_TEST ) then
  print '***TEST BAND***', "\n"
  wn = 10.0
  w_bandbnd = [wn]   # wavenumber boundary of band
  w_bandbnd_nonremove = [wn]   # wavenumber boundary which cannot be removed
  # initialization of wavenumber boundary of band
  wn = 100.0
  while ( wn < 7700.0 ) do
    w_bandbnd << wn
    wn += 2000.0
  end
  wn = 7700.0
  w_bandbnd_nonremove << wn
  while ( wn < 50000.0 ) do
    w_bandbnd << wn
    wn += 20000.0
  end
  wn = 50000.0
  w_bandbnd << wn
  w_bandbnd_nonremove << wn
end
# TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST


print 'number of band                        : ', (w_bandbnd.size-1), "\n"
print 'band boundary (cm-1)                  : ', w_bandbnd, "\n"
print 'band boundary not to be removed (cm-1): ', w_bandbnd_nonremove, "\n"


nip = 16

r_syms = [
  'Venus_ProfB',
  'Venus_ProfB_nocld',
]

r_INPROFNCFNs       = []
r_INORGOPTPROPNCFNs = []
r_syms.each { |sym|
  r_INPROFNCFNs       << '../../../prog01.0_mkprofile_ascii/out/'+sym+'.nc'
  r_INORGOPTPROPNCFNs << '../../../prog02.1_calc_ac/out/'+sym+'_ac.nc'
}

nRefProfs = r_INPROFNCFNs.size


pro_path             = 'sort_ac'
$conf_sort_ac_path               = 'sort_ac.conf'
$conf_sort_ac_template_path      = 'template_'+$conf_sort_ac_path
$conf_sort_ac_file_path          = 'sort_ac_file.conf'
$conf_sort_ac_file_template_path = 'template_'+$conf_sort_ac_file_path
script_rmse_path     = 'disp_comp_1Dresults_v1.rb'
out_rmse_path        = 'error_script_rmse_each.log'
script_rmse_lbl_path = 'disp_comp_1Dresults_v1_LBL.rb'
out_rmse_lbl_path    = 'error_script_rmse_lbl_each.log'
bandstruct_path      = 'out/band_structure.txt'
loss_path            = 'out/loss.txt'
loss_lbl_path        = 'out/loss_lbl.txt'
$files_dir           = 'files'
filelistname_flux    = 'filelist_flux.txt'
filelistname_tend    = 'filelist_tend.txt'


def prep_dir( dir_work, flag_quiet = true )

  # create working directory
  unless ( flag_quiet ) then
    print 'creating working directory '+dir_work+"\n"
  end
  com = 'mkdir '+dir_work
  system( com )

  # copy files required to perform calculation
  unless ( flag_quiet ) then
    print 'copying files to '+dir_work+"\n"
  end
  com = 'cp '+$files_dir+'/* '+dir_work
  system( com )

  # enter into the working directory
  unless ( flag_quiet ) then
    print 'cd '+dir_work+"\n"
  end
  Dir.chdir(dir_work)

  # check and make output directory
  dir = 'out'
  unless ( File.directory?( dir ) ) then
    unless ( flag_quiet ) then
      print 'making '+dir+' directory'+"\n"
    end
    com = 'mkdir '+dir
    system( com )
  end

end


def makeconf( w_bandbnd, bands, bande, nip, cINPROFNCFN, cINORGOPTPROPNCFN )

  # make configuration file, sort_ac.conf
#  com = 'cp ' + $conf_sort_ac_template_path + ' ' + $conf_sort_ac_path
#  system( com )
  com = 'cat ' + $conf_sort_ac_template_path +
        '| sed -e s#BANDNUMS#' + bands.to_s + '#g' + 
        '| sed -e s#BANDNUME#' + bande.to_s + '#g' + 
        '> ' + $conf_sort_ac_path
  system( com )
  #  band setting
  file = File.open($conf_sort_ac_path, 'a')
  line = '&band_nml'
  file.puts line
  line = '  KeyMolNum = 1, 2, 5, 9, 14, 19, 22,'
  file.puts line
  line = '  BandNBin  = '+nip.to_s+','
  file.puts line
  line = '  NBand     = '+(w_bandbnd.size-1).to_s+','
  file.puts line
  line = '  WNBnds    = '
  for i in 0..(w_bandbnd.size-1)
    line += w_bandbnd[i].to_s + 'd2,'
  end
  file.puts line
  line = '/'
  file.puts line
  file.close

  # make configuration file, sort_ac_file.conf
  com = 'cat ' + $conf_sort_ac_file_template_path +
        '| sed -e s#INPROFNCFN#'       + cINPROFNCFN       + '#g' + 
        '| sed -e s#INORGOPTPROPNCFN#' + cINORGOPTPROPNCFN + '#g' + 
        '> ' + $conf_sort_ac_file_path
  system( com )

end


def read_RMSEs( out_path )

  # read RMSEs
  iline = 1
  i = 0
  a_rmses = Array.new(8,0.0)
  File.foreach( out_path ){|line|
    #Example
    #RMSE summary
    # 1st file  : out/Flux-000-10.nc
    #           : out/Tendency-000-10.nc
    # 2nd file  : out/Flux-000-LBL.nc
    #           : out/Tendency-000-LBL.nc
    #variable : Planetary Rad.      Solar Rad.
    #   upflx   : 2.59421e-01    |    1.27926e-01 W m-2
    #   dnflx   : 1.22763e-01    |    1.20202e-01 W m-2
    #   flxcnv  : 5.11733e-05    |    2.29760e-05 W m-3
    #   tend    : 1.81266e-05    |    1.24212e-05 K s-1
    #
    # a_rmses[0] = upflx  of Planetary Rad.
    # a_rmses[1] = upflx of Solar Rad.
    # a_rmses[2] = dnflx  of Planetary Rad.
    # a_rmses[3] = dnflx  of Solar Rad.
    # a_rmses[4] = flxcnv of Planetary Rad.
    # a_rmses[5] = flxcnv of Solar Rad.
    # a_rmses[6] = tend   of Planetary Rad.
    # a_rmses[7] = tend   of Solar Rad.
    if ( iline >= 7 ) then
      line = line.split
      a_rmses[i] = line[2].to_f # planetary radiation
      i += 1
      a_rmses[i] = line[4].to_f # solar radiation
      i += 1
    end
    iline += 1
  }

  return a_rmses
end


dir = 'workdir-ref'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end
dir = 'out'
if ( File.directory?( dir ) ) then
  print 'Deleting '+dir, "\n"
  com = 'rm -rf '+dir
  system( com )
end


# check and make output directory
dir = 'out'
unless ( File.directory?( dir ) ) then
#  print '  making '+dir+' directory'+"\n"
  com = 'mkdir '+dir
  system( com )
end

# create output files
file = File.open(bandstruct_path, 'w')
file.close
#
file = File.open(loss_path, 'w')
line = '# [iloop]  [nband]  [loss]  [deleted bandbnd]  [prof1 RMSE sum]  [prof2 RMSE sum] ... [PR.upflx mean RMSE]  [SR.upflx mean RMSE]  [PR.dnflx mean RMSE]  [SR.dnflx mean RMSE]  [PR.flxcnv mean RMSE]  [SR.flxcnv mean RMSE]  [PR.tend mean RMSE]  [SR.tend mean RMSE]'
file.puts line
file.close
#
file = File.open(loss_lbl_path, 'w')
line = '# [iloop]  [nband]  [loss]  [deleted bandbnd]  [prof1 RMSE sum]  [prof2 RMSE sum] ... [PR.upflx mean RMSE]  [SR.upflx mean RMSE]  [PR.dnflx mean RMSE]  [SR.dnflx mean RMSE]  [PR.flxcnv mean RMSE]  [SR.flxcnv mean RMSE]  [PR.tend mean RMSE]  [SR.tend mean RMSE]'
file.puts line
file.close


print '====================', "\n"

# calculate reference
print 'calculate reference values with the k-dist. model'+"\n"

ra_rmses = []
#for iRefProf in 0..(nRefProfs-1)
Parallel.each(0..(nRefProfs-1)) do |iRefProf|
  com = 'sleep ' + iRefProf.to_s
  system( com )
  print '  reference profile #', iRefProf, "\n"

  #   prepare working directory
  dir_work = 'workdir-ref-'+iRefProf.to_s
  prep_dir( dir_work )

  #   make configuration file, sort_ac.conf and sort_ac_file.conf
  cINPROFNCFN       = r_INPROFNCFNs[iRefProf]
  cINORGOPTPROPNCFN = r_INORGOPTPROPNCFNs[iRefProf]
  print '    profile   : ', cINPROFNCFN, "\n"
  print '    opt. prop.: ', cINORGOPTPROPNCFN, "\n"
  makeconf( w_bandbnd, 0, 0, nip, cINPROFNCFN, cINORGOPTPROPNCFN )

  #   execute sort_ac
  com = './'+pro_path + ' >> error_pro_all.log'
  system( com )

  #   calculate RMSEs
  com = 'ruby '+script_rmse_lbl_path+' 2'+' 1> '+out_rmse_lbl_path+' 2> /dev/null'
  system( com )

  #   go back to the parent directory
  #print '  exiting '+dir_work+"\n"
  Dir.chdir('..')

end

print '  Checking RMSEs', "\n"
ra_rmses_lbl = Array.new(nRefProfs) { Array.new(8,0.0) }
for iRefProf in 0..(nRefProfs-1)
  dir_work = 'workdir-ref-'+iRefProf.to_s
  Dir.chdir(dir_work)

  # read RMSEs with respect to LBL
  a_rmses = read_RMSEs( out_rmse_lbl_path )
  for i in 0..(a_rmses.size-1)
    ra_rmses_lbl[iRefProf][i] = a_rmses[i]
  end

  #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
  Dir.chdir('..')
end

#   output RMSEs with respect to the LBL model
file = File.open(loss_lbl_path, 'a')
#loss = a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]
loss = 0.0
for iRefProf in 0..(nRefProfs-1)
  a_rmses = ra_rmses_lbl[iRefProf]

  # old
#  loss += a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]
  # new
  loss += factor_flx    * (a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]) +
          factor_flxcnv * (a_rmses[4]+a_rmses[5]) +
          factor_tend   * (a_rmses[6]+a_rmses[7])
end
line = 0.to_s+' '+(w_bandbnd.size-1).to_s+' '+loss.to_s+' '+0.to_s
for iRefProf in 0..(nRefProfs-1)
  a_rmses = ra_rmses_lbl[iRefProf]
  # old
#  loss = a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]
  # new
  loss = factor_flx    * (a_rmses[0]+a_rmses[1]+a_rmses[2]+a_rmses[3]) +
         factor_flxcnv * (a_rmses[4]+a_rmses[5]) +
         factor_tend   * (a_rmses[6]+a_rmses[7])

  line += ' '+loss.to_s
end
for j in 0..(8-1)
  loss = a_rmses[j]
  line += ' '+loss.to_s
end
file.puts line
file.close


# save results for reference profiles
for iRefProf in 0..(nRefProfs-1)
  dir_work = 'workdir-ref-'+iRefProf.to_s
#  com = 'mv ' + dir_work + ' ' + dir_work+'-'+iRefProf.to_s
  com = 'mv ' + dir_work+'/out' + ' ' + 'out.ref-'+iRefProf.to_s
  system( com )

  com = 'rm -rf ' + dir_work
  system( com )
end


# calculate k-dist. and flux and tendency in all each band separately
print 'calculate k-dist. and flux and tendency in all each band, separately', "\n"
a_dir_work_alleach = []
for iRefProf in 0..(nRefProfs-1)
  a_dir_work_alleach << 'workdir-alleachbands'+'-'+iRefProf.to_s
end
w_bandbnd_current = w_bandbnd
nbandbnd = w_bandbnd_current.size
#for iRefProf in 0..(nRefProfs-1)
Parallel.each(0..(nRefProfs-1)) do |iRefProf|
#    print '    reference profile #', iRefProf, "\n"
  if ( iRefProf == 0 ) then
    print '  reference profile #', iRefProf
  else
    print ',', iRefProf
  end
  if ( iRefProf == (nRefProfs-1) ) then
    print "\n"
  end

  # prepare working directory
  dir_work = a_dir_work_alleach[iRefProf]
  prep_dir( dir_work )

  # make configuration file, sort_ac.conf and sort_ac_file.conf
  cINPROFNCFN       = r_INPROFNCFNs[iRefProf]
  cINORGOPTPROPNCFN = r_INORGOPTPROPNCFNs[iRefProf]
  makeconf( w_bandbnd_current, 1, nbandbnd-1, nip, cINPROFNCFN, cINORGOPTPROPNCFN )

  # execute sort_ac
  com = './'+pro_path + ' >> error_pro_all.log'
  system( com )

  #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
  Dir.chdir('..')

end


nbandbnd_init = w_bandbnd.size
for iloop in 1..(nbandbnd_init-2)
  print '====================', "\n"
  print 'Outermost loop: ', iloop, "\n"
  print '  number of band        : ', w_bandbnd.size-1, "\n"
  print '  band boundaries (cm-1): ', w_bandbnd, "\n"

  nbandbnd = w_bandbnd.size

  a_dir_work = []
  for ibandbnd in 0..(nbandbnd-1)
    for iRefProf in 0..(nRefProfs-1)
      a_dir_work << 'workdir-'+ibandbnd.to_s.rjust(4,"0")+'-'+iRefProf.to_s
    end
  end

  # loop for trials with increased integration points in each band
#  for isubloop in 0..(nbandbnd*nRefProfs-1)
  Parallel.each(0..(nbandbnd*nRefProfs-1)) do |isubloop|
    ibandbnd = isubloop / nRefProfs
    iRefProf = isubloop.modulo(nRefProfs)

    if ( iRefProf == 0 ) then
      if ( ibandbnd == 0 ) then
        print '  Trial for band boundary: '
      else
        print ','
      end
      print ibandbnd
    end


    flag_calc = true
    for i in 0..(w_bandbnd_nonremove.size-1)
      if ( w_bandbnd[ibandbnd] == w_bandbnd_nonremove[i] ) then
        # If the boundary #ibandbnd is one that cannot be removed, calculation
        # will not be performed.
        flag_calc = false
      end
    end

    if ( flag_calc ) then

      # prepare number of band boundaries
      w_bandbnd_current = []
      for i in 0..(ibandbnd-1)
        w_bandbnd_current << w_bandbnd[i]
      end
      for i in (ibandbnd+1)..(nbandbnd-1)
        w_bandbnd_current << w_bandbnd[i]
      end

    end


    # prepare working directory
    dir_work = a_dir_work[isubloop]
    prep_dir( dir_work )

    if ( flag_calc ) then

      # make configuration file, sort_ac.conf and sort_ac_file.conf
      cINPROFNCFN       = r_INPROFNCFNs[iRefProf]
      cINORGOPTPROPNCFN = r_INORGOPTPROPNCFNs[iRefProf]
      makeconf( w_bandbnd_current, ibandbnd, ibandbnd, nip, cINPROFNCFN, cINORGOPTPROPNCFN )

      # execute sort_ac
      com = './'+pro_path + ' >> error_pro_all.log'
      system( com )

      # calculate flux and tendency by summing values in each band
      #   make a list of file for flux
      dir_work = '../'+a_dir_work_alleach[iRefProf]
      File.open(filelistname_flux, "w") do |f|
        for i in 1..(ibandbnd-1)
          f.puts dir_work+'/out/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
        i = ibandbnd
        f.puts 'out'+'/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
        for i in (ibandbnd+1+1)..(nbandbnd-1)
          f.puts dir_work+'/out/Flux-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
      end
      #   make a list of file for tendency
      dir_work = '../'+a_dir_work_alleach[iRefProf]
      File.open(filelistname_tend, "w") do |f|
        for i in 1..(ibandbnd-1)
          f.puts dir_work+'/out/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
        i = ibandbnd
        f.puts 'out'+'/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
        for i in (ibandbnd+1+1)..(nbandbnd-1)
          f.puts dir_work+'/out/Tendency-'+i.to_s.rjust(3,'0')+'-10.nc'
        end
      end
      #   flux and tendency summed over all each band are output to
      #   out/Flux-SUM-10.nc and out/Tendency-SUM-10.nc
      com = 'ruby sum_flux_tendency.rb'
      system( com )
      com = 'ln -s Flux-SUM-10.nc out/Flux-000-10.nc'
      system( com )
      com = 'ln -s Tendency-SUM-10.nc out/Tendency-000-10.nc'
      system( com )

      # calculate RMSEs
      com = 'cp -Rp ' + '../out.ref-'+iRefProf.to_s + ' out.ref'
      system( com )
      com = 'ruby '+script_rmse_path+' 2'+' 1> '+out_rmse_path+' 2> /dev/null'
      system( com )
      com = 'rm -rf out.ref'
      system( com )

      # calculate RMSEs with respect to LBL
      com = 'ln -s ../../out.ref-'+iRefProf.to_s+'/Flux-000-LBL.nc out'
      system( com )
      com = 'ln -s ../../out.ref-'+iRefProf.to_s+'/Tendency-000-LBL.nc out'
      system( com )
      com = 'ruby '+script_rmse_lbl_path+' 2'+' 1> '+out_rmse_lbl_path+' 2> /dev/null'
      system( com )

    end

    # output flag for calculation
    file = File.open('flag.txt', "w")
    file.puts( flag_calc.to_s )
    file.close

    #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
    Dir.chdir('..')

  end
  print "\n"
#  p ba_rmses


  print '  Checking RMSEs', "\n"
  wra_rmses     = Array.new(nbandbnd) { Array.new(nRefProfs) { Array.new(8,0.0) } }
  wra_rmses_lbl = Array.new(nbandbnd) { Array.new(nRefProfs) { Array.new(8,0.0) } }
#  for ibandbnd in 0..(nbandbnd-1)
#    r_dir_work = wr_dir_work[ibandbnd]
  for isubloop in 0..(nbandbnd*nRefProfs-1)
    ibandbnd = isubloop / nRefProfs
    iRefProf = isubloop.modulo(nRefProfs)
    dir_work = a_dir_work[isubloop]
    Dir.chdir(dir_work)

    flag_calc = true
    file = File.open('flag.txt', "r")
    flag_calc = file.read
    file.close
    flag_calc.chomp!
    if ( flag_calc == 'true' ) then
      flag_calc = true
    else
      flag_calc = false
    end

    if ( flag_calc ) then

      # read RMSEs
      a_rmses = read_RMSEs( out_rmse_path )
      for i in 0..(a_rmses.size-1)
        wra_rmses[ibandbnd][iRefProf][i] = a_rmses[i]
      end

      # read RMSEs with respect to LBL
      a_rmses = read_RMSEs( out_rmse_lbl_path )
      for i in 0..(a_rmses.size-1)
        wra_rmses_lbl[ibandbnd][iRefProf][i] = a_rmses[i]
      end

    else

      for i in 0..(wra_rmses[0][0].size-1)
        wra_rmses    [ibandbnd][iRefProf][i] = 1.0e10
        wra_rmses_lbl[ibandbnd][iRefProf][i] = 1.0e10
      end

    end

    #   go back to the parent directory
#    print 'exiting '+dir_work+"\n"
    Dir.chdir('..')

  end



  # check minimum RMSEs
  w_rmses = []
  for ibandbnd in 0..(nbandbnd-1)
    loss = 0.0
    for iRefProf in 0..(nRefProfs-1)
      #       PR.upflx
      loss += wra_rmses[ibandbnd][iRefProf][0]*factor_flx+
      #      +SR.upflx
              wra_rmses[ibandbnd][iRefProf][1]*factor_flx+
      #      +PR.dnflx
              wra_rmses[ibandbnd][iRefProf][2]*factor_flx+
      #      +SR.dnflx
              wra_rmses[ibandbnd][iRefProf][3]*factor_flx+
      #      +PR.flxcnv
              wra_rmses[ibandbnd][iRefProf][4]*factor_flxcnv+
      #      +SR.flxcnv
              wra_rmses[ibandbnd][iRefProf][5]*factor_flxcnv+
      #      +PR.tend
              wra_rmses[ibandbnd][iRefProf][6]*factor_tend+
      #      +SR.tend
              wra_rmses[ibandbnd][iRefProf][7]*factor_tend
    end
    w_rmses << loss
  end
  i_min = w_rmses.index(w_rmses.min)
  print '  Delete band boundary at '+w_bandbnd[i_min].to_s+' cm-1 (RMSE sum=', w_rmses.min, ')'+"\n"
  # delete band boundary #i_min
  w_bandbnd_bk = []
  for i in 0..(nbandbnd-1)
    w_bandbnd_bk << w_bandbnd[i]
  end
  w_bandbnd = []
  for i in 0..(i_min-1)
    w_bandbnd << w_bandbnd_bk[i]
  end
  for i in (i_min+1)..(nbandbnd-1)
    w_bandbnd << w_bandbnd_bk[i]
  end
  nbandbnd = w_bandbnd.size
  # check condition
  if ( w_bandbnd.size <= w_bandbnd_nonremove.size ) then
    print 'All remained band boundary are required, ', w_bandbnd, '.'+"\n"
    break
  end


  # delete files in workdir-alleachbands-N for flux and tendency in the band
  # which will be combined
  for iRefProf in 0..(nRefProfs-1)
    dir_work=a_dir_work_alleach[iRefProf]+'/out/'
    com = 'rm'+
          ' '+dir_work+'Flux-'    +(i_min  ).to_s.rjust(3,'0')+'-10.nc' +
          ' '+dir_work+'Flux-'    +(i_min  ).to_s.rjust(3,'0')+'-LBL.nc'+
          ' '+dir_work+'Flux-'    +(i_min+1).to_s.rjust(3,'0')+'-10.nc' +
          ' '+dir_work+'Flux-'    +(i_min+1).to_s.rjust(3,'0')+'-LBL.nc'+
          ' '+dir_work+'Tendency-'+(i_min  ).to_s.rjust(3,'0')+'-10.nc' +
          ' '+dir_work+'Tendency-'+(i_min  ).to_s.rjust(3,'0')+'-LBL.nc'+
          ' '+dir_work+'Tendency-'+(i_min+1).to_s.rjust(3,'0')+'-10.nc' +
          ' '+dir_work+'Tendency-'+(i_min+1).to_s.rjust(3,'0')+'-LBL.nc'
    system( com )
    dir_work_alleach=a_dir_work_alleach[iRefProf]+'/out/'
    dir_work        =a_dir_work[i_min*nRefProfs+iRefProf]+'/out/'
    com = 'cp -Rp'+
          ' '+dir_work+'Flux-'    +(i_min  ).to_s.rjust(3,'0')+'-10.nc' +
          ' '+dir_work+'Flux-'    +(i_min  ).to_s.rjust(3,'0')+'-LBL.nc'+
          ' '+dir_work+'Tendency-'+(i_min  ).to_s.rjust(3,'0')+'-10.nc' +
          ' '+dir_work+'Tendency-'+(i_min  ).to_s.rjust(3,'0')+'-LBL.nc'+
          ' '+dir_work_alleach
    system( com )
    dir_work=a_dir_work_alleach[iRefProf]+'/out/'
    for i in (i_min+1)..(nbandbnd-1)
      targetfile=dir_work+'Flux-'    +(i  ).to_s.rjust(3,'0')+'-10.nc'
      if ( File.exist?(targetfile) ) then
        print 'ERROR: '+targetfile+' exists, unexpectedly.', "\n"
        exit
      end
      targetfile=dir_work+'Flux-'    +(i  ).to_s.rjust(3,'0')+'-LBL.nc'
      if ( File.exist?(targetfile) ) then
        print 'ERROR: '+targetfile+' exists, unexpectedly.', "\n"
        exit
      end
      targetfile=dir_work+'Tendency-'+(i  ).to_s.rjust(3,'0')+'-10.nc'
      if ( File.exist?(targetfile) ) then
        print 'ERROR: '+targetfile+' exists, unexpectedly.', "\n"
        exit
      end
      targetfile=dir_work+'Tendency-'+(i  ).to_s.rjust(3,'0')+'-LBL.nc'
      if ( File.exist?(targetfile) ) then
        print 'ERROR: '+targetfile+' exists, unexpectedly.', "\n"
        exit
      end
      com = 'mv'+
            ' '+dir_work+'Flux-'    +(i+1).to_s.rjust(3,'0')+'-10.nc' +
            ' '+dir_work+'Flux-'    +(i  ).to_s.rjust(3,'0')+'-10.nc'
      system( com )
      com = 'mv'+
            ' '+dir_work+'Flux-'    +(i+1).to_s.rjust(3,'0')+'-LBL.nc'+
            ' '+dir_work+'Flux-'    +(i  ).to_s.rjust(3,'0')+'-LBL.nc'
      system( com )
      com = 'mv'+
            ' '+dir_work+'Tendency-'+(i+1).to_s.rjust(3,'0')+'-10.nc' +
            ' '+dir_work+'Tendency-'+(i  ).to_s.rjust(3,'0')+'-10.nc'
      system( com )
      com = 'mv'+
            ' '+dir_work+'Tendency-'+(i+1).to_s.rjust(3,'0')+'-LBL.nc'+
            ' '+dir_work+'Tendency-'+(i  ).to_s.rjust(3,'0')+'-LBL.nc'
      system( com )
    end
  end


  a_dir_work.each{ |dir_work|
#      print 'deleting working directory, '+dir_work+"\n"
    com = 'rm -rf '+dir_work
    system( com )
  }


  # output to file
  line = ''
  file = File.open(bandstruct_path, 'a')
  line = 'Number of bands : '+ (w_bandbnd.size-1).to_s
  file.puts line
  line = '  Band boundaries : '+ w_bandbnd.to_s
  file.puts line
#  for ibandbnd in 0..(nbandbnd-1)
#    line = iloop.to_s+' '+w_bandbnd[ibandbnd].to_s
#    file.puts line
#  end
  line = ''
  file.puts line
  file.close
  #
  file = File.open(loss_path, 'a')
  line = iloop.to_s+' '+(w_bandbnd.size-1).to_s+' '+w_rmses.min.to_s+' '+w_bandbnd_bk[i_min].to_s
  for iRefProf in 0..(nRefProfs-1)
    loss = wra_rmses[i_min][iRefProf][0]*factor_flx+
           wra_rmses[i_min][iRefProf][1]*factor_flx+
           wra_rmses[i_min][iRefProf][2]*factor_flx+
           wra_rmses[i_min][iRefProf][3]*factor_flx+
           wra_rmses[i_min][iRefProf][4]*factor_flxcnv+
           wra_rmses[i_min][iRefProf][5]*factor_flxcnv+
           wra_rmses[i_min][iRefProf][6]*factor_tend+
           wra_rmses[i_min][iRefProf][7]*factor_tend
    line += ' '+loss.to_s
  end
  for j in 0..(8-1)
    loss = 0.0
    for iRefProf in 0..(nRefProfs-1)
      loss += wra_rmses[i_min][iRefProf][j]
    end
    loss /= nRefProfs
    line += ' '+loss.to_s
  end
  file.puts line
  file.close


  file = File.open(loss_lbl_path, 'a')
  loss = 0.0
  for iRefProf in 0..(nRefProfs-1)
    loss += wra_rmses_lbl[i_min][iRefProf][0]*factor_flx+
            wra_rmses_lbl[i_min][iRefProf][1]*factor_flx+
            wra_rmses_lbl[i_min][iRefProf][2]*factor_flx+
            wra_rmses_lbl[i_min][iRefProf][3]*factor_flx+
            wra_rmses_lbl[i_min][iRefProf][4]*factor_flxcnv+
            wra_rmses_lbl[i_min][iRefProf][5]*factor_flxcnv+
            wra_rmses_lbl[i_min][iRefProf][6]*factor_tend+
            wra_rmses_lbl[i_min][iRefProf][7]*factor_tend
  end
  line = iloop.to_s+' '+(w_bandbnd.size-1).to_s+' '+loss.to_s+' '+w_bandbnd_bk[i_min].to_s
  for iRefProf in 0..(nRefProfs-1)
    loss = wra_rmses_lbl[i_min][iRefProf][0]*factor_flx+
           wra_rmses_lbl[i_min][iRefProf][1]*factor_flx+
           wra_rmses_lbl[i_min][iRefProf][2]*factor_flx+
           wra_rmses_lbl[i_min][iRefProf][3]*factor_flx+
           wra_rmses_lbl[i_min][iRefProf][4]*factor_flxcnv+
           wra_rmses_lbl[i_min][iRefProf][5]*factor_flxcnv+
           wra_rmses_lbl[i_min][iRefProf][6]*factor_tend+
           wra_rmses_lbl[i_min][iRefProf][7]*factor_tend
    line += ' '+loss.to_s
  end
  for j in 0..(8-1)
    loss = 0.0
    for iRefProf in 0..(nRefProfs-1)
      loss += wra_rmses_lbl[i_min][iRefProf][j]
    end
    loss /= nRefProfs
    line += ' '+loss.to_s
  end
  file.puts line
  file.close

end


a_dir_work.each{ |dir_work|
#  print 'deleting working directory, '+dir_work+"\n"
  com = 'rm -rf '+dir_work
  system( com )
}
a_dir_work_alleach.each{ |dir_work|
#  print 'deleting working directory, '+dir_work_alleach+"\n"
  com = 'rm -rf '+dir_work
  system( com )
}

print 'Finish', "\n"
