set term qt
#set term pdf
#set output 'fig_optband_v3-loss.pdf'

nprof   = 2
nvar    = 8
ntotvar = nprof * nvar

set key left Left reverse

set autoscale
set logscale y

set xlabel  "number of bands"
#set ylabel  "RMSEs with respect to k-dist. model"
#set ylabel  "loss function (x 0.1)"
set ylabel  "loss function"
set y2label ""
set xtics autofreq
set ytics autofreq
set ytics mirror

plot \
     "out/loss.txt"u 2:($3/ntotvar) t "" w lp

#pause -1
#
#set autoscale
#unset logscale y
#
#set xlabel  "number of bands"
##set ylabel  "RMSEs with respect to LBL model"
#set ylabel  "loss function, but with respect to LBL model (x 0.1)"
#set y2label ""
#set ytics mirror
#
#plot \
#     "out/loss_lbl.txt"u 2:($3/ntotvar) t "" w lp


pause -1

set multiplot

unset logscale y

set xlabel  "number of bands"
#set ylabel  "RMSEs with respect to LBL model"
#set ylabel  "loss function, but with respect to LBL model (x 0.1)"
set ylabel  "loss function, but with respect to LBL model"
set y2label ""
set ytics mirror

plot \
     "out/loss_lbl.txt"u 2:($3/ntotvar) t "" w lp

set origin 0.25, 0.25
set size 0.7, 0.7
set xrange [0:40]
set yrange [0:1]

set ytics 0, 0.05, 1
set xlabel  ""
set ylabel  ""

set grid

plot \
     "out/loss_lbl.txt"u 2:($3/ntotvar) t "" w lp

unset grid
set origin 0.0, 0.0
set size 1.0, 1.0
unset multiplot

set term qt
