#
# dcpam Development History in RD (Ruby Document) format
#
#   For instruction of installing dcpam, 
#   see "HISTORY.htm.en" (written in English) or 
#   "HISTORY.htm" (written in Japanese)
#   included in "dcpam" tar.gz package
#   available from http://www.gfd-dennou.org/library/dcpam. 
#   Otherwise, see this file directly, or generate 
#   above mentioned html files with "make doc-HISTORY" 
#   in current directory after installing  rdtool 
#   <http://raa.ruby-lang.org/project/rdtool/>.

=begin TOPLINK
[((<English|URL:HISTORY.htm.en>)) |
((<Japanese|URL:HISTORY.htm>))]
[((<GFD Dennou Club|URL:http://www.gfd-dennou.org>)) |
((<DCPAM Project|URL:http://www.gfd-dennou.org/library/dcpam>))]
=end TOPLINK

=begin JA

= dcpam 開発履歴
#* 森川 靖大 (morikawa), 石渡 正樹 (momoko)
#  * $Id: HISTORY,v 1.50 2015/02/17 23:54:08 yot Exp $
=end JA
=begin EN
= dcpam Development History
#* Yasuhiro MORIKAWA (morikawa), Masaki ISHIWARARI (momoko)
#  * $Id: HISTORY,v 1.50 2015/02/17 23:54:08 yot Exp $
=end EN

#=begin HTML
#  <hr />
#=end HTML

#=begin
#== 200?/??/?? (Tag: dcpam5-????????)
#=end
#
#=begin JA
#=end JA
#=begin EN
#=end EN

=begin
== 2018/03/04
=end

=begin JA
* debian 用コンパイルスクリプトの変更
* ドキュメントの更新
=end JA
=begin EN
* A compile script for debian is changed.
* Some documents are updated.
=end EN

=begin
== 2017/03/06
=end

=begin JA
* debian 用コンパイルスクリプトの変更
=end JA
=begin EN
* A compile script for debian is changed. 
=end EN

=begin
== 2017/03/05
=end

=begin JA
* 不要な変数の削除
* など
=end JA
=begin EN
* unused variables are deleted
* etc.
=end EN

=begin
== 2016/10/21
=end

=begin JA
* 文書更新
* 出力変数の説明の修正
* など
=end JA
=begin EN
* update document
* correct descriptions of some output variables
* etc.
=end EN

=begin
== 2016/06/12
=end

=begin JA
* 文書更新
* サンプル設定ファイルのデフォルト値の変更
* など
=end JA
=begin EN
* update document
* change default values in sample configuration files
* etc.
=end EN

=begin
== 2016/05/17
=end

=begin JA
* 文書更新
* src/phy_implicit/phy_implicit_sdh_V5.f90 内のフラッグの値の変更
=end JA
=begin EN
* update document
* change a default value of flag in src/phy_implicit/phy_implicit_sdh_V5.f90
=end EN

=begin
== 2016/05/11
=end

=begin JA
* チュートリアル用 conf ファイルの更新
* 若干のバグフィックス
* 氷モデルの導入
=end JA
=begin EN
* update configuration files for tutorial
* some bug fixes
* ice model is implemented
=end EN

=begin
== 2016/02/17
=end

=begin JA
* 若干のバグフィックス
* 若干の更新
=end JA
=begin EN
* some bug fixes
* some updates
=end EN

=begin
== 2015/08/04
=end

=begin JA
* 若干のバグフィックス
* 若干の更新
=end JA
=begin EN
* some bug fixes
* some updates
=end EN

=begin
== 2015/07/27
=end

=begin JA
* dcpam_main.f90 内の些細なバグフィックス
* 若干のドキュメントの更新
=end JA
=begin EN
* Bug fix in a dcpam_main.f90
* Update some documents
=end EN

=begin
== 2015/07/26
=end

=begin JA
* たくさんの更新
=end JA
=begin EN
* a lot of updates
=end EN

=begin
== 2015/02/17
=end

=begin JA
* いくつか更新
=end JA
=begin EN
* some updates
=end EN

=begin
== 2015/02/13
=end

=begin JA
* 色々更新
=end JA
=begin EN
* a lot of updates
=end EN

=begin
== 2015/02/06
=end

=begin JA
* 色々更新
=end JA
=begin EN
* a lot of updates
=end EN

=begin
== 2015/01/29
=end

=begin JA
* 色々更新
=end JA
=begin EN
* a lot of updates
=end EN

=begin
== 2014/06/30
=end

=begin JA
* 色々更新
=end JA
=begin EN
* a lot of updates
=end EN

=begin
== 2014/05/07
=end

=begin JA
* 倍精度リテラルに_DPを使うようにした
* 単精度定数の代わりに倍精度定数を使うようにした。
=end JA
=begin EN
* use _DP for double precision literal
* use double precision constants instead of single precision constants.
=end EN


=begin
== 2014/03/14 (Tag: dcpam5-20140314)
=end

=begin JA
* 文書の更新
=end JA
=begin EN
* Document update
=end EN


=begin
== 2014/02/18 (Tag: dcpam5-20140218)
=end

=begin JA
* マイナーアップデート
=end JA
=begin EN
* Minor updates
=end EN


=begin
== 2014/02/04 (Tag: dcpam5-20140204)
=end

=begin JA
* いくつかのバグフィックス
* 今後に向けたコード導入
=end JA
=begin EN
* Bug fix
* Add some codes for future extention
=end EN


=begin
== 2013/10/07 (Tag: dcpam5-20131007)
=end

=begin JA
* 様々な更新
=end JA
=begin EN
* Various updates
=end EN


=begin
== 2013/09/21 (Tag: dcpam5-20130921)
=end

=begin JA
* 様々な更新
=end JA
=begin EN
* Various updates
=end EN


=begin
== 2013/03/02 (Tag: dcpam5-20130302)
=end

=begin JA
* バグフィックス
* 誤植修正
=end JA
=begin EN
* Bug fix
* Typo fix
=end EN


=begin
== 2013/02/19 (Tag: dcpam5-20130219)
=end

=begin JA
* セミラグランジュ法による物質移流計算法の導入
* 乱流拡散, 惑星表面熱収支, 土壌熱伝導方程式による連立方程式の解法のテスト
* バグフィックス
=end JA
=begin EN
* Introduction of semi-Lagrange tracer transport calculation
* Test implementation of solver for simultaneous linear equations composed of turbulent mixing, surface thermal budget, and soil thermal conduction equations
* Bug fix
=end EN


=begin
== 2012/11/29 (Tag: dcpam5-20121129)
=end

=begin JA
* ドキュメントの誤植の訂正
* いくつかのルーチンのテスト実装 (コメントアウトされているため使われない)
=end JA
=begin EN
* Fix typos
* Test implementation of several routines (those are commented out, now)
=end EN


=begin
== 2012/11/10 (Tag: dcpam5-20121110)
=end

=begin JA
* 雲モデル計算方法の更新.
* 新しい雲モデルのテスト.
* 時間フィルタの更新.
=end JA
=begin EN
* Update calculation method of cloud model.
* Create test version of a new cloud model.
* Update time filter.
=end EN


=begin
== 2012/10/08 (Tag: dcpam5-20121008)
=end

=begin JA
* 主に文書の更新. 
=end JA
=begin EN
* Update documents mainly.
=end EN


=begin
== 2012/09/22 (Tag: dcpam5-20120922)
=end

=begin JA
* ダストに関わる出力におけるバグ修正.
=end JA
=begin EN
* A bug for output of adust-related variable is fixed.
=end EN


=begin
== 2012/09/21 (Tag: dcpam5-20120921)
=end

=begin JA
* 重要な更新.
=end JA
=begin EN
* Significant updates.
=end EN


=begin
== 2012/03/01 (Tag: dcpam5-20120726)
=end

=begin JA
* いくつかの更新.
=end JA
=begin EN
* Several updates.
=end EN


=begin
== 2012/03/01 (Tag: dcpam5-20120301)
=end

=begin JA
* 誤植訂正.
=end JA
=begin EN
* Typos are fixed.
=end EN


=begin
== 2012/02/29 (Tag: dcpam5-20120229)
=end

=begin JA
* 誤植訂正.
=end JA
=begin EN
* Typos are fixed.
=end EN


=begin
== 2012/02/26 (Tag: dcpam5-20120226)
=end

=begin JA
* 様々な改良.
=end JA
=begin EN
* Notable improvements
=end EN


=begin
== 2010/10/08 (Tag: dcpam5-20101008)
=end

=begin JA
* 様々な改良.
=end JA
=begin EN
* Notable improvements
=end EN


=begin
== 2009/04/05 (Tag: dcpam5-20090405)
=end

=begin JA
* ((<README|URL:README>)) の作成. 
* src ディレクトリ以下の構造に関して記した文書
  ((<"src/SRC_LIST"|URL:src/SRC_LIST>)) を作成. 
* トップディレクトリの整理. 
  * スクリプトや Makefile のいくつかをサブディレクトリに移動. 
* dcpam5 の保守管理に関するいくつかの文書の作成. 
=end JA
=begin EN
* ((<README|URL:README>)) is created. 
* "((<"src/SRC_LIST"|URL:src/SRC_LIST>))" that is a document 
  about directory structure under "src" is created. 
* Top directory is arranged. 
  * Some scripts and Makefiles are moved to subdirectories. 
* Some documents for maintenance of dcpam5 are created. 
=end EN


=begin
== 2009/03/19 (Tag: dcpam5-20090319)
=end

=begin JA
* ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
  の改善.
  * リスタートファイルを入出力する機能を追加.
* MPI ライブラリの参照の方法を "include mpif.h" から
  "use mpi" へ入れ替え. 
* ((<ground_file_io|URL:doc/code_reference/htm/classes/ground_file_io.html>))
  の改善.  
  * 並列データ入出力に対応.
=end JA
=begin EN
* ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
  is improved. 
  * Input/Output of a restart file is available. 
* A method of refering to a MPI library is changed from
  "include mpif.h" to "use mpi". 
* ((<ground_file_io|URL:doc/code_reference/htm/classes/ground_file_io.html>))
  is improved. 
  * Parallel data I/O is supported. 
=end EN


=begin
== 2009/03/17 (Tag: dcpam5-20090317)
=end

=begin JA
* リスタートが正しく行われない問題の修正. 
* プログラム終了時に, ALLOCATE 関数によってメモリ割り付けが行われた
  変数の割り付け解除を行うよう修正. 
* ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  の修正. 
  * PhyImplTendency に, 地表面だけでなく全体の放射フラックスを与えるよう
    インターフェースを変更.
  * 速度, 温度, 比湿に関する陰解法行列計算コードの一部を整理.
* ((<auxiliary|URL:doc/code_reference/htm/classes/auxiliary.html>))
  の改良. 
  * エクスナー関数をサブルーチン AuxVars で計算.
  * サブルーチン AuxVars から返る引数に OPTIONAL 属性を付加. 
=end JA
=begin EN
* A problem that restart is not performed correctly is fixed. 
* Variables that are allocated with ALLOCATE function
  are deallocated when the program is finished. 
* ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  is modified. 
  * Arguments of "PhyImplTendency" is changed.
    "PhyImplTendency" receives not 
    radiation fluxes on surface but whole radiation fluxes. 
  * A part of codes for calculation of implicit matrices of
    velocity, temperature, specific humidity is arranged. 
* ((<auxiliary|URL:doc/code_reference/htm/classes/auxiliary.html>))
  is modified. 
  * Exner function is calculated in a subroutine "AuxVars". 
  * OPTIONAL attribute is added to arguments
    that return from a subroutine "AuxVars". 
=end EN


=begin
== 2009/03/06 (Tag: dcpam5-20090306)
=end

=begin JA
* ((<らくらく dcpam5|URL:doc/tutorial/rakuraku/index.htm>)) に加筆修正. 
* 初期値データの構成を変更.
* 力学過程
  ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>))
  中のいくつかの変数の名称を変更.
* 水惑星実験と Held and Suarez (1994) ベンチマークテストの切り替え方法を変更.
* サンプルとして用意している NAMELIST ファイル中の項目の整理.
=end JA
=begin EN
* ((<RakuRaku dcpam5|URL:doc/tutorial/rakuraku/index.htm.en>)) is improved. 
* Components of initial data is changed. 
* Names of some variables
  in a dynamical process
  ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>))
  are changed.
* A way of switching from APE to Held and Suarez (1994) benchmark test
  is changed. 
* Items in prepared sample NAMELIST files are arranged. 
=end EN


=begin
== 2009/02/25 (Tag: dcpam5-20090225-2)
=end
=begin JA
* 力学過程
  ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>))
  のソースコードと, 
  ((<支配方程式系とその離散化|URL:doc/basic_equations/htm/basic_equations.htm>))
  ドキュメントとの対応付けをよりよくすべく改善. 
* ((<コード解説|URL:doc/code_description/htm/code_description.htm>))
  の作成.
=end JA
=begin EN
* Modification for correspondence between 
  source codes of a dynamical process
  ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>)) and 
  ((<"The governing equations and basic_equations (JAPANESE only)"|URL:doc/basic_equations/htm/basic_equations.htm>)). 
* ((<"Code Descriptions (JAPANESE only)"|URL:doc/code_description/htm/code_description.htm>)) is created. 

=end EN



=begin
== 2009/02/18 (Tag: dcpam5-20090218-1)
=end

=begin JA
* 鉛直拡散フラックス, 地表面フラックス, 放射フラックスの出力に
  関連するコードの整理. 
* 物理過程に関する陰解法のための行列を
  ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  内に隠蔽. 
* 放射フラックスの計算間隔に関する処理の誤りを修正.
* プログラムの終了時に必ずリスタートファイルを出力. 
* 温度の半整数σレベルの補間, 気圧と高度の算出を行うための
  サブルーチンを提供するモジュール intpol_half を
  ((<auxiliary|URL:doc/code_reference/htm/classes/auxiliary.html>))
  へ改名.
* 開発用ユーティリティの改善. 
  * Makefile 関連. 
    * ソースファイルのコンパイル時に depend を自動更新.
    * make clean の際の無駄なエラーメッセージの排除.
    * Config.mk から変数 DCPAMDIR を削除し, configure 実行後に
      作業ディレクトリを容易に変更可能に. 
=end JA
=begin EN
* Codes for output of vertical diffusion fluxes,
  surface fluxes, radiation fluxes are modified. 
* Matrices for implicit scheme of physical processes
  are capsuled in 
  ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  module. 
* An error about handlings of interval of calculation of radiation fluxes
  is modified. 
* Restart data is output when a calculation is finished. 
* A module "intpol_half" that provides subroutines for
  interpolation of temperature on half sigma level, and
  calculation pressure and height is renamed to
  ((<auxiliary|URL:doc/code_reference/htm/classes/auxiliary.html>)).
* Utilities for development are improved.
  * Makefile etc.
    * "depend" is updated automatically when source files are compiled. 
    * Irrelevant error messages when "make clean" are rejected.
    * A variable "DCPAMDIR" is removed in "Config.mk", and
      a working directory can be moved easily. 
=end EN


=begin
== 2009/01/26 (Tag: dcpam5-20090126)
=end

=begin JA
* 全体的な修正
  * dcpam_ape.F90 と dcpam_hs94.F90 を
    ((<dcpam_main.F90|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>))
    に統合. (選択に関しては((<らくらく dcpam5|URL:doc/tutorial/rakuraku/index.htm>)) を参照のこと. )
  * 地表面温度固定の設定 (例えば SST fix での水惑星実験) 
    において地表面温度が固定されていなかったバグを修正. 
  * 「(ジオポテンシャル) 高度」を誤って「ジオポテンシャル」と記述されていた
    部分を修正. 変数名も GeoPot から Height に修正.
  * 地形データを
    ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>)) からではなく,
    ((<ground_file_io|URL:doc/code_reference/htm/classes/ground_file_io.html>))
    から読み込み, 各過程で共有する. 
  * OLR, OSR, SLR, SSR は主プログラムではなく, 
    ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
    モジュール内で出力する.

* ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>)) の修正
  * 「平均温度」と誤って表記されていた部分を「基準温度」に修正.
    変数名も TempAvrXY から RefTemp へ変更.
  * 基準温度を NAMELIST として読み込むよう修正.

* ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  の修正
  * 本来フラックスの出力ためのサブルーチン PhyImplFluxCorrect の名称を
    PhyImplFluxOutput に変更. 
  * フラックスをこのモジュール内で出力.
  * t-Δt における変化率から t+Δt の長波フラックスを算出する
    サブルーチン RadiationCorrect を
    ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
    モジュールから phy_implicit モジュールへ移動し,
    PhyImplEvalRadLFluxA へ改名.
  * 長波フラックスの補正スキームを
    ((<intg_surftemp|URL:doc/code_reference/htm/classes/intg_surftemp.html>))
    モジュールの IntegralSurfTemp サブルーチンから
    phy_implicit モジュールの PhyImplFluxOutput サブルーチンへ移動.
    * 補正された長波フラックスを PhyImplFluxOutput サブルーチン内で出力.

* ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
  の修正
  * t-Δt における変化率から t+Δt の長波フラックスを算出する
    サブルーチン RadiationCorrect を radiation_band モジュールから
    ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
    モジュールへ移動し, PhyImplEvalRadLFluxA へ改名.
    
=end JA
=begin EN
* General modification
  * "dcpam_ape.F90" and "dcpam_hs94.F90" are integrated to 
    ((<dcpam_main.F90|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>)).
    (See ((<RakuRaku dcpam5|URL:doc/tutorial/rakuraku/index.htm.en>))
    for selection)
  * A bug that surface temperature is not fixed with 
    surface temperature fix settings 
    (for example, aqua planet experiments with SST fix) is fixed. 
  * Errors that "(geo-potential) height" is described "get-potential" wrongly 
    are fixed. Variable names are modified from "GetPot" to "Height".
  * Geography data is loaded from not 
    ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>)), but 
    ((<ground_file_io|URL:doc/code_reference/htm/classes/ground_file_io.html>)), 
    and the data is shared with each process. 
  * "OLR", "OSR", "SLR", "SSR" are output in
    ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
    module. 

* ((<dynamics_hspl_vas83|URL:doc/code_reference/htm/classes/dynamics_hspl_vas83.html>)) is modified. 
  * Erroneous notations "average temperature" are modified to 
    "reference temperature". Variable names are modified from
    "TempAvrXY" to "RefTemp".
  * Reference temperature can be loaded from NAMELIST. 

* ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  is modified. 
  * A name of subroutine "PhyImplFluxCorrect" that is worked for
    output of fluxes in nature is changed to "PhyImplFluxOutput".
  * Fluxes are output in this module. 
  * A subroutine "RadiationCorrect" that calculates radiation flux at
    t+Dt from the tendency at t-Dt is moved from
    ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
    module to "phy_implicit" module and renamed to "PhyImplEvalRadLFluxA".
  * Scheme of correction of longwave flux is moved from 
    subroutine "IntegralSurfTemp" in module
    ((<intg_surftemp|URL:doc/code_reference/htm/classes/intg_surftemp.html>))
    to subroutine "PhyImplFluxOutput" in module "phy_implicit". 
    * Corrected longwave flux is output in subroutine "PhyImplFluxOutput". 

* ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
  is modified. 
  * A subroutine "RadiationCorrect" that calculates radiation flux at
    t+Dt from the tendency at t-Dt is moved from "radiation_band" module to
    ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
    module and renamed to "PhyImplEvalRadLFluxA".
    
=end EN


=begin
== 2008/11/29 (Tag: dcpam5-20081129)
=end

=begin JA
* ((<dcpam_main|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>))
  の修正. 
  * OLR, SSR などのヒストリ出力を可能に. 
* ((<らくらく dcpam5|URL:doc/tutorial/rakuraku/index.htm>))
  に「可視化」, 「設定の参照」, 「設定の変更」等を追記.
* Tetens (1930) の飽和比湿算出コードを追加. 
=end JA
=begin EN
* ((<dcpam_main|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>))
  is modified. 
  * Some history output variables (OLR, SSR, etc.) are added. 
* Some contents ("Visualization", "Refer configuration",
  "Change configuration", etc.) are added to
  ((<RakuRaku dcpam5|URL:doc/tutorial/rakuraku/index.htm.en>))
* Codes of calculation of saturation specific humidity
  in Tetens (1930) are added. 
=end EN


=begin
== 2008/11/18 (Tag: dcpam5-20081118)
=end

=begin JA
* ビルドの際に
  ((<sst_data|URL:doc/code_reference/htm/files/main/sst_data_F90.html>))
  のバイナリが作成されない問題を修正. 
* ((<dcpam_main|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>)), 
  ((<cumulus_adjust|URL:doc/code_reference/htm/classes/cumulus_adjust.html>)), 
  ((<lscond|URL:doc/code_reference/htm/classes/lscond.html>)) の変更. 
  * 積雲パラメタリゼーションスキーム, 大規模凝結スキーム
    の降水の合計値を主プログラムから出力するよう変更. 
  * 出力されるヒストリデータとして OLR などを追加. 
* 短波入射を
  ((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))
  とは別のモジュール
  ((<radation_short_income|URL:doc/code_reference/htm/classes/radation_short_income.html>))
  としてパッケージ. 
=end JA
=begin EN
* A problem that a binary file of 
  ((<sst_data|URL:doc/code_reference/htm/files/main/sst_data_F90.html>))
  is not created by "make" is fixed. 
* ((<dcpam_main|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>)), 
  ((<cumulus_adjust|URL:doc/code_reference/htm/classes/cumulus_adjust.html>)), 
  ((<lscond|URL:doc/code_reference/htm/classes/lscond.html>)) are changed. 
  * Summation of rain of cumulus parameterization scheme and 
    rain of large scale condensation scheme are output from
    a main program. 
  * Some history data like as "OLR", etc. can be output additionally. 
* Short wave incoming is separated from
  "((<radiation_band|URL:doc/code_reference/htm/classes/radiation_band.html>))"
  and packaged as
  "((<radation_short_income|URL:doc/code_reference/htm/classes/radation_short_income.html>))". 
=end EN


=begin
== 2008/11/09 (Tag: dcpam5-20081109-1)
=end

=begin JA
* ((<dcpam_main|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>))
  の修正. 
  * 地表面温度を変化できるよう修正.
  * ((<intg_surftemp|URL:doc/code_reference/htm/classes/intg_surftemp.html>))
    を AGCM5 から移植. 
* 地表面温度リスタートデータの入出力機構を追加. 
* 初期値データ生成用メインプログラムと NAMELIST ファイルの作成.
* 地表面データ生成用メインプログラムと NAMELIST ファイルの作成.
* 物理過程の陰解法に関連するフラックス補正サブルーチンを
  AGCM5 から PhyImplFluxCorrect として
  ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  へ移植.
* ((<negative_moist|URL:doc/code_reference/htm/classes/negative_moist.html>))
  の修正. 
  * 負の水蒸気が除去しきれない場合についてエラーを返す.
=end JA
=begin EN
* ((<dcpam_main|URL:doc/code_reference/htm/files/main/dcpam_main_F90.html>))
  is modified. 
  * Surface temperature can be changed. 
  * ((<intg_surftemp|URL:doc/code_reference/htm/classes/intg_surftemp.html>))
    is imported from AGCM5. 
* A mechanism of input/output of restart data of surface temperature
  is added. 
* A main program and a NAMELIST file for generation of
  initial data is created. 
* A main program and a NAMELIST file for generation of
  surface data is created. 
* A subroutine corrects fluxes for implicit scheme of physical processes
  in AGCM5 are imported to 
  ((<phy_implicit|URL:doc/code_reference/htm/classes/phy_implicit.html>))
  as a subroutine "PhyImplFluxCorrect". 
* ((<negative_moist|URL:doc/code_reference/htm/classes/negative_moist.html>))
  is modified. 
  * Error is returned when negative moist can not be removed. 
=end EN


=begin
== 2008/10/08 (Tag: dcpam5-20081008)
=end

=begin JA
* 計算開始日時をデータに出力可能にする. 
* 時間の制御は「ステップ数」ではなく時刻型 (gtool5 ライブラリの 
  DC_DIFFTIME, DC_DATETIME 型) の変数で行う. 
=end JA
=begin EN
* Date of start of calculation can be output to data. 
* Time is controlled by not number of step but variables of time types 
  ("DC_DIFFTIME" or "DC_DATETIME" in gtool5 library).  
=end EN


=begin
== 2008/09/25 (Tag: dcpam5-20080925)
=end

=begin JA
* 使用するデータ入出力ライブラリを
  ((<gt4f90io|URL:http://www.gfd-dennou.org/library/gtool4/gt4f90io.htm>))
  から
  ((<gtool5|URL:http://www.gfd-dennou.org/library/gtool4/gtool5.htm>)) へ変更
* 予報変数に関しては, タイムフィルターをかける前の値を出力.
* 時間発展の DO LOOP の制御は「ステップ数」ではなく時刻で行う.
=end JA
=begin EN
* Data input/output library is changed from
  ((<gt4f90io|URL:http://www.gfd-dennou.org/library/gtool4/gt4f90io.htm.en>))
  to 
  ((<gtool5|URL:http://www.gfd-dennou.org/library/gtool4/gtool5.htm.en>)).
* Prediction variables are output not time filtered.
* DO LOOP of time integration is controlled by not number of step but time.
=end EN


=begin
== 2008/08/12 (Tag: dcpam5-20080812)
=end

=begin JA
* 力学コアを実装.
* 大規模凝結スキームを実装.
* 乾燥対流調節過程を実装.
* 地表面フラックス過程を実装. 
* タイムフィルター (Asselin, 1972) 実装. 
* 負の水蒸気除去のためのユーティリティを実装.
* 地表面データファイルの入力のためのモジュールを作成.
* Held and Suarez (1994) による強制と散逸に関する物理過程を実装. 
* Held and Suarez (1994) ベンチマークテスト用主プログラムを実装. 
=end JA
=begin EN
* Dynamical core is implemented. 
* Large scale condensation scheme is implemented. 
* Dry convective adjustment process is implemented. 
* Surface flux process is implemented. 
* Time filter (Asselin, 1972) is implemented. 
* A utility for elimination of negative moisture is implemented. 
* A module for ground data file input is created. 
* A physical process for forcing and dissipation suggested
  by Held and Suarez (1994) is implemented. 
* Main program for Held and Suarez (1994) benchmark test is implemented. 
=end EN


=begin
== 2008/08/04 (Tag: dcpam5-20080804)
=end

=begin JA
* dcpam4 からプログラムの書き方を大幅に変更.
* まだ作成段階. 
  * 放射, 鉛直拡散, 積雲パラメタリゼーション (湿潤対流) のみ
    実装されている. 
=end JA
=begin EN
* Programming style is considerably changed from "dcpam4".
* Under construction. 
  * Only radiation, vertical diffusion, cumulus parameterization
    (moist adjust) are implemented. 
=end EN


#
# Following comments are needed for TeX Documents.
# These are automatically setting by cvs.
# So do not modify directly.
#
$Name:  $
$Date: 2015/02/17 23:54:08 $

=begin HTML
<hr />
<small>$Id: HISTORY,v 1.50 2015/02/17 23:54:08 yot Exp $
</small>
=end HTML

#== Mode setting for Emacs
#Local Variables:
#mode: rd
#End:
#
