#
# dcpam5 Installation Guide in RD (Ruby Document) format
#
#   For instruction of installing dcpam, 
#   see "INSTALL.htm.en" (English) or "INSTALL.htm" (Japanese)
#   included in "dcpam5" tar.gz package
#   available from http://www.gfd-dennou.org/library/dcpam.
#   Otherwise, see this file directly, or generate
#   above mentioned html files with "make guide" 
#   in current directory after installing  rdtool
#   <http://raa.ruby-lang.org/project/rdtool/>.

=begin JA

= dcpam5 インストールガイド
#* 森川 靖大 (morikawa), 石渡 正樹 (momoko)
#  * $Id: INSTALL,v 1.33 2014/03/10 04:37:06 yot Exp $
=end JA
=begin EN

= dcpam5 Installation Guide
#* Yasuhiro MORIKAWA (morikawa), Masaki ISHIWARARI (momoko)
#  * $Id: INSTALL,v 1.33 2014/03/10 04:37:06 yot Exp $
=end EN

=begin JA
== 動作環境

このプログラムは以下のコンパイラでの動作を確認しています。

=end JA

=begin EN
== Operation Environment

This program is operated by following compilers.

=end EN

=begin
#  * ((<"Debian GNU/Linux 6.0 "|URL:http://www.debian.org/>)) +
#    ((<g95|URL:http://www.g95.org/>))
#
#  * ((<"Debian GNU/Linux 5.0 "|URL:http://www.debian.org/>)) +
#    ((<g95|URL:http://www.g95.org/>))
#
#  * ((<"Debian GNU/Linux 5.0 "|URL:http://www.debian.org/>)) +
#    ((<Fujitsu Fortran 5.0 (in JAPANESE)|URL:http://jp.fujitsu.com/group/kyushu/services/dev-tech/fortran/>))

#  * ((<"Debian GNU/Linux 6.0 "|URL:http://www.debian.org/>)) +
#    ((<gfortran|URL:http://gcc.gnu.org/wiki/GFortran/>))
#
#  * ((<"Debian GNU/Linux 6.0 "|URL:http://www.debian.org/>)) +
#    ((<g95|URL:http://www.g95.org/>))
#
#  * ((<"Debian GNU/Linux 6.0 "|URL:http://www.debian.org/>)) +
#    ((<Fujitsu Fortran 5.0 (in Japanese)|URL:http://jp.fujitsu.com/group/kyushu/services/dev-tech/fortran/>))
#
#  * ((<"Debian GNU/Linux 6.0 "|URL:http://www.debian.org/>)) +
#    ((<Fujitsu Fortran 64V1 (in Japanese)|URL:http://jp.fujitsu.com/group/kyushu/services/dev-tech/fortran/>))
#
#  * ((<"Debian GNU/Linux 6.0 "|URL:http://www.debian.org/>)) +
#    ((<PGI Fortran 12.5-0 64 big|URL:http://www.pgroup.com/>))
#
#  * ((<"Debian GNU/Linux 7.0 "|URL:http://www.debian.org/>)) +
#    ((<gfortran|URL:http://gcc.gnu.org/wiki/GFortran/>))
#
#  * ((<"Debian GNU/Linux 7.0 "|URL:http://www.debian.org/>)) +
#    ((<Fujitsu Fortran 64V1 (in Japanese)|URL:http://jp.fujitsu.com/group/kyushu/services/dev-tech/fortran/>))

  * ((<"Debian GNU/Linux 9 "|URL:http://www.debian.org/>)) +
    ((<gfortran|URL:http://gcc.gnu.org/wiki/GFortran/>))

=end


#=begin JA
#過去には以下の環境でも動作したことが確認されています.
#確認はしていませんが, 現在のバージョンでもおそらく動作すると期待されます.
#=end JA
#=begin EN
#dcpam5 was operated by following environments in the past.
#Latest version may be operated (unconfirmed).
#=end EN
#
#=begin
#  * ((<"Debian GNU/Linux 4.0 "|URL:http://www.debian.org/      >)) +
#    ((<Fujitsu Fortran 5.0 (in JAPANESE)|URL:http://www.fqs.co.jp/fort-c/>))
#
#  * ((<"Debian GNU/Linux 3.1 "|URL:http://www.debian.org/      >)) +
#    ((<Fujitsu Fortran 5.0 (in JAPANESE)|URL:http://www.fqs.co.jp/fort-c/>))
#
#  * ((<"Debian GNU/Linux 4.0 "|URL:http://www.debian.org/      >)) +
#    Intel Fortran 10.0
#
#  * ((<"Debian GNU/Linux 3.1 "|URL:http://www.debian.org/      >)) +
#    Intel Fortran 9.0
#
#  * ((<"Debian GNU/Linux 3.1, 4.0"|URL:http://www.debian.org/>)) +
#    ((<G95 Fortran 0.9       |URL:http://www.g95.org/>))
#
##  * Windows Vista + G95 Fortran
##  * Windows Vista + Intel Visual Fortran 9.1.032
##  * Windows Vista + Compaq Visual Fortran 6.6
##  * HITACHI SR11000 + IBM XL Fortran Enterprise Edition for AIX5L
##  * HITACHI SR11000 + Optimizing FORTRAN90 Compiler
#  * NEC SX-8 + FORTRAN90/SX
##  * FUJITSU VPP-5000 + VPP Fortran
#=end


#=begin JA
#== インストールの流れ
#
#dcpam5 のインストールは以下のように行います.
#詳しくは各項目を参照してください.
#
#  (1) ((<必要なソフトウェア>)) をインストールします.
#  (2) ((<ビルドの手引き>)) に従い, ソースからライブラリをビルドします.
#  (3) ((<サンプルプログラム実行の手順>)) に従い, インストールされた
#      ライブラリが正常に機能するかどうか確認してください.
#
#=== インストールの例
#
#((<dcpam プロジェクト|URL:http://www.gfd-dennou.org/library/dcpam/>))
#の「チュートリアル」では, インストールの実例も紹介されています.
#インストールがうまくいかない場合は参照してください.
#
#
#=== Debian GNU/Linux ユーザのみなさまへ
#
#Debian GNU/Linux を使用している場合は,
#((<URL:http://www.gfd-dennou.org/library/dcpam/debian.htm>))
#にて配布しているバイナリパッケージも利用できます.
#
#=end JA
#
#=begin EN
#== General outline
#
#Install dcpam5 as follows. Refer each items for details.
#
#  (1) Satisfy ((<Software Requirements>)).
#  (2) Build the library following ((<How to build>)).
#  (3) Check whether the installed library functions normally
#      following ((<Execute sample programs>)).
#
#=== Install example
#
#There are examples of installation in "Tutorial" on
#((<dcpam Project|URL:http://www.gfd-dennou.org/library/dcpam/>)).
#Refer them if the installation is not successful.
#
#=== For Debian GNU/Linux users
#
#When you are using Debian GNU/Linux, binary packages distributed with
#((<URL:http://www.gfd-dennou.org/library/dcpam/debian.htm.en>))
#can be used.
#
#=end EN


=begin JA
== 必要なソフトウェア

dcpam5 を利用するためには以下のソフトウエアを
事前にインストールしておく必要があります.

: MPI ライブラリ (並列計算を行う場合のみ必要です)

  MPI を用いた並列計算を行う場合には, MPI ライブラリをインストールしてください.

: ((<netCDF|URL:http://www.gfd-dennou.org/library/netcdf>)) (バージョン 3.6.X 以上)

: ((<gtool5|URL:http://www.gfd-dennou.org/library/gtool>)) (バージョン 20100924 以上)

: ((<ISPACK|URL:http://www.gfd-dennou.org/library/ispack>)) (バージョン 1.0.2 以上, 1.04 以下)

: ((<spmodel|URL:http://www.gfd-dennou.org/library/spmodel>)) (バージョン 0.8.0)

* インストール
  *  Debian GNU/Linux を使用しているならば, バイナリパッケージを利用し, 
     一括インストールができます. 
     ((<こちら|URL:http://www.gfd-dennou.org/library/cc-env/debian-dennou/index.htm.ja>))
     を参照してリポジトリを設定し,

         % apt-get install spml

     とすると, 一連の必要なパッケージがインストールされます

  * ソースからビルドする場合

    * ((<netcdf 3.6.3 版 ソースのTGZ|URL:http://www.unidata.ucar.edu/downloads/netcdf/ftp/netcdf-3.6.3.tar.gz>))
# [((<Unidata 本家 NetCDFクイックインストールガイド (英語) |URL:http://my.unidata.ucar.edu/content/software/netcdf/docs/netcdf-install/Quick-Instructions-for-Installing-NetCDF-on-Unix.html#Quick-Instructions-for-Installing-NetCDF-on-Unix>))
# |
# ((<(日本語訳)|URL:INSTALL_netcdf.htm>)) ]
# [((<Unidata 本家のインストールガイドの目次|URL:http://my.unidata.ucar.edu/content/software/netcdf/docs/netcdf-install/index.html>))]


    * ((<gtool5 最新バージョン TGZ|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current.tgz>))
      [((<インストールガイド|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/INSTALL.htm>))]


    * ((<ISPACK バージョン 1.0.4 TGZ|URL:http://www.gfd-dennou.org/library/ispack/ispack-1.0.4.tar.gz>)) [ダウンロード, 展開して README を参照してください]

    * ((<spml 最新版 TGZ|URL:http://www.gfd-dennou.org/library/spmodel/spml_current.tar.gz>))
      ((<インストールガイド|URL:http://www.gfd-dennou.org/library/spmodel/spml/doc/INSTALL.htm>))



=== 開発者にとって必要なソフトウェア

ソースコードを編集したり, 
ドキュメントを生成するためには以下の
ソフトウェアを事前にインストールしておく必要があります. 
(tar.gz パッケージには既にドキュメントが同梱しています)

* ソースコードの編集
  * ((<Ruby|URL:http://www.ruby-lang.org/>))
  * ((<Rsed.rb (Recursive Sed with Ruby)|URL:http://www.ep.sci.hokudai.ac.jp/~michi/pc/ruby/script-02.html>))
    (tar.gz パッケージに同梱済み)

* ドキュメント生成
  * 個別の HTML ページ
    (例: 本ページ, ((<dcpam5 ドキュメント|URL:doc/index.htm>)),
    ((<ごくらく dcpam5|URL:doc/gokuraku/index.htm>)),
    ((<らくらく dcpam5|URL:doc/rakuraku/rakuraku.pdf>)))
    * ((<rdtool|URL:http://raa.ruby-lang.org/project/rdtool/>))
    * ((<rd2latex|URL:http://shugo.net/archive/rd2latex/>))
      (tar.gz パッケージに同梱済み)
  * 各モジュールのリファレンスマニュアル
    * ((<"RDoc Fortran90/95 ソースコード解析機能強化版"|URL:http://www.gfd-dennou.org/library/dcmodel>))
  * 支配方程式系とその離散化, 導出に関する参考資料 
    * ((<LaTeX|URL:http://www.latex-project.org/>))
      * スタイルファイル: ((<Dennou6 style|URL:http://www.gfd-dennou.org/library/cc-env/TeXmacro/dennou/SIGEN.htm>))
    * ((<latex2html に日本語パッチ, Dennou6 style パッチをあてたもの|URL:http://www.gfd-dennou.org/library/cc-env/latex2html/SIGEN.htm>))

=end JA
=begin EN

== Software Requirements

Following softwares should be installed for installing dcpam.

: MPI library (required only when parallel computation is performed)

  If you perform parallel computing by using the MPI, install MPI library. 


: ((<netCDF|URL:http://my.unidata.ucar.edu/content/software/netcdf/index.html>)) (version 3.6.X or more)

  Debian GNU/Linux (use binary packages)

#  If you use Debian GNU/Linux and use binary package of netCDF, see ((<here|URL:http://www.gfd-dennou.org/library/spmodel/debian/needed.htm.en>)) and install it. 
  If you use Debian GNU/Linux, you can use binary package of netCDF. 

#  If you use above Debian package to install netCDF, you need
#  ((* "netcdf-bin" *)) package too. (Parhaps you can get by "apt-get").

  Building from source codes

  * ((<Version 3.6.2 TGZ|URL:http://www.gfd-dennou.org/library/netcdf/unidata-mirror/netcdf-3.6.2.tar.gz>)),

    [((<Quick Instructions for Installing (Unidata)|URL:http://my.unidata.ucar.edu/content/software/netcdf/docs/netcdf-install/Quick-Instructions-for-Installing-NetCDF-on-Unix.html#Quick-Instructions-for-Installing-NetCDF-on-Unix>))]
    * [((<NetCDF Installation and Porting Guide (Unidata)|URL:http://my.unidata.ucar.edu/content/software/netcdf/docs/netcdf-install/index.html>))]


: ((<gtool5|URL:http://www.gfd-dennou.org/library/gtool>)) (version 20100924 or more)

  If you use Debian GNU/Linux and use binary package of gtool5, see ((<here|URL:http://www.gfd-dennou.org/library/cc-env/debian-dennou/index.htm.en>)) and install it. 

  Building from source codes
  * ((<Latest version TGZ|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current.tgz>))

    ((<Installation Guide|URL:http://www.gfd-dennou.org/library/gtool/gtool5/gtool5_current/INSTALL.htm.en>))


: ((<ISPACK (in Japanese)|URL:http://www.gfd-dennou.org/library/ispack>)) (version 1.0.2)

  If you use Debian GNU/Linux and use binary package of ISPACK, see ((<here|URL:http://www.gfd-dennou.org/library/cc-env/debian-dennou/index.htm.en>)) and install it. 

  See "README" file in a tar.gz file. (but that is written in Japanese)

: ((<spmodel|URL:http://www.gfd-dennou.org/library/spmodel>)) (version 0.8.0 or more)
  
  If you use Debian GNU/Linux and use binary package of spmodel, see ((<here|URL:http://www.gfd-dennou.org/library/cc-env/debian-dennou/index.htm.en>)) and install it. 

  Building from source codes
  * ((<Latest TGZ|URL:http://www.gfd-dennou.org/library/spmodel/spml_current.tar.gz>))

    ((<Installation Guide (in Japanese)|URL:http://www.gfd-dennou.org/library/spmodel/spml/INSTALL>))


=== Software Requirements for developers

Following softwares should be installed
for modification of source code and generation of documents.
(But if you get tar.gz package, documentations are already generated).

* Modification of source code
  * ((<Ruby|URL:http://www.ruby-lang.org/>))
  * ((<Rsed.rb: Recursive Sed with Ruby (in Japanese)|URL:http://www.ep.sci.hokudai.ac.jp/~michi/pc/ruby/script-02.html>))
    (This is bundled in the tar.gz package)

* generation of documents
  * Individual HTML pages
    (Examples: This page, ((<dcpam5 Documents|URL:doc/index.htm.en>)),
    ((<GOKURAKU dcpam5|URL:doc/gokuraku/index.htm.en>)),
    ((<RAKURAKU dcpam5|URL:doc/rakuraku/rakuraku.pdf>)))
    * ((<rdtool|URL:http://raa.ruby-lang.org/project/rdtool/>))
    * ((<rd2latex|URL:http://shugo.net/archive/rd2latex/>))
      (This is bundled in the tar.gz package)
  * Reference Manual of modules
    * ((<"Enhanced version of RDoc Fortran90/95 parser"|URL:http://www.gfd-dennou.org/library/dcmodel>))
  * The governing equations and basic_equations, References for derivation
    * ((<LaTeX|URL:http://www.latex-project.org/>))
      * Style file: ((<Dennou6 style (Japanese only)|URL:http://www.gfd-dennou.org/library/cc-env/TeXmacro/dennou/SIGEN.htm>))
    * ((<latex2html_jp+dennou (Japanese only)|URL:http://www.gfd-dennou.org/library/cc-env/latex2html/SIGEN.htm>))

=end EN

=begin JA
== ビルドの手引き
=end JA
=begin EN
== How to build
=end EN

=begin JA
=== TGZ パッケージの展開

適当な作業ディレクトリで以下のようにソースアーカイブを展開します.
ソースは dcpam5-((|バージョン|)) というディレクトリに展開されます.

	$ tar xvzf dcpam5_latest.tgz

または

	$ zcat dcpam5_latest.tgz | tar -xvf -

=end JA
=begin EN
=== Extract TGZ Package

Make an empty directory, and extract archive as follows.
A directory `dcpam5-((|version|))'
created at the current working directory.

	$ tar xvzf dcpam5_latest.tgz

or

	$ zcat dcpam5_latest.tgz | tar -xvf -

=end EN


=begin JA
=== Fortran コンパイラの指定

環境変数 ((* FC *)) に使用する Fortran コンパイラを指定してください.
以下は, コンパイラとして spmfrt を使用する場合です.

* sh, bash の場合

	$ FC=spmfrt ; export FC

* csh, tcsh の場合

	$ setenv FC spmfrt

最適化やデバッグのためのオプションは環境変数 ((* FFLAGS *))
に設定してください. 以下はオプションに -O を指定する場合です. 

* sh, bash の場合

	$ FFLAGS="-O" ; export FFLAGS

* csh, tcsh の場合

	$ setenv FFLAGS "-O"


なお, スペクトル変換に sjpack を用いる場合には FFLAGS に -DSJPACK を指定してください. 

さらに, 軸対称計算を行う場合には, FFLAGS に -DAXISYMMETRY または -DAXISYMMETRY_SJPACK を
指定してください. 


=end JA
=begin EN
=== Specify Fortran Compiler

Specify Fortran compiler to environmental variable ((* FC *)).
For example, if you use "spmfrt",

* sh, bash

	$ FC=spmfrt ; export FC

* csh, tcsh

	$ setenv FC spmfrt

Specify Fortran compiler options for optimization and debug to
environmental variable ((* FFLAGS *)).
For example, if you set -O option, 

* sh, bash

	$ FFLAGS="-O" ; export FFLAGS

* csh, tcsh

	$ setenv FFLAGS "-O"

On the one hand, specify -DSJPACK to FFLAGS if you use sjpack for spectral transformation.

Further, specify -DAXISYMMETRY or -DAXISYMMETRY_SJPACK to FFLAGS if you perform 
axisymmetric calculation. 

=end EN


=begin JA
=== Config.mk の作成

展開されたディレクトリに移動し, (({ ./configure }))を実行します.
((<コンパイルに必要なライブラリ>))でインストールした各ライブラリを
以下のオプションに指定する必要があります.

:(({--with-ispack=}))((|ARG|))
  ispack ライブラリ (*.a) のファイル名.

:(({--with-netcdf=}))((|ARG|))
  netcdf ライブラリ (*.a) のファイル名.
  場合によって (({--with-netcdff=}))((|ARG|)) (netcdf Fortran ライブラリのファイル名), (({--with-netcdff-include=}))((|ARG|)) (netcdf ライブラリの include ファイル名) も指定する必要があります.

:(({--with-gtool5=}))((|ARG|))
  gtool5 ライブラリ (*.a) のファイル名.

:(({--with-spml=}))((|ARG|))
  spmodel ライブラリ (*.a) のファイル名.

例えば以下のように指定します.
このコマンドによって (({ Config.mk })) ファイルが生成されます.

    $ ./configure --with-ispack=/usr/local/lib/libisp.a \
                  --with-netcdf=/usr/local/lib/libnetcdf.a \
                  --with-gtool5=/usr/local/lib/gtool5/lib/libgtool5.a \
                  --with-spml=/usr/local/lib/spml/lib/libspml.a

また, gfortran, netcdf, ispack, gtool5, spml の Debian package を使用する場合には, 
以下のように configure を実行します. 

    % ./configure \
        --with-ispack=/usr/lib/x86_64-linux-gnu/libispack.a \
        --with-netcdf=/usr/lib/libnetcdf.a \
        --with-netcdff=/usr/lib/libnetcdff.a \
        --with-netcdf-include=/usr/include/netcdf \
        --with-gtool5=/usr/lib/x86_64-linux-gnu/gtool5/lib/libgtool5.a \
        --with-spml=/usr/lib/x86_64-linux-gnu/spml/lib/libspml-lapack-lapack.a

ビルドには GNU make が必要となるため, configure は PATH 内から
自動で GNU make を探査しようとしますが, もし見つからない場合,
エラーを返します. その場合には環境変数 ((* MAKE *)) に
GNU make コマンドを指定して再度 configure を実行してください.

インストール先などを変更したい場合は, 以下のように (({ --help })) オプ
ションをつけることで, 指定可能なオプションリストが表示されます.

	$ ./configure --help

主なオプションに関しての説明です.

:(({--prefix=}))((|ARG|))
  ((|ARG|)) にライブラリやモジュール, 実行ファイルのインストール先の
  ディレクトリのプレフィックスを指定します.
  デフォルトは (({ /usr/local/dcpam5 })) です.

:(({--libdir=}))((|ARG|))
  ((|ARG|)) にライブラリのインストール先のディレクトリを指定します.
  デフォルトは (({ /usr/local/dcpam5/lib })) です.

:(({--includedir=}))((|ARG|))
  ((|ARG|)) にモジュール情報ファイルのインストール先のディレクトリ
  を指定します. デフォルトは (({ /usr/local/dcpam5/include })) です.

:(({--bindir=}))((|ARG|))
  ((|ARG|)) に実行ファイルのインストール先のディレクトリを指定します.
  デフォルトは (({ /usr/local/dcpam5/bin })) です.

:(({--with-docdir=}))((|ARG|))
  ((|ARG|)) にドキュメントファイルのインストール先を指定します.
  デフォルトは (({ /usr/local/dcpam5/doc })) です.

:(({--with-dcpam_lib_name=}))((|ARG|))
  ((|ARG|)) に dcpam5 のライブラリ名を指定します.
  ライブラリ名は (({lib}))((|<ARG>|))(({.a})) となります.
  デフォルトは (({ dcpam5 })) であり, その際のライブラリ名は
  (({ libdcpam5.a })) となります.

:(({--with-dcpam_suffix=}))((|ARG|))
  ((|ARG|)) にはインストールディレクトリ, ライブラリ名,
  実行ファイルの末尾につける接尾語を指定します.
  例えば, 他が全てデフォルトの設定で (({ ffc5 })) と指定すると,
  インストール先のディレクトリのプレフィックスが
  (({ /usr/local/dcpam5-ffc5 })), ライブラリ名が
  (({ libdcpam5-ffc5.a }))等のようになります.

:(({--with-lang_conform_check=}))((|ARG|))
  ((|ARG|)) に言語規格を指定することで, コンパイル時に言語規格の
  チェックを行うよう, オプションを追加します. 現在 "(({95}))"
  のみ指定可能です. コンパイラによっては指定できません.

:(({--enable-debug}))
  このオプションを指定することで, コンパイル時や実行時にデバッグメッセージ
  を出力するオプションを追加します.
  コンパイラによっては指定できません.

:(({--config-cache})) または (({-C}))

  (({ Config.mk })) ファイルが生成されると同時に, (({config.cache}))
  ファイルが作成され, (({ ./configure })) の引数に指定された netCDF
  ライブラリの位置などの情報が保持されます.

  再度 (({ ./configure })) を実行する際にもこのオプションを指定することで,
  (({config.cache})) が読み込まれ, 前回指定したオプション等が引き継がれます.
  既に存在する (({config.cache})) を無視する場合はこのオプションを
  指定せずに (({ ./configure })) を実行してください.

  例えば下記のように (({ ./configure })) を実行するとします.

      $ ./configure -C  --enable-debug \
                    --with-ispack=/usr/local/lib/libisp.a \
                    --with-netcdf=/usr/local/lib/libnetcdf.a \
                    --with-gtool5=/usr/local/lib/gtool5/lib/libgtool5.a \
                    --with-spml=/usr/local/lib/spml/lib/libspml.a

  すると次回以降, 下記のように (({ ./configure })) を実行することで
  netCDF ライブラリ等の位置や, デバッグオプションを付加する情報が
  引き継がれます.

      $ ./configure -C

  Debian GNU/Linux で Fujitsu Fortran を利用している場合には,
  Config.cache.debian-ffc* を (({config.cache})) に移動して
  (({ ./configure })) コマンドを実行するだけで自動的に
  ライブラリの位置が設定されます.

      $ cp Config.cache.debian-ffc5 config.cache
      $ ./configure -C

:(({--enable-mpi}))
  このオプションを指定することで, 並列版のコンパイルを行います. 


=end JA
=begin EN

=== Create `Config.mk'

Move created directroy, and excute `(({ ./configure }))'.

Specify library files in ((<Libraries needed for compile>)) to
following options.

:(({--with-ispack=}))((|ARG|))
  ispack library filename (*.a)

:(({--with-netcdf=}))((|ARG|))
  netcdf library filename (*.a)

:(({--with-gtool5=}))((|ARG|))
  gtool5 library filename (*.a)

:(({--with-spml=}))((|ARG|))
  spmodel library filename (*.a)

For exapmle, specify as follow. This command will generate
(({ Config.mk })).

    $ ./configure --with-ispack=/usr/local/lib/libisp.a \
                  --with-netcdf=/usr/local/lib/libnetcdf.a \
                  --with-gtool5=/usr/local/lib/gtool5/lib/libgtool5.a \
                  --with-spml=/usr/local/lib/spml/lib/libspml.a \

GNU make is needed to build, so configure automatically inquires
into GNU make in PATH. However, it returns error when GNU make is
not found. In that case, please set the GNU make command for
environment variable ((* MAKE *)). And rerun execute `(({ ./configure }))'.

If you want to change directory to which the library and the module, etc.
are installed, please set (({ --help })) option as follow. Available
options are showed.

	$ ./configure --help

Descriptions about principal options are listed below.

:(({--prefix=}))((|ARG|))
  Specify prefix to ((|ARG|)).
  Default value is (({ /usr/local/dcpam5 })).

:(({--libdir=}))((|ARG|))
  Specify directory to which the library is installed to ((|ARG|)).
  Default value is (({ /usr/local/dcpam5/lib })).

:(({--includedir=}))((|ARG|))
  Specify directory to which the module is installed to ((|ARG|)).
  Default value is (({ /usr/local/dcpam5/include })).

:(({--bindir=}))((|ARG|))
  Specify directory to which the executable file is installed to ((|ARG|)).
  Default value is (({ /usr/local/dcpam5/bin })).

:(({--with-docdir=}))((|ARG|))
  Specify directory to which the documentation file is installed to ((|ARG|)).
  Default value is (({ /usr/local/dcpam5/doc })).

:(({--with-dcpam_lib_name=}))((|ARG|))
  Specify dcpam5 library name to ((|ARG|)).
  Library name becomes (({lib}))((|<ARG>|))(({.a})) .
  Default value is (({ dcpam5 })), so library name becomes
  (({ libdcpam5.a })) .

:(({--with-dcpam_suffix=}))((|ARG|))
  Specify suffix of installdir, library name, executable files to((|ARG|)).
  For example, you specify (({ ffc5 })) when others are default,
  prefix of installdir becomes (({ /usr/local/dcpam5-ffc5 })),
  library name becomes (({ libdcpam5-ffc5.a })),
  executable files become (({ gt4frt.ffc5 })), (({ gt4config.ffc5 })).

:(({--with-lang_conform_check=}))((|ARG|))
  Specify language standard to ((|ARG|)).
  And when you compile source code, check the language standard conformance.
  Now, "(({95}))" is valid.
  The compiler that can be used is limited.

:(({--enable-debug}))
  When you compile source code and execute binary file, output debug
  messages.
  The compiler that can be used is limited.

:(({--config-cache or -C}))
  (({ config.cache })) is created at the same time as (({ Config.mk }))'s
  being generated.
  (({ config.cache })) stores information investigated with
  (({ ./configure })).

  If you set this option, when you execute (({ ./configure })) again,
  (({config.cache})) is loaded.
  If you want to ignore (({config.cache})), don't set this option

  For example, execute (({ ./configure })) as follows.

      $ ./configure -C  --enable-debug \
                    --with-ispack=/usr/local/lib/libisp.a \
                    --with-netcdf=/usr/local/lib/libnetcdf.a \
                    --with-gtool5=/usr/local/lib/gtool5/lib/libgtool5.a \
                    --with-spml=/usr/local/lib/spml/lib/libspml.a \

  Then, information such as the locations of the netCDF library etc. is
  succeeded by executing (({ ./configure })) as follows after next time.

      $ ./configure -C

  If you use Fujitsu Fortran compiler in Debian GNU/Linux,
  copy "Config.cache.debian-ffc*" to (({config.cache})) and
  execute (({ ./configure })). So, locations of libraries are
  specified automatically.

      $ cp Config.cache.debian-ffc5 config.cache
      $ ./configure

:(({--enable-mpi}))
  If you set this option, the parallelized version is compiled. 


=end EN



=begin JA
=== Config.mk の編集

上記の configure によって, 基本的な設定が記述された
(({ Config.mk })) ファイルが作成されます. 
しかし, 環境によっては configure のみでは不十分な場合もあるため,
必要に応じて Config.mk を手動で編集して下さい.

以下に主要な設定項目を挙げます. 

:FC
  Fortran コンパイラ

:SYSFFLAGS
  コンパイル時・リンク時に必要なフラグ
  (Fortran コンパイラ実行時に必要なオプション)

:SYSLDFLAGS
  リンク時に必要なフラグ

:SYSLDLIBS
  リンク時に必要なライブラリ

:prefix
  dcpam5 のライブラリ, モジュール, 実行ファイル,
  ドキュメントのインストールディレクトリ

:CLEAN_MODS
  make clean 時に使用するモジュール情報ファイル指定

:MAKE
  GNU make コマンド

:AR
  アーカイブコマンド

:ARFLAGS
  アーカイブ時に必要なフラグ

:RANLIB
  アーカイブのインデックスを作成するコマンド


=end JA
=begin EN
=== Edit `Config.mk'

A file '(({ Config.mk }))' in which elemental settings are written
is created by above "configure". 
However, the settings may be insufficient by "configure" in some environments.
In that case, edit '(({ Config.mk }))' manually according to need. 

Followings are main items.

:FC
  Fortran compiler

:SYSFFLAGS
  Flags needed when compiled and linked

:SYSLDFLAGS
  Flags needed when linked

:SYSLDLIBS
  Libraries needed when linked

:prefix
  Directory where dcpam5 library, modules, executable files,
  and documentations are installed

:CLEAN_MODS
  Extensions of Module Files used when "make clean"

:MAKE
  GNU make command

:AR
  Archive command

:ARFLAGS
  Flag of Archive command

:RANLIB
  Generate index to archive command

=end EN


=begin JA
=== ソースコードのコンパイル

ビルドには必ず GNU make を使用してください. 他の "make" プログラムを使
用すると, 正しくビルドが行われません.
以降 GNU make のコマンド名を "make" と表記しますが,
これらはシステムの GNU make コマンドの名前に置き換えてください.

configure 実行時に, 以下のように GNU make のコマンド名が
表示されたはずです. このメッセージに従って GNU make を実行してください. 

  Execute GNU make in the current directory, as follows.

    /usr/bin/make

以下のようなメッセージが表示されればビルドは成功です. 

    You have successfully built dcpam5.

=end JA
=begin EN
=== Compile source code

You must use GNU make to build. No other "make" program is acceptable.
"make" tentatively means GNU make at the following.
Replace them with GNU make of your system.

When ./configure is executed, the command name of GNU make is
displayed as follows. Execute GNU make according to the
message.

  Execute GNU make in the current directory, as follows.

    /usr/bin/make

If dcpam5 is built successfully, following messages will be displayed.

    You have successfully built dcpam5.

=end EN


=begin JA
=== ドキュメントの生成

マニュアルとコードリファレンスのコンパイルはカレントディレクトリ
において, 以下のコマンドを実行してください.
((<dcpam5 の TGZ パッケージ|URL:http://www.gfd-dennou.org/library/dcpam/dcpam5/dcpam5_latest.tgz>))
から入手する場合には既に生成済みです.

	$ make doc
=end JA
=begin EN
=== Generate documentations

To generate documentations, execute following command in current directory.
If you get from
((<dcpam5 TGZ package|URL:http://www.gfd-dennou.org/library/dcpam/dcpam5/dcpam5_latest.tgz>)),
documentations are already generated.

	$ make doc
=end EN

=begin JA
== プログラム実行の手順

ビルドが成功すると, src/main 以下に ((*dcpam_main*)), ((*init_data*)), ((*sst_data*))
などの実行ファイルが作成されています. 

これらの実行の手順については
((<ごくらく dcpam5|URL:doc/gokuraku>)) を参照してください. 
#((<らくらく dcpam5|URL:doc/rakuraku>)) を参照してください. 

=end JA
=begin EN
== Execute programs

If dcpam5 is built successfully,
some executable files ((*dcpam_main*)), ((*init_data*)), ((*sst_data*)) are
created under "src/main".

See ((<GOKURAKU (easiest) dcpam5|URL:doc/gokuraku/index.htm.en>)) for execution of the files. . 
#See ((<RAKURAKU (easier) dcpam5|URL:doc/rakuraku/index.htm.en>)) for execution of the files. 

=end EN


#=begin JA
#== Fortran 90/95 プログラムの編集の手引き
#
#((<らくらく dcpam5 (製作中)|URL:doc/tutorial/rakuraku>)) を参照してください.
#
#=end JA
#=begin EN
#== How to edit Fortran 90/95 programs
#
#See ((<RAKURAKU (easier) dcpam5 (under construction)|URL:doc/tutorial/rakuraku/index.htm.en>)). 
#
#=end EN


=begin HTML
<hr>
<small>$Id: INSTALL,v 1.33 2014/03/10 04:37:06 yot Exp $
</small>
=end HTML

#== Mode setting for Emacs
#Local Variables:
#mode: rd
#End:
#
