# 履歴
# * 2013/09/24 Satoshi NODA   作成

= 軌道要素の時間変化を求めるプログラムと地球用データ

== 概要

軌道要素を西暦の関数として求める近似式を実装したプログラムと
Berger (1978) の提案した地球用の係数が記された入力ファイル.

== 内容物

* calc_orbit.rb, calc_orbit.f90
  * 軌道要素を求めるプログラム. いずれも, 使い方と計算に用いている式は
    同じなので好きな方を使うとよい.
* CoefsForOrbElem_Earth_B1978.dat
  * Berger (1978) の提案した, 地球の軌道要素を計算するための係数
  * データフォーマットは, ファイル末尾を参照のこと.

== 使い方

内容物を同じディレクトリ内に置き, 引数なしで実行するのみ.
出力は標準出力になされる.

デフォルトの出力内容は, 
西暦紀元前 1,000,000 年から紀元 100,000 年までの値を
100 年間隔で出力する.
出力データの各カラムの値は左から

* 年 (西暦)
* 軌道傾斜角 (degree)
* 離心率
* fixed equinox を基準にした近日点の経度 (degree)

である.

== 注意点

* Berger (1978) の係数を用いた場合の有効範囲は
  過去 100 万年, 未来 10 万年.
  前者の値は Berger and Loutre (1991) に記されている.

* 100 万年前から 1000 万年前を計算する場合は
  Berger and Loutre (1991) を用いること.

* このプログラムでは, 本来存在しない西暦 0 年が存在する.
  そのため, 紀元前を計算した場合は
  本来求めたい年の 1 年前の値を返すことになる.

== その他

* dcpam への組み込みについては未定.

== 参考文献

* Berger, A., 1978: Long-Term Variations of
  Daily Insolation and Quaternary Climatic Changes.
  Journal of the Atmospheric Sciences, 35, 2362-2367.
* Berger, A. and M. F. Loutre. 1991:
  Insolation values for the climate of the last 10 million years.
  Quaternary Science Reviews, 10, 297-317.
