module rad_kd_utils

  use vtype_module

  implicit none

  private

  public :: InqPFIntGQNum
  public :: RadKDUtilsCalcTendency
  public :: RadKDUtilsCalcTendencyVarCp

contains

  !----------------------------------------------------------------------------

  function InqPFIntGQNum( DelWaveNum ) result( GQNum )


    real(DP), intent(in) :: DelWaveNum
!!$    real(DP), intent(in) :: Temp

    integer :: GQNum

    real(DP), parameter :: DelWaveNumPerPoint = 10.0d0
!!$    real(DP) :: DelWaveNumPerPoint

!!$    DelWaveNumPerPoint = 1.0d0 / ( 2.897d-3 / Temp ) / 1.0d4

    GQNum = int( DelWaveNum / DelWaveNumPerPoint ) + 1

    GQNum = min( GQNum, 1000 )

!!$    GQNum = min( GQNum, 1000 )
!!$    GQNum = min( GQNum, 10000 )


  end function InqPFIntGQNum

  !----------------------------------------------------------------------------

  subroutine RadKDUtilsCalcTendency( &
    & Grav, Cp, &
    & kmax, r_Press, &
    & r_RadUwFlux, r_RadDwFlux, &
    & z_DTempDt &
!!$    & GasRUniv, r_Temp, r_MolWt, &
!!$    & z_HRinWpm3 &
    & )

    real(DP)    , intent(in ) :: Grav
    real(DP)    , intent(in ) :: Cp
    integer     , intent(in ) :: kmax
    real(DP)    , intent(in ) :: r_Press(0:kmax)
    real(DP)    , intent(in ) :: r_RadUwFlux(0:kmax)
    real(DP)    , intent(in ) :: r_RadDwFlux(0:kmax)
    real(DP)    , intent(out) :: z_DTempDt  (1:kmax)
!!$    real(DP)    , intent(in ), optional :: GasRUniv
!!$    real(DP)    , intent(in ), optional :: r_Temp(0:kmax)
!!$    real(DP)    , intent(in ), optional :: r_MolWt(0:kmax)
!!$    real(DP)    , intent(out), optional :: z_HRinWpm3(1:kmax)


    ! Local variables
    !
    real(DP) :: r_RadNetFlux(0:kmax)
    real(DP) :: GasConst
    real(DP) :: Rho
    integer  :: k


    r_RadNetFlux = r_RadUwFlux - r_RadDwFlux

    do k = 1, kmax
      z_DTempDt(k) = &
        &   ( r_RadNetFlux(k-1) - r_RadNetFlux(k) ) &
        & / ( r_Press     (k-1) - r_Press     (k) ) &
        & * Grav / Cp
    end do

!!$    if ( present( z_HRinWpm3 ) ) then
!!$      if ( ( .not. present( GasRUniv ) ) .or. &
!!$        &  ( .not. present( r_MolWt  ) ) .or. &
!!$        &  ( .not. present( r_Temp   ) ) ) then
!!$        write( 6, * ) 'Error in RadKDUtilsCalcTendency'
!!$        write( 6, * ) '  GasRUniv, r_Temp and r_MolWt have to be present ', &
!!$          & 'when heating rate in Wm-3 is calculated.'
!!$        stop
!!$      end if
!!$      ! - dF/dz = - dF/dp dp/dz = - dF/dp * ( -rho g ) = dF/dp * rho g
!!$      do k = 1, kmax
!!$        GasConst = GasRUniv / ( ( r_MolWt(k-1) + r_MolWt(k) ) / 2.0d0 )
!!$        Rho = ( r_Press(k-1) + r_Press(k) ) / 2.0d0 &
!!$          & / ( GasConst * ( r_Temp(k-1) + r_Temp(k) ) / 2.0d0 )
!!$        z_HRinWpm3(k) = &
!!$          &   ( r_RadNetFlux(k-1) - r_RadNetFlux(k) ) &
!!$          & / ( r_Press     (k-1) - r_Press     (k) ) &
!!$          & * Rho * Grav
!!$      end do
!!$    end if


  end subroutine RadKDUtilsCalcTendency

  !----------------------------------------------------------------------------

  subroutine RadKDUtilsCalcTendencyVarCp( &
    & Grav, z_Cp, &
    & kmax, r_Press, &
    & r_RadUwFlux, r_RadDwFlux, &
    & z_DTempDt &
    & )

    real(DP)    , intent(in ) :: Grav
    real(DP)    , intent(in ) :: z_Cp       (1:kmax)
    integer     , intent(in ) :: kmax
    real(DP)    , intent(in ) :: r_Press    (0:kmax)
    real(DP)    , intent(in ) :: r_RadUwFlux(0:kmax)
    real(DP)    , intent(in ) :: r_RadDwFlux(0:kmax)
    real(DP)    , intent(out) :: z_DTempDt  (1:kmax)


    ! Local variables
    !
    real(DP) :: r_RadNetFlux(0:kmax)
    integer  :: k


    r_RadNetFlux = r_RadUwFlux - r_RadDwFlux

    do k = 1, kmax
      z_DTempDt(k) = &
        &   ( r_RadNetFlux(k-1) - r_RadNetFlux(k) ) &
        & / ( r_Press     (k-1) - r_Press     (k) ) &
        & * Grav / z_Cp(k)
    end do


  end subroutine RadKDUtilsCalcTendencyVarCp

  !----------------------------------------------------------------------------

end module rad_kd_utils
