!> A module containing information about grid used in PBL schemes

module pbl_grid
  use pp_vardef
  implicit none

  !> the number of vertical layers
  integer(4) :: nz
  integer(4) :: shcu_levels
  

contains
  !> Set the module variables given by users
  subroutine pbl_grid_ini(nz_in, shcu_levels_in)
    implicit none
    
    ! > User input for the number of vertical layers
    integer(4), intent(in) :: nz_in
    integer(4), intent(in), optional :: shcu_levels_in
    
    nz = nz_in
    shcu_levels = nz_in

    if (present(shcu_levels_in)) then
      shcu_levels = shcu_levels_in
    end if

    return
  end subroutine pbl_grid_ini
  !

  !> Return some values related to grid assignment.
  subroutine pbl_grid_set(z_f, z_h, dz_f, rdz_f, rdz_h, &
    & f2h_m, f2h_p, h2f_m, h2f_p)
    use pp_vardef
    implicit none

    !> Height of the vertical layers where tendencies should be returned.
    !! Typically these would be the heights of full levels
    real(r_size), intent(in) :: z_f(nz)

    !> Height of the vertical layers where fluxes are defined.
    !! Typically these would be the height of half levels
    real(r_size), intent(in) :: z_h(nz-1)

    !> vertical grid intervals between half levels.
    !! Defined at the full levels
    real(r_size), intent(out) :: dz_f(nz-1)

    !> reciprocal of dz_f
    real(r_size), intent(out) :: rdz_f(nz)

    !> reciprocal of vertical grid intervals between full levels.
    !! Defined at the full levels
    real(r_size), intent(out) :: rdz_h(nz-1)

    !> The following factors would be used as
    !!

    !> lower weight factor for interpolation from full levels to half levels
    real(r_size), intent(out) :: f2h_m(nz-1)
    !> upper weight factor for interpolation from full levels to half levels
    real(r_size), intent(out) :: f2h_p(nz-1)
    !> lower weight factor for interpolation from half levels to full levels
    real(r_size), intent(out) :: h2f_m(nz-1)
    !> upper weight factor for interpolation from half levels to full levels
    real(r_size), intent(out) :: h2f_p(nz-1)

    integer(4) :: kz

    real(r_size) :: dz_h


    kz = 1
    dz_f(kz) = z_h(kz)

    do kz = 2, nz - 1
      dz_f(kz) = z_h(kz) - z_h(kz - 1)
    end do

    do kz = 1, nz - 1
      dz_h = z_f(kz + 1) - z_f(kz)

      rdz_f(kz) = 1.0 / dz_f(kz)
      rdz_h(kz) = 1.0 / dz_h

      f2h_m(kz) = (z_f(kz + 1) - z_h(kz)) * rdz_h(kz)
      f2h_p(kz) = 1.0 - f2h_m(kz)

      h2f_m(kz) = (z_h(kz) - z_f(kz)) * rdz_f(kz)
      h2f_p(kz) = 1.0 - h2f_m(kz)
    end do
    
    kz = nz
    rdz_f(kz) = 2.0 / (z_f(kz) - z_h(kz - 1))

    !h2f_m(nz) = (z_h(nz) - z_f(nz)) / (z_h(nz) - z_h(nz - 1))
    !h2f_p(nz) = (z_f(nz) - z_h(nz - 1)) / (z_h(nz) - z_h(nz - 1))
    return


  end subroutine pbl_grid_set

end module pbl_grid
