module pbl_implic
  implicit none
  
  private

  public :: pbl_implic_solve

contains
  subroutine pbl_implic_solve(aa, bb, cc, qq)
    use pp_vardef
    use pbl_grid, only: nz
    implicit none

    real(r_size), intent(inout) :: aa(nz)
                                ! coefficients of fields on level K-1
                                ! in the tri-diagonal equation
    real(r_size), intent(inout) :: bb(nz)
                                ! coefficients on fields level K
                                ! in the tri-diagonal equation
    real(r_size), intent(inout) :: cc(nz)
                                ! coefficients on fields level K+1
                                ! in the tri-diagonal equation
    real(r_size), intent(inout) :: qq(nz)
                        ! right hand side of the tri-diagonal equation

    ! Local variables
    integer(4) :: kz

    do kz = nz, 2, -1
      aa(kz - 1) = aa(kz - 1) * bb(kz)
      bb(kz - 1) = bb(kz - 1) * bb(kz) - aa(kz) * cc(kz - 1)
      qq(kz - 1) = qq(kz - 1) * bb(kz) - qq(kz) * cc(kz - 1)
    end do

    qq(1) = qq(1) / bb(1)

    ! Solve from bottom to top
    do kz = 2, nz
      qq(kz) = (qq(kz) - aa(kz) * qq(kz - 1)) / bb(kz)
    end do
    return

  end subroutine pbl_implic_solve


end module pbl_implic
