************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2011 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
************************************************************************
*     SUBROUTINES FOR CONVERTING                                95/10/13
************************************************************************
*     CHANGE PSI TO AVT
************************************************************************
      SUBROUTINE NDCP2A(MM,OMG,PSI,AVT)

      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER(SQRT3=1.7320508075688772935D0)
      DIMENSION PSI((MM+1)*(MM+1)),AVT((MM+1)*(MM+1))

      CALL STCLFA(MM,PSI,AVT)

      AVT(2)=AVT(2)+2*OMG/SQRT3

      END
************************************************************************
*     CHANGE AVT TO PSI
************************************************************************
      SUBROUTINE NDCA2P(MM,OMG,AVT,PSI)

      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER(SQRT3=1.7320508075688772935D0)
      DIMENSION AVT((MM+1)*(MM+1)),PSI((MM+1)*(MM+1))

      CALL STCLBA(MM,AVT,PSI)

      PSI(2)=PSI(2)+OMG/SQRT3

      END
