/*
 *    dcl graphic driver for Xlib
 *
 *                         original  M. Shiotani
 *                         93/04/15  A. Numaguti (wait option etc.)
 *                         94/01/28  S. Sakai  ver.5.x
 *                         94/03/15  M. Shiotani
 *                         95/03/18  A. Numaguti
 *
 *    Copyright (C) 2000 GFD Dennou Club. All rights reserved.
 *
 */
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

struct  MouseInfo{
    int     bMouseClick;
    int     xPos,yPos;
};


#define BORDWD 2             /* border width */
#define PAD    2.0           /* padding for workstation window */
#define FACTZ  0.03          /* scaling factor */
#define TRUE   1             /* numeric value for true  */
#define FALSE  0             /* numeric value for false */
#define LWDATR TRUE          /* line width  capability */
#define LCLATR TRUE          /* line color  capability */
#define LTNATR TRUE          /* hard fill   capability */
#define LIMATR TRUE          /* bit image   capability */
#define LPTATR TRUE          /* mouse point capability */
#define MAXWDI 9             /* maximum number of line index */
#define MAXCLI 255           /* maximum number of line color */
#define MAXBMP 300           /* maximum number of bitmaps */

#define nmax 100             // max line points
#define nplmax 256           // numnber of color table



static int linewidth[MAXWDI] = { 1, 2, 2, 3, 3, 4, 4, 5, 5 };
                             /* initialization for line width */
static int iwdidz, iclidz, iwtroz, lclatrz, iwnd;
static int wsxwd, wsywd, wsxmnz, wsxmxz, wsymnz, wsymxz;
static int ixz, iyz, iwz, ihz, ixxz, iyyz, page;
static int posx, posy, wait, wait0, wait1, keymask, alternate, dump,fgbg;
static int nbmap, nn1[MAXBMP], nn2[MAXBMP], nx[MAXBMP], ny[MAXBMP];
static unsigned long pl[1], px[MAXCLI];
static float rwxold, rwyold;
static char dmpfile[80], xtitle[80];
static char bmline[MAXBMP][260];


int        OtbRes;
int        ix[nmax+1], iy[nmax+1];
int        laltz;
struct MouseInfo  mf;
int        kc;
int        mode0,ldisp;
//privateɂȂĂ̂ł킯ȂႢȂBline
int        ndata=0, iwidth=1, icolor=1, i_rgb=0, iwz=-1, icz=-1, ifz=-1;
POINT      gpoint[nmax];
int        gpolypolyline[255];
int        OtbRed,OtbGreen,OtbBlue;
//corrdinate
int        nxmin, nxmax, nymin, nymax, nvx, nvy,mode0;
//color
int        ir[nplmax], ig[nplmax], ib[nplmax];
int        l_full_color = FALSE;
//image
int        ix0, iy0, iy1, iy2, iy3, iwd, igpos, iend, igdata;
int        nline=16;
unsigned char*      img;
int        ui;
BITMAPINFO  bmi;

short   ipat[500][2],ipos[500],ilen[500];
short   nrec,iwdth;
unsigned char    idata[10000];
int     jwtrot=1;

void zmpline(void);
void zmfint_(float*, float*, int*, int*);
void zmcoini(int,int);
int OtbZMCOLOR2(int,int);
int zmqfcm();
void zmcmnt(int,char*);
void zmpcls_(int * ,int * ,int *);
void zmpause();
void zmspattern(int);
void zmihead(void);
void fsleep(int);
void zmgvpt(int,int,int,int);
void zmstat(void);
/*------------------------- device ------------------------*/

void zmdopn_(mode,width, height, iposx, iposy,
         lwait, lwait0, lwait1, lkey, lalt, ldump,lfgbg,
         clrmap, cbmmap, file, title)
    int *width, *height, *iposx, *iposy, *lwait, *lwait0, *lwait1,
    *lkey, *lalt, *ldump, *lfgbg;
    char clrmap[], cbmmap[], file[], title[];
    int *mode;
{
    int i;
    int ixmax,iymax;
    int rec_len;
    
    int bordcl, backcl, ncolor, n, m, msk;
    long int rx[MAXCLI], gx[MAXCLI], bx[MAXCLI],rx1,gx1,bx1;
    char c[80], cmapz[80], bmapz[80];

    FILE *stream;
    void cfnchr();


    posx      = *iposx;
    posy      = *iposy;
    wait      = *lwait;
    wait0     = *lwait0;
    wait1     = *lwait1;
    keymask   = *lkey;
    alternate = *lalt;
    dump      = *ldump;

    mode0 = *mode;
    ldisp = FALSE;
    if (mode0==1){ ldisp=TRUE; }
    cfnchr (dmpfile, file, 79);
    cfnchr (xtitle, title, 79);

/* window size */
    zmcoini(*width,*height);
/* jantle */
/* read colormap file */

    cfnchr (cmapz, clrmap, 79);
    if ((stream = fopen(cmapz, "r")) == NULL) {
    fprintf (stderr, "*** Error in zmdopn : ");
    fprintf (stderr,
         "Allocation failed for colormap (%s).\n", cmapz);
    exit (1);
    }
    fscanf (stream, "%d : %s", &ncolor, c);
    for (n = 0; n < ncolor; n++)
    fscanf(stream, "%6ld%6ld%6ld : %s", &ir[n], &ig[n], &ib[n], c);
    fclose(stream);

    if (fgbg) {
        rx1 = ir[0];
        gx1 = ig[0];
        bx1 = ib[0];
        ir[0] = ir[1];
        ig[0] = ig[1];
        ib[0] = ib[1];
        ir[1] = rx1;
        ig[1] = gx1;
        ib[1] = bx1;
    }


/* read bitmap file */

    cfnchr (bmapz, cbmmap, 79);
    if ((stream = fopen(bmapz, "rb")) == NULL) {
    fprintf (stderr, "*** Error in zmdopn : ");
    fprintf (stderr,
         "Allocation failed for bitmap (%s).\n", bmapz);
    exit (1);
    }
   fread(&rec_len,sizeof(int),1,stream);
   fread(&nrec,sizeof(short),1,stream);
   fread(&iwdth,sizeof(short),1,stream);
    for(i=0;i<500;i++){
        fread(&ipat[i][0],sizeof(short),1,stream);
    }
    for(i=0;i<500;i++){
        fread(&ipat[i][1],sizeof(short),1,stream);
    }
    for(i=0;i<500;i++){
        fread(&ipos[i],sizeof(short),1,stream);
    }
    for(i=0;i<500;i++){
        fread(&ilen[i],sizeof(short),1,stream);
    }
    for(i=0;i<10000;i++){
        fread(&idata[i],sizeof(char),1,stream);
    }

    fclose(stream);

/* open ( and activate ) workstation */

    zmcoini(*width,*height);

    if(mode0==1){
      OtbRes=OpenDCLWindow(*width, *height,mode0);
    }
    if(mode0==2){
      OtbRes=OpenDCLWindow(*width, *height,mode0);
      OtbRes=DCLGetDCSize(&ixmax,&iymax);
      *width  = ixmax;
      *height = iymax;
    }

    OtbRes=DCLBMPFilename(&dmpfile,3);

    zmcmnt(0, xtitle);

    laltz = *lalt;

    OtbRes=DCLNewPage(OtbZMCOLOR2(1,0),OtbZMCOLOR2(2,0),OtbZMCOLOR2(3,0));

    if(laltz){
      fsleep (300);
      OtbRes=DCLSwapWritePage();
      OtbRes=DCLNewPage(OtbZMCOLOR2(1,0),OtbZMCOLOR2(2,0),OtbZMCOLOR2(3,0));
    }

    zmgvpt(nxmin, nxmax, nymin, nymax);

}

void zmdcls_(lwait)
    int *lwait;
{
    if(*lwait){
      zmpause();
    }
    OtbRes=DCLExitProcess();

}

/*------------------------- page --------------------------*/

void zmpopn_()
{
    OtbRes=DCLNewPage(OtbZMCOLOR2(1,0),OtbZMCOLOR2(2,0),OtbZMCOLOR2(3,0));
}

void zmpcls_(lwait,ldump,laltz)
    int *lwait, *ldump, *laltz;
{
    char*   msgs;
    if(*ldump){
       OtbRes=DCLSwapBMPOutMode();
    }
    msgs="Completed.";
    zmcmnt(1,msgs);
    OtbRes=DCLPageUpdate();
    if(*laltz){
      OtbRes=DCLSwapActivePage();
      OtbRes=DCLSwapWritePage();
    }
    if(*lwait){
      zmpause();
    }
}

/*------------------------- object ------------------------*/

void zmoopn_(objname, comment,cobj_len,comm_len)
    char *objname, *comment;
    int  cobj_len,comm_len;
{
    char commentz[80];
    cfnchr(commentz,objname,cobj_len);
    zmcmnt(1, commentz);
}

void zmocls_(objname)
    char *objname;
{
}

/*------------------------- line --------------------------*/

void zmswdi_(iwdidx)
    int *iwdidx;
{
    iwidth = *iwdidx;
    if(iwidth == 0){
         iwidth = 1;
    }
    iwidth = (iwidth+1)/2;

}

void zmscli_(iclidx)
    int *iclidx;
{
    icolor = *iclidx;
}

void zmgopn_()
{

    if(zmqfcm()){
      if(i_rgb != ifz || iwidth != iwz){

        OtbRed=i_rgb / 16777216;
        i_rgb = i_rgb - OtbRed * 16777216;
        OtbGreen=i_rgb / 65536;
        i_rgb = i_rgb - OtbGreen * 65536;
        OtbBlue=i_rgb/256;

        OtbRes=ChangeDCLPen(iwidth,OtbRed,OtbGreen,OtbBlue);
        ifz = i_rgb;
        icz = -1;
        iwz = iwidth;
      }
    }else{
      if(icolor != icz || iwidth != iwz){
        OtbRes=ChangeDCLPen(iwidth,OtbZMCOLOR(1,icolor),OtbZMCOLOR(2,icolor),OtbZMCOLOR(3,icolor));
        icz = icolor;
        ifz = -1;
        iwz = iwidth;
      }
    }

}

void zmgmov_(wx, wy)
    float *wx, *wy;
{
    zmpline();
    ndata = 1;
    zmfint_(wx, wy, &ix[ndata], &iy[ndata]);
}

void zmgplt_(wx, wy)
    float *wx, *wy;
{
    ndata= ndata + 1;
    zmfint_(wx, wy, &ix[ndata], &iy[ndata]);
    if (ndata == nmax ) {
      zmpline();
      ix[1] = ix[ndata];
      iy[1] = iy[ndata];
      ndata = 1;
    }

}

void zmpline(){
    int i;
    if(ndata >= 2){

      gpolypolyline[0]=ndata;

      for(i=0;i<ndata;i++){
        gpoint[i].x=ix[i+1];
        gpoint[i].y=iy[i+1];
      }

      OtbRes=DCLPolyPolyLine(&gpoint[0],&gpolypolyline[0],1);

    }

}

void zmgcls_()
{
/* close graphic segment */
    zmpline();
    ndata = 0;
}

/*------------------------- tone --------------------------*/

void zmgton_(np, wpx, wpy, itpat)
    int *np, *itpat;
    float wpx[], wpy[];
{

    int   ix,iy,i;
    POINT *gpoint;
    int   gpolypolygon[1];

    gpoint=(POINT *)malloc(*np * sizeof(POINT));
    zmspattern(*itpat);

    gpolypolygon[0]=*np;

    for(i=0;i<*np;i++){
        zmfint_(&wpx[i], &wpy[i], &ix, &iy);
        gpoint[i].x=ix;
        gpoint[i].y=iy;
    }
    OtbRes=DCLPolyPolygon(&gpoint[0],&gpolypolygon[0],1);

    free(gpoint);

}

/*------------------------- image -------------------------*/

void zmiopn_(iwx, iwy, iwidth, iheight)
    int *iwx, *iwy, *iwidth, *iheight;
{
    ix0 = *iwx;
    iy0 = *iwy;
    iy3 = *iwy + *iheight -1;
    iwd = *iwidth;

    img=malloc(sizeof(char)*(*iwidth+4)*(*iheight)*4);

    iy1 = *iwy;
    zmihead();
 
}

void zmidat_(image, nlen)
    int *nlen, *image;
{
    int i;
    unsigned char a;
    for(i=0;i<*nlen;i++){
        igdata++;
        img[ui++]=OtbZMCOLOR2(3,image[i]);
        img[ui++]=OtbZMCOLOR2(2,image[i]);
        img[ui++]=OtbZMCOLOR2(1,image[i]);
        img[ui++]=0;
       if (igdata == iend) {
         OtbRes=DCLDrawImage(ix0,iy1,bmi.bmiHeader.biWidth, 
             -( bmi.bmiHeader.biHeight),&img[0],&bmi);
         iy1 = iy2 + 1;
         zmihead();
       }
    }



}

void zmicls_()
{
    free(img);
}

/*------------------------- mouse -------------------------*/

void zmqpnt_(wx, wy, mb)
    float *wx, *wy;
    int *mb;
{
}

/*---------------------- transformation -------------------*/

void zmfint_(wx, wy, iwx, iwy)
    float *wx, *wy;
    int *iwx, *iwy;
{

  *iwx=(int) *wx+0.5;
  *iwy=(int) *wy+0.5;
  *iwy=nvy-*wy;

}

void zmiint_(iwx, iwy, wx, wy)
    float *wx, *wy;
    int *iwx, *iwy;
{
    *wx = *iwx;
    *wy = nvy - *iwy;
}

/*------------------------- inquiry -----------------------*/

void zmqwdc_(lwdatr)
    int *lwdatr;
{
    *lwdatr = TRUE;
}

void zmqclc_(lclatr)
    int *lclatr;
{
/* inquire line color capability */
    *lclatr = TRUE;
}

void zmqtnc_(ltnatr)
    int *ltnatr;
{
/* inquire hard fill capability */
    *ltnatr = TRUE;
}

void zmqimc_(limatr)
    int *limatr;
{
/* inquire bit image capability */
    *limatr = TRUE;
}

void zmqptc_(lptatr)
    int *lptatr;
{
/* inquire mouse point capability */

    *lptatr = FALSE;
}

void zmqrct_(wsxmn, wsxmx, wsymn, wsymx, fact)
    float *wsxmn, *wsxmx, *wsymn, *wsymx, *fact;
{

/* inquire workstation rectangle */
    int idpi;

    *wsxmn = 0;
    *wsxmx = nvx;
    *wsymn = 0;
    *wsymx = nvy;
    *fact  = 10;

   if(mode0==1){
      *fact  = 20./(float) nvy;
   }else{
      OtbRes=DCLGetPrintBMPdpi(&idpi);
      *fact = 2.54/idpi;
   }

}

void zmsrot_(iwtrot)
    int *iwtrot;
{
/* set frame rotation flag */
    jwtrot = *iwtrot;
}

/*---------------------internal function ------------------*/

void zmbmcv_(nx, ny, bmline, bitmap)
    int *nx, *ny;
    char bmline[], bitmap[];
{
    static int n8 = 8;
    int n, nb;
    unsigned bx;

    nb = *nx * *ny / n8;
    for (n = 0; n < nb; n++){
    sscanf(&bmline[2*n], "%2x", &bx);
    bitmap[n] = bx;
    }
    bitmap[nb] = '\0';
}

void zmcoini(iwidth,iheight){
    nvx    = iwidth - 1;
    nxmin  = 0;
    nxmax  = nxmin + nvx;

    nvy    = iheight - 1;
    nymin  = 0;
    nymax  = nymin + nvy;
}

int OtbZMCOLOR(index,number){
    if(number==0){
        return 0;
    }
    if(index==1){
        return ir[number]/256;
    }else if(index==2){
        return ig[number]/256;
    }
    return ib[number]/256;

}

int OtbZMCOLOR2(index,number){
    if(index==1){
        return ir[number]/256;
    }else if(index==2){
        return ig[number]/256;
    }
    return ib[number]/256;
}

int zmqfcm(){
    return l_full_color;
}

void zmcmnt(ipos,comment)
    int ipos;
    char* comment;
{
    char commentz[80];
    cfnchr (commentz, comment, 79);

    if(ipos==0){
        OtbRes=DCLTitleBarString(comment);
    }else{
        OtbRes=DCLStatusBarString(comment,0);
    }
}

void zmpause(){
    int ix,iy,idat;

    while(1){
      OtbRes=DCLGetMouseClick(&mf);
      idat = mf.bMouseClick;
      ix = mf.xPos;
      iy = mf.yPos;

      OtbRes=DCLGetKeyCode(&kc);

      if(kc == 16){
        OtbRes=DCLExitProcess();
        exit(0);
      }else if(idat==1 || kc != 0){
        break;
      }
    }
    fsleep (100);

}

void zmspattern(ipatan){

    unsigned short     int2;
    short              int2s;

    int   itpz=-1, ifz=-1, icz=-1;
    char  cmsg[64],cmsg2[64];
    short Otb_BmpPat[128];

    int   icol,itptn,itrec,i,j;
    int   jlen,iword,KOtb,jpos;

    icol  = ipatan / 1000;
    itptn = ipatan - icol*1000;
    if(zmqfcm()){
      if((itptn==itpz) && (i_rgb==ifz)) return;
      ifz = i_rgb;
      icz = -1;
    }else{
      if((itptn==itpz) && (icol==icz)) return;
      icz = icol;
      ifz = -1;
    }
    itpz = itptn;

    itrec = 0;
    while (ipat[itrec][jwtrot] != itptn){
      itrec = itrec + 1;
      if(itrec > nrec) {
        strcpy(cmsg,"***Warning*** (zmspattern) pattern (");
        sprintf(cmsg2,"%5d",itptn);
        strcat(cmsg,cmsg2);
        strcat(cmsg,") is not defined.");
        printf("%s\n",cmsg);
        break;
      }
    }

    jlen = ilen[itrec];

    iword = iwdth/8;
    KOtb=0;
    for(  i=0; i<iwdth ; i++){
      for( j=0; j<iword ; j++){
        jpos = ipos[itrec] + ((i*iword+j)%(jlen*iword)) - 1;
        int2 = idata[jpos];
        Otb_BmpPat[KOtb++] = ~int2;
      }
    }

    if(zmqfcm()){
        OtbRed=i_rgb / 16777216;
        i_rgb = i_rgb - OtbRed * 16777216;
        OtbGreen=i_rgb / 65536;
        i_rgb = i_rgb - OtbGreen * 65536;
        OtbBlue=i_rgb/256;
        OtbRes=ChangeDCLBrush(&Otb_BmpPat[0],iwdth,OtbRed,OtbGreen,OtbBlue);
    }else{
     OtbRes=ChangeDCLBrush(&Otb_BmpPat[0],iwdth, 
               OtbZMCOLOR(1,icol),OtbZMCOLOR(2,icol),OtbZMCOLOR(3,icol));
    }

}
void zmgvpt(ixmin,ixmax,iymin,iymax)
{
    ixmin = nxmin;
    ixmax = nxmax;
    iymin = nymin;
    iymax = nymax;
}

void zmihead(){
    int ifrac,iht;
    char  cmsg[64],cmsg2[64];
 
    ifrac = (iy1-iy0)*100/(iy3-iy0);
    strcpy(cmsg,"image:");
    sprintf(cmsg2,"%3d",ifrac);
    strcat(cmsg,cmsg2);
    strcat(cmsg,"%");
    zmcmnt(1,cmsg);

    iy2 = min(iy3, iy1+nline-1);
    iht = iy2 - iy1 + 1;
    if(iht != 0) {
      bmi.bmiHeader.biSize          = 40;
      bmi.bmiHeader.biPlanes        = 1;
      bmi.bmiHeader.biWidth         = iwd;
      bmi.bmiHeader.biHeight        = -iht;
      bmi.bmiHeader.biBitCount      = 32;
      bmi.bmiHeader.biClrImportant  = 0;
      bmi.bmiHeader.biClrUsed       = 0;
      bmi.bmiHeader.biCompression   = BI_RGB;
      bmi.bmiHeader.biSizeImage     = 0;
      bmi.bmiHeader.biXPelsPerMeter = 0;
      bmi.bmiHeader.biYPelsPerMeter = 0;

      igdata = 0;
      iend = iwd*iht;

      ui=0;

    }
}
void zmstat(){

    int ixdpi,iydpi,ixsize,iysize,ibdpi;

    OtbRes=DCLGetPrinterdpi(&ixdpi,&iydpi);
    OtbRes=DCLGetPrinterSize(&ixsize,&iysize);
    OtbRes=DCLGetPrintBMPdpi(&ibdpi);

    printf(" --- PRINTER RESOLUSION : %d %d\n",ixdpi,iydpi);
    printf(" --- PRINTABLE SIZE     : %d %d\n",ixsize,iysize);
    printf(" --- PRINTING DPI       : %d   \n",ibdpi);
}

void fsleep(nt){
    _sleep(nt);
}

