#
# u2df03.rb
#
# $Id: u2df03.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 19
ny = 19
xmin = 0
xmax = 360
dx1 = 10
dx2 = 60
ymin = -90
ymax = 90
my = 7
nc = 3
drad = PI/180
dz = 0.05

XMNZ = 60
XMXZ = 300
NXZ = 13
NYZ = 13
IXZ1 = 4
IYZ1 = 4

p = NArray.sfloat(nx, ny)
uy1 = NArray.sfloat(ny)
uy2 = NArray.sfloat(my)

#-- data ---
ch = ['SP ', '60S', '30S', 'EQ ', '30N', '60N', 'NP ']

for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

uy1.indgen(ymin, (ymax-ymin)/(ny-1).to_f)
uy1 = NMath.sin(uy1*drad)
uy2.indgen(ymin, (ymax-ymin)/(my-1).to_f)
uy2 = NMath.sin(uy2*drad)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, uy1[0], uy1[ny-1])
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::uxaxdv('B', dx1, dx2)
DCL::uxaxdv('T', dx1, dx2)
DCL::uxsttl('B', 'LONGITUDE', 0.0)

DCL::uyaxlb('L', uy1, uy2, ch, nc)
DCL::uyaxlb('R', uy1, uy2, ch, nc)
DCL::uysttl('L', 'LATITUDE', 0.0)

DCL::uwsgxb(XMNZ, XMXZ, NXZ)
DCL::uwsgya(uy1[(IYZ1-1)..-1])

DCL::udcntr(p[(IXZ1-1)..-1,(IYZ1-1)..-1])

DCL::grcls

