module NumRu
  module DCLExt
    module Anim

      class Source

        include Anim

        def initialize(pixmap, pipe)
          @pixmap = pixmap
          @pipe = pipe
          @first_frame = true
        end

        def new_frame
          if @first_frame
            @first_frame = false
          else
            put_data
          end
        end

        def close
          put_data unless @first_frame
          @pipe.close
        end


        private
        def put_data
          pixbuf = Gdk::Pixbuf.from_drawable(nil, @pixmap, 0, 0, width, height)
          @pipe.write pixbuf.pixels
        end

      end # class DCL

    end # module Anim
  end # module DCLExt
end # module NumRu
