#
# kihon4.rb
#   $Id: kihon4.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 9
x1 = 0.1
xc = 0.5
x2 = 0.9

y = NArray.sfloat(nmax)

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws
DCL::sgfrm

#-- line ----
for n in 0..nmax-1
  y[n] = 0.1*(9-n)
  DCL::sglnv(x1, y[n], x2, y[n])
end

DCL::sglnv(xc, 0.05, xc, 0.95)

#-- default ----
DCL::sgtxv(xc, y[0], 'SGTXV')

#-- text line index ----
DCL::sgstxi(3)
DCL::sgtxv(xc, y[1], 'INDEX3')

DCL::sgstxi(5)
DCL::sgtxv(xc, y[2], 'INDEX5')

DCL::sgstxi(1)

#-- text size ----
DCL::sgstxs(0.03)
DCL::sgtxv(xc, y[3], 'SMALL')

DCL::sgstxs(0.07)
DCL::sgtxv(xc, y[4], 'LARGE')

DCL::sgstxs(0.05)

#-- text centering option ----
DCL::sgstxc(-1)
DCL::sgtxv(xc, y[5], 'LEFT')

DCL::sgstxc(1)
DCL::sgtxv(xc, y[6], 'RIGHT')

DCL::sgstxc(0)

#-- text rotation ----
DCL::sgstxr(10)
DCL::sgtxv(xc, y[7], 'ROTATION+')

DCL::sgstxr(-10)
DCL::sgtxv(xc, y[8], 'ROTATION-')

DCL::sgcls

