#ifdef WINDOWS
#include <io.h>
#include <fcntl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../../../config.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <cairo.h>
#include <cairo-ps.h>
#include <cairo-pdf.h>
#include <cairo-svg.h>

static DCL_REAL rwxold, rwyold;

#define FACTZ  0.03          /* scaling factor */

#ifndef TRUE
#define TRUE   -1             /* numeric value for true  */
#endif
#ifndef FALSE
#define FALSE  0             /* numeric value for false */
#endif

#define PAD    2.0           /* padding for workstation window */
#define LWDATR TRUE          /* line width  capability */
#define LCLATR TRUE          /* line color  capability */
#define LTNATR TRUE          /* hard fill   capability */
#define LIMATR TRUE          /* bit image   capability */
#define LPTATR FALSE         /* mouse point capability */

#define MAXWDI 9             /* maximum number of line index */
#define MAXCLI 255           /* maximum number of line color */
#define MAXBMP 300           /* maximum number of bitmaps */

#define DOPN  1
#define DCLS  2
#define PCLS  3

#define IWS_DISP  1
#define IWS_FILE  2

#define IFL_EPS   2
#define IFL_PNG   1
#define IFL_SVG   3
#define IFL_PDF   4



//static double linewidth[MAXWDI] = { 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0 };
static double linewidth[MAXWDI] = { 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0 };

static int iwidth,iheight;
static int iwdidz;           /* pen width */
static int iclidz;           /* pen color index */
static int iwtroz;           /* direction of frame */
static int lclatrz = TRUE;          /* type of screen */
//static int imagewrite = FALSE;          /* (Not) Use Image buffer Surface */
static int idev_type;         /* absolute value of type of device 1:Display 2:Files */
                              /*1:png 2:eps 3:SVG 4:PDF */
static int jdev_type;         /* type of device (landscape or portlait) 1:Display 2:Files */
                              /*1:png 2:eps 3:SVG 4:PDF */
static int wsxwd, wsywd, wsxmnz,wsymnz;
// wsxmxz, , wsymxz;
static int ixz, iyz, iwz, ihz, ixxz, iyyz, page; /* for image */
static int irxt,iryt,irxb,iryb,irwidth; /* for Invalidate */
static int posx, posy, wait_np, wait_op, wait_cl, key, dump, fgbg, sep;
static int nbmap, nn1[MAXBMP], nn2[MAXBMP], nx[MAXBMP], ny[MAXBMP];
static char dmpfile[80], xtitle[80];
static char bmline[MAXBMP][260];
static int lfcmod = FALSE;

static int lfirst = TRUE;
static int ltfrst = TRUE;

static int laltz = FALSE;

static int pactive;

static GdkGC *gc;
static GdkGC *gct;
static GtkWidget *window = NULL;
static GtkWidget *drawing_area = NULL;

static int ldclonly = FALSE;

static int wnd;

//Name Should be change (cr(cairo surface ) to cairo cr)
static cairo_t *cr;
static cairo_surface_t *csr;

//Font
gchar     *fontfamily;
PangoFontDescription *font_desc;

static char defaultfont[]="Sans Normal 12";
//imagemode surface
////static cairo_t *cri;
static cairo_surface_t *csi;

static char imgfmt[8];
static DCL_REAL imgcmp;

static GdkColor cx[MAXCLI];

static int ifunc, next;
static int dumpz = FALSE;

/* Post Script A4 Page (Landscape) */
static int PS_PAGE_WIDTH  = 595;
static int PS_PAGE_HEIGHT = 842;

static int iPS_PAGE_WIDTH;
static int iPS_PAGE_HEIGHT;

static double ipsx=33;
static double ipsy=46;

static double ddvscale = 1.0;
static double dlnscale;
static double offx = 0.0;
static double offy = 0.0;

/* For BITMAP Image */
static unsigned char * pixels;
static int rows;

static int dmpdgt;
static int pngstdout;
static int ifl;

static cairo_status_t png2stdout(void *, const unsigned char* , unsigned int );
static void zgcatl(void);

static char fontlist[255] = { 41, 42, 43, 44, 55, 66, 77, 85, 95 };

/*---------------------- transformation -------------------*/
#ifndef WINDOWS
void zgfint_(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *iwx, DCL_INT *iwy)
#else
void ZGFINT(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *iwx, DCL_INT *iwy)
#endif
{

    *iwx = *wx + 0.5;
    *iwy = wsywd - *wy + 0.5;
}

#ifndef WINDOWS
void zgfrel_(DCL_REAL *wx, DCL_REAL *wy, DCL_REAL *rwx, DCL_REAL *rwy)
#else
void ZGFREL(DCL_REAL *wx, DCL_REAL *wy, DCL_REAL *rwx, DCL_REAL *rwy)
#endif
{

  *rwx = *wx + 0.5;
  *rwy = wsywd - *wy + 0.5;

  *rwx = *rwx * ddvscale;
  *rwy = *rwy * ddvscale;

}

#ifndef WINDOWS
void zgiint_(DCL_INT *iwx, DCL_INT *iwy, DCL_REAL *wx, DCL_REAL *wy)
#else
void ZGIINT(DCL_INT *iwx, DCL_INT *iwy, DCL_REAL *wx, DCL_REAL *wy)
#endif
{
  *wx = *iwx;
  *wy = wsywd - *iwy;
}

/*------------------------- GDK 設定 ------------------------*/

void zgupdate(int flag)
{
    GdkRectangle update_rect;

    if (idev_type==IWS_DISP){
      update_rect.x = irxb-1;
      update_rect.y = iryb-1;
      update_rect.width  = irxt-irxb+1;
      update_rect.height = iryt-iryb+1;

      if (irxb == 0 && irxt == 0 && iryb == 0 && iryt == 0 && flag == 0){
        update_rect.x = 0;
        update_rect.y = 0;
        update_rect.width  = wsxwd;
        update_rect.height = wsywd;
      }

      while (gtk_events_pending()) gtk_main_iteration();

      gtk_widget_draw(drawing_area, &update_rect);

      irxt = 0;
      irxb = 0;
      iryt = 0;
      iryb = 0;
    }
}
/*--------------------- internal function -------------------*/

void zguprect(int ix,int iy){
	if ((ix-irwidth) < irxb || irxb == 0) irxb =ix-irwidth;
	if ((ix+irwidth) > irxt ) irxt =ix+irwidth;
	if ((iy-irwidth) < iryb || iryb == 0) iryb =iy-irwidth;
	if ((iy+irwidth) > iryt ) iryt =iy+irwidth;
}


/*-----------------------------------------------*/
gint zg_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
static cairo_t *cre;

  if (idev_type==IWS_DISP){
//    cre = gdk_cairo_create (drawing_area->window);
    cre = gdk_cairo_create (widget->window);
    cairo_set_source_surface(cre,csr,0,0);
    cairo_paint(cre);
    cairo_destroy(cre);
  }

  return FALSE;
}

gint zg_key_press_event(GtkWidget *widget, GdkEventKey *event)
{
  switch (ifunc){
  case DOPN:
    next = TRUE;
    break;

  case DCLS:
    switch (event->keyval) {
    case GDK_space:
    case GDK_Return:
      next = TRUE;
      break;
    default:
      next = FALSE;
    }
    break;

  case PCLS:
    switch (event->keyval) {
    case GDK_w:
      wait_np = TRUE;
      break;
    case GDK_Return:
    case GDK_space:
      next = TRUE;
      break;
    case GDK_d:
      next = TRUE;
      dumpz = TRUE;
      break;
    case GDK_s:
      next = TRUE;
      wait_np = FALSE;
      break;
    case GDK_q:
      gtk_exit(0);
      exit(0);
    default:
      next = FALSE;
    }
    break;

  default:
    next = FALSE;
  }

  return TRUE;
}

gint zg_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
  switch (ifunc){
  case DOPN:
  case DCLS:
  case PCLS:
    next = TRUE;
    break;

  default:
    next = FALSE;
  }

  return TRUE;
}

gint zg_destroy_event(GtkWidget *widget, GdkEventButton *event)
{
      gtk_exit(0);
      exit(0);

  return TRUE;
}

/*-----------------------------------------------*/
#ifndef WINDOWS
static GtkWidget *zggdrw_(DCL_INT *width, DCL_INT *height)
#else
static GtkWidget *ZGGDRW(DCL_INT *width, DCL_INT *height)
#endif
{
  GtkWidget * drw;
  GtkWidget *vbox;

  gtk_init(0,NULL);

  drw = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA (drw), wsxwd, wsywd);
  gtk_widget_show(drw);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), xtitle);
  gtk_container_add(GTK_CONTAINER (window), drw);

  if (!wnd)
    gtk_widget_realize(drw);
  else {
    if (key){
      gtk_widget_set_events(window, GDK_BUTTON_PRESS_MASK|GDK_KEY_PRESS_MASK);
      gtk_signal_connect(GTK_OBJECT (window), "key_press_event",
			 (GtkSignalFunc) zg_key_press_event, NULL);
    } else
      gtk_widget_set_events(window, GDK_BUTTON_PRESS_MASK);

    gtk_signal_connect(GTK_OBJECT (window), "button_press_event",
		       (GtkSignalFunc) zg_button_press_event, NULL);

    gtk_widget_set_events(drw, GDK_EXPOSURE_MASK);
    gtk_signal_connect(GTK_OBJECT (drw), "expose_event",
		       (GtkSignalFunc) zg_expose_event, NULL);

    gtk_signal_connect(GTK_OBJECT (window), "destroy",
		       (GtkSignalFunc) zg_destroy_event, NULL);

    gtk_widget_show(window);
  }

  return drw;
}

#ifndef WINDOWS
GtkWidget *zgqdrw_(void)
#else
GtkWidget *ZGQDRW(void)
#endif
{
  return drawing_area;
}

static cairo_t *zgcsfc(){
  cairo_t *cro;
  char cout[64];

  if (idev_type == IWS_DISP){
    csr = cairo_image_surface_create(CAIRO_FORMAT_ARGB32,wsxwd,wsywd);
  }else if (idev_type == IWS_FILE){
    if(ifl == IFL_EPS){
      ddvscale = 1.0;
      if (page != 0){
        sprintf (cout, "%s_%0*d.eps", dmpfile,dmpdgt, page);
        csr = cairo_ps_surface_create(cout, PS_PAGE_HEIGHT * ddvscale, PS_PAGE_WIDTH * ddvscale );
        cairo_ps_surface_set_eps(csr,TRUE);
      }
      linewidth[0] =  2.0;
      linewidth[1] =  4.0;
      linewidth[2] =  6.0;
      linewidth[3] =  8.0;
      linewidth[4] = 10.0;
      linewidth[5] = 11.0;
      linewidth[6] = 12.0;
      linewidth[7] = 13.0;
      linewidth[8] = 14.0;
    }else if(ifl == IFL_PNG){
      csr = cairo_image_surface_create(CAIRO_FORMAT_ARGB32,wsxwd,wsywd);
    }else if(ifl == IFL_SVG){
      if (page != 0){
        sprintf (cout, "%s_%0*d.svg", dmpfile,dmpdgt, page);
        csr = cairo_svg_surface_create(cout,wsxwd,wsywd);
      }
    }else if (ifl == IFL_PDF){
      ddvscale = 1.0;
      if ( !sep ){
        sprintf (cout, "%s.pdf", dmpfile,dmpdgt, page);
      } else if ( page != 0 ){
        sprintf (cout, "%s_%0*d.pdf", dmpfile,dmpdgt, page);
      }
      csr = cairo_pdf_surface_create(cout, PS_PAGE_WIDTH * ddvscale, PS_PAGE_HEIGHT * ddvscale );
/*      linewidth[0] =  2.0;
      linewidth[1] =  4.0;
      linewidth[2] =  6.0;
      linewidth[3] =  8.0;
      linewidth[4] = 10.0;
      linewidth[5] = 11.0;
      linewidth[6] = 12.0;
      linewidth[7] = 13.0;
      linewidth[8] = 14.0; */
/*      linewidth[0] =  1.0;
      linewidth[1] =  2.0;
      linewidth[2] =  2.0;
      linewidth[3] =  3.0;
      linewidth[4] = 3.0;
      linewidth[5] = 4.0;
      linewidth[6] = 4.0;
      linewidth[7] = 5.0;
      linewidth[8] = 5.0;*/
    }
  }

  cro = cairo_create(csr);

  cairo_pattern_set_filter(cairo_get_source(cro), CAIRO_FILTER_NEAREST);

  cairo_set_source_rgb(cro,1.0,1.0,1.0);

  return cro;
}

/*-----------------------------------------------*/
static void zgbmcv(int *nx, int *ny, char bmline[], char bitmap[])
{
  static int n8 = 8;
  int n, nb;
  unsigned bx;

  nb = *nx * *ny / n8;

  for (n = 0; n < nb; n++){
    sscanf(&bmline[2*n], "%2x", &bx);
    bitmap[n] = bx;
  }
  bitmap[nb] = '\0';
}

/*------------------------- device ------------------------*/
#ifndef WINDOWS
void zgdopn_(DCL_INT *dev_type,
             DCL_INT *width, DCL_INT *height, DCL_INT *iposx, DCL_INT *iposy, DCL_INT *idmpdgt,
             DCL_INT *ibgpage,DCL_REAL *rlwfact,
             DCL_INT *lwait, DCL_INT *lwait0, DCL_INT *lwait1, DCL_INT *lalt , DCL_INT *lstdot,
             DCL_INT *lkey, DCL_INT *ldump, DCL_INT *lwnd, DCL_INT *lfgbg, DCL_INT *lsep, DCL_INT *ifln,
             char cimgfmt[], DCL_REAL *rimgcmp, char clrmap[], char cbmmap[], char file[], char title[]
             )
#else
void ZGDOPN(DCL_INT *dev_type,
            DCL_INT *width, DCL_INT *height, DCL_INT *iposx, DCL_INT *iposy, DCL_INT *idmpdgt,
            DCL_INT *ibgpage, DCL_REAL *rlwfact,
            DCL_INT *lwait, DCL_INT *lwait0, DCL_INT *lwait1, DCL_INT *lalt,DCL_INT *lstdot,
            DCL_INT *lkey, DCL_INT *ldump, DCL_INT *lwnd, DCL_INT *lfgbg, DCL_INT *lsep, DCL_INT *ifln,
            char cimgfmt[], DCL_REAL *rimgcmp, char clrmap[], char cbmmap[], char file[], char title[]
            )
#endif
{
  void cfnchr();

  int ncolor, n, m ,fscanret;

  guint16 rx[MAXCLI], gx[MAXCLI], bx[MAXCLI], rx1, gx1, bx1;
  char c[80], cmapz[80], bmapz[80];

  FILE *stream;

  GdkVisual *vis;

  GdkRectangle update_rect;
  GdkEvent *ev;

  double rt1,gt1,bt1;

  fontfamily=defaultfont;
  font_desc = pango_font_description_from_string ("Sans Normal 12");

  posx      = *iposx;
  posy      = *iposy;
  wait_np   = *lwait;
  wait_op   = *lwait0;
  wait_cl   = *lwait1;
  key       = *lkey;
  dump      = *ldump;
  fgbg      = *lfgbg;
  sep       = *lsep;
  laltz     = *lalt;
  idev_type = abs(*dev_type);
  jdev_type = *dev_type;
  wnd       = *lwnd;
  page      = *ibgpage - 1;

  cfnchr(imgfmt, cimgfmt, 7);
  imgcmp = *rimgcmp;
  dmpdgt = *idmpdgt;
  pngstdout  = *lstdot;
  ifl  = *ifln;

  iwidth = *width;
  iheight = *height;

  dlnscale = *rlwfact;

  if ((idev_type == IWS_FILE) && ( ifl == IFL_EPS || ifl == IFL_PDF)){
    if (((PS_PAGE_HEIGHT - ipsy *2) / iwidth) > ((PS_PAGE_WIDTH - ipsx *2 )/ iheight)){
      iPS_PAGE_WIDTH   = PS_PAGE_WIDTH - ipsx * 2;
      iPS_PAGE_HEIGHT  = (PS_PAGE_WIDTH - ipsx * 2) * iwidth / iheight;
      offx = ipsx;
      offy = ipsy + (PS_PAGE_HEIGHT - ipsy *2 - iPS_PAGE_HEIGHT )/2;
      if(dlnscale==999.){
        dlnscale = (DCL_REAL)iPS_PAGE_WIDTH / iwidth ;
      }
    }else{
      iPS_PAGE_WIDTH   = (PS_PAGE_HEIGHT -ipsy*2) * iheight / iwidth;
      iPS_PAGE_HEIGHT  = PS_PAGE_HEIGHT - ipsy*2;
      offx = ipsx + (PS_PAGE_WIDTH  - ipsx *2 - iPS_PAGE_WIDTH)/2;
      offy = ipsy;
      if(dlnscale==999.){
        dlnscale = (DCL_REAL)iPS_PAGE_HEIGHT/iheight;
      }
    }
    if( ifl == IFL_EPS ){
      dlnscale=0.1;
    }
  }else{
    dlnscale = 1.0;
  }

  if (!wnd) {
    wait_np = FALSE;
    wait_op = FALSE;
    wait_cl = FALSE;
    dump    = TRUE;
  }

  cfnchr(dmpfile, file, 79);
  cfnchr(xtitle, title, 79);

  /* check drawing_area, if not set, stop */

  if (idev_type == IWS_DISP){
    if (drawing_area == NULL) {
      ldclonly = TRUE;
      wsxwd  = iwidth  + 2 * PAD;  /* window width */
      wsywd  = iheight + 2 * PAD;  /* window height */
      wsxmnz = PAD + offx;                /* lower-left  corner */
      wsymnz = PAD + offy;                /* lower-left  corner */
#ifndef WINDOWS
      drawing_area = zggdrw_(width,height);
#else
      drawing_area = ZGGDRW(width,height);
#endif
    }
  }else if (idev_type == IWS_FILE){
    if(ifl == IFL_EPS || ifl == IFL_PDF){
    wsywd = iPS_PAGE_WIDTH * ddvscale;
    wsxwd = iPS_PAGE_HEIGHT * ddvscale;
    wsymnz = offx * ddvscale;
    wsxmnz = offy * ddvscale;
    }else if(ifl == IFL_PNG || ifl == IFL_SVG ){
    wsxwd  = iwidth  + 2 * PAD;  /* window width */
    wsywd  = iheight + 2 * PAD;  /* window height */
    wsxmnz = PAD + offx;                /* lower-left  corner */
    wsymnz = PAD + offy;                /* lower-left  corner */
    }
  }
#ifdef WINDOWS
 if (pngstdout){
   _setmode(_fileno(stdout),_O_BINARY);
 }
#endif

  /* read colormap file */

  cfnchr(cmapz, clrmap, 79);
  if ((stream = fopen(cmapz, "r")) == NULL) {
    fprintf(stderr, "*** Error in zgdopn : ");
    fprintf(stderr,
	    "Allocation failed for colormap (%s).\n", cmapz);
    exit (1);
  }

  fscanret=fscanf(stream, "%d : %s", &ncolor, c);
  for (n = 0; n < ncolor; n++)
    fscanret=fscanf(stream, "%6hd%6hd%6hd : %s", &rx[n], &gx[n], &bx[n], c);
  fclose(stream);

  if (fgbg) {
    rx1 = rx[0];
    gx1 = gx[0];
    bx1 = bx[0];
    rx[0] = rx[1];
    gx[0] = gx[1];
    bx[0] = bx[1];
    rx[1] = rx1;
    gx[1] = gx1;
    bx[1] = bx1;
  }

  /* read bitmap file */

  cfnchr (bmapz, cbmmap, 79);

  if ((stream = fopen(bmapz, "r")) == NULL) {
    fprintf(stderr, "*** Error in zgdopn : ");
    fprintf(stderr,
	     "Allocation failed for bitmap (%s).\n", bmapz);
    exit (1);
  }

  fscanret=fscanf(stream, "%d", &nbmap);
  for (n = 0; n < nbmap; n++)
    fscanret=fscanf(stream, "%4d%4d%3d%3d%s",
	   &nn1[n], &nn2[n], &nx[n], &ny[n], bmline[n]);
  fclose(stream);

  /* set colormap */
  for (n = 0; n < MAXCLI; n++) {

      m = n % ncolor;

      cx[n].red   = rx[m];
      cx[n].green = gx[m];
      cx[n].blue  = bx[m];
  }

  if (ldclonly) {

    cr =zgcsfc();
    zgupdate(0);

    if (wait_op) {
      next = FALSE;
      ifunc = DOPN;
      while (1) {
	gtk_main_iteration();
	if (next)
	  break;
      }
    }

  }else{
     cr =zgcsfc();
  }

  if (idev_type == IWS_FILE && ifl == IFL_PDF){
    zgcatl();
}

  rt1 = (double) cx[0].red   / 65535 ;
  gt1 = (double) cx[0].green / 65535 ;
  bt1 = (double) cx[0].blue  / 65535 ;
  cairo_set_source_rgb(cr,rt1,gt1,bt1);
}

#ifndef WINDOWS
void zgdcls_(void)
#else
void ZGDCLS(void)
#endif
{
  /* device closing proc. */

  GdkEvent *ev;

  if (ldclonly) {
    if (!wait_np && wait_cl) {
      next = FALSE;
      ifunc = DCLS;
      while (1) {
	gtk_main_iteration();
	if (next)
	  break;
      }

      gtk_widget_destroy(window);
      window = NULL;
    }
  }
  if (idev_type == IWS_FILE){
    if(ifl==IFL_EPS || ifl == IFL_SVG ){
    }else if(ifl==IFL_PNG){
      cairo_destroy(cr);
      cairo_surface_destroy (csr);
    }else if (ifl == IFL_PDF){
      if(!sep){
        cairo_destroy(cr);
        cairo_surface_finish (csr);
        cairo_surface_destroy (csr);
      }
    }
 }

}

/*------------------------- page --------------------------*/

#ifndef WINDOWS
void zgpopn_(void)
#else
void ZGPOPN(void)
#endif
{
  cairo_t *cro;
  double rt1,gt1,bt1;
  char cout[64];

  /* background drawing proc. */
  ++page;

  pactive=1;

  iwdidz = 1;
  iclidz = 1;

   if (idev_type == IWS_DISP){
     cro = cairo_create(csr);
   }else if (idev_type == IWS_FILE){
     if(ifl==IFL_EPS){
       cr=zgcsfc();
       cro = cairo_create(csr);
     }else if(ifl ==IFL_PNG){
       cro = cairo_create(csr);
     }else if(ifl ==IFL_SVG){
       cr=zgcsfc();
       cro = cairo_create(csr);
     }else if (ifl == IFL_PDF){
       if(sep){
         cr=zgcsfc();
         zgcatl();
       }
       cro = cairo_create(csr);
     }
  }

  rt1 =(double) cx[0].red   / 65535;
  gt1 =(double) cx[0].green / 65535;
  bt1 =(double) cx[0].blue  / 65535;

  cairo_set_source_rgb(cro,rt1,gt1,bt1);

  if (idev_type == IWS_DISP || ( idev_type == IWS_FILE && ifl == IFL_PNG)){
     cairo_rectangle(cro,0.0,0.0,wsxwd,wsywd);
     cairo_fill(cro);
     if(!laltz){
       zgupdate(0);
    }
  }

  cairo_destroy(cro);

}

#ifndef WINDOWS
void zgpcls_(void)
#else
void ZGPCLS(void)
#endif
{

  /* event loop */

  char cout[64];

  char* opt_key[2];
  char* opt_val[2];

  char cnum[4];

  if (ldclonly) {

    zgupdate(0);

    if (wait_np) {
      dumpz = FALSE;
      next = FALSE;
      ifunc = PCLS;
      while (1) {
	gtk_main_iteration();
	if (next)
	  break;
      }
    }
    if (dump || dumpz) {
      sprintf (cout, "%s_%0*d.%s", dmpfile,dmpdgt, page, imgfmt);
      opt_key[0] = NULL;
      opt_key[1] = NULL;
      if (imgcmp>=0.0 && imgcmp<=1.0) {
	if (strcmp(imgfmt, "png")==0) {
	  opt_key[0] = "compression";
          sprintf(cnum, "%d", (int)(imgcmp*9));
	  opt_val[0] = cnum;
	} else if (strcmp(imgfmt, "jpeg")==0) {
	  opt_key[0] = "quality";
	  sprintf(cnum, "%d", (int)((1-imgcmp)*100));
	  opt_val[0] = cnum;
	}
      } else if (imgcmp>1.0) {
	fprintf(stderr, " *** Error in zgdopn : ");
	fprintf(stderr,
		"Image compression must be 0-1.\n");
      }
      cairo_surface_write_to_png(csr,cout);
    }
  }
  if ( idev_type == IWS_FILE && pactive){
    if(ifl==IFL_EPS || ifl == IFL_SVG){
      cairo_surface_show_page (csr);
      cairo_destroy(cr);
      cairo_surface_destroy(csr);
    }else if(ifl==IFL_PNG){
      if(pngstdout){
        cairo_surface_write_to_png_stream(csr,png2stdout,stdout);
      }else{
        sprintf (cout, "%s_%0*d.%s", dmpfile,dmpdgt, page, imgfmt);
        opt_key[0] = NULL;
        opt_key[1] = NULL;
        if (imgcmp>=0.0 && imgcmp<=1.0) {
          if (strcmp(imgfmt, "png")==0) {
            opt_key[0] = "compression";
            sprintf(cnum, "%d", (int)(imgcmp*9));
            opt_val[0] = cnum;
          }else if (strcmp(imgfmt, "jpeg")==0){
            opt_key[0] = "quality";
            sprintf(cnum, "%d", (int)((1-imgcmp)*100));
            opt_val[0] = cnum;
          }
        }else if (imgcmp>1.0) {
          fprintf(stderr, " *** Error in zgdopn : ");
          fprintf(stderr,"Image compression must be 0-1.\n");
        }
        cairo_surface_write_to_png(csr,cout);
      }
    }else if ( ifl == IFL_PDF){
        cairo_show_page (cr);
        if( sep ){
          cairo_destroy(cr);
          cairo_surface_destroy(csr);
        }
    }
  }
  pactive=0;


}

/*------------------------- object ------------------------*/

#ifndef WINDOWS
void zgoopn_(char *objname, char *comment)
#else
void ZGOOPN(char *objname, char *comment)
#endif
{
  /* for long-type message? */
}

#ifndef WINDOWS
void zgocls_(char *objname)
#else
void ZGOCLS(char *objname)
#endif
{
  if (!laltz) zgupdate(1);

  /* for long-type message? */
}

/*------------------------- line --------------------------*/

#ifndef WINDOWS
void zgswdi_(DCL_INT *iwdidx)
#else
void ZGSWDI(DCL_INT *iwdidx)
#endif
{

  /* set line width index */

  iwdidz = *iwdidx % 10;
  if (iwdidz == 0) iwdidz = 1;

  irwidth = iwdidz;
}

#ifndef WINDOWS
void zgscli_(DCL_INT *iclidx)
#else
void ZGSCLI(DCL_INT *iclidx)
#endif
{
  /* set line color index */
  double rt1,gt1,bt1;

  if (!lfcmod){

  iclidz = *iclidx % MAXCLI;

  rt1 = (double) cx[iclidz].red   / 65535;
  gt1 = (double) cx[iclidz].green / 65535;
  bt1 = (double) cx[iclidz].blue  / 65535;

  cairo_set_source_rgb(cr,rt1,gt1,bt1);
  }
/*if (iclidz == 0)
    iclidz = 1; */
}

#ifndef WINDOWS
void zggopn_(void)
#else
void ZGGOPN(void)
#endif
{

  /* open graphic segment */

  cairo_set_line_width(cr,linewidth[iwdidz-1]*dlnscale);
  cairo_set_line_cap(cr,CAIRO_LINE_CAP_ROUND);
  cairo_set_line_join(cr,CAIRO_LINE_JOIN_BEVEL);
}

#ifndef WINDOWS
void zggmov_(DCL_REAL *wx, DCL_REAL *wy)
#else
void ZGGMOV(DCL_REAL *wx, DCL_REAL *wy)
#endif
{
  DCL_REAL rwx, rwy;

#ifndef WINDOWS
  zgfrel_( wx, wy, &rwx, &rwy );
#else
  ZGFREL( wx, wy, &rwx, &rwy );
#endif

  /* pen-up move */
  cairo_move_to(cr,(double)rwx,(double)rwy);

  rwxold = *wx;
  rwyold = *wy;
  zguprect(rwx,rwy);

}

#ifndef WINDOWS
void zgtesttxt_(DCL_REAL *wx, DCL_REAL *wy, DCL_REAL *size, char* text)
#else
void ZGTESTTXT(DCL_REAL *wx, DCL_REAL *wy, DCL_REAL *size, char* text)
#endif
{
  void cfnchr();
  DCL_INT iiwx,iiwy;
  char textz[80];

  cfnchr(textz, text, 79);

  cairo_set_font_size (cr , *size);
  cairo_select_font_face (cr , (gchar *) pango_font_description_get_family (font_desc),
                   CAIRO_FONT_SLANT_NORMAL ,
                   CAIRO_FONT_WEIGHT_NORMAL);

  iiwy = drawing_area->allocation.height - *wy + *size / 2 ;
  iiwx = *wx - *size / 2;

  cairo_move_to (cr , iiwx , iiwy);
  zguprect(*wx,iiwy);
  cairo_show_text (cr , &textz[0]);
// *size * ncz
  zguprect(*wx+*size,iiwy-*size);
  if(!laltz){zgupdate(1);}
}

static void font_dialog_response(
           GtkFontSelectionDialog *dialog,
           gint response, gpointer data){

  gchar *font;

  switch (response){
  case (GTK_RESPONSE_APPLY):
  case (GTK_RESPONSE_OK):
    font=gtk_font_selection_dialog_get_font_name(dialog);
    font_desc = pango_font_description_from_string (font);
    g_free(font);
    break;
  default:
    gtk_widget_destroy(GTK_WIDGET(dialog));
  }

  if (response==GTK_RESPONSE_OK){
    gtk_widget_destroy(GTK_WIDGET(dialog));
  }
  if (font_desc == NULL){
    font_desc = pango_font_description_from_string ("Sans Normal 12");
  }
}

#ifndef WINDOWS
void zgtestselectfont_(){
#else
void ZGTESTSELECTFONT(){
#endif
  GtkWidget *dialog;
//  static void font_dialog_response (GtkFontSelectionDialog*, gint, gpointer);

  dialog = gtk_font_selection_dialog_new("Choose a Font");
  if (fontfamily == NULL){
    fontfamily = defaultfont;
  }
  gtk_font_selection_dialog_set_font_name(
           GTK_FONT_SELECTION_DIALOG(dialog),
           fontfamily);
  gtk_font_selection_dialog_set_preview_text(
           GTK_FONT_SELECTION_DIALOG(dialog),
           "GFD Dennou Common Library 電脳ライブラリ αβΣΩ");
  g_signal_connect(G_OBJECT(dialog),"response",
           G_CALLBACK(font_dialog_response),NULL);
  gtk_dialog_run(GTK_DIALOG(dialog));

}
#ifndef WINDOWS
void zgtestftfc_(char* family)
#else
void ZGTESTFTFC(char* family)
#endif
{
  font_desc = pango_font_description_from_string (family);
}

#ifndef WINDOWS
void zggplt_(DCL_REAL *wx, DCL_REAL *wy)
#else
void ZGGPLT(DCL_REAL *wx, DCL_REAL *wy)
#endif
{
  DCL_REAL iwxold, iwyold, rwx, rwy;
//  void zgfint_();

  /* pen-down move */

#ifndef WINDOWS
  zgfrel_(&rwxold, &rwyold, &iwxold, &iwyold);
  zgfrel_( wx,      wy,     &rwx,    &rwy   );
#else
  ZGFREL(&rwxold, &rwyold, &iwxold, &iwyold);
  ZGFREL( wx,      wy,     &rwx,    &rwy   );
#endif

  cairo_line_to(cr,(double)rwx,(double)rwy);

  zguprect(rwx,rwy);
  rwxold = *wx;
  rwyold = *wy;
}

#ifndef WINDOWS
void zggcls_(void)
#else
void ZGGCLS(void)
#endif
{
    cairo_stroke(cr);
    lfcmod = FALSE;
  /* close graphic segment */
}

/*------------------------- tone --------------------------*/

#ifndef WINDOWS
void zggton_(DCL_INT *np, DCL_REAL wpx[], DCL_REAL wpy[], DCL_INT *itpat)
#else
void ZGGTON(DCL_INT *np, DCL_REAL wpx[], DCL_REAL wpy[], DCL_INT *itpat)
#endif
{
  static int ltfrst = TRUE, ibitold = -1;
  DCL_REAL rpx, rpy;
  DCL_INT iclr, ibit;
  int i,j,k,l,m, nb,nl,nm;
  char bitmap[16384];
  double rt1,gt1,bt1;
  double alpha;

  static cairo_pattern_t *pattern;
  static cairo_surface_t *csb;
  static cairo_t *crb;

  /* hard fill */

  if (ltfrst) {
    csb = cairo_image_surface_create(CAIRO_FORMAT_ARGB32, 8,8);
    crb = cairo_create(csb);
    ltfrst = FALSE;
  }

  //  ibit = *itpat % 1000;
  iclr = (*itpat / 1000) % MAXCLI;
  if ((*itpat / 1000) == 999){ iclr=0;}
  rt1 = (double) cx[iclr].red   / 65535;
  gt1 = (double) cx[iclr].green / 65535;
  bt1 = (double) cx[iclr].blue  / 65535;

  cairo_set_source_rgb(crb,rt1,gt1,bt1);
  cairo_rectangle(crb,0.0,0.0,16.0,16.0);
  cairo_fill(crb);

  pattern = cairo_pattern_create_for_surface (csb);
  cairo_pattern_set_extend (pattern , CAIRO_EXTEND_REPEAT);
  cairo_set_source (cr , pattern);

#ifndef WINDOWS
  zgfrel_(&wpx[0],&wpy[0], &rpx, &rpy);
#else
  ZGFREL(&wpx[0],&wpy[0], &rpx, &rpy);
#endif
  cairo_move_to(cr,(double)rpx,(double)rpy);
  zguprect(rpx,rpy);
  for (i = 1; i < *np; i++) {
#ifndef WINDOWS
    zgfrel_(&wpx[i],&wpy[i], &rpx, &rpy);
#else
    ZGFREL(&wpx[i],&wpy[i], &rpx, &rpy);
#endif
    cairo_line_to(cr,(double)rpx,(double)rpy);
    zguprect(rpx,rpy);
  }

  cairo_close_path(cr);
  cairo_set_source_rgb(cr,rt1,gt1,bt1);
// Adhoc Patch for 3
  if ( idev_type == IWS_FILE && ifl == IFL_PDF ){
    cairo_fill_preserve(cr);
    cairo_set_line_width(cr,0.4);
    cairo_stroke(cr);
  }else{
    cairo_set_antialias(cr,CAIRO_ANTIALIAS_NONE);
    cairo_fill(cr);
    cairo_set_antialias(cr,CAIRO_ANTIALIAS_DEFAULT);
  }
//  cairo_surface_destroy(csb);
//  cairo_destroy(crb);
//  cairo_pattern_destroy (pattern);
}

/*------------------------- image -------------------------*/

#ifndef WINDOWS
void zgiopn_(DCL_INT *iwx, DCL_INT *iwy, DCL_INT *iwidth, DCL_INT *iheight)
#else
void ZGIOPN(DCL_INT *iwx, DCL_INT *iwy, DCL_INT *iwidth, DCL_INT *iheight)
#endif
{
    ixz = *iwx ;
    iyz = *iwy ;
    iwz = *iwidth;
    ihz = *iheight;
    ixxz = ixz;
    iyyz = iyz;

    csi    = cairo_image_surface_create(CAIRO_FORMAT_RGB24, iwz, ihz);
    pixels = cairo_image_surface_get_data(csi);
    rows   = cairo_image_surface_get_stride(csi);

    fprintf (stderr, " *** image ");
}

#ifndef WINDOWS
void zgidat_(DCL_INT image[], DCL_INT *nlen)
#else
void ZGIDAT(DCL_INT image[], DCL_INT *nlen)
#endif
{
  int i,ofs;
  int e=1;
  double rt1,gt1,bt1;

  for ( i=0; i< *nlen; i++){
    ofs = (iyyz-iyz)*rows + 4*(ixxz -ixz);
    if(* (char*) &e){
    //For Little Endian
    pixels[ofs  ]=(unsigned char)(cx[image[i]].blue /256);
    pixels[ofs+1]=(unsigned char)(cx[image[i]].green/256);
    pixels[ofs+2]=(unsigned char)(cx[image[i]].red  /256);
    // pixels[ofs+3]=(unsigned char)(128);
    }else{
    //For Big Endian
    // pixels[ofs  ]=(unsigned char)(128);
    pixels[ofs+1]=(unsigned char)(cx[image[i]].red  /256);
    pixels[ofs+2]=(unsigned char)(cx[image[i]].green/256);
    pixels[ofs+3]=(unsigned char)(cx[image[i]].blue /256);
    }


    ixxz = ixxz + 1;
    if (ixxz >= ixz+iwz) {
      ixxz = ixz;
      iyyz = iyyz + 1;
      if (iyyz % 16 == 0) {
        fprintf(stderr, ".");
        fflush(stdout);
      }
    }
  }
  if(!laltz){zgupdate(1);}
////  cairo_set_antialias(cr,CAIRO_ANTIALIAS_DEFAULT);
}

#ifndef WINDOWS
void zgicls_(void)
#else
void ZGICLS(void)
#endif
{
  cairo_set_source_surface(cr, csi, (double)ixz, (double)iyz);
  cairo_pattern_set_filter(cairo_get_source(cr), CAIRO_FILTER_NEAREST);
  cairo_rectangle(cr, (double)ixz, (double)iyz, (double)iwz-1, (double) ihz-1);
  //  cairo_fill(cr);
  cairo_paint(cr);

  if(!laltz){zgupdate(1);}
  fprintf (stderr, " end\n");
//  cairo_surface_finish(csi);
  cairo_surface_destroy(csi);
}

/*------------------------- mouse -------------------------*/

#ifndef WINDOWS
void zgqpnt_(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *mb)
#else
void ZGQPNT(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *mb)
#endif
{
  /* mouse pointer position info. */
}

/*------------------------- inquiry -----------------------*/

#ifndef WINDOWS
void zgqwdc_(DCL_INT *lwdatr)
#else
void ZGQWDC(DCL_INT *lwdatr)
#endif
{
  /* inquire line width capability */
  *lwdatr = LWDATR;
}

#ifndef WINDOWS
void zgqclc_(DCL_INT *lclatr)
#else
void ZGQCLC(DCL_INT *lclatr)
#endif
{
  /* inquire line color capability */
  *lclatr = lclatrz;
}

#ifndef WINDOWS
void zgqtnc_(DCL_INT *ltnatr)
#else
void ZGQTNC(DCL_INT *ltnatr)
#endif
{
  /* inquire hard fill capability */
  *ltnatr = LTNATR;
}

#ifndef WINDOWS
void zgqimc_(DCL_INT *limatr)
#else
void ZGQIMC(DCL_INT *limatr)
#endif
{
  /* inquire bit image capability */
  *limatr = LIMATR;
}

#ifndef WINDOWS
void zgqptc_(DCL_INT *lptatr)
#else
void ZGQPTC(DCL_INT *lptatr)
#endif
{
  /* inquire mouse point capability */
  *lptatr = LPTATR;
}

#ifndef WINDOWS
void zgqrct_(DCL_REAL *wsxmn, DCL_REAL *wsxmx, DCL_REAL *wsymn, DCL_REAL *wsymx, DCL_REAL *fact)
#else
void ZGQRCT(DCL_REAL *wsxmn, DCL_REAL *wsxmx, DCL_REAL *wsymn, DCL_REAL *wsymx, DCL_REAL *fact)
#endif
{
  /* inquire workstation rectangle */
// Korehakairodemawaseruyounisitekyoutuukadekiruyouni

  if (idev_type == IWS_DISP || (idev_type == IWS_FILE && (ifl == IFL_PNG || ifl == IFL_SVG))){
    *wsxmn = PAD;
    *wsxmx = wsxwd-PAD;
    *wsymn = PAD;
    *wsymx = wsywd-PAD;
    *fact  = FACTZ;
  }else if (idev_type == IWS_FILE && ( ifl == IFL_EPS || ifl == IFL_PDF)){
    *wsxmn = offy;
    *wsxmx = iPS_PAGE_HEIGHT + offy;
    *wsymn = offx;
    *wsymx = iPS_PAGE_WIDTH + offx;
    *wsxmn = 0;
    *wsxmx = iPS_PAGE_HEIGHT;
    *wsymn = 0;
    *wsymx = iPS_PAGE_WIDTH;
    *fact  = FACTZ;
  }else{
    *wsxmn = offx;
    *wsxmx = iPS_PAGE_WIDTH+offx;
    *wsymn = offy;
    *wsymx = iPS_PAGE_HEIGHT+offy;
    *wsxmn = 0;
    *wsxmx = iPS_PAGE_WIDTH;
    *wsymn = 0;
    *wsymx = iPS_PAGE_HEIGHT;
    *fact  = FACTZ;
  }
}

#ifndef WINDOWS
void zgsrot_(DCL_INT *iwtrot)
#else
void ZGSROT(DCL_INT *iwtrot)
#endif
{
  /* set frame rotation flag */

  iwtroz = *iwtrot;
}

// New function for Fullcolor
#ifndef WINDOWS
void zgsfcm_(DCL_INT *lfc)
#else
void ZGSFCM(DCL_INT *lfc)
#endif
{
  lfcmod = *lfc;
}

#ifndef WINDOWS
void zgslcl_(DCL_INT *icolor)
#else
void ZGSLCL(DCL_INT *icolor)
#endif
{
  GdkColor loccx;

  double rt1,gt1,bt1;

  loccx.red   = ((*icolor >> 16) & 255) * 256;
  loccx.green = ((*icolor >> 8)  & 255) * 256;
  loccx.blue  = ((*icolor >> 0)  & 255) * 256;

  rt1 = (double) loccx.red   / 65535;
  gt1 = (double) loccx.green / 65535;
  bt1 = (double) loccx.blue  / 65535;

  cairo_set_source_rgb(cr,rt1,gt1,bt1);
}

#ifndef WINDOWS
void zgstcl_(DCL_INT *icolor)
#else
void ZGSTCL(DCL_INT *icolor)
#endif
{
  /*This Function is not used in uipk samples
     So, it is not tested.*/
  /* set tone color in 24 bit RGB */
  GdkColor  loccx;
  double rt1,gt1,bt1;

  if (ltfrst) {
//    gct = gdk_gc_new (drawing_area->window);

    ltfrst = FALSE;
  }

  loccx.red   = ((*icolor >> 16) & 255) * 256;
  loccx.green = ((*icolor >> 8)  & 255) * 256;
  loccx.blue  = ((*icolor >> 0)  & 255) * 256;

  rt1 = (double) loccx.red   / 65535;
  gt1 = (double) loccx.green / 65535;
  bt1 = (double) loccx.blue  / 65535;

  cairo_set_source_rgb(cr,rt1,gt1,bt1);
}

#ifndef WINDOWS
void zgiclr_(DCL_INT *image,DCL_INT *nlen)
#else
void ZGICLR(DCL_INT *image,DCL_INT *nlen)
#endif
{
  GdkColor  loccx;
  int i,ofs;
  int e=1;
  double rt1,gt1,bt1;

  for ( i=0; i< *nlen; i++){
    ofs = (iyyz-iyz)*rows + 4*(ixxz -ixz);

    loccx.red   = ((image[i] >> 16) & 255);
    loccx.green = ((image[i] >> 8)  & 255);
    loccx.blue  = ((image[i] >> 0)  & 255);

    if(* (char*) &e){
    //For Little Endian
      pixels[ofs  ]=(unsigned char)(loccx.blue);
      pixels[ofs+1]=(unsigned char)(loccx.green);
      pixels[ofs+2]=(unsigned char)(loccx.red);
    // pixels[ofs+3]=(unsigned char)(128);
    }else{
    //For Big Endian
    // pixels[ofs  ]=(unsigned char)(128);
      pixels[ofs+1]=(unsigned char)(loccx.red);
      pixels[ofs+2]=(unsigned char)(loccx.green);
      pixels[ofs+3]=(unsigned char)(loccx.blue);
    }

    ixxz = ixxz + 1;
    if (ixxz >= ixz+iwz) {
      ixxz = ixz;
      iyyz = iyyz + 1;
      if (iyyz % 16 == 0) {
        fprintf (stderr,".");
        fflush (stdout);
      }
    }
  }
  if(!laltz){zgupdate(1);}
}

#ifndef WINDOWS
void zgclini_(char clrmap[], DCL_INT *lfgbg)
#else
void ZGCLINI(char clrmap[], DCL_INT *lfgbg)
#endif
{

  void cfnchr();

  char c[80],cmapz[80];
  FILE *stream;
  int ncolor,n,m,fscanret;
  guint16 rx[MAXCLI], gx[MAXCLI], bx[MAXCLI], rx1, gx1, bx1;
  double rt1,gt1,bt1;
  int fgbg;

  /* read colormap file */

  cfnchr(cmapz, clrmap, 79);

  if ((stream = fopen(cmapz, "r")) == NULL) {
    fprintf(stderr, "*** Error in zgdopn : ");
    fprintf(stderr,
	    "Allocation failed for colormap (%s).\n", cmapz);
    exit (1);
  }

  fscanret=fscanf(stream, "%d : %s", &ncolor, c);
  for (n = 0; n < ncolor; n++)
    fscanret=fscanf(stream, "%6hd%6hd%6hd : %s", &rx[n], &gx[n], &bx[n], c);
  fclose(stream);

  fgbg = *lfgbg;

  if (fgbg) {
    rx1 = rx[0];
    gx1 = gx[0];
    bx1 = bx[0];
    rx[0] = rx[1];
    gx[0] = gx[1];
    bx[0] = bx[1];
    rx[1] = rx1;
    gx[1] = gx1;
    bx[1] = bx1;
  }

  lclatrz = 1;
/* set colormap */
  for (n = 0; n < MAXCLI; n++) {

      m = n % ncolor;

      cx[n].red   = rx[m];
      cx[n].green = gx[m];
      cx[n].blue  = bx[m];
  }

  rt1 = (double) cx[0].red   / 65535 ;
  gt1 = (double) cx[0].green / 65535 ;
  bt1 = (double) cx[0].blue  / 65535 ;

  cairo_set_source_rgb(cr,rt1,gt1,bt1);
}


static cairo_status_t png2stdout(void *closure, const unsigned char* data, unsigned int length)
{
  if (length == fwrite(data, 1, length,closure) ){
  return  CAIRO_STATUS_SUCCESS;
  }
  return CAIRO_STATUS_WRITE_ERROR;
}


static void zgcatl(){
    cairo_translate (cr, offx+iPS_PAGE_WIDTH * ddvscale / 2.0   , offy+iPS_PAGE_HEIGHT * ddvscale / 2.0 );
    cairo_rotate(cr, -2 * 3.1415926 * 0.25 );
    cairo_translate (cr, -iPS_PAGE_HEIGHT * ddvscale / 2.0 , -iPS_PAGE_WIDTH * ddvscale / 2.0 );
}
