/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*
#include <global.hpp>

#include <FL/fl_draw.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>


#include <interfacce.hpp>
#include <multiline_label.hpp>


#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
*/


#include <global.hpp>

#include <cstdio>



#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/fl_draw.H>
#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>

#include <procedura.hpp>
#include <gruppo.hpp>

#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>

#include <prefs.hpp>
#include <util.hpp>

extern finestra_pr* MainWindow;



extern Preferences  __pref;


paragraph_text::paragraph_text()
  :etichetta(),
   _pointer_to_currline(0),
   _interline_space(paragraph_text::_default_interline_space),
   _layout_lines(PARAGRAPH_TEXT_ALIGN_LEFT_TEXT_LAYOUT)
{
  //std::cerr << "creo paragraph " << __FUNCTION__ << std::endl;
}



paragraph_text::paragraph_text(const paragraph_text& other)
 :etichetta(other),
  _pointer_to_currline(other._pointer_to_currline),
  _interline_space(other._interline_space),
  _layout_lines(other._layout_lines)

{
  
  for(unsigned int i=0;i< (other._lines_of_text.size()) ;i++){
    multifont_label* tmp=new multifont_label(other._lines_of_text[i]);
    _lines_of_text.push_back(tmp);
  }

}

paragraph_text::paragraph_text(const paragraph_text* other)
  :etichetta(other),
   _pointer_to_currline(other->_pointer_to_currline),
   _interline_space(other->_interline_space),
   _layout_lines(other->_layout_lines)

{

  //std::cerr << "ricopio paragraph " << __FUNCTION__ << std::endl;
  for(unsigned int i=0;i< (other->_lines_of_text.size()) ;i++){
    multifont_label* tmp=new multifont_label(other->_lines_of_text[i]);
    _lines_of_text.push_back(tmp);
  }

}


paragraph_text& paragraph_text::operator=(const paragraph_text& other){
  _pointer_to_currline=other._pointer_to_currline;
  _interline_space=other._interline_space;
  _layout_lines=other._layout_lines;


  for(unsigned int i=0;i< (other._lines_of_text.size()) ;i++){
    multifont_label* tmp=new multifont_label(other._lines_of_text[i]);
    _lines_of_text.push_back(tmp);
  }

  return (*this);
}

paragraph_text::~paragraph_text(){
  //std::cerr << __FUNCTION__ << std::endl;
  
  for(unsigned int i=0;i< _lines_of_text.size(); i++){
    //std::cerr << "paragr eliminata " << _lines_of_text[i] << std::endl;
    delete _lines_of_text[i];
  }
  
}




void paragraph_text::update_highligted_text(){
  if(size_lines_of_text()>0){
    int saved_ptrline=pointer_to_currline();
    int saved_ptrline_child=_lines_of_text[pointer_to_currline()]->pointer_to_currline();
    std::pair<int,string::size_type> saved_curpos(0,0);
    get_cursor_position(&saved_curpos);

    go_to_start_of_label();
    _lines_of_text[pointer_to_currline()]->set_cursor_position_abs(0,0,0);
    int currtype=0;
    while(cursor_one_step_fwd(currtype)){
      bool old_h=highlight_child(true);
      if(old_h){
        dim_child(phys_dim());
        font_child(font());
        color_child(cr(),cg(),cb());
      }
      highlight_child(old_h);
    }

    pointer_to_currline(saved_ptrline);
    _lines_of_text[pointer_to_currline()]->set_cursor_position_abs(saved_ptrline_child,
                                                                   saved_curpos.first,
                                                                   saved_curpos.second);
  }
}





int paragraph_text::cr(){
  return _cr;
}

int paragraph_text::cg(){
  return _cg;
}

int paragraph_text::cb(){
  return _cb;
}

void paragraph_text::cr(int nw){
  _cr=nw;
}

void paragraph_text::cg(int nw){
  _cg=nw;
}

void paragraph_text::cb(int nw){
  _cb=nw;
}


int paragraph_text::font(){
  return _font;
}



int paragraph_text::dim(){
  int res=5;

  if( cairo_t_singleton::can_export()){
    res=phys_dim();
  }else{
    res=visual_dim();
  }

  return res;

}


int paragraph_text::phys_dim(){
  return _dim;


}

int paragraph_text::visual_dim(){
  int res=static_cast<int>(rintf(phys_dim()*__pref.getZoom()));
  
  if(res<5){
    res=5;
  }

  return res;

}


void paragraph_text::dim(int nw){
  _dim=nw;
}


bool paragraph_text::set_ptrline_to_modify_children(int* whished_ptr_line, 
                                                    int* whished_ptr_line_child,
                                                    int* saved_ptr_line, 
                                                    int* saved_ptr_line_child,
                                                    int* act_ptr_line, 
                                                    int* act_ptr_line_child){

  bool is_legal_req=false;

  if(pointer_to_currline() >= 0 &&
     ptr_line_less_lines_text() &&
     _lines_of_text[pointer_to_currline()]->pointer_to_currline() >= 0 &&
     (_lines_of_text[pointer_to_currline()]->pointer_to_currline() <
      static_cast<int>(_lines_of_text[pointer_to_currline()]->size_lines_of_text()))){
     
    is_legal_req=true;
    *saved_ptr_line=pointer_to_currline();
    *saved_ptr_line_child=_lines_of_text[pointer_to_currline()]->pointer_to_currline();
    
    *act_ptr_line=*saved_ptr_line;
    *act_ptr_line_child=*saved_ptr_line_child;

    if(whished_ptr_line!=NULL && 
       *whished_ptr_line < static_cast<int>(size_lines_of_text()) &&
       *whished_ptr_line>=0){
      *act_ptr_line=*whished_ptr_line;
    }
    

    if(whished_ptr_line_child!=NULL && 
       *whished_ptr_line_child < static_cast<int>(_lines_of_text[*act_ptr_line]->size_lines_of_text()) &&
       *whished_ptr_line>=0){
      *act_ptr_line_child=*whished_ptr_line_child;
    }
  }


  return is_legal_req;

}



int paragraph_text::dim_child(int nw,int* ptr_line, int* ptr_line_child){
  int res=-1;


  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);


  


  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    res=_lines_of_text[act_ptr_line]->dim();
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    _lines_of_text[act_ptr_line]->dim(nw);
    pointer_to_currline(saved_ptr_line);

    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }

  return res;
}


int paragraph_text::font_child(int nw,int* ptr_line, int* ptr_line_child){
  int res=-1;

  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);

  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    res=_lines_of_text[act_ptr_line]->dim();
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    _lines_of_text[act_ptr_line]->font(nw);
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }

  return res;
}


void paragraph_text::highlight_current_line(){
  if(size_lines_of_text()>0){
    if(pointer_to_currline()>=0 && ptr_line_less_lines_text()){
      bool old_t=_lines_of_text[pointer_to_currline()]->treat_as_a_whole(true);
      _lines_of_text[pointer_to_currline()]->draw_negative(true);
      _lines_of_text[pointer_to_currline()]->treat_as_a_whole(old_t);
    }
  }
}


void paragraph_text::dehighlight_current_line(){
  if(size_lines_of_text()>0){
    if(pointer_to_currline()>=0 && ptr_line_less_lines_text()){
      bool old_t=_lines_of_text[pointer_to_currline()]->treat_as_a_whole(true);
      _lines_of_text[pointer_to_currline()]->draw_negative(false);
      _lines_of_text[pointer_to_currline()]->treat_as_a_whole(old_t);
    }
  }
}



bool paragraph_text::highlight_under_bounding_box(std::pair<float,float> ld,
						  std::pair<float,float> ru){
  
  format_paragraph();
  bool res=false;
  for(unsigned int i=0; i<_lines_of_text.size(); i++){
    std::vector<etichetta*> labels=_lines_of_text[i]->get_lines_text();
    for(unsigned int j=0; j<labels.size(); j++){

      if(labels[j]->x() > ld.first  && labels[j]->x()  < ru.first &&
	 labels[j]->y() > ld.second && labels[j]->y()  < ru.second){
	labels[j]->draw_negative(true);
	res=true;
      }
    }
  }
  
  return res;
}

bool paragraph_text::some_highlighted(){
  
  bool res=false;
  for(unsigned int i=0; i<_lines_of_text.size(); i++){
    std::vector<etichetta*> labels=_lines_of_text[i]->get_lines_text();
    for(unsigned int j=0; j<labels.size(); j++){
      if(labels[j]->draw_negative()){
	res=true;
	break;
      }
    }
  }
  
  return res;
}




bool paragraph_text::invert_highlight_child_and_shift_cursor(bool fwd){
  int dummy=0;
  bool res=false;
  if(fwd){
    pointer_to_currline();
    cursor_one_step_fwd(dummy);
    _lines_of_text[pointer_to_currline()]->go_to_end_of_line();
    res=highlight_child(true);
    highlight_child(!res);

  }else{
    pointer_to_currline();
    res=highlight_child(true);
    highlight_child(!res);
    _lines_of_text[pointer_to_currline()]->go_to_start_of_line();
    cursor_one_step_back(dummy);
  }
  
  return res;



}


bool paragraph_text::highlight_child(bool nw,int* ptr_line, int* ptr_line_child){
  int res=false;

  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);

  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    res=_lines_of_text[act_ptr_line]->draw_negative();
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    _lines_of_text[act_ptr_line]->draw_negative(nw);
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }

  return res;
}






int paragraph_text::cr_child(int nw,int* ptr_line, int* ptr_line_child){
  int res=-1;
  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);
  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    int old_cg=_lines_of_text[act_ptr_line]->cg();
    int old_cb=_lines_of_text[act_ptr_line]->cb();
    color_child(nw, old_cg, old_cb, ptr_line,ptr_line_child);
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }
  return res;
}
int paragraph_text::cg_child(int nw,int* ptr_line, int* ptr_line_child){

  int res=-1;
  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);
  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    int old_cr=_lines_of_text[act_ptr_line]->cr();
    int old_cb=_lines_of_text[act_ptr_line]->cb();
    color_child(old_cr, nw, old_cb, ptr_line,ptr_line_child);
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }
  return res;


}
int paragraph_text::cb_child(int nw,int* ptr_line, int* ptr_line_child){
  int res=-1;
  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);
  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    int old_cr=_lines_of_text[act_ptr_line]->cr();
    int old_cg=_lines_of_text[act_ptr_line]->cg();
    color_child(old_cr, old_cg, nw, ptr_line,ptr_line_child);
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }
  return res;
}

void paragraph_text::color_child(int cr, int cg, int cb,
                                int* ptr_line, int* ptr_line_child){



  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);

  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    _lines_of_text[act_ptr_line]->cr(cr);
    _lines_of_text[act_ptr_line]->cg(cg);
    _lines_of_text[act_ptr_line]->cb(cb);
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }
}



void paragraph_text::query_child(int* cr, int* cg, int* cb,
                                 int* font, int* dim,
                                 int* ptr_line, int* ptr_line_child){



  int saved_ptr_line=-1;
  int saved_ptr_line_child=-1;
  int act_ptr_line=-1;
  int act_ptr_line_child=-1;

  bool is_legal=set_ptrline_to_modify_children(ptr_line, 
                                               ptr_line_child,
                                               &saved_ptr_line, 
                                               &saved_ptr_line_child,
                                               &act_ptr_line, 
                                               &act_ptr_line_child);

  if(is_legal){
    bool old_t=_lines_of_text[act_ptr_line]->treat_as_a_whole(false);
    _lines_of_text[act_ptr_line]->pointer_to_currline(act_ptr_line_child);
    if(cr!=NULL){
      *cr=_lines_of_text[act_ptr_line]->cr();
    }
    if(cg!=NULL){
      *cg=_lines_of_text[act_ptr_line]->cg();
    }
    if(cb!=NULL){
      *cb=_lines_of_text[act_ptr_line]->cb();
    }
    if(dim!=NULL){
      *dim=_lines_of_text[act_ptr_line]->dim();
    }
    if(font!=NULL){

      *font=_lines_of_text[act_ptr_line]->font();
    }
    pointer_to_currline(saved_ptr_line);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(saved_ptr_line_child);
    _lines_of_text[act_ptr_line]->treat_as_a_whole(old_t);
  }


}




float paragraph_text::x(){
  float res=0;

  if( cairo_t_singleton::can_export()){
    res=phys_x();
  }else{
    res=visual_x();
  }

  return res;
}

float paragraph_text::visual_x(){

  float res=(rintf(phys_x()*__pref.getZoom()));
  return res;

}

float paragraph_text::phys_x(){ 
  return _x;
}



float paragraph_text::y(){
  float res=0;

  if( cairo_t_singleton::can_export()){
    res=phys_y();
  }else{
    res=visual_y();
  }

  return res;
}

float paragraph_text::visual_y(){

  float res=phys_y()*__pref.getZoom();
  return res;

}

float paragraph_text::phys_y(){ 
  return _y;
}



void paragraph_text::font(int nw){
  _font=nw;
}

void paragraph_text::x(float nw){
  _x=nw;
}



void paragraph_text::y(float nw){
  _y=nw;
}


void paragraph_text::misura(float& altris,float& larris ){
  
  if( cairo_t_singleton::can_export()){
    phys_misura(altris,larris);
  }else{
    
    visual_misura(altris,larris);
  }
  
}


  
/**
 *Misura l'altezza e la larghezza di questa etichetta tenendo conto dello zoom
 *\param altris l'altezza dell'etichetta
 *\param larris la larghezza dell'etichetta
 */

void paragraph_text::visual_misura(float& altris,float& larris ){
    phys_misura_as_a_whole(altris,larris);
    
    altris*=__pref.getZoom();
    larris*=__pref.getZoom();

}



void paragraph_text::phys_misura(float& altris,float& larris ){
  phys_misura_as_a_whole(altris,larris);

}


void paragraph_text::phys_misura_as_a_whole(float& altris,float& larris ){
  if(static_cast<int>(size_lines_of_text())>0){
    format_paragraph();
    float ypos_max=-1;
    float ypos_min=10000000;

    for(unsigned int i=0;i<_lines_of_text.size();i++){
      if(_lines_of_text[i]->phys_y()  < ypos_min){
        ypos_min=_lines_of_text[i]->phys_y();
      }

      if(_lines_of_text[i]->phys_y() + _lines_of_text[i]->phys_h() > ypos_max){
        ypos_max=_lines_of_text[i]->phys_y() + _lines_of_text[i]->phys_h();
      }

    }


    float xpos_max=-1;
    float xpos_min=10000000;

    for(unsigned int i=0;i<_lines_of_text.size();i++){
      if(_lines_of_text[i]->phys_x() < xpos_min){
        xpos_min=_lines_of_text[i]->phys_x();
      }

      if(_lines_of_text[i]->phys_x() + _lines_of_text[i]->phys_w() > xpos_max){
        xpos_max=_lines_of_text[i]->phys_x()+ _lines_of_text[i]->phys_w(); 
      }

    }

    altris=ypos_max - ypos_min;
    larris=xpos_max - xpos_min;

    if(layout_lines()!=MULTILINE_LABEL_ALIGN_SINGLE_LINE_TEXT_LAYOUT){
      altris+= phys_interline_space();
    }
  }else{
    altris=0;
    larris=0;
  }  


}


float paragraph_text::h(){

  float h=0;
  float w=0;

  if( cairo_t_singleton::can_export()){
    phys_misura(h,w);
  }else{
    visual_misura(h,w);
  }

  return h;
}

float paragraph_text::visual_h(){

  float h=0;
  float w=0;
  visual_misura(h,w);
  return h;

}

float paragraph_text::phys_h(){
  float h=0;
  float w=0;
  
  phys_misura(h,w);
  
  return h;
}



float paragraph_text::w(){

  float h=0;
  float w=0;

  if( cairo_t_singleton::can_export()){
    phys_misura(h,w);
  }else{
    visual_misura(h,w);
  }
  return w;
}

float paragraph_text::visual_w(){

  float h=0;
  float w=0;

  visual_misura(h,w);


  return w;

}

float paragraph_text::phys_w(){
  float h=0;
  float w=0;

  phys_misura(h,w);
  
  return w;
}




float paragraph_text::interline_space(){
  float res=0;
  if( cairo_t_singleton::can_export()){
    res=phys_interline_space();
  }else{
    res=visual_interline_space();
  }

  return res;
}

int paragraph_text::interline_space(int nw){
  int old=_interline_space;
  _interline_space=nw;
  return old;
}

float paragraph_text::phys_interline_space(){
  return _interline_space;
}

float paragraph_text::visual_interline_space(){
  return _interline_space * __pref.getZoom();
  
}



std::vector< std::pair<std::string,int> > paragraph_text::vec_str(){
  std::vector< std::pair<std::string,int> > res=etichetta::vec_str();
  if(ptr_line_less_lines_text()){
    res=_lines_of_text[_pointer_to_currline]->vec_str();
  }
  return res;
}





void paragraph_text::aggiungi(std::string nw, int tipo){
  if(ptr_line_less_lines_text()){
    _lines_of_text[_pointer_to_currline]->aggiungi(nw,tipo);
  }
}


void paragraph_text::add_line(multifont_label new_line){
  multifont_label* tmp=new multifont_label(new_line);
  add_line(tmp);
}


void paragraph_text::add_line(multifont_label* new_line){
  _lines_of_text.push_back(new_line);
  _pointer_to_currline=_lines_of_text.size()-1;
}



void paragraph_text::add_line(multifont_label new_line,int pos){
  if(pos>=0  && static_cast<unsigned int>(pos) < _lines_of_text.size()){
    multifont_label* tmp=new multifont_label(new_line);
    add_line(tmp,pos);
  }
}


void paragraph_text::add_line(multifont_label* new_line, int pos){
  if(pos>=0  && static_cast<unsigned int>(pos) < _lines_of_text.size()){
    if(static_cast<unsigned int>(pos)==_lines_of_text.size()-1){
      add_line(new_line);
    }else{
      std::vector<multifont_label*>::iterator beg=_lines_of_text.begin() + pos + 1;
      _lines_of_text.insert(beg,new_line);
      _pointer_to_currline=pos+1;
    }
  }
}



void paragraph_text::insert(std::string nw, int type, int pos){
  //DA FARE
}


void paragraph_text::insert_line(multifont_label new_line, int pos){
  add_line(new_line,pos);
}

void paragraph_text::insert_line(multifont_label* new_line, int pos){
  add_line(new_line,pos);
}


void paragraph_text::delete_line(int pos, bool reset_pointer_currline){
  etichetta* to_delete=0;
  std::vector <multifont_label*>::iterator pos_iter=_lines_of_text.begin()+pos;
  if(pos>=0 && static_cast<unsigned int>(pos) < _lines_of_text.size()){
    to_delete=*pos_iter;
    _lines_of_text.erase(pos_iter);
    if(reset_pointer_currline){
      reset_pointer_to_currline();
    }
  }

  delete to_delete;
}


void paragraph_text::elimina(bool reset_cur){
  for(unsigned int i=0;i< _lines_of_text.size();i++){
    multifont_label* to_delete=_lines_of_text[i];
    vector<multifont_label*>::iterator beg=_lines_of_text.begin();
    beg+=i;
    _lines_of_text.erase(beg);
    delete to_delete;
  }

  if(reset_cur){
    reset_pointer_to_currline();
  }

}


void paragraph_text::subst_line(multifont_label* nw, int pos){
  delete_line(pos,false);
  if(static_cast<unsigned int>(pos)!=_lines_of_text.size()){
    insert_line(nw,pos);
  }else{
    _lines_of_text.push_back(nw);
  }
}

void paragraph_text::format_paragraph(){

  switch(layout_lines()){

  case PARAGRAPH_TEXT_ALIGN_LEFT_TEXT_LAYOUT:
    {
      for(unsigned int i=0;i<_lines_of_text.size();i++){
        _lines_of_text[i]->x(_x);

        float total_h=0;
        for(unsigned int j=0;j<i;j++){
          total_h+=_lines_of_text[j]->phys_h();

          total_h+=phys_interline_space();
        }

        _lines_of_text[i]->y(_y+total_h);
      }
    }
    break;
  case PARAGRAPH_TEXT_ALIGN_RIGHT_TEXT_LAYOUT:
    {
      format_lines_align_right();      
    }
    break;
  case PARAGRAPH_TEXT_ALIGN_CENTER_TEXT_LAYOUT:
    {
      format_lines_align_center();
    }
    break;

  case PARAGRAPH_TEXT_ALIGN_SINGLE_LINE_TEXT_LAYOUT:
    {

      for(unsigned int i=0;i<_lines_of_text.size();i++){
        _lines_of_text[i]->y(_y);
        
        int total_w=0;
        for(unsigned int j=0;j<i;j++){
          total_w+=_lines_of_text[j]->phys_w();
        }

        _lines_of_text[i]->x(_x+total_w);
      }  
    }
    break;

  default:
    format_lines_align_center();
    break;
  }
}


void paragraph_text::draw_cursor(bool draw){
  if(pointer_to_currline()>=0 &&
     _lines_of_text.size()>0){
    _lines_of_text[pointer_to_currline()]->draw_cursor(draw);
  }
}

void paragraph_text::disegna(){
			     
  format_paragraph();

  if( cairo_t_singleton::can_export()){
    for(unsigned int i=0;i<_lines_of_text.size();i++){
      /*
      cairo_t* cn=cairo_t_singleton::get_context();
       cairo_save(cn);
       int yy=_lines_of_text[i]->y();
       cairo_set_source_rgb(cn,1,0,1);
       cairo_move_to(cn,_lines_of_text[i]->x(),yy);
       cairo_line_to(cn,_lines_of_text[i]->x()+99,yy);
       cairo_stroke(cn);

       cairo_set_source_rgb(cn,1,0,0);
       cairo_move_to(cn,_lines_of_text[i]->x()+100,yy+_lines_of_text[i]->h());
       cairo_line_to(cn,_lines_of_text[i]->x()+200,yy+_lines_of_text[i]->h());
       cairo_stroke(cn);


       cairo_restore(cn);
      */
      _lines_of_text[i]->disegna();
    }
  }else{
      
    for(unsigned int i=0;i<_lines_of_text.size();i++){
      bool old_t=_lines_of_text[i]->treat_as_a_whole(true);
      _lines_of_text[i]->draw_cursor(false);
      
      _lines_of_text[i]->treat_as_a_whole(false);
      if(static_cast<int>(i)==pointer_to_currline()){
        _lines_of_text[i]->draw_cursor(true);
      }else{
        _lines_of_text[i]->draw_cursor(false);
      }
      
      _lines_of_text[i]->treat_as_a_whole(old_t);
      _lines_of_text[i]->disegna();
    }

  }

}



void paragraph_text::trasla(float dx, float dy){
  x(descale(x()+dx));
  y(descale(y()+dy));
}


void paragraph_text::phys_translate(float dx, float dy){
  x(phys_x()+dx);
  y(phys_y()+dy);
}



void paragraph_text::scale(float sc){
  if(sc<1){
    if(phys_dim()>6){
      for(unsigned int i=0;i<_lines_of_text.size();i++){
        _lines_of_text[i]->dim(_lines_of_text[i]->phys_dim()-1);
      }
    }
  }else{
    for(unsigned int i=0;i<_lines_of_text.size();i++){
      _lines_of_text[i]->dim(_lines_of_text[i]->phys_dim()+1);
    }
  }

  
}

void paragraph_text::ruota(float xpiv, float ypiv,float angl){
  not_impl();
}


bool paragraph_text::dentro_bb(float x_bb, float y_bb, float w_bb , float h_bb){
  std::pair<float, float> ld(x_bb,y_bb);
  std::pair<float, float> ru(x_bb+w_bb,y_bb+h_bb);


  if(can_highlight()){
    highlight_under_bounding_box(ld,ru);
  }

  if(x() > x_bb && x()+w()<x_bb+w_bb &&
     y() > y_bb && y()+h()<y_bb+h_bb ){
    return true;
  }else{
    return false;
  }
}

void paragraph_text::pointer_to_currline(int nw){
  if(static_cast<unsigned int>(nw)<_lines_of_text.size()){
    _pointer_to_currline=nw;
  }
}
 
int paragraph_text::pointer_to_currline(){
  return _pointer_to_currline;
}


int paragraph_text::pointer_to_currline_transl(int delta){
  int nw=pointer_to_currline()+delta;
  int old=pointer_to_currline();
  if(nw>=0 && static_cast<unsigned int>(nw) < _lines_of_text.size()){
    pointer_to_currline(nw);
    
  }

  return old;
  
}




int  paragraph_text::set_cursor_position(int limit){
  int res=-1;
  int ptr_line=pointer_to_currline();
  if(ptr_line>=0  && ptr_line_less_lines_text()){
    res=_lines_of_text[ptr_line]->set_cursor_position(limit);
  }

  return res;
}


void paragraph_text::go_to_end_of_label(){
  if(size_lines_of_text()>0){
    for(unsigned int i=0;i<size_lines_of_text();i++){
      _lines_of_text[i]->go_to_end_of_label();
    }
    pointer_to_currline(size_lines_of_text()-1);
  }
}


void paragraph_text::go_to_end_of_line(){
  if(size_lines_of_text()>0 && 
     pointer_to_currline()>=0 &&
     ptr_line_less_lines_text()){
    _lines_of_text[pointer_to_currline()]->go_to_end_of_label();
  }
}

void paragraph_text::go_to_start_of_label(){
  if(size_lines_of_text()>0){
    
    for(unsigned int i=0;i<size_lines_of_text();i++){
      _lines_of_text[i]->go_to_start_of_label();
    }
    
    pointer_to_currline(0);
  }
  
}

void paragraph_text::go_to_start_of_line(){
  if(size_lines_of_text()>0){
    _lines_of_text[pointer_to_currline()]->go_to_start_of_label();
  }

}


int paragraph_text::get_cursor_position(std::pair<int,string::size_type>* pos){

  int res=-1;
  int ptr_line=pointer_to_currline();
  if(ptr_line>=0  && ptr_line_less_lines_text()){
    res=_lines_of_text[ptr_line]->get_cursor_position(pos);
  }

  return res;

}


bool paragraph_text::cursor_one_step_fwd(int &curr_type){
  int ptr_line=pointer_to_currline();
  bool has_more=true;
  if(size_lines_of_text()>0 && _lines_of_text[ptr_line]->size_lines_of_text()>0){
    if(ptr_line>=0  && ptr_line_less_lines_text()){
      //int currt=0;
      bool not_end = _lines_of_text[ptr_line]->cursor_one_step_fwd(curr_type);
      if(!not_end){
        int old_pos_line=pointer_to_currline();
        pointer_to_currline_transl(1);
        ptr_line=pointer_to_currline();
        if(ptr_line>=0 && ptr_line_less_lines_text()){
          _lines_of_text[ptr_line]->pointer_to_currline(0);
          _lines_of_text[ptr_line]->set_cursor_position(0,0);
          if(old_pos_line== static_cast<int>(size_lines_of_text()-1)){
            has_more=false;
          }
        }
      }

    }
  }else{
    has_more=false;
  }
  return has_more;
}



bool paragraph_text::cursor_one_step_back(int &curr_type){
  int ptr_line=pointer_to_currline();
  bool has_more=true;
  if(size_lines_of_text()>0 && _lines_of_text[ptr_line]->size_lines_of_text()>0){
    if(ptr_line>=0 && ptr_line_less_lines_text()){
      bool not_beg = _lines_of_text[ptr_line]->cursor_one_step_back(curr_type);

      if(!not_beg && ptr_line>0){
        
        pointer_to_currline_transl(-1);
        ptr_line=pointer_to_currline();
        if(ptr_line>=0 && ptr_line_less_lines_text()){
        
          std::vector < std::pair<std::string,int> > the_vec_str=
            _lines_of_text[ptr_line]->vec_str();
          int nl=_lines_of_text[ptr_line]->size_lines_of_text()-1;
          int size_f=the_vec_str.size()-1;
          int size_s=(the_vec_str.back().first).size();
          _lines_of_text[ptr_line]->pointer_to_currline(nl);
          _lines_of_text[ptr_line]->set_cursor_position(size_f,size_s);
      
        }
      }else{
        has_more=false;
      }
    }
  }else{
    has_more=false;
  }
  return has_more;
}



bool paragraph_text::cursor_one_step_up(int &curr_type){
  bool has_more=false;
  if(pointer_to_currline()>0){
    has_more=true;
    int ptr_line_child=_lines_of_text[pointer_to_currline()]->pointer_to_currline();
    std::pair<int,string::size_type> cpos(0,0);    
    get_cursor_position(&cpos);


    unsigned int line=pointer_to_currline();

    /*
    std::cerr << line << " " 
              << ptr_line_child 
              << " " << cpos.first << " " << cpos.second << std::endl;

    std::cerr << "before=" << calculate_no_chars_before_abs_cur_pos(line,
                                                                    ptr_line_child,
                                                                    cpos)
              << std::endl;
    */
    int limit=calculate_no_chars_before_abs_cur_pos(line,ptr_line_child,cpos);
    //std::cerr << "limit(up)= " << limit << std::endl;
    pointer_to_currline_transl(-1);
    line=pointer_to_currline();

    calculate_curpos_until_limit(pointer_to_currline(), line, cpos, limit);
    
    /*
    std::cerr << "line=" << line
              << " cpos=" << cpos.first << "," << cpos.second 
              << " limit=" << limit << std::endl;
    */
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(line);
    /*
    std::cerr << "cpos.first=" << cpos.first
              << "cpos.second=" << cpos.second 
              << "_lines_of_text[pointer_to_currline()]->pointer_to_currline()="
              << _lines_of_text[pointer_to_currline()]->pointer_to_currline()<< std::endl;
    
    */
    _lines_of_text[pointer_to_currline()]->set_cursor_position(cpos.first,cpos.second);

    if(_lines_of_text[pointer_to_currline()]->pointer_to_currline()>0 
       && cpos.second==0){
      cursor_one_step_fwd(curr_type);
      cursor_one_step_back(curr_type);
    }

  }
  return has_more;
}

bool paragraph_text::cursor_one_step_down(int &curr_type){

  /*
  std::cerr << "legal=" <<  check_if_abs_pos_legal(int ptrline,
                                                   int ptrline_child,
                                                   int cpos_f,
                                                   int cpos_s)
            <<std::endl;

  */


  bool has_more=false;
  if(pointer_to_currline()>=0 &&
     pointer_to_currline() < static_cast<int>(_lines_of_text.size())){
    has_more=true;
    int ptr_line_child=_lines_of_text[pointer_to_currline()]->pointer_to_currline();
    std::pair<int,string::size_type> cpos(0,0);    
    get_cursor_position(&cpos);
    unsigned int line=pointer_to_currline();
    int limit=calculate_no_chars_before_abs_cur_pos(line,ptr_line_child,cpos);
    //std::cerr << "limit(down)= " << limit << std::endl;
    pointer_to_currline_transl(1);
    line=pointer_to_currline();

    
    calculate_curpos_until_limit(pointer_to_currline(), line, cpos, limit);
    
    /*
    std::cerr << "line=" << line
              << " cpos=" << cpos.first << "," << cpos.second 
              << " limit=" << limit << std::endl;
    */
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(line);
    /*
    std::cerr << "cpos.first=" << cpos.first
              << "cpos.second=" << cpos.second 
              << "_lines_of_text[pointer_to_currline()]->pointer_to_currline()="
              << _lines_of_text[pointer_to_currline()]->pointer_to_currline()<< std::endl;
    
    */
    _lines_of_text[pointer_to_currline()]->set_cursor_position(cpos.first,cpos.second);

    if(_lines_of_text[pointer_to_currline()]->pointer_to_currline()>0 
       && cpos.second==0){
      cursor_one_step_fwd(curr_type);
      cursor_one_step_back(curr_type);
    }

  }
  return has_more;

  /*
  bool has_more=false;
  if(pointer_to_currline() < static_cast<int>(_lines_of_text.size())){
    has_more=true;
    int ptr_line_child=_lines_of_text[pointer_to_currline()]->pointer_to_currline();
    std::pair<int,string::size_type> cpos(0,0);
    get_cursor_position(&cpos);
    pointer_to_currline_transl(1);
    _lines_of_text[pointer_to_currline()]->pointer_to_currline(ptr_line_child);
    _lines_of_text[pointer_to_currline()]->set_cursor_position(cpos.first+cpos.second);
    

  }
  return has_more;
  */
}

void paragraph_text::insert_string_in_curr_pos(std::string str,int type){
  int ptr_line=pointer_to_currline();
  if(ptr_line>=0  && ptr_line_less_lines_text()){
    bool old_v=_lines_of_text[ptr_line]->treat_as_a_whole(false);
    _lines_of_text[ptr_line]->insert_string_in_curr_pos(str,type);
    
    int phys_dim_l=_lines_of_text[ptr_line]->phys_dim();
    if(!some_highlighted()){
      phys_dim_l=phys_dim();
    }

    _lines_of_text[ptr_line]->treat_as_a_whole(old_v);
    font_child(font());
    dim_child(phys_dim_l);
    color_child(cr(),cg(),cb());
  }else if(_lines_of_text.size()==0){
    multifont_label*  tmp=new multifont_label(font(),phys_dim(),cr(),cg(),cb());
    tmp->insert_string_in_curr_pos(str,ET_STR);
    set_cursor_position(0,str.size());
    tmp->reset_cursor_if_outside_limits();
    add_line(tmp);
  }
}

bool paragraph_text::ptr_line_less_lines_text(){
  bool res=false;
  if(static_cast<unsigned int>(pointer_to_currline()) <  
     _lines_of_text.size()){
    res=true;
  }
  return res;
}

bool paragraph_text::ptr_line_is_last_line(){
  return pointer_to_currline() == static_cast<int>((_lines_of_text.size()-1));
}


void paragraph_text::reset_cursor_if_outside_limits(){
  int ptr_line=pointer_to_currline();
  if(ptr_line>=0  && ptr_line_less_lines_text()){
    _lines_of_text[ptr_line]->reset_cursor_if_outside_limits();
  }

}


void paragraph_text::reset_pointer_to_currline(){

  if(_lines_of_text.size() == 0){
    _pointer_to_currline=-1;
  }else if(static_cast<unsigned int>(_pointer_to_currline) >= 
           _lines_of_text.size()){
    _pointer_to_currline=_lines_of_text.size()-1;
  }

}

void paragraph_text::delete_char_curr_pos(bool before){
  if(size_lines_of_text()>0){
    if(_pointer_to_currline >= 0  && ptr_line_less_lines_text()){
      _lines_of_text[pointer_to_currline()]->delete_char_curr_pos(before);
    }

    if(_lines_of_text[pointer_to_currline()]->size_lines_of_text()==0){
      delete_line(pointer_to_currline(),true);
    }
  }
}


std::vector<multifont_label*> paragraph_text::get_lines_text(){
  return _lines_of_text;
}

bool paragraph_text::dump_label(){
  std::cerr << __FUNCTION__ << std::endl;
  
  std::cerr << __FUNCTION__ << "x: " << x() << std::endl;
  std::cerr << __FUNCTION__ << "y: " << y() << std::endl;
  std::cerr << __FUNCTION__ << "w: " << w() << std::endl;
  std::cerr << __FUNCTION__ << "h: " << h() << std::endl;
  std::cerr << __FUNCTION__ << "interline " << interline_space() << std::endl;
  for(unsigned int i =0;i< _lines_of_text.size();i++){
    std::cerr << __FUNCTION__ << _lines_of_text[i]->to_raw_string() 
              << std::endl;
  }

  return true;
}


int paragraph_text::layout_lines(){
  return _layout_lines;
}

void paragraph_text::layout_lines(int nw){
  _layout_lines=nw;
}



void paragraph_text::format_lines_align_right(){

  float w_max=0;

  for(unsigned int i=0;i<_lines_of_text.size();i++){
    if(_lines_of_text[i]->phys_w() > w_max){
      w_max=_lines_of_text[i]->phys_w();
    }
  }

  for(unsigned int i=0;i<_lines_of_text.size();i++){
    _lines_of_text[i]->x(_x + (w_max - _lines_of_text[i]->phys_w()) );


    int total_h=0;
    for(unsigned int j=0;j<i;j++){
      total_h+=_lines_of_text[j]->phys_h();
      total_h+=phys_interline_space();
    }
    

    _lines_of_text[i]->y(_y+total_h);

  
  }
}

void paragraph_text::format_lines_align_center(){

  float w_max=0;

  for(unsigned int i=0;i<_lines_of_text.size();i++){
    if(_lines_of_text[i]->phys_w() > w_max){
      w_max=_lines_of_text[i]->phys_w();
    }
  }

  for(unsigned int i=0;i<_lines_of_text.size();i++){
    _lines_of_text[i]->x(_x + w_max/2 - _lines_of_text[i]->phys_w()/2 );


    int total_h=0;
    for(unsigned int j=0;j<i;j++){
      total_h+=_lines_of_text[j]->phys_h();
      total_h+=phys_interline_space();

    }

    _lines_of_text[i]->y(_y+total_h);

  }

}


void paragraph_text::increase_highlighted(){
  //da fare
}

void paragraph_text::decrease_highlighted(){
  //da fare
  

}

void paragraph_text::de_highlight(){
  if(size_lines_of_text()>0){
    int saved_ptrline=pointer_to_currline();
    int saved_ptrline_child=_lines_of_text[pointer_to_currline()]->pointer_to_currline();
    std::pair<int,string::size_type> saved_curpos(0,0);
    get_cursor_position(&saved_curpos);

    go_to_start_of_label();
    _lines_of_text[pointer_to_currline()]->set_cursor_position_abs(0,0,0);
    int currtype=0;
    while(cursor_one_step_fwd(currtype)){
      highlight_child(false);
    }

    pointer_to_currline(saved_ptrline);
    _lines_of_text[pointer_to_currline()]->set_cursor_position_abs(saved_ptrline_child,
                                                                   saved_curpos.first,
                                                                   saved_curpos.second);

  }
}


unsigned int paragraph_text::size_lines_of_text(){
  return _lines_of_text.size();
}


bool paragraph_text::break_and_split_normal_str(etichetta** left , etichetta** right){
  bool res=false;
  int point_bk=pointer_to_currline();
  if(*left==0 ){
    *left=new multifont_label();
  }

  if(*right==0 ){
    *right=new multifont_label();
  }

  if(typeid(**left) == typeid(multifont_label) &&
     typeid(**right) == typeid(multifont_label) &&
     pointer_to_currline()>=0 &&
     ptr_line_less_lines_text() ){
    
    if((*left)!=0 && (*right)!=0){
      delete (*left);
      delete (*right);
    }
    
    multifont_label copy_lb(_lines_of_text[pointer_to_currline()]);
    //std::cerr << copy_lb.dump_label() << std::endl;
    unsigned int labels_size=copy_lb.get_lines_text().size();
    int cpos=copy_lb.pointer_to_currline();

    (*left)=new multifont_label(copy_lb);
    (*right)=new multifont_label(copy_lb);
    
    dynamic_cast<multifont_label*>((*left))->elimina();
    dynamic_cast<multifont_label*>((*right))->elimina();

  //delete_line(int pos, bool reset_pointer_currline);
    for(unsigned int i=0;i<labels_size;i++){
      if(static_cast<int>(i)<=cpos){
        dynamic_cast<multifont_label*>((*right))->add_line(copy_lb.get_line_copy(i));
      }else{
        dynamic_cast<multifont_label*>((*left))->add_line(copy_lb.get_line_copy(i));
  
      }
    }
    
    
    insert_line(dynamic_cast<multifont_label*>(*right), pointer_to_currline());
    insert_line(dynamic_cast<multifont_label*>(*left), pointer_to_currline());
    delete_line(pointer_to_currline()-2,true);
    pointer_to_currline(point_bk);
    pointer_to_currline_transl(1);
    _lines_of_text[pointer_to_currline()]->set_cursor_position_abs(0,0,0);
    res=true;
  }
  return res;
}



bool paragraph_text::check_if_abs_pos_legal(int ptrline,
                                            int ptrline_child,
                                            int cpos_f,
                                            int cpos_s){

  bool res=false;

  if(ptrline >=0 && 
     ptrline < static_cast<int>(size_lines_of_text())){
    int size_pointer_child=_lines_of_text[ptrline]->size_lines_of_text();
    if(ptrline_child >=0 && 
       ptrline_child < size_pointer_child ){
         etichetta lb=_lines_of_text[ptrline]->get_line_copy(ptrline_child);
         std::vector < std::pair<std::string,int> > the_vec_str=lb.vec_str();
         if(cpos_f >= 0 && 
            cpos_f < static_cast<int>(the_vec_str.size())){
           std::string st=the_vec_str[cpos_f].first;
           if(cpos_s >= 0 && cpos_s <= static_cast<int>(st.size())){
             res=true;
           }
         }
    }
  }
    
    return res;
}

etichetta paragraph_text::get_label_copy_from_coordinate(int ptrline,
                                                         int ptrline_child) throw (out_of_range){
  etichetta lb;
  if(ptrline >=0 && 
     ptrline < static_cast<int>(size_lines_of_text())){
     int saved_pointer_child=_lines_of_text[ptrline]->pointer_to_currline();
     if(ptrline_child >=0 && 
        ptrline_child < static_cast<int>(saved_pointer_child)){
       lb=_lines_of_text[ptrline]->get_line_copy(ptrline_child);
    }else{
      std::string st=std::string("error in ") +  std::string(__FUNCTION__);
      throw out_of_range(st);
    }
  }

  return lb;
}
                                                   


int paragraph_text::calculate_no_chars_before_abs_cur_pos(int line,
                                                          int line_child,
                                                          std::pair<int,string::size_type> cpos_c){

  int res=0;
  if(check_if_abs_pos_legal(line,
                            line_child,
                            cpos_c.first,
                            cpos_c.second)){
    for(int i=0;i<line_child;i++){
      etichetta lb=get_label_copy_from_coordinate(line,i);
      std::vector < std::pair<std::string,int> > the_vec_str=lb.vec_str();
      for(unsigned int j=0;j<the_vec_str.size();j++){
        res+=the_vec_str[j].first.size();
      }
    }

    if(cpos_c.first>0){
      res+=cpos_c.first;
    }
    res+=cpos_c.second;

  }
    
  return res;
}


void paragraph_text::calculate_curpos_until_limit(unsigned int ptrline,
                                                  unsigned int& line, 
                                                  std::pair<int,string::size_type>& cpos,
                                                  int limit){
  int raw_count=0;
  int label_in_line=_lines_of_text[ptrline]->size_lines_of_text();
  for(unsigned int j=0;j< _lines_of_text[ptrline]->size_lines_of_text();j++){
    line=j;
    etichetta lb=_lines_of_text[ptrline]->get_line_copy(j);
    std::vector < std::pair<std::string,int> > the_vec_str=lb.vec_str();
    for(unsigned int k=0;k<the_vec_str.size();k++){
      cpos.first=k;
      std::string s_l=the_vec_str[k].first;
      int s_l_size_mod=0;
      if(static_cast<int>(j) == label_in_line-1 && limit-raw_count>0 ){
        s_l_size_mod=1;
      }
      for(unsigned int l=0;l<s_l.size()+s_l_size_mod;l++){
        cpos.second=l;
        if( (static_cast<int>(j) == label_in_line-1 && raw_count<=limit) ||
            (static_cast<int>(j) < label_in_line && raw_count<limit) ){
          /*
          std::cerr << "static_cast<int>(j) == label_in_line-1 " 
                    << (static_cast<int>(j) == label_in_line-1) << " " 
                    << label_in_line-1 << " "<< "j="<< j 
                    << "raw=" << raw_count 
                    << "s_l=" << s_l
                    << std::endl;
          */
          raw_count++;

        }else{
          return;
        }
      }
    }
  }
}






const int paragraph_text::_default_interline_space=5;

