#ifndef GBEMOL_MPD_H
#define GBEMOL_MPD_H

#include <gtk/gtk.h>
#include "libmpdclient.h"
/*
 * Type macros.
 */

G_BEGIN_DECLS

#define GBEMOL_TYPE_MPD         (gbemol_mpd_get_type ())
#define GBEMOL_MPD(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GBEMOL_TYPE_MPD, GbemolMpd))
#define GBEMOL_MPD_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GBEMOL_TYPE_MPD, GbemolMpdClass))
#define GBEMOL_IS_MPD(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GBEMOL_TYPE_MPD))
#define GBEMOL_IS_MPD_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GBEMOL_TYPE_MPD))
#define GBEMOL_MPD_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GBEMOL_TYPE_MPD, GbemolMpdClass))

typedef struct _GbemolMpd GbemolMpd;
typedef struct _GbemolMpdClass GbemolMpdClass;
typedef struct _GbemolMpdPrivate GbemolMpdPrivate;

/* Naming conventions typedefs */
typedef mpd_Status GbemolMpdStatus;
typedef mpd_Song GbemolMpdSong;
typedef mpd_InfoEntity GbemolMpdInfo;
typedef mpd_OutputEntity GbemolMpdOutput;

struct _GbemolMpd {
  GObject parent;
  GbemolMpdStatus *status;
  GbemolMpdPrivate *priv;
};


struct _GbemolMpdClass {
  GObjectClass parent;
};

GType gbemol_mpd_get_type (void);

/* Methods */

/* New GbemolMpd with default values */
GbemolMpd* gbemol_mpd_new_with_defaults (void);
GbemolMpd* gbemol_mpd_new (const gchar *host, const gchar *pass, int port, float timeout);

/* Connection Methods */
gboolean gbemol_mpd_connect (GbemolMpd *obj);
gboolean gbemol_mpd_connect_and_authenticate (GbemolMpd* obj);
void gbemol_mpd_disconnect (GbemolMpd *obj);
gboolean gbemol_mpd_is_connected (GbemolMpd *obj);
gchar* gbemol_mpd_get_version (GbemolMpd* obj);

/* Authenticate the connection with the password */
gboolean gbemol_mpd_authenticate (GbemolMpd *obj);

/* Property set methods */
void gbemol_mpd_set_host (GbemolMpd *obj, const gchar *host);
void gbemol_mpd_set_pass (GbemolMpd *obj, const gchar *pass);
void gbemol_mpd_set_port (GbemolMpd *obj, guint port);
void gbemol_mpd_set_timeout (GbemolMpd *obj, gfloat timeout);

/* Player Methods */
void gbemol_mpd_player_next (GbemolMpd *obj);
void gbemol_mpd_player_previous (GbemolMpd *obj);
void gbemol_mpd_player_pause (GbemolMpd *obj);
void gbemol_mpd_player_stop (GbemolMpd *obj);
void gbemol_mpd_player_play_song_by_id (GbemolMpd *obj, int id);
void gbemol_mpd_player_play_song_by_pos (GbemolMpd *obj, int pos);
void gbemol_mpd_set_random (GbemolMpd *obj, gboolean random);
void gbemol_mpd_set_repeat (GbemolMpd *obj, gboolean repeat);
void gbemol_mpd_seek (GbemolMpd *obj, int id, int sec);
void gbemol_mpd_crossfade (GbemolMpd *obj, int fade);
void gbemol_mpd_set_volume (GbemolMpd *obj, int vol); 
GbemolMpdSong* gbemol_mpd_get_current_song (GbemolMpd *obj);

gboolean gbemol_mpd_song_is_stream (GbemolMpdSong* song);

/* playlist methods */
GList* gbemol_mpd_playlist_get_songs (GbemolMpd *obj);
GbemolMpdSong* gbemol_mpd_playlist_get_song_by_id (GbemolMpd *obj, gint id);
void gbemol_mpd_playlist_clear (GbemolMpd *obj);
void gbemol_mpd_playlist_shuffle (GbemolMpd *obj);
void gbemol_mpd_playlist_remove_song_by_id (GbemolMpd *obj, gint id);
void gbemol_mpd_playlist_remove_song_by_pos (GbemolMpd *obj, gint pos);
void gbemol_mpd_playlist_add_song (GbemolMpd* obj, gchar* path);

/* playlist files methods */
GList* gbemol_mpd_get_playlists (GbemolMpd *obj);
GList* gbemol_mpd_preview_playlist (GbemolMpd *obj, gchar *path);
void gbemol_mpd_load_playlist (GbemolMpd *obj, gchar *path);
void gbemol_mpd_delete_playlist (GbemolMpd *obj, gchar *path);
gboolean gbemol_mpd_save_playlist (GbemolMpd *obj, gchar *path);

/* Memory methods */
void gbemol_mpd_free_song (GbemolMpdSong *song);
void gbemol_mpd_free_song_list (GList *songs);
void gbemol_mpd_free_char_list (GList *l);
void gbemol_mpd_free_output_list (GList *l);
GbemolMpdSong* gbemol_mpd_songdup(GbemolMpdSong* song);

/* Queue functions */
void gbemol_mpd_queue_start (GbemolMpd *obj);
void gbemol_mpd_queue_finish (GbemolMpd* obj);
void gbemol_mpd_queue_remove_song (GbemolMpd* obj, gint id);
void gbemol_mpd_queue_add_song (GbemolMpd *obj, gchar* path);

/* Search functions */
void gbemol_mpd_search_field_start (GbemolMpd* obj, gint field);
void gbemol_mpd_search_add_constraint (GbemolMpd* obj, gint tag, gchar* value);
GList* gbemol_mpd_search_field_get_results (GbemolMpd* obj, gint tag);
GList* gbemol_mpd_search_get_results (GbemolMpd* obj);
void gbemol_mpd_search_start (GbemolMpd* obj);
void gbemol_mpd_search_commit (GbemolMpd* obj);

/* DB Functions */
GList* gbemol_mpd_database_get_all_songs (GbemolMpd* obj);
void gbemol_mpd_database_update (GbemolMpd* obj, gchar* path);

/* Output functions */
void gbemol_mpd_output_set_active (GbemolMpd* obj, gint id, gboolean active);
GList* gbemol_mpd_output_get_list (GbemolMpd* obj);

/* Status retrieval functions */
gint gbemol_mpd_get_crossfade (GbemolMpd* obj);
gint gbemol_mpd_get_state (GbemolMpd* obj);
gint gbemol_mpd_get_current_id (GbemolMpd* obj);
gint gbemol_mpd_get_total_time (GbemolMpd* obj);


gboolean gbemol_mpd_check_permission (GbemolMpd *obj, gchar *command);



G_END_DECLS


#endif
