# frozen_string_literal: true

class RemoveIndexVulnerabilityFindingSignaturesOnFindingId < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_finding_signatures
  INDEX_NAME = 'index_vulnerability_finding_signatures_on_finding_id'
  COLUMNS = %i[finding_id]

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, COLUMNS, name: INDEX_NAME
  end
end
