/* gmpc-widgets-qtable.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-widgets-qtable.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_QTABLE_ENTRY (qtable_entry_get_type ())
#define QTABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QTABLE_ENTRY, QtableEntry))
#define QTABLE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QTABLE_ENTRY, QtableEntryClass))
#define IS_QTABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QTABLE_ENTRY))
#define IS_QTABLE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QTABLE_ENTRY))
#define QTABLE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QTABLE_ENTRY, QtableEntryClass))

typedef struct _QtableEntry QtableEntry;
typedef struct _QtableEntryClass QtableEntryClass;
typedef struct _QtableEntryPrivate QtableEntryPrivate;

#define QTABLE_ENTRY_TYPE_TYPE (qtable_entry_type_get_type ())
typedef struct _ParamSpecQtableEntry ParamSpecQtableEntry;
#define __g_list_free__qtable_entry_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__qtable_entry_unref0_ (var), NULL)))
#define _qtable_entry_unref0(var) ((var == NULL) ? NULL : (var = (qtable_entry_unref (var), NULL)))

typedef enum  {
	QTABLE_ENTRY_TYPE_HEADER,
	QTABLE_ENTRY_TYPE_ITEM
} QtableEntryType;

struct _QtableEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QtableEntryPrivate * priv;
	QtableEntryType type;
	GtkWidget* widget;
};

struct _QtableEntryClass {
	GTypeClass parent_class;
	void (*finalize) (QtableEntry *self);
};

struct _ParamSpecQtableEntry {
	GParamSpec parent_instance;
};

struct _GmpcWidgetsQtablePrivate {
	gint item_width_real;
	gint item_height_real;
	gint header_height_real;
	gint max_columns_real;
	gint num_items;
	gint columns;
	gint _spacing;
	GList* children;
};


static gpointer qtable_entry_parent_class = NULL;
static gpointer gmpc_widgets_qtable_parent_class = NULL;
static GtkBuildableIface* gmpc_widgets_qtable_gtk_buildable_parent_iface = NULL;

#define use_transition_gav TRUE
#define some_unique_name_gav VERSION
gpointer qtable_entry_ref (gpointer instance);
void qtable_entry_unref (gpointer instance);
GParamSpec* param_spec_qtable_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_qtable_entry (GValue* value, gpointer v_object);
void value_take_qtable_entry (GValue* value, gpointer v_object);
gpointer value_get_qtable_entry (const GValue* value);
GType qtable_entry_get_type (void) G_GNUC_CONST;
GType qtable_entry_type_get_type (void) G_GNUC_CONST;
enum  {
	QTABLE_ENTRY_DUMMY_PROPERTY
};
QtableEntry* qtable_entry_new (void);
QtableEntry* qtable_entry_construct (GType object_type);
static void qtable_entry_finalize (QtableEntry* obj);
#define GMPC_WIDGETS_QTABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_WIDGETS_TYPE_QTABLE, GmpcWidgetsQtablePrivate))
enum  {
	GMPC_WIDGETS_QTABLE_DUMMY_PROPERTY,
	GMPC_WIDGETS_QTABLE_SPACING,
	GMPC_WIDGETS_QTABLE_MAX_COLUMNS,
	GMPC_WIDGETS_QTABLE_ITEM_WIDTH,
	GMPC_WIDGETS_QTABLE_ITEM_HEIGHT,
	GMPC_WIDGETS_QTABLE_HEADER_HEIGHT
};
static void _qtable_entry_unref0_ (gpointer var);
static void _g_list_free__qtable_entry_unref0_ (GList* self);
static void gmpc_widgets_qtable_real_add_child (GtkBuildable* base, GtkBuilder* build, GObject* child, const gchar* type);
static void gmpc_widgets_qtable_real_size_request (GtkWidget* base, GtkRequisition* req);
static void gmpc_widgets_qtable_real_add (GtkContainer* base, GtkWidget* widget);
static GType gmpc_widgets_qtable_real_child_type (GtkContainer* base);
static void gmpc_widgets_qtable_real_remove (GtkContainer* base, GtkWidget* widget);
static void gmpc_widgets_qtable_real_size_allocate (GtkWidget* base, GdkRectangle* alloc);
static void gmpc_widgets_qtable_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback callback, void* callback_target);
static GObject * gmpc_widgets_qtable_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_widgets_qtable_finalize (GObject* obj);
static void _vala_gmpc_widgets_qtable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gmpc_widgets_qtable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType qtable_entry_type_get_type (void) {
	static volatile gsize qtable_entry_type_type_id__volatile = 0;
	if (g_once_init_enter (&qtable_entry_type_type_id__volatile)) {
		static const GEnumValue values[] = {{QTABLE_ENTRY_TYPE_HEADER, "QTABLE_ENTRY_TYPE_HEADER", "header"}, {QTABLE_ENTRY_TYPE_ITEM, "QTABLE_ENTRY_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType qtable_entry_type_type_id;
		qtable_entry_type_type_id = g_enum_register_static ("QtableEntryType", values);
		g_once_init_leave (&qtable_entry_type_type_id__volatile, qtable_entry_type_type_id);
	}
	return qtable_entry_type_type_id__volatile;
}


QtableEntry* qtable_entry_construct (GType object_type) {
	QtableEntry* self = NULL;
	self = (QtableEntry*) g_type_create_instance (object_type);
	return self;
}


QtableEntry* qtable_entry_new (void) {
	return qtable_entry_construct (TYPE_QTABLE_ENTRY);
}


static void value_qtable_entry_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_qtable_entry_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		qtable_entry_unref (value->data[0].v_pointer);
	}
}


static void value_qtable_entry_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = qtable_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_qtable_entry_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_qtable_entry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		QtableEntry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = qtable_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_qtable_entry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	QtableEntry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = qtable_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_qtable_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecQtableEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QTABLE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_qtable_entry (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QTABLE_ENTRY), NULL);
	return value->data[0].v_pointer;
}


void value_set_qtable_entry (GValue* value, gpointer v_object) {
	QtableEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QTABLE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QTABLE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		qtable_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qtable_entry_unref (old);
	}
}


void value_take_qtable_entry (GValue* value, gpointer v_object) {
	QtableEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QTABLE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QTABLE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qtable_entry_unref (old);
	}
}


static void qtable_entry_class_init (QtableEntryClass * klass) {
	qtable_entry_parent_class = g_type_class_peek_parent (klass);
	QTABLE_ENTRY_CLASS (klass)->finalize = qtable_entry_finalize;
}


static void qtable_entry_instance_init (QtableEntry * self) {
	self->ref_count = 1;
}


static void qtable_entry_finalize (QtableEntry* obj) {
	QtableEntry * self;
	self = QTABLE_ENTRY (obj);
}


GType qtable_entry_get_type (void) {
	static volatile gsize qtable_entry_type_id__volatile = 0;
	if (g_once_init_enter (&qtable_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_qtable_entry_init, value_qtable_entry_free_value, value_qtable_entry_copy_value, value_qtable_entry_peek_pointer, "p", value_qtable_entry_collect_value, "p", value_qtable_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (QtableEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qtable_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QtableEntry), 0, (GInstanceInitFunc) qtable_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType qtable_entry_type_id;
		qtable_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QtableEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&qtable_entry_type_id__volatile, qtable_entry_type_id);
	}
	return qtable_entry_type_id__volatile;
}


gpointer qtable_entry_ref (gpointer instance) {
	QtableEntry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void qtable_entry_unref (gpointer instance) {
	QtableEntry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QTABLE_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _qtable_entry_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (qtable_entry_unref (var), NULL));
}


static void _g_list_free__qtable_entry_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _qtable_entry_unref0_, NULL);
	g_list_free (self);
}


static void gmpc_widgets_qtable_real_add_child (GtkBuildable* base, GtkBuilder* build, GObject* child, const gchar* type) {
	GmpcWidgetsQtable * self;
	gboolean _tmp0_ = FALSE;
	self = (GmpcWidgetsQtable*) base;
	g_return_if_fail (build != NULL);
	g_return_if_fail (child != NULL);
	if (!GTK_IS_WIDGET (child)) {
		g_warning ("gmpc-widgets-qtable.vala:92: Trying to add non widget");
		return;
	}
	if (type != NULL) {
		_tmp0_ = g_strcmp0 (type, "header") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GObject* _tmp1_;
		_tmp1_ = child;
		gmpc_widgets_qtable_add_header (self, GTK_IS_WIDGET (_tmp1_) ? ((GtkWidget*) _tmp1_) : NULL);
	} else {
		GObject* _tmp2_;
		_tmp2_ = child;
		gtk_container_add ((GtkContainer*) self, GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL);
	}
}


GmpcWidgetsQtable* gmpc_widgets_qtable_construct (GType object_type) {
	GmpcWidgetsQtable * self = NULL;
	self = (GmpcWidgetsQtable*) g_object_new (object_type, NULL);
	return self;
}


GmpcWidgetsQtable* gmpc_widgets_qtable_new (void) {
	return gmpc_widgets_qtable_construct (GMPC_WIDGETS_TYPE_QTABLE);
}


/**
     * Calculates the size of the widget.
 */
static gpointer _qtable_entry_ref0 (gpointer self) {
	return self ? qtable_entry_ref (self) : NULL;
}


static void gmpc_widgets_qtable_real_size_request (GtkWidget* base, GtkRequisition* req) {
	GmpcWidgetsQtable * self;
	GtkRequisition _req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkRequisition _tmp1_ = {0};
	gint cover_width;
	gint cover_height;
	gint header_height;
	gint width;
	gint items;
	gint rows;
	self = (GmpcWidgetsQtable*) base;
	memset (&_tmp0_, 0, sizeof (GtkRequisition));
	_tmp1_ = _tmp0_;
	_req = _tmp1_;
	cover_width = self->priv->item_width_real;
	cover_height = self->priv->item_height_real;
	header_height = self->priv->header_height_real;
	width = 0;
	items = 0;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = self->priv->children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			QtableEntry* _tmp2_;
			QtableEntry* child;
			_tmp2_ = _qtable_entry_ref0 ((QtableEntry*) child_it->data);
			child = _tmp2_;
			{
				gboolean _tmp3_;
				_tmp3_ = gtk_widget_get_visible (child->widget);
				if (_tmp3_) {
					if (child->type == QTABLE_ENTRY_TYPE_ITEM) {
						GtkRequisition _tmp4_ = {0};
						GtkRequisition cr;
						GtkRequisition _tmp5_ = {0};
						gint _tmp6_;
						gint _tmp7_;
						_tmp4_.width = 0;
						_tmp4_.height = 0;
						cr = _tmp4_;
						gtk_widget_size_request (child->widget, &_tmp5_);
						cr = _tmp5_;
						_tmp6_ = MAX (cr.width, cover_width);
						cover_width = _tmp6_;
						_tmp7_ = MAX (cr.height, cover_height);
						cover_height = _tmp7_;
					} else {
						GtkRequisition _tmp8_ = {0};
						GtkRequisition cr;
						GtkRequisition _tmp9_ = {0};
						gint _tmp10_;
						gint _tmp11_;
						_tmp8_.width = 0;
						_tmp8_.height = 0;
						cr = _tmp8_;
						gtk_widget_size_request (child->widget, &_tmp9_);
						cr = _tmp9_;
						_tmp10_ = MAX (cr.width, width);
						width = _tmp10_;
						_tmp11_ = MAX (cr.height, header_height);
						header_height = _tmp11_;
					}
				}
				_qtable_entry_unref0 (child);
			}
		}
	}
	if (self->priv->_spacing > 0) {
		cover_width = cover_width + self->priv->_spacing;
		cover_height = cover_height + self->priv->_spacing;
		header_height = header_height + self->priv->_spacing;
	}
	rows = 0;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = self->priv->children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			QtableEntry* _tmp12_;
			QtableEntry* child;
			_tmp12_ = _qtable_entry_ref0 ((QtableEntry*) child_it->data);
			child = _tmp12_;
			{
				gboolean _tmp13_;
				_tmp13_ = gtk_widget_get_visible (child->widget);
				if (_tmp13_) {
					if (child->type == QTABLE_ENTRY_TYPE_ITEM) {
						items++;
					} else {
						if (items != 0) {
							gint nrows;
							gint _tmp14_ = 0;
							gint remain;
							nrows = items / self->priv->columns;
							if ((items % self->priv->columns) > 0) {
								_tmp14_ = 1;
							} else {
								_tmp14_ = 0;
							}
							remain = _tmp14_;
							rows = rows + ((nrows + remain) * cover_height);
						}
						items = 0;
						rows = rows + header_height;
					}
				}
				_qtable_entry_unref0 (child);
			}
		}
	}
	if (items != 0) {
		gint nrows;
		gint _tmp15_ = 0;
		gint remain;
		nrows = items / self->priv->columns;
		if ((items % self->priv->columns) > 0) {
			_tmp15_ = 1;
		} else {
			_tmp15_ = 0;
		}
		remain = _tmp15_;
		rows = rows + ((nrows + remain) * cover_height);
	}
	_req.width = cover_width;
	_req.height = rows;
	if (req) {
		*req = _req;
	}
}


static void gmpc_widgets_qtable_real_add (GtkContainer* base, GtkWidget* widget) {
	GmpcWidgetsQtable * self;
	self = (GmpcWidgetsQtable*) base;
	g_return_if_fail (widget != NULL);
	if (widget != NULL) {
		QtableEntry* _tmp0_ = NULL;
		QtableEntry* a;
		QtableEntry* _tmp1_;
		_tmp0_ = qtable_entry_new ();
		a = _tmp0_;
		a->type = QTABLE_ENTRY_TYPE_ITEM;
		a->widget = widget;
		_tmp1_ = _qtable_entry_ref0 (a);
		self->priv->children = g_list_append (self->priv->children, _tmp1_);
		gtk_widget_set_parent (widget, (GtkWidget*) self);
		self->priv->num_items++;
		gtk_widget_queue_resize ((GtkWidget*) self);
		_qtable_entry_unref0 (a);
	}
}


void gmpc_widgets_qtable_add_header (GmpcWidgetsQtable* self, GtkWidget* widget) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (widget != NULL) {
		QtableEntry* _tmp0_ = NULL;
		QtableEntry* a;
		QtableEntry* _tmp1_;
		_tmp0_ = qtable_entry_new ();
		a = _tmp0_;
		a->type = QTABLE_ENTRY_TYPE_HEADER;
		a->widget = widget;
		_tmp1_ = _qtable_entry_ref0 (a);
		self->priv->children = g_list_append (self->priv->children, _tmp1_);
		gtk_widget_set_parent (widget, (GtkWidget*) self);
		self->priv->num_items++;
		gtk_widget_queue_resize ((GtkWidget*) self);
		_qtable_entry_unref0 (a);
	}
}


static GType gmpc_widgets_qtable_real_child_type (GtkContainer* base) {
	GmpcWidgetsQtable * self;
	GType result = 0UL;
	self = (GmpcWidgetsQtable*) base;
	result = GTK_TYPE_WIDGET;
	return result;
}


static void gmpc_widgets_qtable_real_remove (GtkContainer* base, GtkWidget* widget) {
	GmpcWidgetsQtable * self;
	self = (GmpcWidgetsQtable*) base;
	g_return_if_fail (widget != NULL);
	if (widget != NULL) {
		QtableEntry* a;
		gboolean _tmp2_;
		gboolean visible;
		QtableEntry* _tmp3_;
		QtableEntry* _tmp4_;
		a = NULL;
		{
			GList* f_collection;
			GList* f_it;
			f_collection = self->priv->children;
			for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
				QtableEntry* _tmp0_;
				QtableEntry* f;
				_tmp0_ = _qtable_entry_ref0 ((QtableEntry*) f_it->data);
				f = _tmp0_;
				{
					if (f->widget == widget) {
						QtableEntry* _tmp1_;
						_tmp1_ = _qtable_entry_ref0 (f);
						_qtable_entry_unref0 (a);
						a = _tmp1_;
						_qtable_entry_unref0 (f);
						break;
					}
					_qtable_entry_unref0 (f);
				}
			}
		}
		if (a == NULL) {
			g_error ("gmpc-widgets-qtable.vala:221: Failed to find widget in container");
		}
		_tmp2_ = gtk_widget_get_visible (widget);
		visible = _tmp2_;
		gtk_widget_unparent (widget);
		_tmp3_ = a;
		a = NULL;
		_tmp4_ = _tmp3_;
		self->priv->children = g_list_remove (self->priv->children, _tmp4_);
		_qtable_entry_unref0 (_tmp4_);
		self->priv->num_items--;
		if (visible) {
			gtk_widget_queue_resize ((GtkWidget*) self);
		}
		_qtable_entry_unref0 (a);
	}
}


static void gmpc_widgets_qtable_real_size_allocate (GtkWidget* base, GdkRectangle* alloc) {
	GmpcWidgetsQtable * self;
	gint cover_width;
	gint cover_height;
	gint header_height;
	gint width;
	gint new_columns;
	gint rows;
	gint item;
	gint _tmp10_;
	self = (GmpcWidgetsQtable*) base;
	cover_width = self->priv->item_width_real;
	cover_height = self->priv->item_height_real;
	header_height = self->priv->header_height_real;
	if ((*alloc).width == 1) {
		return;
	}
	width = (*alloc).width;
	new_columns = 0;
	rows = 0;
	item = 0;
	((GtkWidget*) self)->allocation = (GtkAllocation) (*alloc);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = self->priv->children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			QtableEntry* _tmp0_;
			QtableEntry* child;
			_tmp0_ = _qtable_entry_ref0 ((QtableEntry*) child_it->data);
			child = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = gtk_widget_get_visible (child->widget);
				if (_tmp1_) {
					if (child->type == QTABLE_ENTRY_TYPE_ITEM) {
						GtkRequisition _tmp2_ = {0};
						GtkRequisition cr;
						GtkRequisition _tmp3_ = {0};
						gint _tmp4_;
						gint _tmp5_;
						_tmp2_.width = 0;
						_tmp2_.height = 0;
						cr = _tmp2_;
						gtk_widget_size_request (child->widget, &_tmp3_);
						cr = _tmp3_;
						_tmp4_ = MAX (cr.width, cover_width);
						cover_width = _tmp4_;
						_tmp5_ = MAX (cr.height, cover_height);
						cover_height = _tmp5_;
						item++;
					} else {
						GtkRequisition _tmp6_ = {0};
						GtkRequisition cr;
						GtkRequisition _tmp7_ = {0};
						gint _tmp8_;
						gint _tmp9_;
						_tmp6_.width = 0;
						_tmp6_.height = 0;
						cr = _tmp6_;
						gtk_widget_size_request (child->widget, &_tmp7_);
						cr = _tmp7_;
						item = 0;
						_tmp8_ = MAX (cr.width, width);
						width = _tmp8_;
						_tmp9_ = MAX (cr.height, header_height);
						header_height = _tmp9_;
					}
				}
				_qtable_entry_unref0 (child);
			}
		}
	}
	if (self->priv->_spacing > 0) {
		cover_width = cover_width + self->priv->_spacing;
		cover_height = cover_height + self->priv->_spacing;
		header_height = header_height + self->priv->_spacing;
	}
	_tmp10_ = MAX (width / cover_width, 1);
	new_columns = _tmp10_;
	if (self->priv->max_columns_real > 0) {
		gint _tmp11_;
		_tmp11_ = MIN (new_columns, self->priv->max_columns_real);
		new_columns = _tmp11_;
	}
	item = 0;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = self->priv->children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			QtableEntry* _tmp12_;
			QtableEntry* child;
			_tmp12_ = _qtable_entry_ref0 ((QtableEntry*) child_it->data);
			child = _tmp12_;
			{
				gboolean _tmp13_;
				_tmp13_ = gtk_widget_get_visible (child->widget);
				if (_tmp13_) {
					if (child->type == QTABLE_ENTRY_TYPE_ITEM) {
						GdkRectangle _tmp14_ = {0};
						GdkRectangle ca;
						_tmp14_.x = 0;
						_tmp14_.y = 0;
						_tmp14_.width = 0;
						_tmp14_.height = 0;
						ca = _tmp14_;
						ca.x = (*alloc).x + ((item % self->priv->columns) * cover_width);
						ca.y = (rows + (*alloc).y) + ((item / self->priv->columns) * cover_height);
						ca.width = cover_width - self->priv->_spacing;
						ca.height = cover_height - self->priv->_spacing;
						gtk_widget_size_allocate (child->widget, &ca);
						item++;
					} else {
						GdkRectangle _tmp16_ = {0};
						GdkRectangle ca;
						if (item != 0) {
							gint nrows;
							gint _tmp15_ = 0;
							gint remain;
							nrows = item / self->priv->columns;
							if ((item % self->priv->columns) > 0) {
								_tmp15_ = 1;
							} else {
								_tmp15_ = 0;
							}
							remain = _tmp15_;
							rows = rows + ((nrows + remain) * cover_height);
						}
						item = 0;
						_tmp16_.x = 0;
						_tmp16_.y = 0;
						_tmp16_.width = 0;
						_tmp16_.height = 0;
						ca = _tmp16_;
						ca.x = (*alloc).x;
						ca.y = (*alloc).y + rows;
						ca.width = cover_width * self->priv->columns;
						ca.height = header_height - self->priv->_spacing;
						gtk_widget_size_allocate (child->widget, &ca);
						rows = rows + header_height;
					}
				}
				_qtable_entry_unref0 (child);
			}
		}
	}
	if (new_columns != self->priv->columns) {
		self->priv->columns = new_columns;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
}


static void gmpc_widgets_qtable_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback callback, void* callback_target) {
	GmpcWidgetsQtable * self;
	GList* _tmp0_ = NULL;
	GList* iter;
	self = (GmpcWidgetsQtable*) base;
	_tmp0_ = g_list_first (self->priv->children);
	iter = _tmp0_;
	while (TRUE) {
		QtableEntry* child;
		if (!(iter != NULL)) {
			break;
		}
		child = (QtableEntry*) iter->data;
		iter = iter->next;
		callback (child->widget, callback_target);
	}
}


void gmpc_widgets_qtable_clear (GmpcWidgetsQtable* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = self->priv->children;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			QtableEntry* _tmp0_;
			QtableEntry* a;
			_tmp0_ = _qtable_entry_ref0 ((QtableEntry*) a_it->data);
			a = _tmp0_;
			{
				gtk_widget_unparent (a->widget);
				self->priv->num_items--;
				_qtable_entry_unref0 (a);
			}
		}
	}
	__g_list_free__qtable_entry_unref0_0 (self->priv->children);
	self->priv->children = NULL;
	gtk_widget_queue_resize ((GtkWidget*) self);
}


gint gmpc_widgets_qtable_get_spacing (GmpcWidgetsQtable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_spacing;
	return result;
}


void gmpc_widgets_qtable_set_spacing (GmpcWidgetsQtable* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_spacing = value;
	g_object_notify ((GObject *) self, "spacing");
}


gint gmpc_widgets_qtable_get_max_columns (GmpcWidgetsQtable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->max_columns_real;
	return result;
}


void gmpc_widgets_qtable_set_max_columns (GmpcWidgetsQtable* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->max_columns_real = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "max-columns");
}


gint gmpc_widgets_qtable_get_item_width (GmpcWidgetsQtable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->item_width_real;
	return result;
}


void gmpc_widgets_qtable_set_item_width (GmpcWidgetsQtable* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->item_width_real = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "item-width");
}


gint gmpc_widgets_qtable_get_item_height (GmpcWidgetsQtable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->item_height_real;
	return result;
}


void gmpc_widgets_qtable_set_item_height (GmpcWidgetsQtable* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->item_height_real = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "item-height");
}


gint gmpc_widgets_qtable_get_header_height (GmpcWidgetsQtable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->header_height_real;
	return result;
}


void gmpc_widgets_qtable_set_header_height (GmpcWidgetsQtable* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->header_height_real = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "header-height");
}


static GObject * gmpc_widgets_qtable_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcWidgetsQtable * self;
	parent_class = G_OBJECT_CLASS (gmpc_widgets_qtable_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_WIDGETS_QTABLE (obj);
	gtk_widget_set_has_window ((GtkWidget*) self, FALSE);
	gtk_widget_set_redraw_on_allocate ((GtkWidget*) self, FALSE);
	return obj;
}


static void gmpc_widgets_qtable_class_init (GmpcWidgetsQtableClass * klass) {
	gmpc_widgets_qtable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcWidgetsQtablePrivate));
	GTK_WIDGET_CLASS (klass)->size_request = gmpc_widgets_qtable_real_size_request;
	GTK_CONTAINER_CLASS (klass)->add = gmpc_widgets_qtable_real_add;
	GTK_CONTAINER_CLASS (klass)->child_type = gmpc_widgets_qtable_real_child_type;
	GTK_CONTAINER_CLASS (klass)->remove = gmpc_widgets_qtable_real_remove;
	GTK_WIDGET_CLASS (klass)->size_allocate = gmpc_widgets_qtable_real_size_allocate;
	GTK_CONTAINER_CLASS (klass)->forall = gmpc_widgets_qtable_real_forall_internal;
	G_OBJECT_CLASS (klass)->get_property = _vala_gmpc_widgets_qtable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gmpc_widgets_qtable_set_property;
	G_OBJECT_CLASS (klass)->constructor = gmpc_widgets_qtable_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_widgets_qtable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_WIDGETS_QTABLE_SPACING, g_param_spec_int ("spacing", "spacing", "spacing", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_WIDGETS_QTABLE_MAX_COLUMNS, g_param_spec_int ("max-columns", "max-columns", "max-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_WIDGETS_QTABLE_ITEM_WIDTH, g_param_spec_int ("item-width", "item-width", "item-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_WIDGETS_QTABLE_ITEM_HEIGHT, g_param_spec_int ("item-height", "item-height", "item-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_WIDGETS_QTABLE_HEADER_HEIGHT, g_param_spec_int ("header-height", "header-height", "header-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gmpc_widgets_qtable_gtk_buildable_interface_init (GtkBuildableIface * iface) {
	gmpc_widgets_qtable_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*)(GtkBuildable* ,GtkBuilder* ,GObject* ,const gchar*)) gmpc_widgets_qtable_real_add_child;
}


static void gmpc_widgets_qtable_instance_init (GmpcWidgetsQtable * self) {
	self->priv = GMPC_WIDGETS_QTABLE_GET_PRIVATE (self);
	self->priv->item_width_real = 0;
	self->priv->item_height_real = 0;
	self->priv->header_height_real = 0;
	self->priv->max_columns_real = 0;
	self->priv->num_items = 0;
	self->priv->columns = 3;
	self->priv->_spacing = 8;
	self->priv->children = NULL;
}


static void gmpc_widgets_qtable_finalize (GObject* obj) {
	GmpcWidgetsQtable * self;
	self = GMPC_WIDGETS_QTABLE (obj);
	__g_list_free__qtable_entry_unref0_0 (self->priv->children);
	G_OBJECT_CLASS (gmpc_widgets_qtable_parent_class)->finalize (obj);
}


GType gmpc_widgets_qtable_get_type (void) {
	static volatile gsize gmpc_widgets_qtable_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_widgets_qtable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcWidgetsQtableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_widgets_qtable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcWidgetsQtable), 0, (GInstanceInitFunc) gmpc_widgets_qtable_instance_init, NULL };
		static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) gmpc_widgets_qtable_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_widgets_qtable_type_id;
		gmpc_widgets_qtable_type_id = g_type_register_static (GTK_TYPE_CONTAINER, "GmpcWidgetsQtable", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_widgets_qtable_type_id, GTK_TYPE_BUILDABLE, &gtk_buildable_info);
		g_once_init_leave (&gmpc_widgets_qtable_type_id__volatile, gmpc_widgets_qtable_type_id);
	}
	return gmpc_widgets_qtable_type_id__volatile;
}


static void _vala_gmpc_widgets_qtable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GmpcWidgetsQtable * self;
	self = GMPC_WIDGETS_QTABLE (object);
	switch (property_id) {
		case GMPC_WIDGETS_QTABLE_SPACING:
		g_value_set_int (value, gmpc_widgets_qtable_get_spacing (self));
		break;
		case GMPC_WIDGETS_QTABLE_MAX_COLUMNS:
		g_value_set_int (value, gmpc_widgets_qtable_get_max_columns (self));
		break;
		case GMPC_WIDGETS_QTABLE_ITEM_WIDTH:
		g_value_set_int (value, gmpc_widgets_qtable_get_item_width (self));
		break;
		case GMPC_WIDGETS_QTABLE_ITEM_HEIGHT:
		g_value_set_int (value, gmpc_widgets_qtable_get_item_height (self));
		break;
		case GMPC_WIDGETS_QTABLE_HEADER_HEIGHT:
		g_value_set_int (value, gmpc_widgets_qtable_get_header_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gmpc_widgets_qtable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GmpcWidgetsQtable * self;
	self = GMPC_WIDGETS_QTABLE (object);
	switch (property_id) {
		case GMPC_WIDGETS_QTABLE_SPACING:
		gmpc_widgets_qtable_set_spacing (self, g_value_get_int (value));
		break;
		case GMPC_WIDGETS_QTABLE_MAX_COLUMNS:
		gmpc_widgets_qtable_set_max_columns (self, g_value_get_int (value));
		break;
		case GMPC_WIDGETS_QTABLE_ITEM_WIDTH:
		gmpc_widgets_qtable_set_item_width (self, g_value_get_int (value));
		break;
		case GMPC_WIDGETS_QTABLE_ITEM_HEIGHT:
		gmpc_widgets_qtable_set_item_height (self, g_value_get_int (value));
		break;
		case GMPC_WIDGETS_QTABLE_HEADER_HEIGHT:
		gmpc_widgets_qtable_set_header_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



