// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
)

// This operation is not supported by directory buckets. Returns some or all (up
// to 1,000) access points associated with the Object Lambda Access Point per call.
// If there are more access points than what can be returned in one call, the
// response will include a continuation token that you can use to list the
// additional access points. The following actions are related to
// ListAccessPointsForObjectLambda :
//   - CreateAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
//   - DeleteAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
//   - GetAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
func (c *Client) ListAccessPointsForObjectLambda(ctx context.Context, params *ListAccessPointsForObjectLambdaInput, optFns ...func(*Options)) (*ListAccessPointsForObjectLambdaOutput, error) {
	if params == nil {
		params = &ListAccessPointsForObjectLambdaInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccessPointsForObjectLambda", params, optFns, c.addOperationListAccessPointsForObjectLambdaMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccessPointsForObjectLambdaOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccessPointsForObjectLambdaInput struct {

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// This member is required.
	AccountId *string

	// The maximum number of access points that you want to include in the list. The
	// response may contain fewer access points but will never contain more. If there
	// are more than this number of access points, then the response will include a
	// continuation token in the NextToken field that you can use to retrieve the next
	// page of access points.
	MaxResults int32

	// If the list has more access points than can be returned in one call to this
	// API, this field contains a continuation token that you can provide in subsequent
	// calls to this API to retrieve additional access points.
	NextToken *string

	noSmithyDocumentSerde
}

func (in *ListAccessPointsForObjectLambdaInput) bindEndpointParams(p *EndpointParameters) {
	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type ListAccessPointsForObjectLambdaOutput struct {

	// If the list has more access points than can be returned in one call to this
	// API, this field contains a continuation token that you can provide in subsequent
	// calls to this API to retrieve additional access points.
	NextToken *string

	// Returns list of Object Lambda Access Points.
	ObjectLambdaAccessPointList []types.ObjectLambdaAccessPoint

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccessPointsForObjectLambdaMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListAccessPointsForObjectLambda{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListAccessPointsForObjectLambda{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccessPointsForObjectLambda"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListAccessPointsForObjectLambdaMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAccessPointsForObjectLambdaValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccessPointsForObjectLambda(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addListAccessPointsForObjectLambdaUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opListAccessPointsForObjectLambdaMiddleware struct {
}

func (*endpointPrefix_opListAccessPointsForObjectLambdaMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListAccessPointsForObjectLambdaMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*ListAccessPointsForObjectLambdaInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListAccessPointsForObjectLambdaMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListAccessPointsForObjectLambdaMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListAccessPointsForObjectLambdaAPIClient is a client that implements the
// ListAccessPointsForObjectLambda operation.
type ListAccessPointsForObjectLambdaAPIClient interface {
	ListAccessPointsForObjectLambda(context.Context, *ListAccessPointsForObjectLambdaInput, ...func(*Options)) (*ListAccessPointsForObjectLambdaOutput, error)
}

var _ ListAccessPointsForObjectLambdaAPIClient = (*Client)(nil)

// ListAccessPointsForObjectLambdaPaginatorOptions is the paginator options for
// ListAccessPointsForObjectLambda
type ListAccessPointsForObjectLambdaPaginatorOptions struct {
	// The maximum number of access points that you want to include in the list. The
	// response may contain fewer access points but will never contain more. If there
	// are more than this number of access points, then the response will include a
	// continuation token in the NextToken field that you can use to retrieve the next
	// page of access points.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccessPointsForObjectLambdaPaginator is a paginator for
// ListAccessPointsForObjectLambda
type ListAccessPointsForObjectLambdaPaginator struct {
	options   ListAccessPointsForObjectLambdaPaginatorOptions
	client    ListAccessPointsForObjectLambdaAPIClient
	params    *ListAccessPointsForObjectLambdaInput
	nextToken *string
	firstPage bool
}

// NewListAccessPointsForObjectLambdaPaginator returns a new
// ListAccessPointsForObjectLambdaPaginator
func NewListAccessPointsForObjectLambdaPaginator(client ListAccessPointsForObjectLambdaAPIClient, params *ListAccessPointsForObjectLambdaInput, optFns ...func(*ListAccessPointsForObjectLambdaPaginatorOptions)) *ListAccessPointsForObjectLambdaPaginator {
	if params == nil {
		params = &ListAccessPointsForObjectLambdaInput{}
	}

	options := ListAccessPointsForObjectLambdaPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccessPointsForObjectLambdaPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccessPointsForObjectLambdaPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccessPointsForObjectLambda page.
func (p *ListAccessPointsForObjectLambdaPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccessPointsForObjectLambdaOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListAccessPointsForObjectLambda(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAccessPointsForObjectLambda(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccessPointsForObjectLambda",
	}
}

func copyListAccessPointsForObjectLambdaInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*ListAccessPointsForObjectLambdaInput)
	if !ok {
		return nil, fmt.Errorf("expect *ListAccessPointsForObjectLambdaInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *ListAccessPointsForObjectLambdaInput) copy() interface{} {
	v := *in
	return &v
}
func backFillListAccessPointsForObjectLambdaAccountID(input interface{}, v string) error {
	in := input.(*ListAccessPointsForObjectLambdaInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addListAccessPointsForObjectLambdaUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyListAccessPointsForObjectLambdaInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
