// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetChannel = "BatchGetChannel"

// BatchGetChannelRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetChannel for more information on using the BatchGetChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetChannelRequest method.
//    req, resp := client.BatchGetChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel
func (c *IVS) BatchGetChannelRequest(input *BatchGetChannelInput) (req *request.Request, output *BatchGetChannelOutput) {
	op := &request.Operation{
		Name:       opBatchGetChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetChannel",
	}

	if input == nil {
		input = &BatchGetChannelInput{}
	}

	output = &BatchGetChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetChannel API operation for Amazon Interactive Video Service.
//
// Performs GetChannel on multiple ARNs simultaneously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation BatchGetChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel
func (c *IVS) BatchGetChannel(input *BatchGetChannelInput) (*BatchGetChannelOutput, error) {
	req, out := c.BatchGetChannelRequest(input)
	return out, req.Send()
}

// BatchGetChannelWithContext is the same as BatchGetChannel with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) BatchGetChannelWithContext(ctx aws.Context, input *BatchGetChannelInput, opts ...request.Option) (*BatchGetChannelOutput, error) {
	req, out := c.BatchGetChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetStreamKey = "BatchGetStreamKey"

// BatchGetStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetStreamKey for more information on using the BatchGetStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetStreamKeyRequest method.
//    req, resp := client.BatchGetStreamKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey
func (c *IVS) BatchGetStreamKeyRequest(input *BatchGetStreamKeyInput) (req *request.Request, output *BatchGetStreamKeyOutput) {
	op := &request.Operation{
		Name:       opBatchGetStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetStreamKey",
	}

	if input == nil {
		input = &BatchGetStreamKeyInput{}
	}

	output = &BatchGetStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetStreamKey API operation for Amazon Interactive Video Service.
//
// Performs GetStreamKey on multiple ARNs simultaneously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation BatchGetStreamKey for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey
func (c *IVS) BatchGetStreamKey(input *BatchGetStreamKeyInput) (*BatchGetStreamKeyOutput, error) {
	req, out := c.BatchGetStreamKeyRequest(input)
	return out, req.Send()
}

// BatchGetStreamKeyWithContext is the same as BatchGetStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) BatchGetStreamKeyWithContext(ctx aws.Context, input *BatchGetStreamKeyInput, opts ...request.Option) (*BatchGetStreamKeyOutput, error) {
	req, out := c.BatchGetStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelRequest method.
//    req, resp := client.CreateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateChannel
func (c *IVS) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateChannel",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for Amazon Interactive Video Service.
//
// Creates a new channel and an associated stream key to start streaming.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateChannel
func (c *IVS) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamKey = "CreateStreamKey"

// CreateStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamKey for more information on using the CreateStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamKeyRequest method.
//    req, resp := client.CreateStreamKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey
func (c *IVS) CreateStreamKeyRequest(input *CreateStreamKeyInput) (req *request.Request, output *CreateStreamKeyOutput) {
	op := &request.Operation{
		Name:       opCreateStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStreamKey",
	}

	if input == nil {
		input = &CreateStreamKeyInput{}
	}

	output = &CreateStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamKey API operation for Amazon Interactive Video Service.
//
// Creates a stream key, used to initiate a stream, for the specified channel
// ARN.
//
// Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey
// on the same channel, it will fail because a stream key already exists and
// there is a limit of 1 stream key per channel. To reset the stream key on
// a channel, use DeleteStreamKey and then CreateStreamKey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation CreateStreamKey for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ServiceQuotaExceededException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey
func (c *IVS) CreateStreamKey(input *CreateStreamKeyInput) (*CreateStreamKeyOutput, error) {
	req, out := c.CreateStreamKeyRequest(input)
	return out, req.Send()
}

// CreateStreamKeyWithContext is the same as CreateStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) CreateStreamKeyWithContext(ctx aws.Context, input *CreateStreamKeyInput, opts ...request.Option) (*CreateStreamKeyOutput, error) {
	req, out := c.CreateStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelRequest method.
//    req, resp := client.DeleteChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteChannel
func (c *IVS) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteChannel",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for Amazon Interactive Video Service.
//
// Deletes the specified channel and its associated stream keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ConflictException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteChannel
func (c *IVS) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlaybackKeyPair = "DeletePlaybackKeyPair"

// DeletePlaybackKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlaybackKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlaybackKeyPair for more information on using the DeletePlaybackKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePlaybackKeyPairRequest method.
//    req, resp := client.DeletePlaybackKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackKeyPair
func (c *IVS) DeletePlaybackKeyPairRequest(input *DeletePlaybackKeyPairInput) (req *request.Request, output *DeletePlaybackKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeletePlaybackKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/DeletePlaybackKeyPair",
	}

	if input == nil {
		input = &DeletePlaybackKeyPairInput{}
	}

	output = &DeletePlaybackKeyPairOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlaybackKeyPair API operation for Amazon Interactive Video Service.
//
// Deletes a specified authorization key pair. This invalidates future viewer
// tokens generated using the key pair’s privateKey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeletePlaybackKeyPair for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackKeyPair
func (c *IVS) DeletePlaybackKeyPair(input *DeletePlaybackKeyPairInput) (*DeletePlaybackKeyPairOutput, error) {
	req, out := c.DeletePlaybackKeyPairRequest(input)
	return out, req.Send()
}

// DeletePlaybackKeyPairWithContext is the same as DeletePlaybackKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlaybackKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeletePlaybackKeyPairWithContext(ctx aws.Context, input *DeletePlaybackKeyPairInput, opts ...request.Option) (*DeletePlaybackKeyPairOutput, error) {
	req, out := c.DeletePlaybackKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamKey = "DeleteStreamKey"

// DeleteStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamKey for more information on using the DeleteStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamKeyRequest method.
//    req, resp := client.DeleteStreamKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey
func (c *IVS) DeleteStreamKeyRequest(input *DeleteStreamKeyInput) (req *request.Request, output *DeleteStreamKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStreamKey",
	}

	if input == nil {
		input = &DeleteStreamKeyInput{}
	}

	output = &DeleteStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStreamKey API operation for Amazon Interactive Video Service.
//
// Deletes the stream key for the specified ARN, so it can no longer be used
// to stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation DeleteStreamKey for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey
func (c *IVS) DeleteStreamKey(input *DeleteStreamKeyInput) (*DeleteStreamKeyOutput, error) {
	req, out := c.DeleteStreamKeyRequest(input)
	return out, req.Send()
}

// DeleteStreamKeyWithContext is the same as DeleteStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) DeleteStreamKeyWithContext(ctx aws.Context, input *DeleteStreamKeyInput, opts ...request.Option) (*DeleteStreamKeyOutput, error) {
	req, out := c.DeleteStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannel = "GetChannel"

// GetChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannel for more information on using the GetChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChannelRequest method.
//    req, resp := client.GetChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel
func (c *IVS) GetChannelRequest(input *GetChannelInput) (req *request.Request, output *GetChannelOutput) {
	op := &request.Operation{
		Name:       opGetChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/GetChannel",
	}

	if input == nil {
		input = &GetChannelInput{}
	}

	output = &GetChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannel API operation for Amazon Interactive Video Service.
//
// Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetChannel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel
func (c *IVS) GetChannel(input *GetChannelInput) (*GetChannelOutput, error) {
	req, out := c.GetChannelRequest(input)
	return out, req.Send()
}

// GetChannelWithContext is the same as GetChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetChannelWithContext(ctx aws.Context, input *GetChannelInput, opts ...request.Option) (*GetChannelOutput, error) {
	req, out := c.GetChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPlaybackKeyPair = "GetPlaybackKeyPair"

// GetPlaybackKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the GetPlaybackKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlaybackKeyPair for more information on using the GetPlaybackKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPlaybackKeyPairRequest method.
//    req, resp := client.GetPlaybackKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackKeyPair
func (c *IVS) GetPlaybackKeyPairRequest(input *GetPlaybackKeyPairInput) (req *request.Request, output *GetPlaybackKeyPairOutput) {
	op := &request.Operation{
		Name:       opGetPlaybackKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/GetPlaybackKeyPair",
	}

	if input == nil {
		input = &GetPlaybackKeyPairInput{}
	}

	output = &GetPlaybackKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlaybackKeyPair API operation for Amazon Interactive Video Service.
//
// Gets a specified playback authorization key pair and returns the arn and
// fingerprint. The privateKey held by the caller can be used to generate viewer
// authorization tokens, to grant viewers access to authorized channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetPlaybackKeyPair for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackKeyPair
func (c *IVS) GetPlaybackKeyPair(input *GetPlaybackKeyPairInput) (*GetPlaybackKeyPairOutput, error) {
	req, out := c.GetPlaybackKeyPairRequest(input)
	return out, req.Send()
}

// GetPlaybackKeyPairWithContext is the same as GetPlaybackKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlaybackKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetPlaybackKeyPairWithContext(ctx aws.Context, input *GetPlaybackKeyPairInput, opts ...request.Option) (*GetPlaybackKeyPairOutput, error) {
	req, out := c.GetPlaybackKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStream = "GetStream"

// GetStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStream for more information on using the GetStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStreamRequest method.
//    req, resp := client.GetStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream
func (c *IVS) GetStreamRequest(input *GetStreamInput) (req *request.Request, output *GetStreamOutput) {
	op := &request.Operation{
		Name:       opGetStream,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStream",
	}

	if input == nil {
		input = &GetStreamInput{}
	}

	output = &GetStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStream API operation for Amazon Interactive Video Service.
//
// Gets information about the active (live) stream on a specified channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetStream for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ChannelNotBroadcasting
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream
func (c *IVS) GetStream(input *GetStreamInput) (*GetStreamOutput, error) {
	req, out := c.GetStreamRequest(input)
	return out, req.Send()
}

// GetStreamWithContext is the same as GetStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetStreamWithContext(ctx aws.Context, input *GetStreamInput, opts ...request.Option) (*GetStreamOutput, error) {
	req, out := c.GetStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamKey = "GetStreamKey"

// GetStreamKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamKey for more information on using the GetStreamKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStreamKeyRequest method.
//    req, resp := client.GetStreamKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey
func (c *IVS) GetStreamKeyRequest(input *GetStreamKeyInput) (req *request.Request, output *GetStreamKeyOutput) {
	op := &request.Operation{
		Name:       opGetStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStreamKey",
	}

	if input == nil {
		input = &GetStreamKeyInput{}
	}

	output = &GetStreamKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamKey API operation for Amazon Interactive Video Service.
//
// Gets stream-key information for a specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation GetStreamKey for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey
func (c *IVS) GetStreamKey(input *GetStreamKeyInput) (*GetStreamKeyOutput, error) {
	req, out := c.GetStreamKeyRequest(input)
	return out, req.Send()
}

// GetStreamKeyWithContext is the same as GetStreamKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) GetStreamKeyWithContext(ctx aws.Context, input *GetStreamKeyInput, opts ...request.Option) (*GetStreamKeyOutput, error) {
	req, out := c.GetStreamKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportPlaybackKeyPair = "ImportPlaybackKeyPair"

// ImportPlaybackKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the ImportPlaybackKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportPlaybackKeyPair for more information on using the ImportPlaybackKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportPlaybackKeyPairRequest method.
//    req, resp := client.ImportPlaybackKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ImportPlaybackKeyPair
func (c *IVS) ImportPlaybackKeyPairRequest(input *ImportPlaybackKeyPairInput) (req *request.Request, output *ImportPlaybackKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportPlaybackKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/ImportPlaybackKeyPair",
	}

	if input == nil {
		input = &ImportPlaybackKeyPairInput{}
	}

	output = &ImportPlaybackKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportPlaybackKeyPair API operation for Amazon Interactive Video Service.
//
// Imports the public portion of a new key pair and returns its arn and fingerprint.
// The privateKey can then be used to generate viewer authorization tokens,
// to grant viewers access to authorized channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ImportPlaybackKeyPair for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ImportPlaybackKeyPair
func (c *IVS) ImportPlaybackKeyPair(input *ImportPlaybackKeyPairInput) (*ImportPlaybackKeyPairOutput, error) {
	req, out := c.ImportPlaybackKeyPairRequest(input)
	return out, req.Send()
}

// ImportPlaybackKeyPairWithContext is the same as ImportPlaybackKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See ImportPlaybackKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ImportPlaybackKeyPairWithContext(ctx aws.Context, input *ImportPlaybackKeyPairInput, opts ...request.Option) (*ImportPlaybackKeyPairOutput, error) {
	req, out := c.ImportPlaybackKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsRequest method.
//    req, resp := client.ListChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels
func (c *IVS) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/ListChannels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for Amazon Interactive Video Service.
//
// Gets summary information about all channels in your account, in the AWS region
// where the API request is processed. This list can be filtered to match a
// specified string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels
func (c *IVS) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannels operation.
//    pageNum := 0
//    err := client.ListChannelsPages(params,
//        func(page *ivs.ListChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IVS) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlaybackKeyPairs = "ListPlaybackKeyPairs"

// ListPlaybackKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlaybackKeyPairs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlaybackKeyPairs for more information on using the ListPlaybackKeyPairs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPlaybackKeyPairsRequest method.
//    req, resp := client.ListPlaybackKeyPairsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs
func (c *IVS) ListPlaybackKeyPairsRequest(input *ListPlaybackKeyPairsInput) (req *request.Request, output *ListPlaybackKeyPairsOutput) {
	op := &request.Operation{
		Name:       opListPlaybackKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/ListPlaybackKeyPairs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlaybackKeyPairsInput{}
	}

	output = &ListPlaybackKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlaybackKeyPairs API operation for Amazon Interactive Video Service.
//
// Gets summary information about playback key pairs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListPlaybackKeyPairs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs
func (c *IVS) ListPlaybackKeyPairs(input *ListPlaybackKeyPairsInput) (*ListPlaybackKeyPairsOutput, error) {
	req, out := c.ListPlaybackKeyPairsRequest(input)
	return out, req.Send()
}

// ListPlaybackKeyPairsWithContext is the same as ListPlaybackKeyPairs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlaybackKeyPairs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListPlaybackKeyPairsWithContext(ctx aws.Context, input *ListPlaybackKeyPairsInput, opts ...request.Option) (*ListPlaybackKeyPairsOutput, error) {
	req, out := c.ListPlaybackKeyPairsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlaybackKeyPairsPages iterates over the pages of a ListPlaybackKeyPairs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlaybackKeyPairs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPlaybackKeyPairs operation.
//    pageNum := 0
//    err := client.ListPlaybackKeyPairsPages(params,
//        func(page *ivs.ListPlaybackKeyPairsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IVS) ListPlaybackKeyPairsPages(input *ListPlaybackKeyPairsInput, fn func(*ListPlaybackKeyPairsOutput, bool) bool) error {
	return c.ListPlaybackKeyPairsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlaybackKeyPairsPagesWithContext same as ListPlaybackKeyPairsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListPlaybackKeyPairsPagesWithContext(ctx aws.Context, input *ListPlaybackKeyPairsInput, fn func(*ListPlaybackKeyPairsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlaybackKeyPairsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlaybackKeyPairsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlaybackKeyPairsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreamKeys = "ListStreamKeys"

// ListStreamKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamKeys for more information on using the ListStreamKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamKeysRequest method.
//    req, resp := client.ListStreamKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys
func (c *IVS) ListStreamKeysRequest(input *ListStreamKeysInput) (req *request.Request, output *ListStreamKeysOutput) {
	op := &request.Operation{
		Name:       opListStreamKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStreamKeys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamKeysInput{}
	}

	output = &ListStreamKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamKeys API operation for Amazon Interactive Video Service.
//
// Gets summary information about stream keys for the specified channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListStreamKeys for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys
func (c *IVS) ListStreamKeys(input *ListStreamKeysInput) (*ListStreamKeysOutput, error) {
	req, out := c.ListStreamKeysRequest(input)
	return out, req.Send()
}

// ListStreamKeysWithContext is the same as ListStreamKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamKeysWithContext(ctx aws.Context, input *ListStreamKeysInput, opts ...request.Option) (*ListStreamKeysOutput, error) {
	req, out := c.ListStreamKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamKeysPages iterates over the pages of a ListStreamKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStreamKeys operation.
//    pageNum := 0
//    err := client.ListStreamKeysPages(params,
//        func(page *ivs.ListStreamKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IVS) ListStreamKeysPages(input *ListStreamKeysInput, fn func(*ListStreamKeysOutput, bool) bool) error {
	return c.ListStreamKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamKeysPagesWithContext same as ListStreamKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamKeysPagesWithContext(ctx aws.Context, input *ListStreamKeysInput, fn func(*ListStreamKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamsRequest method.
//    req, resp := client.ListStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams
func (c *IVS) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStreams",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for Amazon Interactive Video Service.
//
// Gets summary information about live streams in your account, in the AWS region
// where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListStreams for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams
func (c *IVS) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamsPages iterates over the pages of a ListStreams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStreams operation.
//    pageNum := 0
//    err := client.ListStreamsPages(params,
//        func(page *ivs.ListStreamsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IVS) ListStreamsPages(input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool) error {
	return c.ListStreamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamsPagesWithContext same as ListStreamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListStreamsPagesWithContext(ctx aws.Context, input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListTagsForResource
func (c *IVS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Interactive Video Service.
//
// Gets information about AWS tags for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//
//   * ValidationException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListTagsForResource
func (c *IVS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *ivs.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IVS) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutMetadata = "PutMetadata"

// PutMetadataRequest generates a "aws/request.Request" representing the
// client's request for the PutMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetadata for more information on using the PutMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMetadataRequest method.
//    req, resp := client.PutMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata
func (c *IVS) PutMetadataRequest(input *PutMetadataInput) (req *request.Request, output *PutMetadataOutput) {
	op := &request.Operation{
		Name:       opPutMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/PutMetadata",
	}

	if input == nil {
		input = &PutMetadataInput{}
	}

	output = &PutMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetadata API operation for Amazon Interactive Video Service.
//
// Inserts metadata into an RTMPS stream for the specified channel. A maximum
// of 5 requests per second per channel is allowed, each with a maximum 1KB
// payload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation PutMetadata for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ResourceNotFoundException
//
//   * ChannelNotBroadcasting
//
//   * ValidationException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata
func (c *IVS) PutMetadata(input *PutMetadataInput) (*PutMetadataOutput, error) {
	req, out := c.PutMetadataRequest(input)
	return out, req.Send()
}

// PutMetadataWithContext is the same as PutMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) PutMetadataWithContext(ctx aws.Context, input *PutMetadataInput, opts ...request.Option) (*PutMetadataOutput, error) {
	req, out := c.PutMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStream = "StopStream"

// StopStreamRequest generates a "aws/request.Request" representing the
// client's request for the StopStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStream for more information on using the StopStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopStreamRequest method.
//    req, resp := client.StopStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream
func (c *IVS) StopStreamRequest(input *StopStreamInput) (req *request.Request, output *StopStreamOutput) {
	op := &request.Operation{
		Name:       opStopStream,
		HTTPMethod: "POST",
		HTTPPath:   "/StopStream",
	}

	if input == nil {
		input = &StopStreamInput{}
	}

	output = &StopStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStream API operation for Amazon Interactive Video Service.
//
// Disconnects the incoming RTMPS stream for the specified channel. Can be used
// in conjunction with DeleteStreamKey to prevent further streaming to a channel.
//
// Many streaming client-software libraries automatically reconnect a dropped
// RTMPS session, so to stop the stream permanently, you may want to first revoke
// the streamKey attached to the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation StopStream for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ChannelNotBroadcasting
//
//   * ValidationException
//
//   * AccessDeniedException
//
//   * StreamUnavailable
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream
func (c *IVS) StopStream(input *StopStreamInput) (*StopStreamOutput, error) {
	req, out := c.StopStreamRequest(input)
	return out, req.Send()
}

// StopStreamWithContext is the same as StopStream with the addition of
// the ability to pass a context and additional request options.
//
// See StopStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) StopStreamWithContext(ctx aws.Context, input *StopStreamInput, opts ...request.Option) (*StopStreamOutput, error) {
	req, out := c.StopStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/TagResource
func (c *IVS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Interactive Video Service.
//
// Adds or updates tags for the AWS resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//
//   * ValidationException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/TagResource
func (c *IVS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UntagResource
func (c *IVS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Interactive Video Service.
//
// Removes tags from the resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//
//   * ValidationException
//
//   * ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UntagResource
func (c *IVS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelRequest method.
//    req, resp := client.UpdateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdateChannel
func (c *IVS) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateChannel",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for Amazon Interactive Video Service.
//
// Updates a channel's configuration. This does not affect an ongoing stream
// of this channel. You must stop and restart the stream for the changes to
// take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ConflictException
//
//   * PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdateChannel
func (c *IVS) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVS) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// User does not have sufficient access to perform this action.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Error related to a specific channel, specified by its ARN.
type BatchError struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Error code.
	Code *string `locationName:"code" type:"string"`

	// Error message, determined by the application.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BatchError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchError) SetArn(v string) *BatchError {
	s.Arn = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchError) SetCode(v string) *BatchError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchError) SetMessage(v string) *BatchError {
	s.Message = &v
	return s
}

type BatchGetChannelInput struct {
	_ struct{} `type:"structure"`

	// Array of ARNs, one per channel.
	//
	// Arns is a required field
	Arns []*string `locationName:"arns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetChannelInput"}
	if s.Arns == nil {
		invalidParams.Add(request.NewErrParamRequired("Arns"))
	}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *BatchGetChannelInput) SetArns(v []*string) *BatchGetChannelInput {
	s.Arns = v
	return s
}

type BatchGetChannelOutput struct {
	_ struct{} `type:"structure"`

	Channels []*Channel `locationName:"channels" type:"list"`

	// Each error object is related to a specific ARN in the request.
	Errors []*BatchError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchGetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetChannelOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *BatchGetChannelOutput) SetChannels(v []*Channel) *BatchGetChannelOutput {
	s.Channels = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetChannelOutput) SetErrors(v []*BatchError) *BatchGetChannelOutput {
	s.Errors = v
	return s
}

type BatchGetStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// Array of ARNs, one per channel.
	//
	// Arns is a required field
	Arns []*string `locationName:"arns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetStreamKeyInput"}
	if s.Arns == nil {
		invalidParams.Add(request.NewErrParamRequired("Arns"))
	}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *BatchGetStreamKeyInput) SetArns(v []*string) *BatchGetStreamKeyInput {
	s.Arns = v
	return s
}

type BatchGetStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	Errors []*BatchError `locationName:"errors" type:"list"`

	StreamKeys []*StreamKey `locationName:"streamKeys" type:"list"`
}

// String returns the string representation
func (s BatchGetStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetStreamKeyOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetStreamKeyOutput) SetErrors(v []*BatchError) *BatchGetStreamKeyOutput {
	s.Errors = v
	return s
}

// SetStreamKeys sets the StreamKeys field's value.
func (s *BatchGetStreamKeyOutput) SetStreamKeys(v []*StreamKey) *BatchGetStreamKeyOutput {
	s.StreamKeys = v
	return s
}

// Object specifying a channel.
type Channel struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Whether the channel is authorized.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Channel ingest endpoint, part of the definition of an ingest server, used
	// when you set up streaming software.
	IngestEndpoint *string `locationName:"ingestEndpoint" type:"string"`

	// Channel latency mode. Default: LOW.
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Channel playback URL.
	PlaybackUrl *string `locationName:"playbackUrl" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable resolution or bitrate, the stream probably will disconnect
	// immediately. Valid values:
	//
	//    * STANDARD: Multiple qualities are generated from the original input,
	//    to automatically give viewers the best experience for their devices and
	//    network conditions. Vertical resolution can be up to 1080 and bitrate
	//    can be up to 8.5 Mbps.
	//
	//    * BASIC: Amazon IVS delivers the original input to viewers. The viewer’s
	//    video-quality choice is limited to the original input. Vertical resolution
	//    can be up to 480 and bitrate can be up to 1.5 Mbps.
	//
	// Default: STANDARD.
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetAuthorized sets the Authorized field's value.
func (s *Channel) SetAuthorized(v bool) *Channel {
	s.Authorized = &v
	return s
}

// SetIngestEndpoint sets the IngestEndpoint field's value.
func (s *Channel) SetIngestEndpoint(v string) *Channel {
	s.IngestEndpoint = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *Channel) SetLatencyMode(v string) *Channel {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPlaybackUrl sets the PlaybackUrl field's value.
func (s *Channel) SetPlaybackUrl(v string) *Channel {
	s.PlaybackUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Channel) SetTags(v map[string]*string) *Channel {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Channel) SetType(v string) *Channel {
	s.Type = &v
	return s
}

type ChannelNotBroadcasting struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The stream is offline for the given channel ARN.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ChannelNotBroadcasting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelNotBroadcasting) GoString() string {
	return s.String()
}

func newErrorChannelNotBroadcasting(v protocol.ResponseMetadata) error {
	return &ChannelNotBroadcasting{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ChannelNotBroadcasting) Code() string {
	return "ChannelNotBroadcasting"
}

// Message returns the exception's message.
func (s *ChannelNotBroadcasting) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ChannelNotBroadcasting) OrigErr() error {
	return nil
}

func (s *ChannelNotBroadcasting) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ChannelNotBroadcasting) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ChannelNotBroadcasting) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information about a channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Whether the channel is authorized.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Channel latency mode. Default: LOW.
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelSummary) SetArn(v string) *ChannelSummary {
	s.Arn = &v
	return s
}

// SetAuthorized sets the Authorized field's value.
func (s *ChannelSummary) SetAuthorized(v bool) *ChannelSummary {
	s.Authorized = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *ChannelSummary) SetLatencyMode(v string) *ChannelSummary {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ChannelSummary) SetTags(v map[string]*string) *ChannelSummary {
	s.Tags = v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Updating or deleting a resource can cause an inconsistent state.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// Whether the channel is authorized. Default: false.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Channel latency mode. Default: LOW.
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// See Channel$tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable resolution or bitrate, the stream probably will disconnect
	// immediately. Valid values:
	//
	//    * STANDARD: Multiple qualities are generated from the original input,
	//    to automatically give viewers the best experience for their devices and
	//    network conditions. Vertical resolution can be up to 1080 and bitrate
	//    can be up to 8.5 Mbps.
	//
	//    * BASIC: Amazon IVS delivers the original input to viewers. The viewer’s
	//    video-quality choice is limited to the original input. Vertical resolution
	//    can be up to 480 and bitrate can be up to 1.5 Mbps.
	//
	// Default: STANDARD.
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// SetAuthorized sets the Authorized field's value.
func (s *CreateChannelInput) SetAuthorized(v bool) *CreateChannelInput {
	s.Authorized = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *CreateChannelInput) SetLatencyMode(v string) *CreateChannelInput {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateChannelInput) SetType(v string) *CreateChannelInput {
	s.Type = &v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`

	// Object specifying a stream key.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *CreateChannelOutput) SetChannel(v *Channel) *CreateChannelOutput {
	s.Channel = v
	return s
}

// SetStreamKey sets the StreamKey field's value.
func (s *CreateChannelOutput) SetStreamKey(v *StreamKey) *CreateChannelOutput {
	s.StreamKey = v
	return s
}

type CreateStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which to create the stream key.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// See Channel$tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamKeyInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateStreamKeyInput) SetChannelArn(v string) *CreateStreamKeyInput {
	s.ChannelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStreamKeyInput) SetTags(v map[string]*string) *CreateStreamKeyInput {
	s.Tags = v
	return s
}

type CreateStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	// Stream key used to authenticate an RTMPS stream for ingestion.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation
func (s CreateStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamKeyOutput) GoString() string {
	return s.String()
}

// SetStreamKey sets the StreamKey field's value.
func (s *CreateStreamKeyOutput) SetStreamKey(v *StreamKey) *CreateStreamKeyOutput {
	s.StreamKey = v
	return s
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteChannelInput) SetArn(v string) *DeleteChannelInput {
	s.Arn = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeletePlaybackKeyPairInput struct {
	_ struct{} `type:"structure"`

	// ARN of the key pair to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlaybackKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlaybackKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlaybackKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlaybackKeyPairInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeletePlaybackKeyPairInput) SetArn(v string) *DeletePlaybackKeyPairInput {
	s.Arn = &v
	return s
}

type DeletePlaybackKeyPairOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlaybackKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlaybackKeyPairOutput) GoString() string {
	return s.String()
}

type DeleteStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stream key to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamKeyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteStreamKeyInput) SetArn(v string) *DeleteStreamKeyInput {
	s.Arn = &v
	return s
}

type DeleteStreamKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamKeyOutput) GoString() string {
	return s.String()
}

type GetChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which the configuration is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetChannelInput) SetArn(v string) *GetChannelInput {
	s.Arn = &v
	return s
}

type GetChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s GetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *GetChannelOutput) SetChannel(v *Channel) *GetChannelOutput {
	s.Channel = v
	return s
}

type GetPlaybackKeyPairInput struct {
	_ struct{} `type:"structure"`

	// ARN of the key pair to be returned.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPlaybackKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlaybackKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlaybackKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlaybackKeyPairInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetPlaybackKeyPairInput) SetArn(v string) *GetPlaybackKeyPairInput {
	s.Arn = &v
	return s
}

type GetPlaybackKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A key pair used to sign and validate a playback authorization token.
	KeyPair *PlaybackKeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s GetPlaybackKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlaybackKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *GetPlaybackKeyPairOutput) SetKeyPair(v *PlaybackKeyPair) *GetPlaybackKeyPairOutput {
	s.KeyPair = v
	return s
}

type GetStreamInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN for stream to be accessed.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetStreamInput) SetChannelArn(v string) *GetStreamInput {
	s.ChannelArn = &v
	return s
}

type GetStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN for the stream key to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamKeyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetStreamKeyInput) SetArn(v string) *GetStreamKeyInput {
	s.Arn = &v
	return s
}

type GetStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a stream key.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation
func (s GetStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamKeyOutput) GoString() string {
	return s.String()
}

// SetStreamKey sets the StreamKey field's value.
func (s *GetStreamKeyOutput) SetStreamKey(v *StreamKey) *GetStreamKeyOutput {
	s.StreamKey = v
	return s
}

type GetStreamOutput struct {
	_ struct{} `type:"structure"`

	// Specifies a live video stream that has been ingested and distributed.
	Stream *Stream `locationName:"stream" type:"structure"`
}

// String returns the string representation
func (s GetStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamOutput) GoString() string {
	return s.String()
}

// SetStream sets the Stream field's value.
func (s *GetStreamOutput) SetStream(v *Stream) *GetStreamOutput {
	s.Stream = v
	return s
}

type ImportPlaybackKeyPairInput struct {
	_ struct{} `type:"structure"`

	// An arbitrary string (a nickname) assigned to a playback key pair that helps
	// the customer identify that resource. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// The public portion of a customer-generated key pair.
	//
	// PublicKeyMaterial is a required field
	PublicKeyMaterial *string `locationName:"publicKeyMaterial" type:"string" required:"true"`

	// Any tags provided with the request are added to the playback key pair tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ImportPlaybackKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportPlaybackKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportPlaybackKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportPlaybackKeyPairInput"}
	if s.PublicKeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyMaterial"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ImportPlaybackKeyPairInput) SetName(v string) *ImportPlaybackKeyPairInput {
	s.Name = &v
	return s
}

// SetPublicKeyMaterial sets the PublicKeyMaterial field's value.
func (s *ImportPlaybackKeyPairInput) SetPublicKeyMaterial(v string) *ImportPlaybackKeyPairInput {
	s.PublicKeyMaterial = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportPlaybackKeyPairInput) SetTags(v map[string]*string) *ImportPlaybackKeyPairInput {
	s.Tags = v
	return s
}

type ImportPlaybackKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A key pair used to sign and validate a playback authorization token.
	KeyPair *PlaybackKeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s ImportPlaybackKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportPlaybackKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *ImportPlaybackKeyPairOutput) SetKeyPair(v *PlaybackKeyPair) *ImportPlaybackKeyPairOutput {
	s.KeyPair = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Unexpected error during processing of request.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	// Filters the channel list to match the specified name.
	FilterByName *string `locationName:"filterByName" type:"string"`

	// Maximum number of channels to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first channel to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterByName sets the FilterByName field's value.
func (s *ListChannelsInput) SetFilterByName(v string) *ListChannelsInput {
	s.FilterByName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching channels.
	//
	// Channels is a required field
	Channels []*ChannelSummary `locationName:"channels" type:"list" required:"true"`

	// If there are more channels than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListPlaybackKeyPairsInput struct {
	_ struct{} `type:"structure"`

	// The first key pair to retrieve. This is used for pagination; see the nextToken
	// response field.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Maximum number of key pairs to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPlaybackKeyPairsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlaybackKeyPairsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlaybackKeyPairsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlaybackKeyPairsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlaybackKeyPairsInput) SetMaxResults(v int64) *ListPlaybackKeyPairsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaybackKeyPairsInput) SetNextToken(v string) *ListPlaybackKeyPairsInput {
	s.NextToken = &v
	return s
}

type ListPlaybackKeyPairsOutput struct {
	_ struct{} `type:"structure"`

	// List of key pairs.
	//
	// KeyPairs is a required field
	KeyPairs []*PlaybackKeyPairSummary `locationName:"keyPairs" type:"list" required:"true"`

	// If there are more key pairs than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPlaybackKeyPairsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlaybackKeyPairsOutput) GoString() string {
	return s.String()
}

// SetKeyPairs sets the KeyPairs field's value.
func (s *ListPlaybackKeyPairsOutput) SetKeyPairs(v []*PlaybackKeyPairSummary) *ListPlaybackKeyPairsOutput {
	s.KeyPairs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaybackKeyPairsOutput) SetNextToken(v string) *ListPlaybackKeyPairsOutput {
	s.NextToken = &v
	return s
}

type ListStreamKeysInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN used to filter the list.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Maximum number of streamKeys to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stream key to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListStreamKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamKeysInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListStreamKeysInput) SetChannelArn(v string) *ListStreamKeysInput {
	s.ChannelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamKeysInput) SetMaxResults(v int64) *ListStreamKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamKeysInput) SetNextToken(v string) *ListStreamKeysInput {
	s.NextToken = &v
	return s
}

type ListStreamKeysOutput struct {
	_ struct{} `type:"structure"`

	// If there are more stream keys than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of stream keys.
	//
	// StreamKeys is a required field
	StreamKeys []*StreamKeySummary `locationName:"streamKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s ListStreamKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamKeysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamKeysOutput) SetNextToken(v string) *ListStreamKeysOutput {
	s.NextToken = &v
	return s
}

// SetStreamKeys sets the StreamKeys field's value.
func (s *ListStreamKeysOutput) SetStreamKeys(v []*StreamKeySummary) *ListStreamKeysOutput {
	s.StreamKeys = v
	return s
}

type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of streams to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stream to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamsInput) SetMaxResults(v int64) *ListStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsInput) SetNextToken(v string) *ListStreamsInput {
	s.NextToken = &v
	return s
}

type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more streams than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of streams.
	//
	// Streams is a required field
	Streams []*StreamSummary `locationName:"streams" type:"list" required:"true"`
}

// String returns the string representation
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsOutput) SetNextToken(v string) *ListStreamsOutput {
	s.NextToken = &v
	return s
}

// SetStreams sets the Streams field's value.
func (s *ListStreamsOutput) SetStreams(v []*StreamSummary) *ListStreamsOutput {
	s.Streams = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of tags to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first tag to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the resource to be retrieved.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// If there are more tags than maxResults, use nextToken in the request to get
	// the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PendingVerification struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Your account is pending verification.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s PendingVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingVerification) GoString() string {
	return s.String()
}

func newErrorPendingVerification(v protocol.ResponseMetadata) error {
	return &PendingVerification{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PendingVerification) Code() string {
	return "PendingVerification"
}

// Message returns the exception's message.
func (s *PendingVerification) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PendingVerification) OrigErr() error {
	return nil
}

func (s *PendingVerification) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PendingVerification) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PendingVerification) RequestID() string {
	return s.RespMetadata.RequestID
}

// A key pair used to sign and validate a playback authorization token.
type PlaybackKeyPair struct {
	_ struct{} `type:"structure"`

	// Key-pair ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Key-pair identifier.
	Fingerprint *string `locationName:"fingerprint" type:"string"`

	// Key-pair name.
	Name *string `locationName:"name" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s PlaybackKeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlaybackKeyPair) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PlaybackKeyPair) SetArn(v string) *PlaybackKeyPair {
	s.Arn = &v
	return s
}

// SetFingerprint sets the Fingerprint field's value.
func (s *PlaybackKeyPair) SetFingerprint(v string) *PlaybackKeyPair {
	s.Fingerprint = &v
	return s
}

// SetName sets the Name field's value.
func (s *PlaybackKeyPair) SetName(v string) *PlaybackKeyPair {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PlaybackKeyPair) SetTags(v map[string]*string) *PlaybackKeyPair {
	s.Tags = v
	return s
}

// Summary information about a playback key pair.
type PlaybackKeyPairSummary struct {
	_ struct{} `type:"structure"`

	// Key-pair ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Key-pair name.
	Name *string `locationName:"name" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value)
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s PlaybackKeyPairSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlaybackKeyPairSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PlaybackKeyPairSummary) SetArn(v string) *PlaybackKeyPairSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PlaybackKeyPairSummary) SetName(v string) *PlaybackKeyPairSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PlaybackKeyPairSummary) SetTags(v map[string]*string) *PlaybackKeyPairSummary {
	s.Tags = v
	return s
}

type PutMetadataInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel into which metadata is inserted. This channel must have
	// an active stream.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Metadata to insert into the stream. Maximum: 1 KB per request.
	//
	// Metadata is a required field
	Metadata *string `locationName:"metadata" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetadataInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *PutMetadataInput) SetChannelArn(v string) *PutMetadataInput {
	s.ChannelArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutMetadataInput) SetMetadata(v string) *PutMetadataInput {
	s.Metadata = &v
	return s
}

type PutMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetadataOutput) GoString() string {
	return s.String()
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request references a resource which does not exist.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request would cause a service quota to be exceeded.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StopStreamInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which the stream is to be stopped.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStreamInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StopStreamInput) SetChannelArn(v string) *StopStreamInput {
	s.ChannelArn = &v
	return s
}

type StopStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStreamOutput) GoString() string {
	return s.String()
}

// Specifies a live video stream that has been ingested and distributed.
type Stream struct {
	_ struct{} `type:"structure"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// The stream’s health.
	Health *string `locationName:"health" type:"string" enum:"StreamHealth"`

	// URL of the video master manifest, required by the video player to play the
	// HLS stream.
	PlaybackUrl *string `locationName:"playbackUrl" type:"string"`

	// ISO-8601 formatted timestamp of the stream’s start.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The stream’s state.
	State *string `locationName:"state" type:"string" enum:"StreamState"`

	// Number of current viewers of the stream.
	ViewerCount *int64 `locationName:"viewerCount" type:"long"`
}

// String returns the string representation
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stream) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *Stream) SetChannelArn(v string) *Stream {
	s.ChannelArn = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Stream) SetHealth(v string) *Stream {
	s.Health = &v
	return s
}

// SetPlaybackUrl sets the PlaybackUrl field's value.
func (s *Stream) SetPlaybackUrl(v string) *Stream {
	s.PlaybackUrl = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Stream) SetStartTime(v time.Time) *Stream {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Stream) SetState(v string) *Stream {
	s.State = &v
	return s
}

// SetViewerCount sets the ViewerCount field's value.
func (s *Stream) SetViewerCount(v int64) *Stream {
	s.ViewerCount = &v
	return s
}

// Object specifying a stream key.
type StreamKey struct {
	_ struct{} `type:"structure"`

	// Stream-key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Stream-key value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s StreamKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamKey) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StreamKey) SetArn(v string) *StreamKey {
	s.Arn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StreamKey) SetChannelArn(v string) *StreamKey {
	s.ChannelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamKey) SetTags(v map[string]*string) *StreamKey {
	s.Tags = v
	return s
}

// SetValue sets the Value field's value.
func (s *StreamKey) SetValue(v string) *StreamKey {
	s.Value = &v
	return s
}

// Summary information about a stream key.
type StreamKeySummary struct {
	_ struct{} `type:"structure"`

	// Stream-key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StreamKeySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamKeySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StreamKeySummary) SetArn(v string) *StreamKeySummary {
	s.Arn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StreamKeySummary) SetChannelArn(v string) *StreamKeySummary {
	s.ChannelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamKeySummary) SetTags(v map[string]*string) *StreamKeySummary {
	s.Tags = v
	return s
}

// Summary information about a stream.
type StreamSummary struct {
	_ struct{} `type:"structure"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// The stream’s health.
	Health *string `locationName:"health" type:"string" enum:"StreamHealth"`

	// ISO-8601 formatted timestamp of the stream’s start.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The stream’s state.
	State *string `locationName:"state" type:"string" enum:"StreamState"`

	// Number of current viewers of the stream.
	ViewerCount *int64 `locationName:"viewerCount" type:"long"`
}

// String returns the string representation
func (s StreamSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamSummary) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *StreamSummary) SetChannelArn(v string) *StreamSummary {
	s.ChannelArn = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *StreamSummary) SetHealth(v string) *StreamSummary {
	s.Health = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StreamSummary) SetStartTime(v time.Time) *StreamSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StreamSummary) SetState(v string) *StreamSummary {
	s.State = &v
	return s
}

// SetViewerCount sets the ViewerCount field's value.
func (s *StreamSummary) SetViewerCount(v int64) *StreamSummary {
	s.ViewerCount = &v
	return s
}

type StreamUnavailable struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The stream is temporarily unavailable.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s StreamUnavailable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamUnavailable) GoString() string {
	return s.String()
}

func newErrorStreamUnavailable(v protocol.ResponseMetadata) error {
	return &StreamUnavailable{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StreamUnavailable) Code() string {
	return "StreamUnavailable"
}

// Message returns the exception's message.
func (s *StreamUnavailable) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StreamUnavailable) OrigErr() error {
	return nil
}

func (s *StreamUnavailable) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StreamUnavailable) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StreamUnavailable) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of the resource for which tags are to be added or updated.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be added or updated.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request was denied due to request throttling.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of the resource for which tags are to be removed.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel to be updated.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Whether the channel is authorized. Default: false.
	Authorized *bool `locationName:"authorized" type:"boolean"`

	// Channel latency mode. Default: LOW.
	LatencyMode *string `locationName:"latencyMode" type:"string" enum:"ChannelLatencyMode"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable resolution or bitrate, the stream probably will disconnect
	// immediately. Valid values:
	//
	//    * STANDARD: Multiple qualities are generated from the original input,
	//    to automatically give viewers the best experience for their devices and
	//    network conditions. Vertical resolution can be up to 1080 and bitrate
	//    can be up to 8.5 Mbps.
	//
	//    * BASIC: Amazon IVS delivers the original input to viewers. The viewer’s
	//    video-quality choice is limited to the original input. Vertical resolution
	//    can be up to 480 and bitrate can be up to 1.5 Mbps.
	//
	// Default: STANDARD.
	Type *string `locationName:"type" type:"string" enum:"ChannelType"`
}

// String returns the string representation
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateChannelInput) SetArn(v string) *UpdateChannelInput {
	s.Arn = &v
	return s
}

// SetAuthorized sets the Authorized field's value.
func (s *UpdateChannelInput) SetAuthorized(v bool) *UpdateChannelInput {
	s.Authorized = &v
	return s
}

// SetLatencyMode sets the LatencyMode field's value.
func (s *UpdateChannelInput) SetLatencyMode(v string) *UpdateChannelInput {
	s.LatencyMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelInput) SetName(v string) *UpdateChannelInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateChannelInput) SetType(v string) *UpdateChannelInput {
	s.Type = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *UpdateChannelOutput) SetChannel(v *Channel) *UpdateChannelOutput {
	s.Channel = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The input fails to satisfy the constraints specified by an AWS service.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ChannelLatencyModeNormal is a ChannelLatencyMode enum value
	ChannelLatencyModeNormal = "NORMAL"

	// ChannelLatencyModeLow is a ChannelLatencyMode enum value
	ChannelLatencyModeLow = "LOW"
)

// ChannelLatencyMode_Values returns all elements of the ChannelLatencyMode enum
func ChannelLatencyMode_Values() []string {
	return []string{
		ChannelLatencyModeNormal,
		ChannelLatencyModeLow,
	}
}

const (
	// ChannelTypeBasic is a ChannelType enum value
	ChannelTypeBasic = "BASIC"

	// ChannelTypeStandard is a ChannelType enum value
	ChannelTypeStandard = "STANDARD"
)

// ChannelType_Values returns all elements of the ChannelType enum
func ChannelType_Values() []string {
	return []string{
		ChannelTypeBasic,
		ChannelTypeStandard,
	}
}

const (
	// StreamHealthHealthy is a StreamHealth enum value
	StreamHealthHealthy = "HEALTHY"

	// StreamHealthStarving is a StreamHealth enum value
	StreamHealthStarving = "STARVING"

	// StreamHealthUnknown is a StreamHealth enum value
	StreamHealthUnknown = "UNKNOWN"
)

// StreamHealth_Values returns all elements of the StreamHealth enum
func StreamHealth_Values() []string {
	return []string{
		StreamHealthHealthy,
		StreamHealthStarving,
		StreamHealthUnknown,
	}
}

const (
	// StreamStateLive is a StreamState enum value
	StreamStateLive = "LIVE"

	// StreamStateOffline is a StreamState enum value
	StreamStateOffline = "OFFLINE"
)

// StreamState_Values returns all elements of the StreamState enum
func StreamState_Values() []string {
	return []string{
		StreamStateLive,
		StreamStateOffline,
	}
}
