/*=========================================================================
 *
 *  Copyright NumFOCUS
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/
#ifndef itkShowDistanceMap_h
#define itkShowDistanceMap_h

#include "itkSmartPointer.h"
#include "itkImageSliceConstIteratorWithIndex.h"
#include <iostream>
#include <iomanip>

template <typename TImage>
void
ShowDistanceMap(itk::SmartPointer<TImage> distanceMap)
{
  itk::ImageSliceConstIteratorWithIndex<TImage> it2D2(distanceMap, distanceMap->GetRequestedRegion());
  it2D2.GoToBegin();
  it2D2.SetFirstDirection(0);
  it2D2.SetSecondDirection(1);

  while (!it2D2.IsAtEnd())
  {
    while (!it2D2.IsAtEndOfSlice())
    {
      while (!it2D2.IsAtEndOfLine())
      {
        std::cout << std::setw(7) << std::setprecision(5) << it2D2.Get() << "\t";
        ++it2D2;
      }
      std::cout << std::endl;
      it2D2.NextLine();
    }
    it2D2.NextSlice();
  }
}

#endif // itkShowDistanceMap_h
