/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.refactor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.lisaac.ldt.editors.LisaacScanner;
import org.lisaac.ldt.model.ILisaacFileVisitor;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.items.Prototype;

public class RenamePrototypeRefactor
extends Refactoring {
    private String oldName;
    private String newName;
    private LisaacModel model;
    private IPath prototypePath;
    private boolean updateReferences;

    public RenamePrototypeRefactor(String oldName, LisaacModel model) {
        this.oldName = oldName;
        this.model = model;
        this.updateReferences = true;
    }

    public RefactoringStatus setNewPrototypeName(String newName) {
        this.newName = newName;
        return this.isValidPrototypeName(newName);
    }

    public void setUpdateReferences(boolean update) {
        this.updateReferences = update;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = this.isValidPrototypeName(this.newName);
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = this.isValidPrototypeName(this.oldName);
        Prototype prototype = this.model.getPrototype(this.oldName);
        if (prototype != null) {
            this.prototypePath = prototype.getWorkspacePath();
        } else {
            status.addFatalError("The prototype do not exist in project");
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = new CompositeChange(this.getName());
        Prototype prototype = this.model.getPrototype(this.oldName);
        result.add(prototype.refactorRenameSelf(this.newName));
        if (this.updateReferences) {
            int work = this.model.getPathManager().getSize();
            pm.beginTask("Collecting occurences...", work);
            this.model.accept(new ILisaacFileVisitor(){

                public void visit(Prototype prototype) {
                    Change change;
                    if (prototype != null && (change = prototype.refactorRenamePrototype(RenamePrototypeRefactor.this.oldName, RenamePrototypeRefactor.this.newName)) != null) {
                        result.add(change);
                    }
                    pm.worked(1);
                }
            });
        }
        result.add((Change)new RenameResourceChange(this.prototypePath, String.valueOf(this.newName.toLowerCase()) + ".li"));
        pm.done();
        return result;
    }

    private RefactoringStatus isValidPrototypeName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        if (name.length() == 0) {
            status.addError("Empty name");
        } else if (!LisaacScanner.isPrototypeIdentifier(name)) {
            status.addError("Invalid prototype name");
        }
        return status;
    }

    public String getName() {
        return "Rename Prototype...";
    }
}

