/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBTable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DBTableAlias
extends DBIdentifier
implements DBTable {
    protected final Map<String, DBColumn> columns = new LinkedHashMap<String, DBColumn>();
    protected final DBTable originTable;

    public DBTableAlias(DBTable originTable, String tableAlias) {
        super(tableAlias);
        this.originTable = originTable;
        for (DBColumn col : originTable) {
            this.columns.put(col.getADQLName(), col.copy(col.getDBName(), DBTableAlias.denormalize(col.getADQLName(), col.isCaseSensitive()), this));
        }
    }

    public DBTable getOriginTable() {
        return this.originTable;
    }

    @Override
    public Iterator<DBColumn> iterator() {
        return this.columns.values().iterator();
    }

    @Override
    public String getADQLSchemaName() {
        return null;
    }

    @Override
    public String getDBSchemaName() {
        return null;
    }

    @Override
    public String getADQLCatalogName() {
        return null;
    }

    @Override
    public String getDBCatalogName() {
        return null;
    }

    @Override
    public DBColumn getColumn(String colName, boolean byAdqlName) {
        if (byAdqlName) {
            return this.columns.get(colName);
        }
        for (DBColumn col : this.columns.values()) {
            if (!col.getDBName().equals(colName)) continue;
            return col;
        }
        return null;
    }

    @Override
    public DBTable copy(String dbName, String adqlName) {
        return new DBTableAlias(this.originTable, adqlName);
    }
}

